/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.text.TextFormatting;

public class Scoreboard {
    private final Map<String, ScoreObjective> scoreObjectives = Maps.newHashMap();
    private final Map<IScoreCriteria, List<ScoreObjective>> scoreObjectiveCriterias = Maps.newHashMap();
    private final Map<String, Map<ScoreObjective, Score>> entitiesScoreObjectives = Maps.newHashMap();
    private final ScoreObjective[] objectiveDisplaySlots = new ScoreObjective[19];
    private final Map<String, ScorePlayerTeam> teams = Maps.newHashMap();
    private final Map<String, ScorePlayerTeam> teamMemberships = Maps.newHashMap();
    private static String[] displaySlots;

    @Nullable
    public ScoreObjective getObjective(String p_getObjective_1_) {
        return this.scoreObjectives.get(p_getObjective_1_);
    }

    public ScoreObjective addScoreObjective(String p_addScoreObjective_1_, IScoreCriteria p_addScoreObjective_2_) {
        if (p_addScoreObjective_1_.length() > 16) {
            throw new IllegalArgumentException("The objective name '" + p_addScoreObjective_1_ + "' is too long!");
        }
        ScoreObjective lvt_3_1_ = this.getObjective(p_addScoreObjective_1_);
        if (lvt_3_1_ != null) {
            throw new IllegalArgumentException("An objective with the name '" + p_addScoreObjective_1_ + "' already exists!");
        }
        lvt_3_1_ = new ScoreObjective(this, p_addScoreObjective_1_, p_addScoreObjective_2_);
        ArrayList lvt_4_1_ = this.scoreObjectiveCriterias.get(p_addScoreObjective_2_);
        if (lvt_4_1_ == null) {
            lvt_4_1_ = Lists.newArrayList();
            this.scoreObjectiveCriterias.put(p_addScoreObjective_2_, lvt_4_1_);
        }
        lvt_4_1_.add(lvt_3_1_);
        this.scoreObjectives.put(p_addScoreObjective_1_, lvt_3_1_);
        this.onScoreObjectiveAdded(lvt_3_1_);
        return lvt_3_1_;
    }

    public Collection<ScoreObjective> getObjectivesFromCriteria(IScoreCriteria p_getObjectivesFromCriteria_1_) {
        Collection lvt_2_1_ = this.scoreObjectiveCriterias.get(p_getObjectivesFromCriteria_1_);
        return lvt_2_1_ == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)lvt_2_1_);
    }

    public boolean entityHasObjective(String p_entityHasObjective_1_, ScoreObjective p_entityHasObjective_2_) {
        Map<ScoreObjective, Score> lvt_3_1_ = this.entitiesScoreObjectives.get(p_entityHasObjective_1_);
        if (lvt_3_1_ == null) {
            return false;
        }
        Score lvt_4_1_ = lvt_3_1_.get(p_entityHasObjective_2_);
        return lvt_4_1_ != null;
    }

    public Score getOrCreateScore(String p_getOrCreateScore_1_, ScoreObjective p_getOrCreateScore_2_) {
        Score lvt_4_1_;
        if (p_getOrCreateScore_1_.length() > 40) {
            throw new IllegalArgumentException("The player name '" + p_getOrCreateScore_1_ + "' is too long!");
        }
        HashMap lvt_3_1_ = this.entitiesScoreObjectives.get(p_getOrCreateScore_1_);
        if (lvt_3_1_ == null) {
            lvt_3_1_ = Maps.newHashMap();
            this.entitiesScoreObjectives.put(p_getOrCreateScore_1_, lvt_3_1_);
        }
        if ((lvt_4_1_ = (Score)lvt_3_1_.get(p_getOrCreateScore_2_)) == null) {
            lvt_4_1_ = new Score(this, p_getOrCreateScore_2_, p_getOrCreateScore_1_);
            lvt_3_1_.put(p_getOrCreateScore_2_, lvt_4_1_);
        }
        return lvt_4_1_;
    }

    public Collection<Score> getSortedScores(ScoreObjective p_getSortedScores_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        for (Map<ScoreObjective, Score> lvt_4_1_ : this.entitiesScoreObjectives.values()) {
            Score lvt_5_1_ = lvt_4_1_.get(p_getSortedScores_1_);
            if (lvt_5_1_ == null) continue;
            lvt_2_1_.add(lvt_5_1_);
        }
        Collections.sort(lvt_2_1_, Score.SCORE_COMPARATOR);
        return lvt_2_1_;
    }

    public Collection<ScoreObjective> getScoreObjectives() {
        return this.scoreObjectives.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.entitiesScoreObjectives.keySet();
    }

    public void removeObjectiveFromEntity(String p_removeObjectiveFromEntity_1_, ScoreObjective p_removeObjectiveFromEntity_2_) {
        if (p_removeObjectiveFromEntity_2_ == null) {
            Map<ScoreObjective, Score> lvt_3_1_ = this.entitiesScoreObjectives.remove(p_removeObjectiveFromEntity_1_);
            if (lvt_3_1_ != null) {
                this.broadcastScoreUpdate(p_removeObjectiveFromEntity_1_);
            }
        } else {
            Map<ScoreObjective, Score> lvt_3_2_ = this.entitiesScoreObjectives.get(p_removeObjectiveFromEntity_1_);
            if (lvt_3_2_ != null) {
                Score lvt_4_1_ = lvt_3_2_.remove(p_removeObjectiveFromEntity_2_);
                if (lvt_3_2_.size() < 1) {
                    Map<ScoreObjective, Score> lvt_5_1_ = this.entitiesScoreObjectives.remove(p_removeObjectiveFromEntity_1_);
                    if (lvt_5_1_ != null) {
                        this.broadcastScoreUpdate(p_removeObjectiveFromEntity_1_);
                    }
                } else if (lvt_4_1_ != null) {
                    this.broadcastScoreUpdate(p_removeObjectiveFromEntity_1_, p_removeObjectiveFromEntity_2_);
                }
            }
        }
    }

    public Collection<Score> getScores() {
        Collection<Map<ScoreObjective, Score>> lvt_1_1_ = this.entitiesScoreObjectives.values();
        ArrayList lvt_2_1_ = Lists.newArrayList();
        for (Map<ScoreObjective, Score> lvt_4_1_ : lvt_1_1_) {
            lvt_2_1_.addAll(lvt_4_1_.values());
        }
        return lvt_2_1_;
    }

    public Map<ScoreObjective, Score> getObjectivesForEntity(String p_getObjectivesForEntity_1_) {
        HashMap lvt_2_1_ = this.entitiesScoreObjectives.get(p_getObjectivesForEntity_1_);
        if (lvt_2_1_ == null) {
            lvt_2_1_ = Maps.newHashMap();
        }
        return lvt_2_1_;
    }

    public void removeObjective(ScoreObjective p_removeObjective_1_) {
        this.scoreObjectives.remove(p_removeObjective_1_.getName());
        for (int lvt_2_1_ = 0; lvt_2_1_ < 19; ++lvt_2_1_) {
            if (this.getObjectiveInDisplaySlot(lvt_2_1_) != p_removeObjective_1_) continue;
            this.setObjectiveInDisplaySlot(lvt_2_1_, null);
        }
        List<ScoreObjective> lvt_2_2_ = this.scoreObjectiveCriterias.get(p_removeObjective_1_.getCriteria());
        if (lvt_2_2_ != null) {
            lvt_2_2_.remove(p_removeObjective_1_);
        }
        for (Map<ScoreObjective, Score> lvt_4_1_ : this.entitiesScoreObjectives.values()) {
            lvt_4_1_.remove(p_removeObjective_1_);
        }
        this.onScoreObjectiveRemoved(p_removeObjective_1_);
    }

    public void setObjectiveInDisplaySlot(int p_setObjectiveInDisplaySlot_1_, ScoreObjective p_setObjectiveInDisplaySlot_2_) {
        this.objectiveDisplaySlots[p_setObjectiveInDisplaySlot_1_] = p_setObjectiveInDisplaySlot_2_;
    }

    @Nullable
    public ScoreObjective getObjectiveInDisplaySlot(int p_getObjectiveInDisplaySlot_1_) {
        return this.objectiveDisplaySlots[p_getObjectiveInDisplaySlot_1_];
    }

    public ScorePlayerTeam getTeam(String p_getTeam_1_) {
        return this.teams.get(p_getTeam_1_);
    }

    public ScorePlayerTeam createTeam(String p_createTeam_1_) {
        if (p_createTeam_1_.length() > 16) {
            throw new IllegalArgumentException("The team name '" + p_createTeam_1_ + "' is too long!");
        }
        ScorePlayerTeam lvt_2_1_ = this.getTeam(p_createTeam_1_);
        if (lvt_2_1_ != null) {
            throw new IllegalArgumentException("A team with the name '" + p_createTeam_1_ + "' already exists!");
        }
        lvt_2_1_ = new ScorePlayerTeam(this, p_createTeam_1_);
        this.teams.put(p_createTeam_1_, lvt_2_1_);
        this.broadcastTeamCreated(lvt_2_1_);
        return lvt_2_1_;
    }

    public void removeTeam(ScorePlayerTeam p_removeTeam_1_) {
        this.teams.remove(p_removeTeam_1_.getRegisteredName());
        for (String lvt_3_1_ : p_removeTeam_1_.getMembershipCollection()) {
            this.teamMemberships.remove(lvt_3_1_);
        }
        this.broadcastTeamRemove(p_removeTeam_1_);
    }

    public boolean addPlayerToTeam(String p_addPlayerToTeam_1_, String p_addPlayerToTeam_2_) {
        if (p_addPlayerToTeam_1_.length() > 40) {
            throw new IllegalArgumentException("The player name '" + p_addPlayerToTeam_1_ + "' is too long!");
        }
        if (!this.teams.containsKey(p_addPlayerToTeam_2_)) {
            return false;
        }
        ScorePlayerTeam lvt_3_1_ = this.getTeam(p_addPlayerToTeam_2_);
        if (this.getPlayersTeam(p_addPlayerToTeam_1_) != null) {
            this.removePlayerFromTeams(p_addPlayerToTeam_1_);
        }
        this.teamMemberships.put(p_addPlayerToTeam_1_, lvt_3_1_);
        lvt_3_1_.getMembershipCollection().add(p_addPlayerToTeam_1_);
        return true;
    }

    public boolean removePlayerFromTeams(String p_removePlayerFromTeams_1_) {
        ScorePlayerTeam lvt_2_1_ = this.getPlayersTeam(p_removePlayerFromTeams_1_);
        if (lvt_2_1_ != null) {
            this.removePlayerFromTeam(p_removePlayerFromTeams_1_, lvt_2_1_);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String p_removePlayerFromTeam_1_, ScorePlayerTeam p_removePlayerFromTeam_2_) {
        if (this.getPlayersTeam(p_removePlayerFromTeam_1_) != p_removePlayerFromTeam_2_) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + p_removePlayerFromTeam_2_.getRegisteredName() + "'.");
        }
        this.teamMemberships.remove(p_removePlayerFromTeam_1_);
        p_removePlayerFromTeam_2_.getMembershipCollection().remove(p_removePlayerFromTeam_1_);
    }

    public Collection<String> getTeamNames() {
        return this.teams.keySet();
    }

    public Collection<ScorePlayerTeam> getTeams() {
        return this.teams.values();
    }

    @Nullable
    public ScorePlayerTeam getPlayersTeam(String p_getPlayersTeam_1_) {
        return this.teamMemberships.get(p_getPlayersTeam_1_);
    }

    public void onScoreObjectiveAdded(ScoreObjective p_onScoreObjectiveAdded_1_) {
    }

    public void onObjectiveDisplayNameChanged(ScoreObjective p_onObjectiveDisplayNameChanged_1_) {
    }

    public void onScoreObjectiveRemoved(ScoreObjective p_onScoreObjectiveRemoved_1_) {
    }

    public void onScoreUpdated(Score p_onScoreUpdated_1_) {
    }

    public void broadcastScoreUpdate(String p_broadcastScoreUpdate_1_) {
    }

    public void broadcastScoreUpdate(String p_broadcastScoreUpdate_1_, ScoreObjective p_broadcastScoreUpdate_2_) {
    }

    public void broadcastTeamCreated(ScorePlayerTeam p_broadcastTeamCreated_1_) {
    }

    public void broadcastTeamInfoUpdate(ScorePlayerTeam p_broadcastTeamInfoUpdate_1_) {
    }

    public void broadcastTeamRemove(ScorePlayerTeam p_broadcastTeamRemove_1_) {
    }

    public static String getObjectiveDisplaySlot(int p_getObjectiveDisplaySlot_0_) {
        TextFormatting lvt_1_1_;
        switch (p_getObjectiveDisplaySlot_0_) {
            case 0: {
                return "list";
            }
            case 1: {
                return "sidebar";
            }
            case 2: {
                return "belowName";
            }
        }
        if (p_getObjectiveDisplaySlot_0_ >= 3 && p_getObjectiveDisplaySlot_0_ <= 18 && (lvt_1_1_ = TextFormatting.fromColorIndex(p_getObjectiveDisplaySlot_0_ - 3)) != null && lvt_1_1_ != TextFormatting.RESET) {
            return "sidebar.team." + lvt_1_1_.getFriendlyName();
        }
        return null;
    }

    public static int getObjectiveDisplaySlotNumber(String p_getObjectiveDisplaySlotNumber_0_) {
        String lvt_1_1_;
        TextFormatting lvt_2_1_;
        if ("list".equalsIgnoreCase(p_getObjectiveDisplaySlotNumber_0_)) {
            return 0;
        }
        if ("sidebar".equalsIgnoreCase(p_getObjectiveDisplaySlotNumber_0_)) {
            return 1;
        }
        if ("belowName".equalsIgnoreCase(p_getObjectiveDisplaySlotNumber_0_)) {
            return 2;
        }
        if (p_getObjectiveDisplaySlotNumber_0_.startsWith("sidebar.team.") && (lvt_2_1_ = TextFormatting.getValueByName(lvt_1_1_ = p_getObjectiveDisplaySlotNumber_0_.substring("sidebar.team.".length()))) != null && lvt_2_1_.getColorIndex() >= 0) {
            return lvt_2_1_.getColorIndex() + 3;
        }
        return -1;
    }

    public static String[] getDisplaySlotStrings() {
        if (displaySlots == null) {
            displaySlots = new String[19];
            for (int lvt_0_1_ = 0; lvt_0_1_ < 19; ++lvt_0_1_) {
                Scoreboard.displaySlots[lvt_0_1_] = Scoreboard.getObjectiveDisplaySlot(lvt_0_1_);
            }
        }
        return displaySlots;
    }

    public void removeEntity(Entity p_removeEntity_1_) {
        if (p_removeEntity_1_ == null || p_removeEntity_1_ instanceof EntityPlayer || p_removeEntity_1_.isEntityAlive()) {
            return;
        }
        String lvt_2_1_ = p_removeEntity_1_.getCachedUniqueIdString();
        this.removeObjectiveFromEntity(lvt_2_1_, null);
        this.removePlayerFromTeams(lvt_2_1_);
    }
}

