/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;

public class ServerScoreboard
extends Scoreboard {
    private final MinecraftServer scoreboardMCServer;
    private final Set<ScoreObjective> addedObjectives = Sets.newHashSet();
    private Runnable[] dirtyRunnables = new Runnable[0];

    public ServerScoreboard(MinecraftServer p_i1501_1_) {
        this.scoreboardMCServer = p_i1501_1_;
    }

    @Override
    public void onScoreUpdated(Score p_onScoreUpdated_1_) {
        super.onScoreUpdated(p_onScoreUpdated_1_);
        if (this.addedObjectives.contains(p_onScoreUpdated_1_.getObjective())) {
            this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketUpdateScore(p_onScoreUpdated_1_));
        }
        this.markSaveDataDirty();
    }

    @Override
    public void broadcastScoreUpdate(String p_broadcastScoreUpdate_1_) {
        super.broadcastScoreUpdate(p_broadcastScoreUpdate_1_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketUpdateScore(p_broadcastScoreUpdate_1_));
        this.markSaveDataDirty();
    }

    @Override
    public void broadcastScoreUpdate(String p_broadcastScoreUpdate_1_, ScoreObjective p_broadcastScoreUpdate_2_) {
        super.broadcastScoreUpdate(p_broadcastScoreUpdate_1_, p_broadcastScoreUpdate_2_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketUpdateScore(p_broadcastScoreUpdate_1_, p_broadcastScoreUpdate_2_));
        this.markSaveDataDirty();
    }

    @Override
    public void setObjectiveInDisplaySlot(int p_setObjectiveInDisplaySlot_1_, ScoreObjective p_setObjectiveInDisplaySlot_2_) {
        ScoreObjective lvt_3_1_ = this.getObjectiveInDisplaySlot(p_setObjectiveInDisplaySlot_1_);
        super.setObjectiveInDisplaySlot(p_setObjectiveInDisplaySlot_1_, p_setObjectiveInDisplaySlot_2_);
        if (lvt_3_1_ != p_setObjectiveInDisplaySlot_2_ && lvt_3_1_ != null) {
            if (this.getObjectiveDisplaySlotCount(lvt_3_1_) > 0) {
                this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketDisplayObjective(p_setObjectiveInDisplaySlot_1_, p_setObjectiveInDisplaySlot_2_));
            } else {
                this.sendDisplaySlotRemovalPackets(lvt_3_1_);
            }
        }
        if (p_setObjectiveInDisplaySlot_2_ != null) {
            if (this.addedObjectives.contains(p_setObjectiveInDisplaySlot_2_)) {
                this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketDisplayObjective(p_setObjectiveInDisplaySlot_1_, p_setObjectiveInDisplaySlot_2_));
            } else {
                this.addObjective(p_setObjectiveInDisplaySlot_2_);
            }
        }
        this.markSaveDataDirty();
    }

    @Override
    public boolean addPlayerToTeam(String p_addPlayerToTeam_1_, String p_addPlayerToTeam_2_) {
        if (super.addPlayerToTeam(p_addPlayerToTeam_1_, p_addPlayerToTeam_2_)) {
            ScorePlayerTeam lvt_3_1_ = this.getTeam(p_addPlayerToTeam_2_);
            this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketTeams(lvt_3_1_, Arrays.asList(p_addPlayerToTeam_1_), 3));
            this.markSaveDataDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removePlayerFromTeam(String p_removePlayerFromTeam_1_, ScorePlayerTeam p_removePlayerFromTeam_2_) {
        super.removePlayerFromTeam(p_removePlayerFromTeam_1_, p_removePlayerFromTeam_2_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketTeams(p_removePlayerFromTeam_2_, Arrays.asList(p_removePlayerFromTeam_1_), 4));
        this.markSaveDataDirty();
    }

    @Override
    public void onScoreObjectiveAdded(ScoreObjective p_onScoreObjectiveAdded_1_) {
        super.onScoreObjectiveAdded(p_onScoreObjectiveAdded_1_);
        this.markSaveDataDirty();
    }

    @Override
    public void onObjectiveDisplayNameChanged(ScoreObjective p_onObjectiveDisplayNameChanged_1_) {
        super.onObjectiveDisplayNameChanged(p_onObjectiveDisplayNameChanged_1_);
        if (this.addedObjectives.contains(p_onObjectiveDisplayNameChanged_1_)) {
            this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketScoreboardObjective(p_onObjectiveDisplayNameChanged_1_, 2));
        }
        this.markSaveDataDirty();
    }

    @Override
    public void onScoreObjectiveRemoved(ScoreObjective p_onScoreObjectiveRemoved_1_) {
        super.onScoreObjectiveRemoved(p_onScoreObjectiveRemoved_1_);
        if (this.addedObjectives.contains(p_onScoreObjectiveRemoved_1_)) {
            this.sendDisplaySlotRemovalPackets(p_onScoreObjectiveRemoved_1_);
        }
        this.markSaveDataDirty();
    }

    @Override
    public void broadcastTeamCreated(ScorePlayerTeam p_broadcastTeamCreated_1_) {
        super.broadcastTeamCreated(p_broadcastTeamCreated_1_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketTeams(p_broadcastTeamCreated_1_, 0));
        this.markSaveDataDirty();
    }

    @Override
    public void broadcastTeamInfoUpdate(ScorePlayerTeam p_broadcastTeamInfoUpdate_1_) {
        super.broadcastTeamInfoUpdate(p_broadcastTeamInfoUpdate_1_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketTeams(p_broadcastTeamInfoUpdate_1_, 2));
        this.markSaveDataDirty();
    }

    @Override
    public void broadcastTeamRemove(ScorePlayerTeam p_broadcastTeamRemove_1_) {
        super.broadcastTeamRemove(p_broadcastTeamRemove_1_);
        this.scoreboardMCServer.getPlayerList().sendPacketToAllPlayers(new SPacketTeams(p_broadcastTeamRemove_1_, 1));
        this.markSaveDataDirty();
    }

    public void addDirtyRunnable(Runnable p_addDirtyRunnable_1_) {
        this.dirtyRunnables = Arrays.copyOf(this.dirtyRunnables, this.dirtyRunnables.length + 1);
        this.dirtyRunnables[this.dirtyRunnables.length - 1] = p_addDirtyRunnable_1_;
    }

    protected void markSaveDataDirty() {
        for (Runnable lvt_4_1_ : this.dirtyRunnables) {
            lvt_4_1_.run();
        }
    }

    public List<Packet<?>> getCreatePackets(ScoreObjective p_getCreatePackets_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        lvt_2_1_.add(new SPacketScoreboardObjective(p_getCreatePackets_1_, 0));
        for (int lvt_3_1_ = 0; lvt_3_1_ < 19; ++lvt_3_1_) {
            if (this.getObjectiveInDisplaySlot(lvt_3_1_) != p_getCreatePackets_1_) continue;
            lvt_2_1_.add(new SPacketDisplayObjective(lvt_3_1_, p_getCreatePackets_1_));
        }
        for (Score lvt_4_1_ : this.getSortedScores(p_getCreatePackets_1_)) {
            lvt_2_1_.add(new SPacketUpdateScore(lvt_4_1_));
        }
        return lvt_2_1_;
    }

    public void addObjective(ScoreObjective p_addObjective_1_) {
        List<Packet<?>> lvt_2_1_ = this.getCreatePackets(p_addObjective_1_);
        for (EntityPlayerMP lvt_4_1_ : this.scoreboardMCServer.getPlayerList().getPlayers()) {
            for (Packet<?> lvt_6_1_ : lvt_2_1_) {
                lvt_4_1_.connection.sendPacket(lvt_6_1_);
            }
        }
        this.addedObjectives.add(p_addObjective_1_);
    }

    public List<Packet<?>> getDestroyPackets(ScoreObjective p_getDestroyPackets_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        lvt_2_1_.add(new SPacketScoreboardObjective(p_getDestroyPackets_1_, 1));
        for (int lvt_3_1_ = 0; lvt_3_1_ < 19; ++lvt_3_1_) {
            if (this.getObjectiveInDisplaySlot(lvt_3_1_) != p_getDestroyPackets_1_) continue;
            lvt_2_1_.add(new SPacketDisplayObjective(lvt_3_1_, p_getDestroyPackets_1_));
        }
        return lvt_2_1_;
    }

    public void sendDisplaySlotRemovalPackets(ScoreObjective p_sendDisplaySlotRemovalPackets_1_) {
        List<Packet<?>> lvt_2_1_ = this.getDestroyPackets(p_sendDisplaySlotRemovalPackets_1_);
        for (EntityPlayerMP lvt_4_1_ : this.scoreboardMCServer.getPlayerList().getPlayers()) {
            for (Packet<?> lvt_6_1_ : lvt_2_1_) {
                lvt_4_1_.connection.sendPacket(lvt_6_1_);
            }
        }
        this.addedObjectives.remove(p_sendDisplaySlotRemovalPackets_1_);
    }

    public int getObjectiveDisplaySlotCount(ScoreObjective p_getObjectiveDisplaySlotCount_1_) {
        int lvt_2_1_ = 0;
        for (int lvt_3_1_ = 0; lvt_3_1_ < 19; ++lvt_3_1_) {
            if (this.getObjectiveInDisplaySlot(lvt_3_1_) != p_getObjectiveDisplaySlotCount_1_) continue;
            ++lvt_2_1_;
        }
        return lvt_2_1_;
    }
}

