/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Team {
    public boolean isSameTeam(Team p_isSameTeam_1_) {
        if (p_isSameTeam_1_ == null) {
            return false;
        }
        return this == p_isSameTeam_1_;
    }

    public abstract String getRegisteredName();

    public abstract String formatString(String var1);

    @SideOnly(value=Side.CLIENT)
    public abstract boolean getSeeFriendlyInvisiblesEnabled();

    public abstract boolean getAllowFriendlyFire();

    @SideOnly(value=Side.CLIENT)
    public abstract EnumVisible getNameTagVisibility();

    public abstract TextFormatting getChatFormat();

    public abstract Collection<String> getMembershipCollection();

    public abstract EnumVisible getDeathMessageVisibility();

    public abstract CollisionRule getCollisionRule();

    public static enum CollisionRule {
        ALWAYS("always", 0),
        NEVER("never", 1),
        HIDE_FOR_OTHER_TEAMS("pushOtherTeams", 2),
        HIDE_FOR_OWN_TEAM("pushOwnTeam", 3);

        private static final Map<String, CollisionRule> nameMap;
        public final String name;
        public final int id;

        public static String[] getNames() {
            return nameMap.keySet().toArray(new String[nameMap.size()]);
        }

        @Nullable
        public static CollisionRule getByName(String p_getByName_0_) {
            return nameMap.get(p_getByName_0_);
        }

        private CollisionRule(String p_i47053_3_, int p_i47053_4_) {
            this.name = p_i47053_3_;
            this.id = p_i47053_4_;
        }

        static {
            nameMap = Maps.newHashMap();
            for (CollisionRule lvt_3_1_ : CollisionRule.values()) {
                nameMap.put(lvt_3_1_.name, lvt_3_1_);
            }
        }
    }

    public static enum EnumVisible {
        ALWAYS("always", 0),
        NEVER("never", 1),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams", 2),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam", 3);

        private static final Map<String, EnumVisible> nameMap;
        public final String internalName;
        public final int id;

        public static String[] getNames() {
            return nameMap.keySet().toArray(new String[nameMap.size()]);
        }

        @Nullable
        public static EnumVisible getByName(String p_getByName_0_) {
            return nameMap.get(p_getByName_0_);
        }

        private EnumVisible(String p_i45550_3_, int p_i45550_4_) {
            this.internalName = p_i45550_3_;
            this.id = p_i45550_4_;
        }

        static {
            nameMap = Maps.newHashMap();
            for (EnumVisible lvt_3_1_ : EnumVisible.values()) {
                nameMap.put(lvt_3_1_.internalName, lvt_3_1_);
            }
        }
    }
}

