/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Bootstrap;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements Runnable,
ICommandSender,
IThreadListener,
ISnooperInfo {
    private static final Logger LOG = LogManager.getLogger();
    public static final File USER_CACHE_FILE = new File("usercache.json");
    private final ISaveFormat anvilConverterForAnvilFile;
    private final Snooper usageSnooper = new Snooper("server", this, MinecraftServer.getCurrentTimeMillis());
    private final File anvilFile;
    private final List<ITickable> tickables = Lists.newArrayList();
    public final ICommandManager commandManager;
    public final Profiler theProfiler = new Profiler();
    private final NetworkSystem networkSystem;
    private final ServerStatusResponse statusResponse = new ServerStatusResponse();
    private final Random random = new Random();
    private final DataFixer dataFixer;
    @SideOnly(value=Side.SERVER)
    private String hostname;
    private int serverPort = -1;
    public WorldServer[] worlds = new WorldServer[0];
    private PlayerList playerList;
    private boolean serverRunning = true;
    private boolean serverStopped;
    private int tickCounter;
    protected final Proxy serverProxy;
    public String currentTask;
    public int percentDone;
    private boolean onlineMode;
    private boolean preventProxyConnections;
    private boolean canSpawnAnimals;
    private boolean canSpawnNPCs;
    private boolean pvpEnabled;
    private boolean allowFlight;
    private String motd;
    private int buildLimit;
    private int maxPlayerIdleMinutes;
    public final long[] tickTimeArray = new long[100];
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    private KeyPair serverKeyPair;
    private String serverOwner;
    private String folderName;
    @SideOnly(value=Side.CLIENT)
    private String worldName;
    private boolean isDemo;
    private boolean enableBonusChest;
    private String resourcePackUrl = "";
    private String resourcePackHash = "";
    private boolean serverIsRunning;
    private long timeOfLastWarning;
    private String userMessage;
    private boolean startProfiling;
    private boolean isGamemodeForced;
    private final YggdrasilAuthenticationService authService;
    private final MinecraftSessionService sessionService;
    private final GameProfileRepository profileRepo;
    private final PlayerProfileCache profileCache;
    private long nanoTimeSinceStatusRefresh;
    public final Queue<FutureTask<?>> futureTaskQueue = Queues.newArrayDeque();
    private Thread serverThread;
    private long currentTime = MinecraftServer.getCurrentTimeMillis();
    @SideOnly(value=Side.CLIENT)
    private boolean worldIconSet;

    public MinecraftServer(File p_i47054_1_, Proxy p_i47054_2_, DataFixer p_i47054_3_, YggdrasilAuthenticationService p_i47054_4_, MinecraftSessionService p_i47054_5_, GameProfileRepository p_i47054_6_, PlayerProfileCache p_i47054_7_) {
        this.serverProxy = p_i47054_2_;
        this.authService = p_i47054_4_;
        this.sessionService = p_i47054_5_;
        this.profileRepo = p_i47054_6_;
        this.profileCache = p_i47054_7_;
        this.anvilFile = p_i47054_1_;
        this.networkSystem = new NetworkSystem(this);
        this.commandManager = this.createCommandManager();
        this.anvilConverterForAnvilFile = new AnvilSaveConverter(p_i47054_1_, p_i47054_3_);
        this.dataFixer = p_i47054_3_;
    }

    public ServerCommandManager createCommandManager() {
        return new ServerCommandManager(this);
    }

    public abstract boolean init() throws IOException;

    public void convertMapIfNeeded(String p_convertMapIfNeeded_1_) {
        if (this.getActiveAnvilConverter().isOldMapFormat(p_convertMapIfNeeded_1_)) {
            LOG.info("Converting map!");
            this.setUserMessage("menu.convertingLevel");
            this.getActiveAnvilConverter().convertMapFormat(p_convertMapIfNeeded_1_, new IProgressUpdate(){
                private long startTime = System.currentTimeMillis();

                @Override
                public void displaySavingString(String p_displaySavingString_1_) {
                }

                @Override
                public void setLoadingProgress(int p_setLoadingProgress_1_) {
                    if (System.currentTimeMillis() - this.startTime >= 1000L) {
                        this.startTime = System.currentTimeMillis();
                        LOG.info("Converting... {}%", new Object[]{p_setLoadingProgress_1_});
                    }
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void resetProgressAndMessage(String p_resetProgressAndMessage_1_) {
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void setDoneWorking() {
                }

                @Override
                public void displayLoadingString(String p_displayLoadingString_1_) {
                }
            });
        }
    }

    protected synchronized void setUserMessage(String p_setUserMessage_1_) {
        this.userMessage = p_setUserMessage_1_;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public synchronized String getUserMessage() {
        return this.userMessage;
    }

    public void loadAllWorlds(String p_loadAllWorlds_1_, String p_loadAllWorlds_2_, long p_loadAllWorlds_3_, WorldType p_loadAllWorlds_5_, String p_loadAllWorlds_6_) {
        WorldSettings worldsettings;
        this.convertMapIfNeeded(p_loadAllWorlds_1_);
        this.setUserMessage("menu.loadingLevel");
        ISaveHandler isavehandler = this.anvilConverterForAnvilFile.getSaveLoader(p_loadAllWorlds_1_, true);
        this.setResourcePackFromWorld(this.getFolderName(), isavehandler);
        WorldInfo worldinfo = isavehandler.loadWorldInfo();
        if (worldinfo == null) {
            if (this.isDemo()) {
                worldsettings = DemoWorldServer.DEMO_WORLD_SETTINGS;
            } else {
                worldsettings = new WorldSettings(p_loadAllWorlds_3_, this.getGameType(), this.canStructuresSpawn(), this.isHardcore(), p_loadAllWorlds_5_);
                worldsettings.setGeneratorOptions(p_loadAllWorlds_6_);
                if (this.enableBonusChest) {
                    worldsettings.enableBonusChest();
                }
            }
            worldinfo = new WorldInfo(worldsettings, p_loadAllWorlds_2_);
        } else {
            worldinfo.setWorldName(p_loadAllWorlds_2_);
            worldsettings = new WorldSettings(worldinfo);
        }
        WorldServer overWorld = (WorldServer)(this.isDemo() ? new DemoWorldServer(this, isavehandler, worldinfo, 0, this.theProfiler).init() : new WorldServer(this, isavehandler, worldinfo, 0, this.theProfiler).init());
        overWorld.initialize(worldsettings);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = dim == 0 ? overWorld : (WorldServer)new WorldServerMulti(this, isavehandler, dim, overWorld, this.theProfiler).init();
            world.addEventListener(new ServerWorldEventHandler(this, world));
            if (!this.isSinglePlayer()) {
                world.getWorldInfo().setGameType(this.getGameType());
            }
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        this.playerList.setPlayerManager(new WorldServer[]{overWorld});
        this.setDifficultyForAllWorlds(this.getDifficulty());
        this.initialWorldChunkLoad();
    }

    public void initialWorldChunkLoad() {
        int i = 16;
        int j = 4;
        int k = 192;
        int l = 625;
        int i1 = 0;
        this.setUserMessage("menu.generatingTerrain");
        int j1 = 0;
        LOG.info("Preparing start region for level 0");
        WorldServer worldserver = DimensionManager.getWorld(j1);
        BlockPos blockpos = worldserver.getSpawnPoint();
        long k1 = MinecraftServer.getCurrentTimeMillis();
        for (int l1 = -192; l1 <= 192 && this.isServerRunning(); l1 += 16) {
            for (int i2 = -192; i2 <= 192 && this.isServerRunning(); i2 += 16) {
                long j2 = MinecraftServer.getCurrentTimeMillis();
                if (j2 - k1 > 1000L) {
                    this.outputPercentRemaining("Preparing spawn area", i1 * 100 / 625);
                    k1 = j2;
                }
                ++i1;
                worldserver.getChunkProvider().provideChunk(blockpos.getX() + l1 >> 4, blockpos.getZ() + i2 >> 4);
            }
        }
        this.clearCurrentTask();
    }

    public void setResourcePackFromWorld(String p_setResourcePackFromWorld_1_, ISaveHandler p_setResourcePackFromWorld_2_) {
        File file1 = new File(p_setResourcePackFromWorld_2_.getWorldDirectory(), "resources.zip");
        if (file1.isFile()) {
            try {
                this.setResourcePack("level://" + URLEncoder.encode(p_setResourcePackFromWorld_1_, Charsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException var5) {
                LOG.warn("Something went wrong url encoding {}", new Object[]{p_setResourcePackFromWorld_1_});
            }
        }
    }

    public abstract boolean canStructuresSpawn();

    public abstract GameType getGameType();

    public abstract EnumDifficulty getDifficulty();

    public abstract boolean isHardcore();

    public abstract int getOpPermissionLevel();

    public abstract boolean shouldBroadcastRconToOps();

    public abstract boolean shouldBroadcastConsoleToOps();

    protected void outputPercentRemaining(String p_outputPercentRemaining_1_, int p_outputPercentRemaining_2_) {
        this.currentTask = p_outputPercentRemaining_1_;
        this.percentDone = p_outputPercentRemaining_2_;
        LOG.info("{}: {}%", new Object[]{p_outputPercentRemaining_1_, p_outputPercentRemaining_2_});
    }

    protected void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    public void saveAllWorlds(boolean p_saveAllWorlds_1_) {
        for (WorldServer worldserver : this.worlds) {
            if (worldserver == null) continue;
            if (!p_saveAllWorlds_1_) {
                LOG.info("Saving chunks for level '{}'/{}", new Object[]{worldserver.getWorldInfo().getWorldName(), worldserver.provider.getDimensionType().getName()});
            }
            try {
                worldserver.saveAllChunks(true, null);
            }
            catch (MinecraftException minecraftexception) {
                LOG.warn(minecraftexception.getMessage());
            }
        }
    }

    public void stopServer() {
        LOG.info("Stopping server");
        if (this.getNetworkSystem() != null) {
            this.getNetworkSystem().terminateEndpoints();
        }
        if (this.playerList != null) {
            LOG.info("Saving players");
            this.playerList.saveAllPlayerData();
            this.playerList.removeAllPlayers();
        }
        if (this.worlds != null) {
            WorldServer[] tmp;
            LOG.info("Saving worlds");
            for (WorldServer worldserver : this.worlds) {
                if (worldserver == null) continue;
                worldserver.disableLevelSaving = false;
            }
            this.saveAllWorlds(false);
            for (WorldServer worldserver1 : this.worlds) {
                if (worldserver1 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver1));
                worldserver1.flush();
            }
            for (WorldServer world : tmp = this.worlds) {
                DimensionManager.setWorld(world.provider.getDimension(), null, this);
            }
        }
        if (this.usageSnooper.isSnooperRunning()) {
            this.usageSnooper.stopSnooper();
        }
    }

    public boolean isServerRunning() {
        return this.serverRunning;
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long i;
        try {
            if (!this.init()) {
                FMLCommonHandler.instance().expectServerStopped();
                this.finalTick(null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            this.currentTime = MinecraftServer.getCurrentTimeMillis();
            i = 0L;
            this.statusResponse.setServerDescription(new TextComponentString(this.motd));
            this.statusResponse.setVersion(new ServerStatusResponse.Version("1.11.2", 316));
            this.applyServerIconToResponse(this.statusResponse);
        }
        catch (StartupQuery.AbortedException e) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            LOG.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = null;
            crashreport = throwable1 instanceof ReportedException ? this.addServerInfoToCrashReport(((ReportedException)throwable1).getCrashReport()) : this.addServerInfoToCrashReport(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.getDataDirectory(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.saveToFile(file1)) {
                LOG.error("This crash report has been saved to: {}", new Object[]{file1.getAbsolutePath()});
            } else {
                LOG.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.finalTick(crashreport);
            return;
        }
        finally {
            try {
                this.stopServer();
                this.serverStopped = true;
            }
            catch (Throwable throwable) {
                LOG.error("Exception stopping the server", throwable);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.serverStopped = true;
                this.systemExitNow();
            }
        }
        while (true) {
            if (!this.serverRunning) {
                FMLCommonHandler.instance().handleServerStopping();
                FMLCommonHandler.instance().expectServerStopped();
                return;
            }
            long k = MinecraftServer.getCurrentTimeMillis();
            long j = k - this.currentTime;
            if (j > 2000L && this.currentTime - this.timeOfLastWarning >= 15000L) {
                LOG.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{j, j / 50L});
                j = 2000L;
                this.timeOfLastWarning = this.currentTime;
            }
            if (j < 0L) {
                LOG.warn("Time ran backwards! Did the system time change?");
                j = 0L;
            }
            i += j;
            this.currentTime = k;
            if (this.worlds[0].areAllPlayersAsleep()) {
                this.tick();
                i = 0L;
            } else {
                while (i > 50L) {
                    i -= 50L;
                    this.tick();
                }
            }
            Thread.sleep(Math.max(1L, 50L - i));
            this.serverIsRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyServerIconToResponse(ServerStatusResponse p_applyServerIconToResponse_1_) {
        File file1 = this.getFile("server-icon.png");
        if (!file1.exists()) {
            file1 = this.getActiveAnvilConverter().getFile(this.getFolderName(), "icon.png");
        }
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuf bytebuf1 = Base64.encode((ByteBuf)bytebuf);
                p_applyServerIconToResponse_1_.setFavicon("data:image/png;base64," + bytebuf1.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                LOG.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWorldIconSet() {
        this.worldIconSet = this.worldIconSet || this.getWorldIconFile().isFile();
        return this.worldIconSet;
    }

    @SideOnly(value=Side.CLIENT)
    public File getWorldIconFile() {
        return this.getActiveAnvilConverter().getFile(this.getFolderName(), "icon.png");
    }

    public File getDataDirectory() {
        return new File(".");
    }

    public void finalTick(CrashReport p_finalTick_1_) {
    }

    public void systemExitNow() {
    }

    public void tick() {
        long i = System.nanoTime();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.tickCounter;
        if (this.startProfiling) {
            this.startProfiling = false;
            this.theProfiler.profilingEnabled = true;
            this.theProfiler.clearProfiling();
        }
        this.theProfiler.startSection("root");
        this.updateTimeLightAndEntities();
        if (i - this.nanoTimeSinceStatusRefresh >= 5000000000L) {
            this.nanoTimeSinceStatusRefresh = i;
            this.statusResponse.setPlayers(new ServerStatusResponse.Players(this.getMaxPlayers(), this.getCurrentPlayerCount()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.getCurrentPlayerCount(), 12)];
            int j = MathHelper.getInt(this.random, 0, this.getCurrentPlayerCount() - agameprofile.length);
            for (int k = 0; k < agameprofile.length; ++k) {
                agameprofile[k] = this.playerList.getPlayers().get(j + k).getGameProfile();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.statusResponse.getPlayers().setPlayers(agameprofile);
            this.statusResponse.invalidateJson();
        }
        if (this.tickCounter % 900 == 0) {
            this.theProfiler.startSection("save");
            this.playerList.saveAllPlayerData();
            this.saveAllWorlds(true);
            this.theProfiler.endSection();
        }
        this.theProfiler.startSection("tallying");
        this.tickTimeArray[this.tickCounter % 100] = System.nanoTime() - i;
        this.theProfiler.endSection();
        this.theProfiler.startSection("snooper");
        if (!this.usageSnooper.isSnooperRunning() && this.tickCounter > 100) {
            this.usageSnooper.startSnooper();
        }
        if (this.tickCounter % 6000 == 0) {
            this.usageSnooper.addMemoryStatsToSnooper();
        }
        this.theProfiler.endSection();
        this.theProfiler.endSection();
        FMLCommonHandler.instance().onPostServerTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeLightAndEntities() {
        this.theProfiler.startSection("jobs");
        Queue<FutureTask<?>> queue = this.futureTaskQueue;
        synchronized (queue) {
            while (!this.futureTaskQueue.isEmpty()) {
                Util.runTask(this.futureTaskQueue.poll(), LOG);
            }
        }
        this.theProfiler.endStartSection("levels");
        ChunkIOExecutor.tick();
        Integer[] ids = DimensionManager.getIDs(this.tickCounter % 200 == 0);
        for (int x = 0; x < ids.length; ++x) {
            int id = ids[x];
            long i = System.nanoTime();
            if (id == 0 || this.getAllowNether()) {
                WorldServer worldserver = DimensionManager.getWorld(id);
                this.theProfiler.startSection(worldserver.getWorldInfo().getWorldName());
                if (this.tickCounter % 20 == 0) {
                    this.theProfiler.startSection("timeSync");
                    this.playerList.sendPacketToAllPlayersInDimension(new SPacketTimeUpdate(worldserver.getTotalWorldTime(), worldserver.getWorldTime(), worldserver.getGameRules().getBoolean("doDaylightCycle")), worldserver.provider.getDimension());
                    this.theProfiler.endSection();
                }
                this.theProfiler.startSection("tick");
                FMLCommonHandler.instance().onPreWorldTick(worldserver);
                try {
                    worldserver.tick();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable1, "Exception ticking world");
                    worldserver.addWorldInfoToCrashReport(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldserver.updateEntities();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.makeCrashReport(throwable, "Exception ticking world entities");
                    worldserver.addWorldInfoToCrashReport(crashreport1);
                    throw new ReportedException(crashreport1);
                }
                FMLCommonHandler.instance().onPostWorldTick(worldserver);
                this.theProfiler.endSection();
                this.theProfiler.startSection("tracker");
                worldserver.getEntityTracker().tick();
                this.theProfiler.endSection();
                this.theProfiler.endSection();
            }
            this.worldTickTimes.get((Object)Integer.valueOf((int)id))[this.tickCounter % 100] = System.nanoTime() - i;
        }
        this.theProfiler.endStartSection("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.theProfiler.endStartSection("connection");
        this.getNetworkSystem().networkTick();
        this.theProfiler.endStartSection("players");
        this.playerList.onTick();
        this.theProfiler.endStartSection("tickables");
        for (int k = 0; k < this.tickables.size(); ++k) {
            this.tickables.get(k).update();
        }
        this.theProfiler.endSection();
    }

    public boolean getAllowNether() {
        return true;
    }

    public void startServerThread() {
        StartupQuery.reset();
        this.serverThread = new Thread((Runnable)this, "Server thread");
        this.serverThread.start();
    }

    public File getFile(String p_getFile_1_) {
        return new File(this.getDataDirectory(), p_getFile_1_);
    }

    public void logWarning(String p_logWarning_1_) {
        LOG.warn(p_logWarning_1_);
    }

    public WorldServer worldServerForDimension(int p_worldServerForDimension_1_) {
        WorldServer ret = DimensionManager.getWorld(p_worldServerForDimension_1_);
        if (ret == null) {
            DimensionManager.initDimension(p_worldServerForDimension_1_);
            ret = DimensionManager.getWorld(p_worldServerForDimension_1_);
        }
        return ret;
    }

    public String getMinecraftVersion() {
        return "1.11.2";
    }

    public int getCurrentPlayerCount() {
        return this.playerList.getCurrentPlayerCount();
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public String[] getOnlinePlayerNames() {
        return this.playerList.getOnlinePlayerNames();
    }

    public GameProfile[] getOnlinePlayerProfiles() {
        return this.playerList.getOnlinePlayerProfiles();
    }

    public String getServerModName() {
        return FMLCommonHandler.instance().getModName();
    }

    public CrashReport addServerInfoToCrashReport(CrashReport p_addServerInfoToCrashReport_1_) {
        p_addServerInfoToCrashReport_1_.getCategory().setDetail("Profiler Position", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return MinecraftServer.this.theProfiler.profilingEnabled ? MinecraftServer.this.theProfiler.getNameOfLastSection() : "N/A (disabled)";
            }
        });
        if (this.playerList != null) {
            p_addServerInfoToCrashReport_1_.getCategory().setDetail("Player Count", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return MinecraftServer.this.playerList.getCurrentPlayerCount() + " / " + MinecraftServer.this.playerList.getMaxPlayers() + "; " + MinecraftServer.this.playerList.getPlayers();
                }
            });
        }
        return p_addServerInfoToCrashReport_1_;
    }

    public List<String> getTabCompletions(ICommandSender p_getTabCompletions_1_, String p_getTabCompletions_2_, BlockPos p_getTabCompletions_3_, boolean p_getTabCompletions_4_) {
        ArrayList list = Lists.newArrayList();
        boolean flag = p_getTabCompletions_2_.startsWith("/");
        if (flag) {
            p_getTabCompletions_2_ = p_getTabCompletions_2_.substring(1);
        }
        if (!flag && !p_getTabCompletions_4_) {
            String[] astring = p_getTabCompletions_2_.split(" ", -1);
            String s2 = astring[astring.length - 1];
            for (String s1 : this.playerList.getOnlinePlayerNames()) {
                if (!CommandBase.doesStringStartWith(s2, s1)) continue;
                list.add(s1);
            }
            return list;
        }
        boolean flag1 = !p_getTabCompletions_2_.contains(" ");
        List<String> list1 = this.commandManager.getTabCompletions(p_getTabCompletions_1_, p_getTabCompletions_2_, p_getTabCompletions_3_);
        if (!list1.isEmpty()) {
            for (String s : list1) {
                if (flag1) {
                    list.add("/" + s);
                    continue;
                }
                list.add(s);
            }
        }
        return list;
    }

    public boolean isAnvilFileSet() {
        return this.anvilFile != null;
    }

    @Override
    public String getName() {
        return "Server";
    }

    @Override
    public void sendMessage(ITextComponent p_sendMessage_1_) {
        LOG.info(p_sendMessage_1_.getUnformattedText());
    }

    @Override
    public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
        return true;
    }

    public ICommandManager getCommandManager() {
        return this.commandManager;
    }

    public KeyPair getKeyPair() {
        return this.serverKeyPair;
    }

    public String getServerOwner() {
        return this.serverOwner;
    }

    public void setServerOwner(String p_setServerOwner_1_) {
        this.serverOwner = p_setServerOwner_1_;
    }

    public boolean isSinglePlayer() {
        return this.serverOwner != null;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String p_setFolderName_1_) {
        this.folderName = p_setFolderName_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorldName(String p_setWorldName_1_) {
        this.worldName = p_setWorldName_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public String getWorldName() {
        return this.worldName;
    }

    public void setKeyPair(KeyPair p_setKeyPair_1_) {
        this.serverKeyPair = p_setKeyPair_1_;
    }

    public void setDifficultyForAllWorlds(EnumDifficulty p_setDifficultyForAllWorlds_1_) {
        for (WorldServer worldserver : this.worlds) {
            if (worldserver == null) continue;
            if (worldserver.getWorldInfo().isHardcoreModeEnabled()) {
                worldserver.getWorldInfo().setDifficulty(EnumDifficulty.HARD);
                worldserver.setAllowedSpawnTypes(true, true);
                continue;
            }
            if (this.isSinglePlayer()) {
                worldserver.getWorldInfo().setDifficulty(p_setDifficultyForAllWorlds_1_);
                worldserver.setAllowedSpawnTypes(worldserver.getDifficulty() != EnumDifficulty.PEACEFUL, true);
                continue;
            }
            worldserver.getWorldInfo().setDifficulty(p_setDifficultyForAllWorlds_1_);
            worldserver.setAllowedSpawnTypes(this.allowSpawnMonsters(), this.canSpawnAnimals);
        }
    }

    public boolean allowSpawnMonsters() {
        return true;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean p_setDemo_1_) {
        this.isDemo = p_setDemo_1_;
    }

    public void canCreateBonusChest(boolean p_canCreateBonusChest_1_) {
        this.enableBonusChest = p_canCreateBonusChest_1_;
    }

    public ISaveFormat getActiveAnvilConverter() {
        return this.anvilConverterForAnvilFile;
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }

    public String getResourcePackHash() {
        return this.resourcePackHash;
    }

    public void setResourcePack(String p_setResourcePack_1_, String p_setResourcePack_2_) {
        this.resourcePackUrl = p_setResourcePack_1_;
        this.resourcePackHash = p_setResourcePack_2_;
    }

    @Override
    public void addServerStatsToSnooper(Snooper p_addServerStatsToSnooper_1_) {
        p_addServerStatsToSnooper_1_.addClientStat("whitelist_enabled", false);
        p_addServerStatsToSnooper_1_.addClientStat("whitelist_count", 0);
        if (this.playerList != null) {
            p_addServerStatsToSnooper_1_.addClientStat("players_current", this.getCurrentPlayerCount());
            p_addServerStatsToSnooper_1_.addClientStat("players_max", this.getMaxPlayers());
            p_addServerStatsToSnooper_1_.addClientStat("players_seen", this.playerList.getAvailablePlayerDat().length);
        }
        p_addServerStatsToSnooper_1_.addClientStat("uses_auth", this.onlineMode);
        p_addServerStatsToSnooper_1_.addClientStat("gui_state", this.getGuiEnabled() ? "enabled" : "disabled");
        p_addServerStatsToSnooper_1_.addClientStat("run_time", (MinecraftServer.getCurrentTimeMillis() - p_addServerStatsToSnooper_1_.getMinecraftStartTimeMillis()) / 60L * 1000L);
        p_addServerStatsToSnooper_1_.addClientStat("avg_tick_ms", (int)(MathHelper.average(this.tickTimeArray) * 1.0E-6));
        int i = 0;
        if (this.worlds != null) {
            for (WorldServer worldserver : this.worlds) {
                if (worldserver == null) continue;
                WorldInfo worldinfo = worldserver.getWorldInfo();
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][dimension]", worldserver.provider.getDimensionType().getId());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][mode]", (Object)worldinfo.getGameType());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][difficulty]", (Object)worldserver.getDifficulty());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][hardcore]", worldinfo.isHardcoreModeEnabled());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][generator_name]", worldinfo.getTerrainType().getName());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][generator_version]", worldinfo.getTerrainType().getGeneratorVersion());
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][height]", this.buildLimit);
                p_addServerStatsToSnooper_1_.addClientStat("world[" + i + "][chunks_loaded]", worldserver.getChunkProvider().getLoadedChunkCount());
                ++i;
            }
        }
        p_addServerStatsToSnooper_1_.addClientStat("worlds", i);
    }

    @Override
    public void addServerTypeToSnooper(Snooper p_addServerTypeToSnooper_1_) {
        p_addServerTypeToSnooper_1_.addStatToSnooper("singleplayer", this.isSinglePlayer());
        p_addServerTypeToSnooper_1_.addStatToSnooper("server_brand", this.getServerModName());
        p_addServerTypeToSnooper_1_.addStatToSnooper("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        p_addServerTypeToSnooper_1_.addStatToSnooper("dedicated", this.isDedicatedServer());
    }

    @Override
    public boolean isSnooperEnabled() {
        return true;
    }

    public abstract boolean isDedicatedServer();

    public boolean isServerInOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean p_setOnlineMode_1_) {
        this.onlineMode = p_setOnlineMode_1_;
    }

    public boolean getPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public boolean getCanSpawnAnimals() {
        return this.canSpawnAnimals;
    }

    public void setCanSpawnAnimals(boolean p_setCanSpawnAnimals_1_) {
        this.canSpawnAnimals = p_setCanSpawnAnimals_1_;
    }

    public boolean getCanSpawnNPCs() {
        return this.canSpawnNPCs;
    }

    public abstract boolean shouldUseNativeTransport();

    public void setCanSpawnNPCs(boolean p_setCanSpawnNPCs_1_) {
        this.canSpawnNPCs = p_setCanSpawnNPCs_1_;
    }

    public boolean isPVPEnabled() {
        return this.pvpEnabled;
    }

    public void setAllowPvp(boolean p_setAllowPvp_1_) {
        this.pvpEnabled = p_setAllowPvp_1_;
    }

    public boolean isFlightAllowed() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean p_setAllowFlight_1_) {
        this.allowFlight = p_setAllowFlight_1_;
    }

    public abstract boolean isCommandBlockEnabled();

    public String getMOTD() {
        return this.motd;
    }

    public void setMOTD(String p_setMOTD_1_) {
        this.motd = p_setMOTD_1_;
    }

    public int getBuildLimit() {
        return this.buildLimit;
    }

    public void setBuildLimit(int p_setBuildLimit_1_) {
        this.buildLimit = p_setBuildLimit_1_;
    }

    public boolean isServerStopped() {
        return this.serverStopped;
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public void setPlayerList(PlayerList p_setPlayerList_1_) {
        this.playerList = p_setPlayerList_1_;
    }

    public void setGameType(GameType p_setGameType_1_) {
        for (WorldServer worldserver : this.worlds) {
            worldserver.getWorldInfo().setGameType(p_setGameType_1_);
        }
    }

    public NetworkSystem getNetworkSystem() {
        return this.networkSystem;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean serverIsInRunLoop() {
        return this.serverIsRunning;
    }

    public boolean getGuiEnabled() {
        return false;
    }

    public abstract String shareToLAN(GameType var1, boolean var2);

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void enableProfiling() {
        this.startProfiling = true;
    }

    @SideOnly(value=Side.CLIENT)
    public Snooper getPlayerUsageSnooper() {
        return this.usageSnooper;
    }

    @Override
    public BlockPos getPosition() {
        return BlockPos.ORIGIN;
    }

    @Override
    public Vec3d getPositionVector() {
        return Vec3d.ZERO;
    }

    @Override
    public World getEntityWorld() {
        return this.worlds[0];
    }

    @Override
    public Entity getCommandSenderEntity() {
        return null;
    }

    public boolean isBlockProtected(World p_isBlockProtected_1_, BlockPos p_isBlockProtected_2_, EntityPlayer p_isBlockProtected_3_) {
        return false;
    }

    public boolean getForceGamemode() {
        return this.isGamemodeForced;
    }

    public Proxy getServerProxy() {
        return this.serverProxy;
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public int getMaxPlayerIdleMinutes() {
        return this.maxPlayerIdleMinutes;
    }

    public void setPlayerIdleTimeout(int p_setPlayerIdleTimeout_1_) {
        this.maxPlayerIdleMinutes = p_setPlayerIdleTimeout_1_;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public boolean isAnnouncingPlayerAchievements() {
        return true;
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.sessionService;
    }

    public GameProfileRepository getGameProfileRepository() {
        return this.profileRepo;
    }

    public PlayerProfileCache getPlayerProfileCache() {
        return this.profileCache;
    }

    public ServerStatusResponse getServerStatusResponse() {
        return this.statusResponse;
    }

    public void refreshStatusNextTick() {
        this.nanoTimeSinceStatusRefresh = 0L;
    }

    @Nullable
    public Entity getEntityFromUuid(UUID p_getEntityFromUuid_1_) {
        for (WorldServer worldserver : this.worlds) {
            Entity entity;
            if (worldserver == null || (entity = worldserver.getEntityFromUuid(p_getEntityFromUuid_1_)) == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    public boolean sendCommandFeedback() {
        return this.worlds[0].getGameRules().getBoolean("sendCommandFeedback");
    }

    @Override
    public void setCommandStat(CommandResultStats.Type p_setCommandStat_1_, int p_setCommandStat_2_) {
    }

    @Override
    public MinecraftServer getServer() {
        return this;
    }

    public int getMaxWorldSize() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> callFromMainThread(Callable<V> p_callFromMainThread_1_) {
        Validate.notNull(p_callFromMainThread_1_);
        if (!this.isCallingFromMinecraftThread() && !this.isServerStopped()) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(p_callFromMainThread_1_);
            Queue<FutureTask<?>> queue = this.futureTaskQueue;
            synchronized (queue) {
                this.futureTaskQueue.add((FutureTask<?>)listenablefuturetask);
                return listenablefuturetask;
            }
        }
        try {
            return Futures.immediateFuture(p_callFromMainThread_1_.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> addScheduledTask(Runnable p_addScheduledTask_1_) {
        Validate.notNull((Object)p_addScheduledTask_1_);
        return this.callFromMainThread(Executors.callable(p_addScheduledTask_1_));
    }

    @Override
    public boolean isCallingFromMinecraftThread() {
        return Thread.currentThread() == this.serverThread;
    }

    public int getNetworkCompressionThreshold() {
        return 256;
    }

    public DataFixer getDataFixer() {
        return this.dataFixer;
    }

    public int getSpawnRadius(WorldServer p_getSpawnRadius_1_) {
        return p_getSpawnRadius_1_ != null ? p_getSpawnRadius_1_.getGameRules().getInt("spawnRadius") : 10;
    }

    @SideOnly(value=Side.SERVER)
    public String getServerHostname() {
        return this.hostname;
    }

    @SideOnly(value=Side.SERVER)
    public void setHostname(String p_setHostname_1_) {
        this.hostname = p_setHostname_1_;
    }

    @SideOnly(value=Side.SERVER)
    public void registerTickable(ITickable p_registerTickable_1_) {
        this.tickables.add(p_registerTickable_1_);
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] p_main_0_) {
        Bootstrap.register();
        try {
            boolean flag = true;
            String s = null;
            String s1 = ".";
            String s2 = null;
            boolean flag1 = false;
            boolean flag2 = false;
            int i = -1;
            for (int j = 0; j < p_main_0_.length; ++j) {
                String s3 = p_main_0_[j];
                String s4 = j == p_main_0_.length - 1 ? null : p_main_0_[j + 1];
                boolean flag3 = false;
                if (!"nogui".equals(s3) && !"--nogui".equals(s3)) {
                    if ("--port".equals(s3) && s4 != null) {
                        flag3 = true;
                        try {
                            i = Integer.parseInt(s4);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("--singleplayer".equals(s3) && s4 != null) {
                        flag3 = true;
                        s = s4;
                    } else if ("--universe".equals(s3) && s4 != null) {
                        flag3 = true;
                        s1 = s4;
                    } else if ("--world".equals(s3) && s4 != null) {
                        flag3 = true;
                        s2 = s4;
                    } else if ("--demo".equals(s3)) {
                        flag1 = true;
                    } else if ("--bonusChest".equals(s3)) {
                        flag2 = true;
                    }
                } else {
                    flag = false;
                }
                if (!flag3) continue;
                ++j;
            }
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(s1, USER_CACHE_FILE.getName()));
            final DedicatedServer dedicatedserver = new DedicatedServer(new File(s1), DataFixesManager.createFixer(), yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache);
            if (s != null) {
                dedicatedserver.setServerOwner(s);
            }
            if (s2 != null) {
                dedicatedserver.setFolderName(s2);
            }
            if (i >= 0) {
                dedicatedserver.setServerPort(i);
            }
            if (flag1) {
                dedicatedserver.setDemo(true);
            }
            if (flag2) {
                dedicatedserver.canCreateBonusChest(true);
            }
            if (flag && !GraphicsEnvironment.isHeadless()) {
                dedicatedserver.setGuiEnabled();
            }
            dedicatedserver.startServerThread();
            Runtime.getRuntime().addShutdownHook(new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.stopServer();
                }
            });
        }
        catch (Exception exception) {
            LOG.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    @SideOnly(value=Side.SERVER)
    public void logInfo(String p_logInfo_1_) {
        LOG.info(p_logInfo_1_);
    }

    @SideOnly(value=Side.SERVER)
    public boolean isDebuggingEnabled() {
        return false;
    }

    @SideOnly(value=Side.SERVER)
    public void logSevere(String p_logSevere_1_) {
        LOG.error(p_logSevere_1_);
    }

    @SideOnly(value=Side.SERVER)
    public void logDebug(String p_logDebug_1_) {
        if (this.isDebuggingEnabled()) {
            LOG.info(p_logDebug_1_);
        }
    }

    @SideOnly(value=Side.SERVER)
    public int getServerPort() {
        return this.serverPort;
    }

    @SideOnly(value=Side.SERVER)
    public void setServerPort(int p_setServerPort_1_) {
        this.serverPort = p_setServerPort_1_;
    }

    @SideOnly(value=Side.SERVER)
    public void setPreventProxyConnections(boolean p_setPreventProxyConnections_1_) {
        this.preventProxyConnections = p_setPreventProxyConnections_1_;
    }

    @SideOnly(value=Side.SERVER)
    public int getSpawnProtectionSize() {
        return 16;
    }

    @SideOnly(value=Side.SERVER)
    public void setForceGamemode(boolean p_setForceGamemode_1_) {
        this.isGamemodeForced = p_setForceGamemode_1_;
    }

    @SideOnly(value=Side.SERVER)
    public long getCurrentTime() {
        return this.currentTime;
    }

    @SideOnly(value=Side.SERVER)
    public Thread getServerThread() {
        return this.serverThread;
    }
}

