/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class ServerEula {
    private static final Logger LOG = LogManager.getLogger();
    private final File eulaFile;
    private final boolean acceptedEULA;

    public ServerEula(File p_i46373_1_) {
        this.eulaFile = p_i46373_1_;
        this.acceptedEULA = this.loadEULAFile(p_i46373_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadEULAFile(File p_loadEULAFile_1_) {
        FileInputStream lvt_2_1_ = null;
        boolean lvt_3_1_ = false;
        try {
            Properties lvt_4_1_ = new Properties();
            lvt_2_1_ = new FileInputStream(p_loadEULAFile_1_);
            lvt_4_1_.load(lvt_2_1_);
            lvt_3_1_ = Boolean.parseBoolean(lvt_4_1_.getProperty("eula", "false"));
        }
        catch (Exception lvt_4_2_) {
            try {
                LOG.warn("Failed to load {}", new Object[]{p_loadEULAFile_1_});
                this.createEULAFile();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_2_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)lvt_2_1_);
        }
        IOUtils.closeQuietly((InputStream)lvt_2_1_);
        return lvt_3_1_;
    }

    public boolean hasAcceptedEULA() {
        return this.acceptedEULA;
    }

    public void createEULAFile() {
        FileOutputStream lvt_1_1_ = null;
        try {
            Properties lvt_2_1_ = new Properties();
            lvt_1_1_ = new FileOutputStream(this.eulaFile);
            lvt_2_1_.setProperty("eula", "false");
            lvt_2_1_.store(lvt_1_1_, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).");
        }
        catch (Exception lvt_2_2_) {
            try {
                LOG.warn("Failed to save {}", new Object[]{this.eulaFile, lvt_2_2_});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_1_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)lvt_1_1_);
        }
        IOUtils.closeQuietly((OutputStream)lvt_1_1_);
    }
}

