/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class DedicatedPlayerList
extends PlayerList {
    private static final Logger LOGGER = LogManager.getLogger();

    public DedicatedPlayerList(DedicatedServer p_i1503_1_) {
        super(p_i1503_1_);
        this.setViewDistance(p_i1503_1_.getIntProperty("view-distance", 10));
        this.maxPlayers = p_i1503_1_.getIntProperty("max-players", 20);
        this.setWhiteListEnabled(p_i1503_1_.getBooleanProperty("white-list", false));
        if (!p_i1503_1_.isSinglePlayer()) {
            this.getBannedPlayers().setLanServer(true);
            this.getBannedIPs().setLanServer(true);
        }
        this.loadPlayerBanList();
        this.savePlayerBanList();
        this.loadIPBanList();
        this.saveIPBanList();
        this.loadOpsList();
        this.readWhiteList();
        this.saveOpsList();
        if (!this.getWhitelistedPlayers().getSaveFile().exists()) {
            this.saveWhiteList();
        }
    }

    @Override
    public void setWhiteListEnabled(boolean p_setWhiteListEnabled_1_) {
        super.setWhiteListEnabled(p_setWhiteListEnabled_1_);
        this.getServerInstance().setProperty("white-list", p_setWhiteListEnabled_1_);
        this.getServerInstance().saveProperties();
    }

    @Override
    public void addOp(GameProfile p_addOp_1_) {
        super.addOp(p_addOp_1_);
        this.saveOpsList();
    }

    @Override
    public void removeOp(GameProfile p_removeOp_1_) {
        super.removeOp(p_removeOp_1_);
        this.saveOpsList();
    }

    @Override
    public void removePlayerFromWhitelist(GameProfile p_removePlayerFromWhitelist_1_) {
        super.removePlayerFromWhitelist(p_removePlayerFromWhitelist_1_);
        this.saveWhiteList();
    }

    @Override
    public void addWhitelistedPlayer(GameProfile p_addWhitelistedPlayer_1_) {
        super.addWhitelistedPlayer(p_addWhitelistedPlayer_1_);
        this.saveWhiteList();
    }

    @Override
    public void reloadWhitelist() {
        this.readWhiteList();
    }

    private void saveIPBanList() {
        try {
            this.getBannedIPs().writeChanges();
        }
        catch (IOException lvt_1_1_) {
            LOGGER.warn("Failed to save ip banlist: ", (Throwable)lvt_1_1_);
        }
    }

    private void savePlayerBanList() {
        try {
            this.getBannedPlayers().writeChanges();
        }
        catch (IOException lvt_1_1_) {
            LOGGER.warn("Failed to save user banlist: ", (Throwable)lvt_1_1_);
        }
    }

    private void loadIPBanList() {
        try {
            this.getBannedIPs().readSavedFile();
        }
        catch (IOException lvt_1_1_) {
            LOGGER.warn("Failed to load ip banlist: ", (Throwable)lvt_1_1_);
        }
    }

    private void loadPlayerBanList() {
        try {
            this.getBannedPlayers().readSavedFile();
        }
        catch (IOException lvt_1_1_) {
            LOGGER.warn("Failed to load user banlist: ", (Throwable)lvt_1_1_);
        }
    }

    private void loadOpsList() {
        try {
            this.getOppedPlayers().readSavedFile();
        }
        catch (Exception lvt_1_1_) {
            LOGGER.warn("Failed to load operators list: ", (Throwable)lvt_1_1_);
        }
    }

    private void saveOpsList() {
        try {
            this.getOppedPlayers().writeChanges();
        }
        catch (Exception lvt_1_1_) {
            LOGGER.warn("Failed to save operators list: ", (Throwable)lvt_1_1_);
        }
    }

    private void readWhiteList() {
        try {
            this.getWhitelistedPlayers().readSavedFile();
        }
        catch (Exception lvt_1_1_) {
            LOGGER.warn("Failed to load white-list: ", (Throwable)lvt_1_1_);
        }
    }

    private void saveWhiteList() {
        try {
            this.getWhitelistedPlayers().writeChanges();
        }
        catch (Exception lvt_1_1_) {
            LOGGER.warn("Failed to save white-list: ", (Throwable)lvt_1_1_);
        }
    }

    @Override
    public boolean canJoin(GameProfile p_canJoin_1_) {
        return !this.isWhiteListEnabled() || this.canSendCommands(p_canJoin_1_) || this.getWhitelistedPlayers().isWhitelisted(p_canJoin_1_);
    }

    @Override
    public DedicatedServer getServerInstance() {
        return (DedicatedServer)super.getServerInstance();
    }

    @Override
    public boolean bypassesPlayerLimit(GameProfile p_bypassesPlayerLimit_1_) {
        return this.getOppedPlayers().bypassesPlayerLimit(p_bypassesPlayerLimit_1_);
    }

    @Override
    public /* synthetic */ MinecraftServer getServerInstance() {
        return this.getServerInstance();
    }
}

