/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class PropertyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Properties serverProperties = new Properties();
    private final File serverPropertiesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyManager(File p_i46372_1_) {
        this.serverPropertiesFile = p_i46372_1_;
        if (p_i46372_1_.exists()) {
            FileInputStream lvt_2_1_ = null;
            try {
                lvt_2_1_ = new FileInputStream(p_i46372_1_);
                this.serverProperties.load(lvt_2_1_);
            }
            catch (Exception lvt_3_1_) {
                LOGGER.warn("Failed to load {}", new Object[]{p_i46372_1_, lvt_3_1_});
                this.generateNewProperties();
            }
            finally {
                if (lvt_2_1_ != null) {
                    try {
                        lvt_2_1_.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            LOGGER.warn("{} does not exist", new Object[]{p_i46372_1_});
            this.generateNewProperties();
        }
    }

    public void generateNewProperties() {
        LOGGER.info("Generating new properties file");
        this.saveProperties();
    }

    public void saveProperties() {
        FileOutputStream lvt_1_1_ = null;
        try {
            lvt_1_1_ = new FileOutputStream(this.serverPropertiesFile);
            this.serverProperties.store(lvt_1_1_, "Minecraft server properties");
        }
        catch (Exception lvt_2_1_) {
            LOGGER.warn("Failed to save {}", new Object[]{this.serverPropertiesFile, lvt_2_1_});
            this.generateNewProperties();
        }
        finally {
            if (lvt_1_1_ != null) {
                try {
                    lvt_1_1_.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getPropertiesFile() {
        return this.serverPropertiesFile;
    }

    public String getStringProperty(String p_getStringProperty_1_, String p_getStringProperty_2_) {
        if (!this.serverProperties.containsKey(p_getStringProperty_1_)) {
            this.serverProperties.setProperty(p_getStringProperty_1_, p_getStringProperty_2_);
            this.saveProperties();
            this.saveProperties();
        }
        return this.serverProperties.getProperty(p_getStringProperty_1_, p_getStringProperty_2_);
    }

    public int getIntProperty(String p_getIntProperty_1_, int p_getIntProperty_2_) {
        try {
            return Integer.parseInt(this.getStringProperty(p_getIntProperty_1_, "" + p_getIntProperty_2_));
        }
        catch (Exception lvt_3_1_) {
            this.serverProperties.setProperty(p_getIntProperty_1_, "" + p_getIntProperty_2_);
            this.saveProperties();
            return p_getIntProperty_2_;
        }
    }

    public long getLongProperty(String p_getLongProperty_1_, long p_getLongProperty_2_) {
        try {
            return Long.parseLong(this.getStringProperty(p_getLongProperty_1_, "" + p_getLongProperty_2_));
        }
        catch (Exception lvt_4_1_) {
            this.serverProperties.setProperty(p_getLongProperty_1_, "" + p_getLongProperty_2_);
            this.saveProperties();
            return p_getLongProperty_2_;
        }
    }

    public boolean getBooleanProperty(String p_getBooleanProperty_1_, boolean p_getBooleanProperty_2_) {
        try {
            return Boolean.parseBoolean(this.getStringProperty(p_getBooleanProperty_1_, "" + p_getBooleanProperty_2_));
        }
        catch (Exception lvt_3_1_) {
            this.serverProperties.setProperty(p_getBooleanProperty_1_, "" + p_getBooleanProperty_2_);
            this.saveProperties();
            return p_getBooleanProperty_2_;
        }
    }

    public void setProperty(String p_setProperty_1_, Object p_setProperty_2_) {
        this.serverProperties.setProperty(p_setProperty_1_, "" + p_setProperty_2_);
    }

    public boolean hasProperty(String p_hasProperty_1_) {
        return this.serverProperties.containsKey(p_hasProperty_1_);
    }

    public void removeProperty(String p_removeProperty_1_) {
        this.serverProperties.remove(p_removeProperty_1_);
    }
}

