/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.mojang.util.QueueLogAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListComponent;
import net.minecraft.server.gui.StatsComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class MinecraftServerGui
extends JComponent {
    private static final Font SERVER_GUI_FONT = new Font("Monospaced", 0, 12);
    private static final Logger LOGGER = LogManager.getLogger();
    private final DedicatedServer server;
    private CountDownLatch latch = new CountDownLatch(1);

    public static void createServerGui(final DedicatedServer p_createServerGui_0_) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        MinecraftServerGui minecraftservergui = new MinecraftServerGui(p_createServerGui_0_);
        JFrame jframe = new JFrame("Minecraft server");
        jframe.add(minecraftservergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent p_windowClosing_1_) {
                p_createServerGui_0_.initiateShutdown();
                while (!p_createServerGui_0_.isServerStopped()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedexception) {
                        interruptedexception.printStackTrace();
                    }
                }
                System.exit(0);
            }
        });
        minecraftservergui.latch.countDown();
    }

    public MinecraftServerGui(DedicatedServer p_i2362_1_) {
        this.server = p_i2362_1_;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.getLogComponent(), "Center");
            this.add((Component)this.getStatsComponent(), "West");
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    private JComponent getStatsComponent() throws Exception {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)new StatsComponent(this.server), "North");
        jpanel.add((Component)this.getPlayerListComponent(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent getPlayerListComponent() throws Exception {
        PlayerListComponent jlist = new PlayerListComponent(this.server);
        JScrollPane jscrollpane = new JScrollPane(jlist, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent getLogComponent() throws Exception {
        JPanel jpanel = new JPanel(new BorderLayout());
        final JTextArea jtextarea = new JTextArea();
        final JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        jtextarea.setFont(SERVER_GUI_FONT);
        final JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent p_actionPerformed_1_) {
                String s = jtextfield.getText().trim();
                if (!s.isEmpty()) {
                    MinecraftServerGui.this.server.addPendingCommand(s, MinecraftServerGui.this.server);
                }
                jtextfield.setText("");
            }
        });
        jtextarea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent p_focusGained_1_) {
            }
        });
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String s;
                while ((s = QueueLogAppender.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                    MinecraftServerGui.this.appendLine(jtextarea, jscrollpane, s);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        return jpanel;
    }

    public void appendLine(final JTextArea p_appendLine_1_, final JScrollPane p_appendLine_2_, final String p_appendLine_3_) {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MinecraftServerGui.this.appendLine(p_appendLine_1_, p_appendLine_2_, p_appendLine_3_);
                }
            });
        } else {
            Document document = p_appendLine_1_.getDocument();
            JScrollBar jscrollbar = p_appendLine_2_.getVerticalScrollBar();
            boolean flag = false;
            if (p_appendLine_2_.getViewport().getView() == p_appendLine_1_) {
                flag = (double)jscrollbar.getValue() + jscrollbar.getSize().getHeight() + (double)(SERVER_GUI_FONT.getSize() * 4) > (double)jscrollbar.getMaximum();
            }
            try {
                document.insertString(document.getLength(), p_appendLine_3_, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (flag) {
                jscrollbar.setValue(Integer.MAX_VALUE);
            }
        }
    }
}

