/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class StatsComponent
extends JComponent {
    private static final DecimalFormat FORMATTER = new DecimalFormat("########0.000");
    private final int[] values = new int[256];
    private int vp;
    private final String[] msgs = new String[11];
    private final MinecraftServer server;

    public StatsComponent(MinecraftServer p_i2367_1_) {
        this.server = p_i2367_1_;
        this.setPreferredSize(new Dimension(456, 246));
        this.setMinimumSize(new Dimension(456, 246));
        this.setMaximumSize(new Dimension(456, 246));
        new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent p_actionPerformed_1_) {
                StatsComponent.this.tick();
            }
        }).start();
        this.setBackground(Color.BLACK);
    }

    private void tick() {
        long lvt_1_1_ = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.gc();
        this.msgs[0] = "Memory use: " + lvt_1_1_ / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.msgs[1] = "Avg tick: " + FORMATTER.format(this.mean(this.server.tickTimeArray) * 1.0E-6) + " ms";
        this.values[this.vp++ & 0xFF] = (int)(lvt_1_1_ * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    private double mean(long[] p_mean_1_) {
        long lvt_2_1_ = 0L;
        for (long lvt_7_1_ : p_mean_1_) {
            lvt_2_1_ += lvt_7_1_;
        }
        return (double)lvt_2_1_ / (double)p_mean_1_.length;
    }

    @Override
    public void paint(Graphics p_paint_1_) {
        p_paint_1_.setColor(new Color(0xFFFFFF));
        p_paint_1_.fillRect(0, 0, 456, 246);
        for (int lvt_2_1_ = 0; lvt_2_1_ < 256; ++lvt_2_1_) {
            int lvt_3_1_ = this.values[lvt_2_1_ + this.vp & 0xFF];
            p_paint_1_.setColor(new Color(lvt_3_1_ + 28 << 16));
            p_paint_1_.fillRect(lvt_2_1_, 100 - lvt_3_1_, 1, lvt_3_1_);
        }
        p_paint_1_.setColor(Color.BLACK);
        for (int lvt_2_2_ = 0; lvt_2_2_ < this.msgs.length; ++lvt_2_2_) {
            String lvt_3_2_ = this.msgs[lvt_2_2_];
            if (lvt_3_2_ == null) continue;
            p_paint_1_.drawString(lvt_3_2_, 32, 116 + lvt_2_2_ * 16);
        }
    }
}

