/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IntegratedPlayerList
extends PlayerList {
    private NBTTagCompound hostPlayerData;

    public IntegratedPlayerList(IntegratedServer p_i1314_1_) {
        super(p_i1314_1_);
        this.setViewDistance(10);
    }

    @Override
    protected void writePlayerData(EntityPlayerMP p_writePlayerData_1_) {
        if (p_writePlayerData_1_.getName().equals(this.getServerInstance().getServerOwner())) {
            this.hostPlayerData = p_writePlayerData_1_.writeToNBT(new NBTTagCompound());
        }
        super.writePlayerData(p_writePlayerData_1_);
    }

    @Override
    public String allowUserToConnect(SocketAddress p_allowUserToConnect_1_, GameProfile p_allowUserToConnect_2_) {
        if (p_allowUserToConnect_2_.getName().equalsIgnoreCase(this.getServerInstance().getServerOwner()) && this.getPlayerByUsername(p_allowUserToConnect_2_.getName()) != null) {
            return "That name is already taken.";
        }
        return super.allowUserToConnect(p_allowUserToConnect_1_, p_allowUserToConnect_2_);
    }

    @Override
    public IntegratedServer getServerInstance() {
        return (IntegratedServer)super.getServerInstance();
    }

    @Override
    public NBTTagCompound getHostPlayerData() {
        return this.hostPlayerData;
    }

    @Override
    public /* synthetic */ MinecraftServer getServerInstance() {
        return this.getServerInstance();
    }
}

