/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ThreadLanServerPing;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.integrated.IntegratedServerCommandManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.Util;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class IntegratedServer
extends MinecraftServer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final WorldSettings theWorldSettings;
    private boolean isGamePaused;
    private boolean isPublic;
    private ThreadLanServerPing lanServerPing;

    public IntegratedServer(Minecraft p_i46523_1_, String p_i46523_2_, String p_i46523_3_, WorldSettings p_i46523_4_, YggdrasilAuthenticationService p_i46523_5_, MinecraftSessionService p_i46523_6_, GameProfileRepository p_i46523_7_, PlayerProfileCache p_i46523_8_) {
        super(new File(p_i46523_1_.mcDataDir, "saves"), p_i46523_1_.getProxy(), p_i46523_1_.getDataFixer(), p_i46523_5_, p_i46523_6_, p_i46523_7_, p_i46523_8_);
        this.setServerOwner(p_i46523_1_.getSession().getUsername());
        this.setFolderName(p_i46523_2_);
        this.setWorldName(p_i46523_3_);
        this.setDemo(p_i46523_1_.isDemo());
        this.canCreateBonusChest(p_i46523_4_.isBonusChestEnabled());
        this.setBuildLimit(256);
        this.setPlayerList(new IntegratedPlayerList(this));
        this.mc = p_i46523_1_;
        this.theWorldSettings = this.isDemo() ? DemoWorldServer.DEMO_WORLD_SETTINGS : p_i46523_4_;
    }

    @Override
    public ServerCommandManager createCommandManager() {
        return new IntegratedServerCommandManager(this);
    }

    @Override
    public void loadAllWorlds(String p_loadAllWorlds_1_, String p_loadAllWorlds_2_, long p_loadAllWorlds_3_, WorldType p_loadAllWorlds_5_, String p_loadAllWorlds_6_) {
        this.convertMapIfNeeded(p_loadAllWorlds_1_);
        ISaveHandler isavehandler = this.getActiveAnvilConverter().getSaveLoader(p_loadAllWorlds_1_, true);
        this.setResourcePackFromWorld(this.getFolderName(), isavehandler);
        WorldInfo worldinfo = isavehandler.loadWorldInfo();
        if (worldinfo == null) {
            worldinfo = new WorldInfo(this.theWorldSettings, p_loadAllWorlds_2_);
        } else {
            worldinfo.setWorldName(p_loadAllWorlds_2_);
        }
        WorldServer overWorld = this.isDemo() ? (WorldServer)new DemoWorldServer(this, isavehandler, worldinfo, 0, this.theProfiler).init() : (WorldServer)new WorldServer(this, isavehandler, worldinfo, 0, this.theProfiler).init();
        overWorld.initialize(this.theWorldSettings);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = dim == 0 ? overWorld : (WorldServer)new WorldServerMulti((MinecraftServer)this, isavehandler, dim, overWorld, this.theProfiler).init();
            world.addEventListener(new ServerWorldEventHandler(this, world));
            if (!this.isSinglePlayer()) {
                world.getWorldInfo().setGameType(this.getGameType());
            }
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        this.getPlayerList().setPlayerManager(new WorldServer[]{overWorld});
        if (overWorld.getWorldInfo().getDifficulty() == null) {
            this.setDifficultyForAllWorlds(this.mc.gameSettings.difficulty);
        }
        this.initialWorldChunkLoad();
    }

    @Override
    public boolean init() throws IOException {
        LOGGER.info("Starting integrated minecraft server version 1.11.2");
        this.setOnlineMode(true);
        this.setCanSpawnAnimals(true);
        this.setCanSpawnNPCs(true);
        this.setAllowPvp(true);
        this.setAllowFlight(true);
        LOGGER.info("Generating keypair");
        this.setKeyPair(CryptManager.generateKeyPair());
        if (!FMLCommonHandler.instance().handleServerAboutToStart(this)) {
            return false;
        }
        this.loadAllWorlds(this.getFolderName(), this.getWorldName(), this.theWorldSettings.getSeed(), this.theWorldSettings.getTerrainType(), this.theWorldSettings.getGeneratorOptions());
        this.setMOTD(this.getServerOwner() + " - " + this.worlds[0].getWorldInfo().getWorldName());
        return FMLCommonHandler.instance().handleServerStarting(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick() {
        boolean flag = this.isGamePaused;
        boolean bl = this.isGamePaused = Minecraft.getMinecraft().getConnection() != null && Minecraft.getMinecraft().isGamePaused();
        if (!flag && this.isGamePaused) {
            LOGGER.info("Saving and pausing game...");
            this.getPlayerList().saveAllPlayerData();
            this.saveAllWorlds(false);
        }
        if (this.isGamePaused) {
            Queue queue = this.futureTaskQueue;
            synchronized (queue) {
                while (!this.futureTaskQueue.isEmpty()) {
                    Util.runTask((FutureTask)this.futureTaskQueue.poll(), LOGGER);
                }
            }
        } else {
            super.tick();
            if (this.mc.gameSettings.renderDistanceChunks != this.getPlayerList().getViewDistance()) {
                LOGGER.info("Changing view distance to {}, from {}", new Object[]{this.mc.gameSettings.renderDistanceChunks, this.getPlayerList().getViewDistance()});
                this.getPlayerList().setViewDistance(this.mc.gameSettings.renderDistanceChunks);
            }
            if (this.mc.world != null) {
                WorldInfo worldinfo1 = this.worlds[0].getWorldInfo();
                WorldInfo worldinfo = this.mc.world.getWorldInfo();
                if (!worldinfo1.isDifficultyLocked() && worldinfo.getDifficulty() != worldinfo1.getDifficulty()) {
                    LOGGER.info("Changing difficulty to {}, from {}", new Object[]{worldinfo.getDifficulty(), worldinfo1.getDifficulty()});
                    this.setDifficultyForAllWorlds(worldinfo.getDifficulty());
                } else if (worldinfo.isDifficultyLocked() && !worldinfo1.isDifficultyLocked()) {
                    LOGGER.info("Locking difficulty to {}", new Object[]{worldinfo.getDifficulty()});
                    for (WorldServer worldserver : this.worlds) {
                        if (worldserver == null) continue;
                        worldserver.getWorldInfo().setDifficultyLocked(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean canStructuresSpawn() {
        return false;
    }

    @Override
    public GameType getGameType() {
        return this.theWorldSettings.getGameType();
    }

    @Override
    public EnumDifficulty getDifficulty() {
        if (this.mc.world == null) {
            return this.mc.gameSettings.difficulty;
        }
        return this.mc.world.getWorldInfo().getDifficulty();
    }

    @Override
    public boolean isHardcore() {
        return this.theWorldSettings.getHardcoreEnabled();
    }

    @Override
    public boolean shouldBroadcastRconToOps() {
        return true;
    }

    @Override
    public boolean shouldBroadcastConsoleToOps() {
        return true;
    }

    @Override
    public void saveAllWorlds(boolean p_saveAllWorlds_1_) {
        super.saveAllWorlds(p_saveAllWorlds_1_);
    }

    @Override
    public File getDataDirectory() {
        return this.mc.mcDataDir;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public boolean shouldUseNativeTransport() {
        return false;
    }

    @Override
    public void finalTick(CrashReport p_finalTick_1_) {
        this.mc.crashed(p_finalTick_1_);
    }

    @Override
    public CrashReport addServerInfoToCrashReport(CrashReport p_addServerInfoToCrashReport_1_) {
        p_addServerInfoToCrashReport_1_ = super.addServerInfoToCrashReport(p_addServerInfoToCrashReport_1_);
        p_addServerInfoToCrashReport_1_.getCategory().setDetail("Type", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return "Integrated Server (map_client.txt)";
            }
        });
        p_addServerInfoToCrashReport_1_.getCategory().setDetail("Is Modded", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                String s = ClientBrandRetriever.getClientModName();
                if (!s.equals("vanilla")) {
                    return "Definitely; Client brand changed to '" + s + "'";
                }
                s = IntegratedServer.this.getServerModName();
                return !"vanilla".equals(s) ? "Definitely; Server brand changed to '" + s + "'" : (Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and both client + server brands are untouched.");
            }
        });
        return p_addServerInfoToCrashReport_1_;
    }

    @Override
    public void setDifficultyForAllWorlds(EnumDifficulty p_setDifficultyForAllWorlds_1_) {
        super.setDifficultyForAllWorlds(p_setDifficultyForAllWorlds_1_);
        if (this.mc.world != null) {
            this.mc.world.getWorldInfo().setDifficulty(p_setDifficultyForAllWorlds_1_);
        }
    }

    @Override
    public void addServerStatsToSnooper(Snooper p_addServerStatsToSnooper_1_) {
        super.addServerStatsToSnooper(p_addServerStatsToSnooper_1_);
        p_addServerStatsToSnooper_1_.addClientStat("snooper_partner", this.mc.getPlayerUsageSnooper().getUniqueID());
    }

    @Override
    public boolean isSnooperEnabled() {
        return Minecraft.getMinecraft().isSnooperEnabled();
    }

    @Override
    public String shareToLAN(GameType p_shareToLAN_1_, boolean p_shareToLAN_2_) {
        try {
            int i = -1;
            try {
                i = HttpUtil.getSuitableLanPort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i <= 0) {
                i = 25564;
            }
            this.getNetworkSystem().addLanEndpoint(null, i);
            LOGGER.info("Started on {}", new Object[]{i});
            this.isPublic = true;
            this.lanServerPing = new ThreadLanServerPing(this.getMOTD(), i + "");
            this.lanServerPing.start();
            this.getPlayerList().setGameType(p_shareToLAN_1_);
            this.getPlayerList().setCommandsAllowedForAll(p_shareToLAN_2_);
            this.mc.player.setPermissionLevel(p_shareToLAN_2_ ? 4 : 0);
            return i + "";
        }
        catch (IOException var6) {
            return null;
        }
    }

    @Override
    public void stopServer() {
        super.stopServer();
        if (this.lanServerPing != null) {
            this.lanServerPing.interrupt();
            this.lanServerPing = null;
        }
    }

    @Override
    public void initiateShutdown() {
        if (this.isServerRunning()) {
            Futures.getUnchecked(this.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    for (EntityPlayerMP entityplayermp : Lists.newArrayList(IntegratedServer.this.getPlayerList().getPlayers())) {
                        if (entityplayermp.getUniqueID().equals(((IntegratedServer)IntegratedServer.this).mc.player.getUniqueID())) continue;
                        IntegratedServer.this.getPlayerList().playerLoggedOut(entityplayermp);
                    }
                }
            }));
        }
        super.initiateShutdown();
        if (this.lanServerPing != null) {
            this.lanServerPing.interrupt();
            this.lanServerPing = null;
        }
    }

    public boolean getPublic() {
        return this.isPublic;
    }

    @Override
    public void setGameType(GameType p_setGameType_1_) {
        super.setGameType(p_setGameType_1_);
        this.getPlayerList().setGameType(p_setGameType_1_);
    }

    @Override
    public boolean isCommandBlockEnabled() {
        return true;
    }

    @Override
    public int getOpPermissionLevel() {
        return 4;
    }

    public void reloadLootTables() {
        if (this.isCallingFromMinecraftThread()) {
            this.worlds[0].getLootTableManager().reloadLootTables();
        } else {
            this.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    IntegratedServer.this.reloadLootTables();
                }
            });
        }
    }
}

