/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class PlayerChunkMap {
    private static final Predicate<EntityPlayerMP> NOT_SPECTATOR = new Predicate<EntityPlayerMP>(){

        public boolean apply(EntityPlayerMP p_apply_1_) {
            return p_apply_1_ != null && !p_apply_1_.isSpectator();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((EntityPlayerMP)p_apply_1_);
        }
    };
    private static final Predicate<EntityPlayerMP> CAN_GENERATE_CHUNKS = new Predicate<EntityPlayerMP>(){

        public boolean apply(EntityPlayerMP p_apply_1_) {
            return p_apply_1_ != null && (!p_apply_1_.isSpectator() || p_apply_1_.getServerWorld().getGameRules().getBoolean("spectatorsGenerateChunks"));
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((EntityPlayerMP)p_apply_1_);
        }
    };
    private final WorldServer world;
    private final List<EntityPlayerMP> players = Lists.newArrayList();
    private final Long2ObjectMap<PlayerChunkMapEntry> entryMap = new Long2ObjectOpenHashMap(4096);
    private final Set<PlayerChunkMapEntry> dirtyEntries = Sets.newHashSet();
    private final List<PlayerChunkMapEntry> pendingSendToPlayers = Lists.newLinkedList();
    private final List<PlayerChunkMapEntry> entriesWithoutChunks = Lists.newLinkedList();
    private final List<PlayerChunkMapEntry> entries = Lists.newArrayList();
    private int playerViewRadius;
    private long previousTotalWorldTime;
    private boolean sortMissingChunks = true;
    private boolean sortSendToPlayers = true;

    public PlayerChunkMap(WorldServer p_i1176_1_) {
        this.world = p_i1176_1_;
        this.setPlayerViewRadius(p_i1176_1_.getMinecraftServer().getPlayerList().getViewDistance());
    }

    public WorldServer getWorldServer() {
        return this.world;
    }

    public Iterator<Chunk> getChunkIterator() {
        final Iterator<PlayerChunkMapEntry> lvt_1_1_ = this.entries.iterator();
        return new AbstractIterator<Chunk>(){

            protected Chunk computeNext() {
                while (lvt_1_1_.hasNext()) {
                    PlayerChunkMapEntry lvt_1_1_2 = (PlayerChunkMapEntry)lvt_1_1_.next();
                    Chunk lvt_2_1_ = lvt_1_1_2.getChunk();
                    if (lvt_2_1_ == null) continue;
                    if (!lvt_2_1_.isLightPopulated() && lvt_2_1_.isTerrainPopulated()) {
                        return lvt_2_1_;
                    }
                    if (!lvt_2_1_.isChunkTicked()) {
                        return lvt_2_1_;
                    }
                    if (!lvt_1_1_2.hasPlayerMatchingInRange(128.0, (Predicate<EntityPlayerMP>)NOT_SPECTATOR)) continue;
                    return lvt_2_1_;
                }
                return (Chunk)this.endOfData();
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public void tick() {
        WorldProvider lvt_3_4_;
        long lvt_1_1_ = this.world.getTotalWorldTime();
        if (lvt_1_1_ - this.previousTotalWorldTime > 8000L) {
            this.previousTotalWorldTime = lvt_1_1_;
            for (int lvt_3_1_ = 0; lvt_3_1_ < this.entries.size(); ++lvt_3_1_) {
                PlayerChunkMapEntry lvt_4_1_ = this.entries.get(lvt_3_1_);
                lvt_4_1_.update();
                lvt_4_1_.updateChunkInhabitedTime();
            }
        }
        if (!this.dirtyEntries.isEmpty()) {
            for (PlayerChunkMapEntry lvt_4_2_ : this.dirtyEntries) {
                lvt_4_2_.update();
            }
            this.dirtyEntries.clear();
        }
        if (this.sortMissingChunks && lvt_1_1_ % 4L == 0L) {
            this.sortMissingChunks = false;
            Collections.sort(this.entriesWithoutChunks, new Comparator<PlayerChunkMapEntry>(){

                @Override
                public int compare(PlayerChunkMapEntry p_compare_1_, PlayerChunkMapEntry p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.getClosestPlayerDistance(), p_compare_2_.getClosestPlayerDistance()).result();
                }

                @Override
                public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
                    return this.compare((PlayerChunkMapEntry)p_compare_1_, (PlayerChunkMapEntry)p_compare_2_);
                }
            });
        }
        if (this.sortSendToPlayers && lvt_1_1_ % 4L == 2L) {
            this.sortSendToPlayers = false;
            Collections.sort(this.pendingSendToPlayers, new Comparator<PlayerChunkMapEntry>(){

                @Override
                public int compare(PlayerChunkMapEntry p_compare_1_, PlayerChunkMapEntry p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.getClosestPlayerDistance(), p_compare_2_.getClosestPlayerDistance()).result();
                }

                @Override
                public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
                    return this.compare((PlayerChunkMapEntry)p_compare_1_, (PlayerChunkMapEntry)p_compare_2_);
                }
            });
        }
        if (!this.entriesWithoutChunks.isEmpty()) {
            long lvt_3_2_ = System.nanoTime() + 50000000L;
            int lvt_5_1_ = 49;
            Iterator<PlayerChunkMapEntry> lvt_6_1_ = this.entriesWithoutChunks.iterator();
            while (lvt_6_1_.hasNext()) {
                boolean lvt_8_1_;
                PlayerChunkMapEntry lvt_7_1_ = lvt_6_1_.next();
                if (lvt_7_1_.getChunk() != null || !lvt_7_1_.providePlayerChunk(lvt_8_1_ = lvt_7_1_.hasPlayerMatching(CAN_GENERATE_CHUNKS))) continue;
                lvt_6_1_.remove();
                if (lvt_7_1_.sendToPlayers()) {
                    this.pendingSendToPlayers.remove(lvt_7_1_);
                }
                if (--lvt_5_1_ >= 0 && System.nanoTime() <= lvt_3_2_) continue;
                break;
            }
        }
        if (!this.pendingSendToPlayers.isEmpty()) {
            int lvt_3_3_ = 81;
            Iterator<PlayerChunkMapEntry> lvt_4_3_ = this.pendingSendToPlayers.iterator();
            while (lvt_4_3_.hasNext()) {
                PlayerChunkMapEntry lvt_5_2_ = lvt_4_3_.next();
                if (!lvt_5_2_.sendToPlayers()) continue;
                lvt_4_3_.remove();
                if (--lvt_3_3_ >= 0) continue;
                break;
            }
        }
        if (this.players.isEmpty() && !(lvt_3_4_ = this.world.provider).canRespawnHere()) {
            this.world.getChunkProvider().unloadAllChunks();
        }
    }

    public boolean contains(int p_contains_1_, int p_contains_2_) {
        long lvt_3_1_ = PlayerChunkMap.getIndex(p_contains_1_, p_contains_2_);
        return this.entryMap.get(lvt_3_1_) != null;
    }

    @Nullable
    public PlayerChunkMapEntry getEntry(int p_getEntry_1_, int p_getEntry_2_) {
        return (PlayerChunkMapEntry)this.entryMap.get(PlayerChunkMap.getIndex(p_getEntry_1_, p_getEntry_2_));
    }

    private PlayerChunkMapEntry getOrCreateEntry(int p_getOrCreateEntry_1_, int p_getOrCreateEntry_2_) {
        long lvt_3_1_ = PlayerChunkMap.getIndex(p_getOrCreateEntry_1_, p_getOrCreateEntry_2_);
        PlayerChunkMapEntry lvt_5_1_ = (PlayerChunkMapEntry)this.entryMap.get(lvt_3_1_);
        if (lvt_5_1_ == null) {
            lvt_5_1_ = new PlayerChunkMapEntry(this, p_getOrCreateEntry_1_, p_getOrCreateEntry_2_);
            this.entryMap.put(lvt_3_1_, (Object)lvt_5_1_);
            this.entries.add(lvt_5_1_);
            if (lvt_5_1_.getChunk() == null) {
                this.entriesWithoutChunks.add(lvt_5_1_);
            }
            if (!lvt_5_1_.sendToPlayers()) {
                this.pendingSendToPlayers.add(lvt_5_1_);
            }
        }
        return lvt_5_1_;
    }

    public void markBlockForUpdate(BlockPos p_markBlockForUpdate_1_) {
        int lvt_3_1_;
        int lvt_2_1_ = p_markBlockForUpdate_1_.getX() >> 4;
        PlayerChunkMapEntry lvt_4_1_ = this.getEntry(lvt_2_1_, lvt_3_1_ = p_markBlockForUpdate_1_.getZ() >> 4);
        if (lvt_4_1_ != null) {
            lvt_4_1_.blockChanged(p_markBlockForUpdate_1_.getX() & 0xF, p_markBlockForUpdate_1_.getY(), p_markBlockForUpdate_1_.getZ() & 0xF);
        }
    }

    public void addPlayer(EntityPlayerMP p_addPlayer_1_) {
        int lvt_2_1_ = (int)p_addPlayer_1_.posX >> 4;
        int lvt_3_1_ = (int)p_addPlayer_1_.posZ >> 4;
        p_addPlayer_1_.managedPosX = p_addPlayer_1_.posX;
        p_addPlayer_1_.managedPosZ = p_addPlayer_1_.posZ;
        for (int lvt_4_1_ = lvt_2_1_ - this.playerViewRadius; lvt_4_1_ <= lvt_2_1_ + this.playerViewRadius; ++lvt_4_1_) {
            for (int lvt_5_1_ = lvt_3_1_ - this.playerViewRadius; lvt_5_1_ <= lvt_3_1_ + this.playerViewRadius; ++lvt_5_1_) {
                this.getOrCreateEntry(lvt_4_1_, lvt_5_1_).addPlayer(p_addPlayer_1_);
            }
        }
        this.players.add(p_addPlayer_1_);
        this.markSortPending();
    }

    public void removePlayer(EntityPlayerMP p_removePlayer_1_) {
        int lvt_2_1_ = (int)p_removePlayer_1_.managedPosX >> 4;
        int lvt_3_1_ = (int)p_removePlayer_1_.managedPosZ >> 4;
        for (int lvt_4_1_ = lvt_2_1_ - this.playerViewRadius; lvt_4_1_ <= lvt_2_1_ + this.playerViewRadius; ++lvt_4_1_) {
            for (int lvt_5_1_ = lvt_3_1_ - this.playerViewRadius; lvt_5_1_ <= lvt_3_1_ + this.playerViewRadius; ++lvt_5_1_) {
                PlayerChunkMapEntry lvt_6_1_ = this.getEntry(lvt_4_1_, lvt_5_1_);
                if (lvt_6_1_ == null) continue;
                lvt_6_1_.removePlayer(p_removePlayer_1_);
            }
        }
        this.players.remove(p_removePlayer_1_);
        this.markSortPending();
    }

    private boolean overlaps(int p_overlaps_1_, int p_overlaps_2_, int p_overlaps_3_, int p_overlaps_4_, int p_overlaps_5_) {
        int lvt_6_1_ = p_overlaps_1_ - p_overlaps_3_;
        int lvt_7_1_ = p_overlaps_2_ - p_overlaps_4_;
        if (lvt_6_1_ < -p_overlaps_5_ || lvt_6_1_ > p_overlaps_5_) {
            return false;
        }
        return lvt_7_1_ >= -p_overlaps_5_ && lvt_7_1_ <= p_overlaps_5_;
    }

    public void updateMovingPlayer(EntityPlayerMP p_updateMovingPlayer_1_) {
        int lvt_2_1_ = (int)p_updateMovingPlayer_1_.posX >> 4;
        int lvt_3_1_ = (int)p_updateMovingPlayer_1_.posZ >> 4;
        double lvt_4_1_ = p_updateMovingPlayer_1_.managedPosX - p_updateMovingPlayer_1_.posX;
        double lvt_6_1_ = p_updateMovingPlayer_1_.managedPosZ - p_updateMovingPlayer_1_.posZ;
        double lvt_8_1_ = lvt_4_1_ * lvt_4_1_ + lvt_6_1_ * lvt_6_1_;
        if (lvt_8_1_ < 64.0) {
            return;
        }
        int lvt_10_1_ = (int)p_updateMovingPlayer_1_.managedPosX >> 4;
        int lvt_11_1_ = (int)p_updateMovingPlayer_1_.managedPosZ >> 4;
        int lvt_12_1_ = this.playerViewRadius;
        int lvt_13_1_ = lvt_2_1_ - lvt_10_1_;
        int lvt_14_1_ = lvt_3_1_ - lvt_11_1_;
        if (lvt_13_1_ == 0 && lvt_14_1_ == 0) {
            return;
        }
        for (int lvt_15_1_ = lvt_2_1_ - lvt_12_1_; lvt_15_1_ <= lvt_2_1_ + lvt_12_1_; ++lvt_15_1_) {
            for (int lvt_16_1_ = lvt_3_1_ - lvt_12_1_; lvt_16_1_ <= lvt_3_1_ + lvt_12_1_; ++lvt_16_1_) {
                PlayerChunkMapEntry lvt_17_1_;
                if (!this.overlaps(lvt_15_1_, lvt_16_1_, lvt_10_1_, lvt_11_1_, lvt_12_1_)) {
                    this.getOrCreateEntry(lvt_15_1_, lvt_16_1_).addPlayer(p_updateMovingPlayer_1_);
                }
                if (this.overlaps(lvt_15_1_ - lvt_13_1_, lvt_16_1_ - lvt_14_1_, lvt_2_1_, lvt_3_1_, lvt_12_1_) || (lvt_17_1_ = this.getEntry(lvt_15_1_ - lvt_13_1_, lvt_16_1_ - lvt_14_1_)) == null) continue;
                lvt_17_1_.removePlayer(p_updateMovingPlayer_1_);
            }
        }
        p_updateMovingPlayer_1_.managedPosX = p_updateMovingPlayer_1_.posX;
        p_updateMovingPlayer_1_.managedPosZ = p_updateMovingPlayer_1_.posZ;
        this.markSortPending();
    }

    public boolean isPlayerWatchingChunk(EntityPlayerMP p_isPlayerWatchingChunk_1_, int p_isPlayerWatchingChunk_2_, int p_isPlayerWatchingChunk_3_) {
        PlayerChunkMapEntry lvt_4_1_ = this.getEntry(p_isPlayerWatchingChunk_2_, p_isPlayerWatchingChunk_3_);
        return lvt_4_1_ != null && lvt_4_1_.containsPlayer(p_isPlayerWatchingChunk_1_) && lvt_4_1_.isSentToPlayers();
    }

    public void setPlayerViewRadius(int p_setPlayerViewRadius_1_) {
        if ((p_setPlayerViewRadius_1_ = MathHelper.clamp(p_setPlayerViewRadius_1_, 3, 32)) == this.playerViewRadius) {
            return;
        }
        int lvt_2_1_ = p_setPlayerViewRadius_1_ - this.playerViewRadius;
        ArrayList lvt_3_1_ = Lists.newArrayList(this.players);
        for (EntityPlayerMP lvt_5_1_ : lvt_3_1_) {
            int lvt_6_1_ = (int)lvt_5_1_.posX >> 4;
            int lvt_7_1_ = (int)lvt_5_1_.posZ >> 4;
            if (lvt_2_1_ > 0) {
                for (int lvt_8_1_ = lvt_6_1_ - p_setPlayerViewRadius_1_; lvt_8_1_ <= lvt_6_1_ + p_setPlayerViewRadius_1_; ++lvt_8_1_) {
                    for (int lvt_9_1_ = lvt_7_1_ - p_setPlayerViewRadius_1_; lvt_9_1_ <= lvt_7_1_ + p_setPlayerViewRadius_1_; ++lvt_9_1_) {
                        PlayerChunkMapEntry lvt_10_1_ = this.getOrCreateEntry(lvt_8_1_, lvt_9_1_);
                        if (lvt_10_1_.containsPlayer(lvt_5_1_)) continue;
                        lvt_10_1_.addPlayer(lvt_5_1_);
                    }
                }
                continue;
            }
            for (int lvt_8_2_ = lvt_6_1_ - this.playerViewRadius; lvt_8_2_ <= lvt_6_1_ + this.playerViewRadius; ++lvt_8_2_) {
                for (int lvt_9_2_ = lvt_7_1_ - this.playerViewRadius; lvt_9_2_ <= lvt_7_1_ + this.playerViewRadius; ++lvt_9_2_) {
                    if (this.overlaps(lvt_8_2_, lvt_9_2_, lvt_6_1_, lvt_7_1_, p_setPlayerViewRadius_1_)) continue;
                    this.getOrCreateEntry(lvt_8_2_, lvt_9_2_).removePlayer(lvt_5_1_);
                }
            }
        }
        this.playerViewRadius = p_setPlayerViewRadius_1_;
        this.markSortPending();
    }

    private void markSortPending() {
        this.sortMissingChunks = true;
        this.sortSendToPlayers = true;
    }

    public static int getFurthestViewableBlock(int p_getFurthestViewableBlock_0_) {
        return p_getFurthestViewableBlock_0_ * 16 - 16;
    }

    private static long getIndex(int p_getIndex_0_, int p_getIndex_1_) {
        return (long)p_getIndex_0_ + Integer.MAX_VALUE | (long)p_getIndex_1_ + Integer.MAX_VALUE << 32;
    }

    public void entryChanged(PlayerChunkMapEntry p_entryChanged_1_) {
        this.dirtyEntries.add(p_entryChanged_1_);
    }

    public void removeEntry(PlayerChunkMapEntry p_removeEntry_1_) {
        ChunkPos lvt_2_1_ = p_removeEntry_1_.getPos();
        long lvt_3_1_ = PlayerChunkMap.getIndex(lvt_2_1_.chunkXPos, lvt_2_1_.chunkZPos);
        p_removeEntry_1_.updateChunkInhabitedTime();
        this.entryMap.remove(lvt_3_1_);
        this.entries.remove(p_removeEntry_1_);
        this.dirtyEntries.remove(p_removeEntry_1_);
        this.pendingSendToPlayers.remove(p_removeEntry_1_);
        this.entriesWithoutChunks.remove(p_removeEntry_1_);
        Chunk lvt_5_1_ = p_removeEntry_1_.getChunk();
        if (lvt_5_1_ != null) {
            this.getWorldServer().getChunkProvider().unload(lvt_5_1_);
        }
    }
}

