/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.world.ChunkWatchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerChunkMapEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PlayerChunkMap playerChunkMap;
    private final List<EntityPlayerMP> players = Lists.newArrayList();
    private final ChunkPos pos;
    private short[] changedBlocks = new short[64];
    @Nullable
    private Chunk chunk;
    private int changes;
    private int changedSectionFilter;
    private long lastUpdateInhabitedTime;
    private boolean sentToPlayers;
    private Runnable loadedRunnable = new Runnable(){

        @Override
        public void run() {
            PlayerChunkMapEntry.this.chunk = PlayerChunkMapEntry.this.playerChunkMap.getWorldServer().getChunkProvider().loadChunk(((PlayerChunkMapEntry)PlayerChunkMapEntry.this).pos.chunkXPos, ((PlayerChunkMapEntry)PlayerChunkMapEntry.this).pos.chunkZPos);
            PlayerChunkMapEntry.this.loading = false;
        }
    };
    private boolean loading = true;

    public PlayerChunkMapEntry(PlayerChunkMap p_i1518_1_, int p_i1518_2_, int p_i1518_3_) {
        this.playerChunkMap = p_i1518_1_;
        this.pos = new ChunkPos(p_i1518_2_, p_i1518_3_);
        p_i1518_1_.getWorldServer().getChunkProvider().loadChunk(p_i1518_2_, p_i1518_3_, this.loadedRunnable);
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public void addPlayer(EntityPlayerMP p_addPlayer_1_) {
        if (this.players.contains(p_addPlayer_1_)) {
            LOGGER.debug("Failed to add player. {} already is in chunk {}, {}", new Object[]{p_addPlayer_1_, this.pos.chunkXPos, this.pos.chunkZPos});
        } else {
            if (this.players.isEmpty()) {
                this.lastUpdateInhabitedTime = this.playerChunkMap.getWorldServer().getTotalWorldTime();
            }
            this.players.add(p_addPlayer_1_);
            if (this.sentToPlayers) {
                this.sendNearbySpecialEntities(p_addPlayer_1_);
                MinecraftForge.EVENT_BUS.post(new ChunkWatchEvent.Watch(this.pos, p_addPlayer_1_));
            }
        }
    }

    public void removePlayer(EntityPlayerMP p_removePlayer_1_) {
        if (this.players.contains(p_removePlayer_1_)) {
            if (this.chunk == null) {
                this.players.remove(p_removePlayer_1_);
                if (this.players.isEmpty()) {
                    if (this.loading) {
                        ChunkIOExecutor.dropQueuedChunkLoad(this.playerChunkMap.getWorldServer(), this.pos.chunkXPos, this.pos.chunkZPos, this.loadedRunnable);
                    }
                    this.playerChunkMap.removeEntry(this);
                }
                return;
            }
            if (this.sentToPlayers) {
                p_removePlayer_1_.connection.sendPacket(new SPacketUnloadChunk(this.pos.chunkXPos, this.pos.chunkZPos));
            }
            this.players.remove(p_removePlayer_1_);
            MinecraftForge.EVENT_BUS.post(new ChunkWatchEvent.UnWatch(this.pos, p_removePlayer_1_));
            if (this.players.isEmpty()) {
                this.playerChunkMap.removeEntry(this);
            }
        }
    }

    public boolean providePlayerChunk(boolean p_providePlayerChunk_1_) {
        if (this.loading) {
            return false;
        }
        if (this.chunk != null) {
            return true;
        }
        this.chunk = p_providePlayerChunk_1_ ? this.playerChunkMap.getWorldServer().getChunkProvider().provideChunk(this.pos.chunkXPos, this.pos.chunkZPos) : this.playerChunkMap.getWorldServer().getChunkProvider().loadChunk(this.pos.chunkXPos, this.pos.chunkZPos);
        return this.chunk != null;
    }

    public boolean sendToPlayers() {
        if (this.sentToPlayers) {
            return true;
        }
        if (this.chunk == null) {
            return false;
        }
        if (!this.chunk.isPopulated()) {
            return false;
        }
        this.changes = 0;
        this.changedSectionFilter = 0;
        this.sentToPlayers = true;
        SPacketChunkData packet = new SPacketChunkData(this.chunk, 65535);
        for (EntityPlayerMP entityplayermp : this.players) {
            entityplayermp.connection.sendPacket(packet);
            this.playerChunkMap.getWorldServer().getEntityTracker().sendLeashedEntitiesInChunk(entityplayermp, this.chunk);
            MinecraftForge.EVENT_BUS.post(new ChunkWatchEvent.Watch(this.pos, entityplayermp));
        }
        return true;
    }

    public void sendNearbySpecialEntities(EntityPlayerMP p_sendNearbySpecialEntities_1_) {
        if (this.sentToPlayers) {
            p_sendNearbySpecialEntities_1_.connection.sendPacket(new SPacketChunkData(this.chunk, 65535));
            this.playerChunkMap.getWorldServer().getEntityTracker().sendLeashedEntitiesInChunk(p_sendNearbySpecialEntities_1_, this.chunk);
        }
    }

    public void updateChunkInhabitedTime() {
        long i = this.playerChunkMap.getWorldServer().getTotalWorldTime();
        if (this.chunk != null) {
            this.chunk.setInhabitedTime(this.chunk.getInhabitedTime() + i - this.lastUpdateInhabitedTime);
        }
        this.lastUpdateInhabitedTime = i;
    }

    public void blockChanged(int p_blockChanged_1_, int p_blockChanged_2_, int p_blockChanged_3_) {
        if (this.sentToPlayers) {
            if (this.changes == 0) {
                this.playerChunkMap.entryChanged(this);
            }
            this.changedSectionFilter |= 1 << (p_blockChanged_2_ >> 4);
            short short1 = (short)(p_blockChanged_1_ << 12 | p_blockChanged_3_ << 8 | p_blockChanged_2_);
            for (int i = 0; i < this.changes; ++i) {
                if (this.changedBlocks[i] != short1) continue;
                return;
            }
            if (this.changes == this.changedBlocks.length) {
                this.changedBlocks = Arrays.copyOf(this.changedBlocks, this.changedBlocks.length << 1);
            }
            this.changedBlocks[this.changes++] = short1;
        }
    }

    public void sendPacket(Packet<?> p_sendPacket_1_) {
        if (this.sentToPlayers) {
            for (int i = 0; i < this.players.size(); ++i) {
                this.players.get((int)i).connection.sendPacket(p_sendPacket_1_);
            }
        }
    }

    public void update() {
        if (this.sentToPlayers && this.chunk != null && this.changes != 0) {
            if (this.changes == 1) {
                int i = (this.changedBlocks[0] >> 12 & 0xF) + this.pos.chunkXPos * 16;
                int j = this.changedBlocks[0] & 0xFF;
                int k = (this.changedBlocks[0] >> 8 & 0xF) + this.pos.chunkZPos * 16;
                BlockPos blockpos = new BlockPos(i, j, k);
                this.sendPacket(new SPacketBlockChange(this.playerChunkMap.getWorldServer(), blockpos));
                IBlockState state = this.playerChunkMap.getWorldServer().getBlockState(blockpos);
                if (state.getBlock().hasTileEntity(state)) {
                    this.sendBlockEntity(this.playerChunkMap.getWorldServer().getTileEntity(blockpos));
                }
            } else if (this.changes >= ForgeModContainer.clumpingThreshold) {
                this.sendPacket(new SPacketChunkData(this.chunk, this.changedSectionFilter));
            } else {
                this.sendPacket(new SPacketMultiBlockChange(this.changes, this.changedBlocks, this.chunk));
                for (int l = 0; l < this.changes; ++l) {
                    int i1 = (this.changedBlocks[l] >> 12 & 0xF) + this.pos.chunkXPos * 16;
                    int j1 = this.changedBlocks[l] & 0xFF;
                    int k1 = (this.changedBlocks[l] >> 8 & 0xF) + this.pos.chunkZPos * 16;
                    BlockPos blockpos1 = new BlockPos(i1, j1, k1);
                    IBlockState state = this.playerChunkMap.getWorldServer().getBlockState(blockpos1);
                    if (!state.getBlock().hasTileEntity(state)) continue;
                    this.sendBlockEntity(this.playerChunkMap.getWorldServer().getTileEntity(blockpos1));
                }
            }
            this.changes = 0;
            this.changedSectionFilter = 0;
        }
    }

    private void sendBlockEntity(TileEntity p_sendBlockEntity_1_) {
        SPacketUpdateTileEntity spacketupdatetileentity;
        if (p_sendBlockEntity_1_ != null && (spacketupdatetileentity = p_sendBlockEntity_1_.getUpdatePacket()) != null) {
            this.sendPacket(spacketupdatetileentity);
        }
    }

    public boolean containsPlayer(EntityPlayerMP p_containsPlayer_1_) {
        return this.players.contains(p_containsPlayer_1_);
    }

    public boolean hasPlayerMatching(Predicate<EntityPlayerMP> p_hasPlayerMatching_1_) {
        return Iterables.tryFind(this.players, p_hasPlayerMatching_1_).isPresent();
    }

    public boolean hasPlayerMatchingInRange(double p_hasPlayerMatchingInRange_1_, Predicate<EntityPlayerMP> p_hasPlayerMatchingInRange_3_) {
        int j = this.players.size();
        for (int i = 0; i < j; ++i) {
            EntityPlayerMP entityplayermp = this.players.get(i);
            if (!p_hasPlayerMatchingInRange_3_.apply((Object)entityplayermp) || !(this.pos.getDistanceSq(entityplayermp) < p_hasPlayerMatchingInRange_1_ * p_hasPlayerMatchingInRange_1_)) continue;
            return true;
        }
        return false;
    }

    public boolean isSentToPlayers() {
        return this.sentToPlayers;
    }

    @Nullable
    public Chunk getChunk() {
        return this.chunk;
    }

    public double getClosestPlayerDistance() {
        double d0 = Double.MAX_VALUE;
        for (EntityPlayerMP entityplayermp : this.players) {
            double d1 = this.pos.getDistanceSq(entityplayermp);
            if (!(d1 < d0)) continue;
            d0 = d1;
        }
        return d0;
    }
}

