/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerInteractionManager {
    private double blockReachDistance = 5.0;
    public World world;
    public EntityPlayerMP player;
    private GameType gameType = GameType.NOT_SET;
    private boolean isDestroyingBlock;
    private int initialDamage;
    private BlockPos destroyPos = BlockPos.ORIGIN;
    private int curblockDamage;
    private boolean receivedFinishDiggingPacket;
    private BlockPos delayedDestroyPos = BlockPos.ORIGIN;
    private int initialBlockDamage;
    private int durabilityRemainingOnBlock = -1;

    public PlayerInteractionManager(World p_i1524_1_) {
        this.world = p_i1524_1_;
    }

    public void setGameType(GameType p_setGameType_1_) {
        this.gameType = p_setGameType_1_;
        p_setGameType_1_.configurePlayerCapabilities(this.player.capabilities);
        this.player.sendPlayerAbilities();
        this.player.mcServer.getPlayerList().sendPacketToAllPlayers(new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_GAME_MODE, this.player));
        this.world.updateAllPlayersSleepingFlag();
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public boolean survivalOrAdventure() {
        return this.gameType.isSurvivalOrAdventure();
    }

    public boolean isCreative() {
        return this.gameType.isCreative();
    }

    public void initializeGameType(GameType p_initializeGameType_1_) {
        if (this.gameType == GameType.NOT_SET) {
            this.gameType = p_initializeGameType_1_;
        }
        this.setGameType(this.gameType);
    }

    public void updateBlockRemoving() {
        ++this.curblockDamage;
        if (this.receivedFinishDiggingPacket) {
            int i = this.curblockDamage - this.initialBlockDamage;
            IBlockState iblockstate = this.world.getBlockState(this.delayedDestroyPos);
            Block block = iblockstate.getBlock();
            if (block.isAir(iblockstate, this.world, this.delayedDestroyPos)) {
                this.receivedFinishDiggingPacket = false;
            } else {
                float f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, this.delayedDestroyPos) * (float)(i + 1);
                int j = (int)(f * 10.0f);
                if (j != this.durabilityRemainingOnBlock) {
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), this.delayedDestroyPos, j);
                    this.durabilityRemainingOnBlock = j;
                }
                if (f >= 1.0f) {
                    this.receivedFinishDiggingPacket = false;
                    this.tryHarvestBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            IBlockState iblockstate1 = this.world.getBlockState(this.destroyPos);
            Block block1 = iblockstate1.getBlock();
            if (block1.isAir(iblockstate1, this.world, this.destroyPos)) {
                this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, -1);
                this.durabilityRemainingOnBlock = -1;
                this.isDestroyingBlock = false;
            } else {
                int k = this.curblockDamage - this.initialDamage;
                float f1 = iblockstate1.getPlayerRelativeBlockHardness(this.player, this.player.world, this.destroyPos) * (float)(k + 1);
                int l = (int)(f1 * 10.0f);
                if (l != this.durabilityRemainingOnBlock) {
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, l);
                    this.durabilityRemainingOnBlock = l;
                }
            }
        }
    }

    public void onBlockClicked(BlockPos p_onBlockClicked_1_, EnumFacing p_onBlockClicked_2_) {
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock(this.player, p_onBlockClicked_1_, p_onBlockClicked_2_, ForgeHooks.rayTraceEyeHitVec(this.player, this.getBlockReachDistance() + 1.0));
        if (event.isCanceled()) {
            this.player.connection.sendPacket(new SPacketBlockChange(this.world, p_onBlockClicked_1_));
            this.world.notifyBlockUpdate(p_onBlockClicked_1_, this.world.getBlockState(p_onBlockClicked_1_), this.world.getBlockState(p_onBlockClicked_1_), 3);
            return;
        }
        if (this.isCreative()) {
            if (!this.world.extinguishFire(null, p_onBlockClicked_1_, p_onBlockClicked_2_)) {
                this.tryHarvestBlock(p_onBlockClicked_1_);
            }
        } else {
            IBlockState iblockstate = this.world.getBlockState(p_onBlockClicked_1_);
            Block block = iblockstate.getBlock();
            if (this.gameType.isAdventure()) {
                if (this.gameType == GameType.SPECTATOR) {
                    return;
                }
                if (!this.player.isAllowEdit()) {
                    ItemStack itemstack = this.player.getHeldItemMainhand();
                    if (itemstack.isEmpty()) {
                        return;
                    }
                    if (!itemstack.canDestroy(block)) {
                        return;
                    }
                }
            }
            this.initialDamage = this.curblockDamage;
            float f = 1.0f;
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, p_onBlockClicked_1_)) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    block.onBlockClicked(this.world, p_onBlockClicked_1_, this.player);
                    this.world.extinguishFire(null, p_onBlockClicked_1_, p_onBlockClicked_2_);
                } else {
                    this.player.connection.sendPacket(new SPacketBlockChange(this.world, p_onBlockClicked_1_));
                    this.world.notifyBlockUpdate(p_onBlockClicked_1_, this.world.getBlockState(p_onBlockClicked_1_), this.world.getBlockState(p_onBlockClicked_1_), 3);
                }
                f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, p_onBlockClicked_1_);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                if (f >= 1.0f) {
                    this.player.connection.sendPacket(new SPacketBlockChange(this.world, p_onBlockClicked_1_));
                    this.world.notifyBlockUpdate(p_onBlockClicked_1_, this.world.getBlockState(p_onBlockClicked_1_), this.world.getBlockState(p_onBlockClicked_1_), 3);
                }
                return;
            }
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, p_onBlockClicked_1_) && f >= 1.0f) {
                this.tryHarvestBlock(p_onBlockClicked_1_);
            } else {
                this.isDestroyingBlock = true;
                this.destroyPos = p_onBlockClicked_1_;
                int i = (int)(f * 10.0f);
                this.world.sendBlockBreakProgress(this.player.getEntityId(), p_onBlockClicked_1_, i);
                this.durabilityRemainingOnBlock = i;
            }
        }
    }

    public void blockRemoving(BlockPos p_blockRemoving_1_) {
        if (p_blockRemoving_1_.equals(this.destroyPos)) {
            int i = this.curblockDamage - this.initialDamage;
            IBlockState iblockstate = this.world.getBlockState(p_blockRemoving_1_);
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, p_blockRemoving_1_)) {
                float f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, p_blockRemoving_1_) * (float)(i + 1);
                if (f >= 0.7f) {
                    this.isDestroyingBlock = false;
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), p_blockRemoving_1_, -1);
                    this.tryHarvestBlock(p_blockRemoving_1_);
                } else if (!this.receivedFinishDiggingPacket) {
                    this.isDestroyingBlock = false;
                    this.receivedFinishDiggingPacket = true;
                    this.delayedDestroyPos = p_blockRemoving_1_;
                    this.initialBlockDamage = this.initialDamage;
                }
            }
        }
    }

    public void cancelDestroyingBlock() {
        this.isDestroyingBlock = false;
        this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, -1);
    }

    private boolean removeBlock(BlockPos p_removeBlock_1_) {
        return this.removeBlock(p_removeBlock_1_, false);
    }

    private boolean removeBlock(BlockPos p_removeBlock_1_, boolean p_removeBlock_2_) {
        IBlockState iblockstate = this.world.getBlockState(p_removeBlock_1_);
        boolean flag = iblockstate.getBlock().removedByPlayer(iblockstate, this.world, p_removeBlock_1_, this.player, p_removeBlock_2_);
        if (flag) {
            iblockstate.getBlock().onBlockDestroyedByPlayer(this.world, p_removeBlock_1_, iblockstate);
        }
        return flag;
    }

    public boolean tryHarvestBlock(BlockPos p_tryHarvestBlock_1_) {
        int exp = ForgeHooks.onBlockBreakEvent(this.world, this.gameType, this.player, p_tryHarvestBlock_1_);
        if (exp == -1) {
            return false;
        }
        IBlockState iblockstate = this.world.getBlockState(p_tryHarvestBlock_1_);
        TileEntity tileentity = this.world.getTileEntity(p_tryHarvestBlock_1_);
        Block block = iblockstate.getBlock();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !this.player.canUseCommandBlock()) {
            this.world.notifyBlockUpdate(p_tryHarvestBlock_1_, iblockstate, iblockstate, 3);
            return false;
        }
        ItemStack stack = this.player.getHeldItemMainhand();
        if (!stack.isEmpty() && stack.getItem().onBlockStartBreak(stack, p_tryHarvestBlock_1_, this.player)) {
            return false;
        }
        this.world.playEvent(this.player, 2001, p_tryHarvestBlock_1_, Block.getStateId(iblockstate));
        boolean flag1 = false;
        if (this.isCreative()) {
            flag1 = this.removeBlock(p_tryHarvestBlock_1_);
            this.player.connection.sendPacket(new SPacketBlockChange(this.world, p_tryHarvestBlock_1_));
        } else {
            ItemStack itemstack1 = this.player.getHeldItemMainhand();
            ItemStack itemstack2 = itemstack1.isEmpty() ? ItemStack.EMPTY : itemstack1.copy();
            boolean flag = iblockstate.getBlock().canHarvestBlock(this.world, p_tryHarvestBlock_1_, this.player);
            if (!itemstack1.isEmpty()) {
                itemstack1.onBlockDestroyed(this.world, iblockstate, p_tryHarvestBlock_1_, this.player);
            }
            if ((flag1 = this.removeBlock(p_tryHarvestBlock_1_, flag)) && flag) {
                iblockstate.getBlock().harvestBlock(this.world, this.player, p_tryHarvestBlock_1_, iblockstate, tileentity, itemstack2);
            }
        }
        if (!this.isCreative() && flag1 && exp > 0) {
            iblockstate.getBlock().dropXpOnBlockBreak(this.world, p_tryHarvestBlock_1_, exp);
        }
        return flag1;
    }

    public EnumActionResult processRightClick(EntityPlayer p_processRightClick_1_, World p_processRightClick_2_, ItemStack p_processRightClick_3_, EnumHand p_processRightClick_4_) {
        if (this.gameType == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        if (p_processRightClick_1_.getCooldownTracker().hasCooldown(p_processRightClick_3_.getItem())) {
            return EnumActionResult.PASS;
        }
        if (ForgeHooks.onItemRightClick(p_processRightClick_1_, p_processRightClick_4_)) {
            return EnumActionResult.PASS;
        }
        int i = p_processRightClick_3_.getCount();
        int j = p_processRightClick_3_.getMetadata();
        ItemStack copyBeforeUse = p_processRightClick_3_.copy();
        ActionResult<ItemStack> actionresult = p_processRightClick_3_.useItemRightClick(p_processRightClick_2_, p_processRightClick_1_, p_processRightClick_4_);
        ItemStack itemstack = actionresult.getResult();
        if (itemstack == p_processRightClick_3_ && itemstack.getCount() == i && itemstack.getMaxItemUseDuration() <= 0 && itemstack.getMetadata() == j) {
            return actionresult.getType();
        }
        if (actionresult.getType() == EnumActionResult.FAIL && itemstack.getMaxItemUseDuration() > 0 && !p_processRightClick_1_.isHandActive()) {
            return actionresult.getType();
        }
        p_processRightClick_1_.setHeldItem(p_processRightClick_4_, itemstack);
        if (this.isCreative()) {
            itemstack.setCount(i);
            if (itemstack.isItemStackDamageable()) {
                itemstack.setItemDamage(j);
            }
        }
        if (itemstack.isEmpty()) {
            p_processRightClick_1_.setHeldItem(p_processRightClick_4_, ItemStack.EMPTY);
            ForgeEventFactory.onPlayerDestroyItem(p_processRightClick_1_, copyBeforeUse, p_processRightClick_4_);
        }
        if (!p_processRightClick_1_.isHandActive()) {
            ((EntityPlayerMP)p_processRightClick_1_).sendContainerToPlayer(p_processRightClick_1_.inventoryContainer);
        }
        return actionresult.getType();
    }

    public EnumActionResult processRightClickBlock(EntityPlayer p_processRightClickBlock_1_, World p_processRightClickBlock_2_, ItemStack p_processRightClickBlock_3_, EnumHand p_processRightClickBlock_4_, BlockPos p_processRightClickBlock_5_, EnumFacing p_processRightClickBlock_6_, float p_processRightClickBlock_7_, float p_processRightClickBlock_8_, float p_processRightClickBlock_9_) {
        Block block;
        if (this.gameType == GameType.SPECTATOR) {
            TileEntity tileentity = p_processRightClickBlock_2_.getTileEntity(p_processRightClickBlock_5_);
            if (tileentity instanceof ILockableContainer) {
                Block block1 = p_processRightClickBlock_2_.getBlockState(p_processRightClickBlock_5_).getBlock();
                ILockableContainer ilockablecontainer = (ILockableContainer)((Object)tileentity);
                if (ilockablecontainer instanceof TileEntityChest && block1 instanceof BlockChest) {
                    ilockablecontainer = ((BlockChest)block1).getLockableContainer(p_processRightClickBlock_2_, p_processRightClickBlock_5_);
                }
                if (ilockablecontainer != null) {
                    p_processRightClickBlock_1_.displayGUIChest(ilockablecontainer);
                    return EnumActionResult.SUCCESS;
                }
            } else if (tileentity instanceof IInventory) {
                p_processRightClickBlock_1_.displayGUIChest((IInventory)((Object)tileentity));
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock(p_processRightClickBlock_1_, p_processRightClickBlock_4_, p_processRightClickBlock_5_, p_processRightClickBlock_6_, ForgeHooks.rayTraceEyeHitVec(p_processRightClickBlock_1_, this.getBlockReachDistance() + 1.0));
        if (event.isCanceled()) {
            return EnumActionResult.PASS;
        }
        EnumActionResult ret = p_processRightClickBlock_3_.onItemUseFirst(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_5_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, p_processRightClickBlock_7_, p_processRightClickBlock_8_, p_processRightClickBlock_9_);
        if (ret != EnumActionResult.PASS) {
            return ret;
        }
        boolean bypass = true;
        for (ItemStack s : new ItemStack[]{p_processRightClickBlock_1_.getHeldItemMainhand(), p_processRightClickBlock_1_.getHeldItemOffhand()}) {
            bypass = bypass && (s.isEmpty() || s.getItem().doesSneakBypassUse(s, p_processRightClickBlock_2_, p_processRightClickBlock_5_, p_processRightClickBlock_1_));
        }
        EnumActionResult result = EnumActionResult.PASS;
        if (!p_processRightClickBlock_1_.isSneaking() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState iblockstate = p_processRightClickBlock_2_.getBlockState(p_processRightClickBlock_5_);
            if (event.getUseBlock() != Event.Result.DENY && iblockstate.getBlock().onBlockActivated(p_processRightClickBlock_2_, p_processRightClickBlock_5_, iblockstate, p_processRightClickBlock_1_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, p_processRightClickBlock_7_, p_processRightClickBlock_8_, p_processRightClickBlock_9_)) {
                result = EnumActionResult.SUCCESS;
            }
        }
        if (p_processRightClickBlock_3_.isEmpty()) {
            return EnumActionResult.PASS;
        }
        if (p_processRightClickBlock_1_.getCooldownTracker().hasCooldown(p_processRightClickBlock_3_.getItem())) {
            return EnumActionResult.PASS;
        }
        if (p_processRightClickBlock_3_.getItem() instanceof ItemBlock && !p_processRightClickBlock_1_.canUseCommandBlock() && ((block = ((ItemBlock)p_processRightClickBlock_3_.getItem()).getBlock()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
            return EnumActionResult.FAIL;
        }
        if (this.isCreative()) {
            int j = p_processRightClickBlock_3_.getMetadata();
            int i = p_processRightClickBlock_3_.getCount();
            if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                EnumActionResult enumactionresult = p_processRightClickBlock_3_.onItemUse(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_5_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, p_processRightClickBlock_7_, p_processRightClickBlock_8_, p_processRightClickBlock_9_);
                p_processRightClickBlock_3_.setItemDamage(j);
                p_processRightClickBlock_3_.setCount(i);
                return enumactionresult;
            }
            return result;
        }
        if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
            return p_processRightClickBlock_3_.onItemUse(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_5_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, p_processRightClickBlock_7_, p_processRightClickBlock_8_, p_processRightClickBlock_9_);
        }
        return result;
    }

    public void setWorld(WorldServer p_setWorld_1_) {
        this.world = p_setWorld_1_;
    }

    public double getBlockReachDistance() {
        return this.blockReachDistance;
    }

    public void setBlockReachDistance(double p_setBlockReachDistance_1_) {
        this.blockReachDistance = p_setBlockReachDistance_1_;
    }
}

