/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.server.management.UserListWhitelistEntry;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.demo.DemoWorldManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File FILE_PLAYERBANS = new File("banned-players.json");
    public static final File FILE_IPBANS = new File("banned-ips.json");
    public static final File FILE_OPS = new File("ops.json");
    public static final File FILE_WHITELIST = new File("whitelist.json");
    private static final Logger LOG = LogManager.getLogger();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer mcServer;
    private final List<EntityPlayerMP> playerEntityList = Lists.newArrayList();
    private final Map<UUID, EntityPlayerMP> uuidToPlayerMap = Maps.newHashMap();
    private final UserListBans bannedPlayers = new UserListBans(FILE_PLAYERBANS);
    private final UserListIPBans bannedIPs = new UserListIPBans(FILE_IPBANS);
    private final UserListOps ops = new UserListOps(FILE_OPS);
    private final UserListWhitelist whiteListedPlayers = new UserListWhitelist(FILE_WHITELIST);
    private final Map<UUID, StatisticsManagerServer> playerStatFiles = Maps.newHashMap();
    private IPlayerFileData playerNBTManagerObj;
    private boolean whiteListEnforced;
    protected int maxPlayers;
    private int viewDistance;
    private GameType gameType;
    private boolean commandsAllowedForAll;
    private int playerPingIndex;

    public PlayerList(MinecraftServer p_i1500_1_) {
        this.mcServer = p_i1500_1_;
        this.bannedPlayers.setLanServer(false);
        this.bannedIPs.setLanServer(false);
        this.maxPlayers = 8;
    }

    public void initializeConnectionToPlayer(NetworkManager p_initializeConnectionToPlayer_1_, EntityPlayerMP p_initializeConnectionToPlayer_2_, NetHandlerPlayServer p_initializeConnectionToPlayer_3_) {
        NBTTagCompound nbttagcompound1;
        Entity entity1;
        GameProfile gameprofile = p_initializeConnectionToPlayer_2_.getGameProfile();
        PlayerProfileCache playerprofilecache = this.mcServer.getPlayerProfileCache();
        GameProfile gameprofile1 = playerprofilecache.getProfileByUUID(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.addEntry(gameprofile);
        NBTTagCompound nbttagcompound = this.readPlayerDataFromFile(p_initializeConnectionToPlayer_2_);
        p_initializeConnectionToPlayer_2_.setWorld(this.mcServer.worldServerForDimension(p_initializeConnectionToPlayer_2_.dimension));
        WorldServer playerWorld = this.mcServer.worldServerForDimension(p_initializeConnectionToPlayer_2_.dimension);
        if (playerWorld == null) {
            p_initializeConnectionToPlayer_2_.dimension = 0;
            playerWorld = this.mcServer.worldServerForDimension(0);
            BlockPos spawnPoint = playerWorld.provider.getRandomizedSpawnPoint();
            p_initializeConnectionToPlayer_2_.setPosition(spawnPoint.getX(), spawnPoint.getY(), spawnPoint.getZ());
        }
        p_initializeConnectionToPlayer_2_.setWorld(playerWorld);
        p_initializeConnectionToPlayer_2_.interactionManager.setWorld((WorldServer)p_initializeConnectionToPlayer_2_.world);
        String s1 = "local";
        if (p_initializeConnectionToPlayer_1_.getRemoteAddress() != null) {
            s1 = p_initializeConnectionToPlayer_1_.getRemoteAddress().toString();
        }
        LOG.info("{}[{}] logged in with entity id {} at ({}, {}, {})", new Object[]{p_initializeConnectionToPlayer_2_.getName(), s1, p_initializeConnectionToPlayer_2_.getEntityId(), p_initializeConnectionToPlayer_2_.posX, p_initializeConnectionToPlayer_2_.posY, p_initializeConnectionToPlayer_2_.posZ});
        WorldServer worldserver = this.mcServer.worldServerForDimension(p_initializeConnectionToPlayer_2_.dimension);
        WorldInfo worldinfo = worldserver.getWorldInfo();
        this.setPlayerGameTypeBasedOnOther(p_initializeConnectionToPlayer_2_, null, worldserver);
        p_initializeConnectionToPlayer_2_.connection = p_initializeConnectionToPlayer_3_;
        p_initializeConnectionToPlayer_3_.sendPacket(new SPacketJoinGame(p_initializeConnectionToPlayer_2_.getEntityId(), p_initializeConnectionToPlayer_2_.interactionManager.getGameType(), worldinfo.isHardcoreModeEnabled(), worldserver.provider.getDimension(), worldserver.getDifficulty(), this.getMaxPlayers(), worldinfo.getTerrainType(), worldserver.getGameRules().getBoolean("reducedDebugInfo")));
        p_initializeConnectionToPlayer_3_.sendPacket(new SPacketCustomPayload("MC|Brand", new PacketBuffer(Unpooled.buffer()).writeString(this.getServerInstance().getServerModName())));
        p_initializeConnectionToPlayer_3_.sendPacket(new SPacketServerDifficulty(worldinfo.getDifficulty(), worldinfo.isDifficultyLocked()));
        p_initializeConnectionToPlayer_3_.sendPacket(new SPacketPlayerAbilities(p_initializeConnectionToPlayer_2_.capabilities));
        p_initializeConnectionToPlayer_3_.sendPacket(new SPacketHeldItemChange(p_initializeConnectionToPlayer_2_.inventory.currentItem));
        this.updatePermissionLevel(p_initializeConnectionToPlayer_2_);
        p_initializeConnectionToPlayer_2_.getStatFile().markAllDirty();
        p_initializeConnectionToPlayer_2_.getStatFile().sendAchievements(p_initializeConnectionToPlayer_2_);
        this.sendScoreboard((ServerScoreboard)worldserver.getScoreboard(), p_initializeConnectionToPlayer_2_);
        this.mcServer.refreshStatusNextTick();
        TextComponentTranslation textcomponenttranslation = p_initializeConnectionToPlayer_2_.getName().equalsIgnoreCase(s) ? new TextComponentTranslation("multiplayer.player.joined", p_initializeConnectionToPlayer_2_.getDisplayName()) : new TextComponentTranslation("multiplayer.player.joined.renamed", p_initializeConnectionToPlayer_2_.getDisplayName(), s);
        textcomponenttranslation.getStyle().setColor(TextFormatting.YELLOW);
        this.sendMessage(textcomponenttranslation);
        this.playerLoggedIn(p_initializeConnectionToPlayer_2_);
        p_initializeConnectionToPlayer_3_.setPlayerLocation(p_initializeConnectionToPlayer_2_.posX, p_initializeConnectionToPlayer_2_.posY, p_initializeConnectionToPlayer_2_.posZ, p_initializeConnectionToPlayer_2_.rotationYaw, p_initializeConnectionToPlayer_2_.rotationPitch);
        this.updateTimeAndWeatherForPlayer(p_initializeConnectionToPlayer_2_, worldserver);
        if (!this.mcServer.getResourcePackUrl().isEmpty()) {
            p_initializeConnectionToPlayer_2_.loadResourcePack(this.mcServer.getResourcePackUrl(), this.mcServer.getResourcePackHash());
        }
        for (PotionEffect potioneffect : p_initializeConnectionToPlayer_2_.getActivePotionEffects()) {
            p_initializeConnectionToPlayer_3_.sendPacket(new SPacketEntityEffect(p_initializeConnectionToPlayer_2_.getEntityId(), potioneffect));
        }
        if (nbttagcompound != null && nbttagcompound.hasKey("RootVehicle", 10) && (entity1 = AnvilChunkLoader.readWorldEntity((nbttagcompound1 = nbttagcompound.getCompoundTag("RootVehicle")).getCompoundTag("Entity"), worldserver, true)) != null) {
            UUID uuid = nbttagcompound1.getUniqueId("Attach");
            if (entity1.getUniqueID().equals(uuid)) {
                p_initializeConnectionToPlayer_2_.startRiding(entity1, true);
            } else {
                for (Entity entity : entity1.getRecursivePassengers()) {
                    if (!entity.getUniqueID().equals(uuid)) continue;
                    p_initializeConnectionToPlayer_2_.startRiding(entity, true);
                    break;
                }
            }
            if (!p_initializeConnectionToPlayer_2_.isRiding()) {
                LOG.warn("Couldn't reattach entity to player");
                worldserver.removeEntityDangerously(entity1);
                for (Entity entity2 : entity1.getRecursivePassengers()) {
                    worldserver.removeEntityDangerously(entity2);
                }
            }
        }
        p_initializeConnectionToPlayer_2_.addSelfToInternalCraftingInventory();
        FMLCommonHandler.instance().firePlayerLoggedIn(p_initializeConnectionToPlayer_2_);
    }

    protected void sendScoreboard(ServerScoreboard p_sendScoreboard_1_, EntityPlayerMP p_sendScoreboard_2_) {
        HashSet set = Sets.newHashSet();
        for (ScorePlayerTeam scoreplayerteam : p_sendScoreboard_1_.getTeams()) {
            p_sendScoreboard_2_.connection.sendPacket(new SPacketTeams(scoreplayerteam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = p_sendScoreboard_1_.getObjectiveInDisplaySlot(i);
            if (scoreobjective == null || set.contains(scoreobjective)) continue;
            for (Packet<?> packet : p_sendScoreboard_1_.getCreatePackets(scoreobjective)) {
                p_sendScoreboard_2_.connection.sendPacket(packet);
            }
            set.add(scoreobjective);
        }
    }

    public void setPlayerManager(WorldServer[] p_setPlayerManager_1_) {
        this.playerNBTManagerObj = p_setPlayerManager_1_[0].getSaveHandler().getPlayerNBTManager();
        p_setPlayerManager_1_[0].getWorldBorder().addListener(new IBorderListener(){

            @Override
            public void onSizeChanged(WorldBorder p_onSizeChanged_1_, double p_onSizeChanged_2_) {
                PlayerList.this.sendPacketToAllPlayers(new SPacketWorldBorder(p_onSizeChanged_1_, SPacketWorldBorder.Action.SET_SIZE));
            }

            @Override
            public void onTransitionStarted(WorldBorder p_onTransitionStarted_1_, double p_onTransitionStarted_2_, double p_onTransitionStarted_4_, long p_onTransitionStarted_6_) {
                PlayerList.this.sendPacketToAllPlayers(new SPacketWorldBorder(p_onTransitionStarted_1_, SPacketWorldBorder.Action.LERP_SIZE));
            }

            @Override
            public void onCenterChanged(WorldBorder p_onCenterChanged_1_, double p_onCenterChanged_2_, double p_onCenterChanged_4_) {
                PlayerList.this.sendPacketToAllPlayers(new SPacketWorldBorder(p_onCenterChanged_1_, SPacketWorldBorder.Action.SET_CENTER));
            }

            @Override
            public void onWarningTimeChanged(WorldBorder p_onWarningTimeChanged_1_, int p_onWarningTimeChanged_2_) {
                PlayerList.this.sendPacketToAllPlayers(new SPacketWorldBorder(p_onWarningTimeChanged_1_, SPacketWorldBorder.Action.SET_WARNING_TIME));
            }

            @Override
            public void onWarningDistanceChanged(WorldBorder p_onWarningDistanceChanged_1_, int p_onWarningDistanceChanged_2_) {
                PlayerList.this.sendPacketToAllPlayers(new SPacketWorldBorder(p_onWarningDistanceChanged_1_, SPacketWorldBorder.Action.SET_WARNING_BLOCKS));
            }

            @Override
            public void onDamageAmountChanged(WorldBorder p_onDamageAmountChanged_1_, double p_onDamageAmountChanged_2_) {
            }

            @Override
            public void onDamageBufferChanged(WorldBorder p_onDamageBufferChanged_1_, double p_onDamageBufferChanged_2_) {
            }
        });
    }

    public void preparePlayer(EntityPlayerMP p_preparePlayer_1_, WorldServer p_preparePlayer_2_) {
        WorldServer worldserver = p_preparePlayer_1_.getServerWorld();
        if (p_preparePlayer_2_ != null) {
            p_preparePlayer_2_.getPlayerChunkMap().removePlayer(p_preparePlayer_1_);
        }
        worldserver.getPlayerChunkMap().addPlayer(p_preparePlayer_1_);
        worldserver.getChunkProvider().provideChunk((int)p_preparePlayer_1_.posX >> 4, (int)p_preparePlayer_1_.posZ >> 4);
    }

    public int getEntityViewDistance() {
        return PlayerChunkMap.getFurthestViewableBlock(this.getViewDistance());
    }

    @Nullable
    public NBTTagCompound readPlayerDataFromFile(EntityPlayerMP p_readPlayerDataFromFile_1_) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = this.mcServer.worlds[0].getWorldInfo().getPlayerNBTTagCompound();
        if (p_readPlayerDataFromFile_1_.getName().equals(this.mcServer.getServerOwner()) && nbttagcompound != null) {
            nbttagcompound1 = this.mcServer.getDataFixer().process(FixTypes.PLAYER, nbttagcompound);
            p_readPlayerDataFromFile_1_.readFromNBT(nbttagcompound1);
            LOG.debug("loading single player");
            ForgeEventFactory.firePlayerLoadingEvent((EntityPlayer)p_readPlayerDataFromFile_1_, this.playerNBTManagerObj, p_readPlayerDataFromFile_1_.getUniqueID().toString());
        } else {
            nbttagcompound1 = this.playerNBTManagerObj.readPlayerData(p_readPlayerDataFromFile_1_);
        }
        return nbttagcompound1;
    }

    public NBTTagCompound getPlayerNBT(EntityPlayerMP p_getPlayerNBT_1_) {
        NBTTagCompound nbttagcompound = this.mcServer.worlds[0].getWorldInfo().getPlayerNBTTagCompound();
        if (p_getPlayerNBT_1_.getName().equals(this.mcServer.getServerOwner()) && nbttagcompound != null) {
            return nbttagcompound;
        }
        return ((SaveHandler)this.playerNBTManagerObj).getPlayerNBT(p_getPlayerNBT_1_);
    }

    protected void writePlayerData(EntityPlayerMP p_writePlayerData_1_) {
        if (p_writePlayerData_1_.connection == null) {
            return;
        }
        this.playerNBTManagerObj.writePlayerData(p_writePlayerData_1_);
        StatisticsManagerServer statisticsmanagerserver = this.playerStatFiles.get(p_writePlayerData_1_.getUniqueID());
        if (statisticsmanagerserver != null) {
            statisticsmanagerserver.saveStatFile();
        }
    }

    public void playerLoggedIn(EntityPlayerMP p_playerLoggedIn_1_) {
        this.playerEntityList.add(p_playerLoggedIn_1_);
        this.uuidToPlayerMap.put(p_playerLoggedIn_1_.getUniqueID(), p_playerLoggedIn_1_);
        this.sendPacketToAllPlayers(new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, p_playerLoggedIn_1_));
        WorldServer worldserver = this.mcServer.worldServerForDimension(p_playerLoggedIn_1_.dimension);
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            p_playerLoggedIn_1_.connection.sendPacket(new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, this.playerEntityList.get(i)));
        }
        ChunkIOExecutor.adjustPoolSize(this.getCurrentPlayerCount());
        worldserver.spawnEntity(p_playerLoggedIn_1_);
        this.preparePlayer(p_playerLoggedIn_1_, null);
    }

    public void serverUpdateMovingPlayer(EntityPlayerMP p_serverUpdateMovingPlayer_1_) {
        p_serverUpdateMovingPlayer_1_.getServerWorld().getPlayerChunkMap().updateMovingPlayer(p_serverUpdateMovingPlayer_1_);
    }

    public void playerLoggedOut(EntityPlayerMP p_playerLoggedOut_1_) {
        Entity entity;
        FMLCommonHandler.instance().firePlayerLoggedOut(p_playerLoggedOut_1_);
        WorldServer worldserver = p_playerLoggedOut_1_.getServerWorld();
        p_playerLoggedOut_1_.addStat(StatList.LEAVE_GAME);
        this.writePlayerData(p_playerLoggedOut_1_);
        if (p_playerLoggedOut_1_.isRiding() && (entity = p_playerLoggedOut_1_.getLowestRidingEntity()).getRecursivePassengersByType(EntityPlayerMP.class).size() == 1) {
            LOG.debug("Removing player mount");
            p_playerLoggedOut_1_.dismountRidingEntity();
            worldserver.removeEntityDangerously(entity);
            for (Entity entity1 : entity.getRecursivePassengers()) {
                worldserver.removeEntityDangerously(entity1);
            }
            worldserver.getChunkFromChunkCoords(p_playerLoggedOut_1_.chunkCoordX, p_playerLoggedOut_1_.chunkCoordZ).setChunkModified();
        }
        worldserver.removeEntity(p_playerLoggedOut_1_);
        worldserver.getPlayerChunkMap().removePlayer(p_playerLoggedOut_1_);
        this.playerEntityList.remove(p_playerLoggedOut_1_);
        UUID uuid = p_playerLoggedOut_1_.getUniqueID();
        EntityPlayerMP entityplayermp = this.uuidToPlayerMap.get(uuid);
        if (entityplayermp == p_playerLoggedOut_1_) {
            this.uuidToPlayerMap.remove(uuid);
            this.playerStatFiles.remove(uuid);
        }
        ChunkIOExecutor.adjustPoolSize(this.getCurrentPlayerCount());
        this.sendPacketToAllPlayers(new SPacketPlayerListItem(SPacketPlayerListItem.Action.REMOVE_PLAYER, p_playerLoggedOut_1_));
    }

    public String allowUserToConnect(SocketAddress p_allowUserToConnect_1_, GameProfile p_allowUserToConnect_2_) {
        if (this.bannedPlayers.isBanned(p_allowUserToConnect_2_)) {
            UserListBansEntry userlistbansentry = (UserListBansEntry)this.bannedPlayers.getEntry(p_allowUserToConnect_2_);
            String s1 = "You are banned from this server!\nReason: " + userlistbansentry.getBanReason();
            if (userlistbansentry.getBanEndDate() != null) {
                s1 = s1 + "\nYour ban will be removed on " + DATE_FORMAT.format(userlistbansentry.getBanEndDate());
            }
            return s1;
        }
        if (!this.canJoin(p_allowUserToConnect_2_)) {
            return "You are not white-listed on this server!";
        }
        if (this.bannedIPs.isBanned(p_allowUserToConnect_1_)) {
            UserListIPBansEntry userlistipbansentry = this.bannedIPs.getBanEntry(p_allowUserToConnect_1_);
            String s = "Your IP address is banned from this server!\nReason: " + userlistipbansentry.getBanReason();
            if (userlistipbansentry.getBanEndDate() != null) {
                s = s + "\nYour ban will be removed on " + DATE_FORMAT.format(userlistipbansentry.getBanEndDate());
            }
            return s;
        }
        return this.playerEntityList.size() >= this.maxPlayers && !this.bypassesPlayerLimit(p_allowUserToConnect_2_) ? "The server is full!" : null;
    }

    public EntityPlayerMP createPlayerForUser(GameProfile p_createPlayerForUser_1_) {
        UUID uuid = EntityPlayer.getUUID(p_createPlayerForUser_1_);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            EntityPlayerMP entityplayermp = this.playerEntityList.get(i);
            if (!entityplayermp.getUniqueID().equals(uuid)) continue;
            list.add(entityplayermp);
        }
        EntityPlayerMP entityplayermp2 = this.uuidToPlayerMap.get(p_createPlayerForUser_1_.getId());
        if (entityplayermp2 != null && !list.contains(entityplayermp2)) {
            list.add(entityplayermp2);
        }
        for (EntityPlayerMP entityplayermp1 : list) {
            entityplayermp1.connection.disconnect("You logged in from another location");
        }
        PlayerInteractionManager playerinteractionmanager = this.mcServer.isDemo() ? new DemoWorldManager(this.mcServer.worldServerForDimension(0)) : new PlayerInteractionManager(this.mcServer.worldServerForDimension(0));
        return new EntityPlayerMP(this.mcServer, this.mcServer.worldServerForDimension(0), p_createPlayerForUser_1_, playerinteractionmanager);
    }

    public EntityPlayerMP recreatePlayerEntity(EntityPlayerMP p_recreatePlayerEntity_1_, int p_recreatePlayerEntity_2_, boolean p_recreatePlayerEntity_3_) {
        WorldServer world = this.mcServer.worldServerForDimension(p_recreatePlayerEntity_2_);
        if (world == null) {
            p_recreatePlayerEntity_2_ = 0;
        } else if (!world.provider.canRespawnHere()) {
            p_recreatePlayerEntity_2_ = world.provider.getRespawnDimension(p_recreatePlayerEntity_1_);
        }
        p_recreatePlayerEntity_1_.getServerWorld().getEntityTracker().removePlayerFromTrackers(p_recreatePlayerEntity_1_);
        p_recreatePlayerEntity_1_.getServerWorld().getEntityTracker().untrack(p_recreatePlayerEntity_1_);
        p_recreatePlayerEntity_1_.getServerWorld().getPlayerChunkMap().removePlayer(p_recreatePlayerEntity_1_);
        this.playerEntityList.remove(p_recreatePlayerEntity_1_);
        this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension).removeEntityDangerously(p_recreatePlayerEntity_1_);
        BlockPos blockpos = p_recreatePlayerEntity_1_.getBedLocation(p_recreatePlayerEntity_2_);
        boolean flag = p_recreatePlayerEntity_1_.isSpawnForced(p_recreatePlayerEntity_2_);
        p_recreatePlayerEntity_1_.dimension = p_recreatePlayerEntity_2_;
        PlayerInteractionManager playerinteractionmanager = this.mcServer.isDemo() ? new DemoWorldManager(this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension)) : new PlayerInteractionManager(this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension));
        EntityPlayerMP entityplayermp = new EntityPlayerMP(this.mcServer, this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension), p_recreatePlayerEntity_1_.getGameProfile(), playerinteractionmanager);
        entityplayermp.connection = p_recreatePlayerEntity_1_.connection;
        entityplayermp.clonePlayer(p_recreatePlayerEntity_1_, p_recreatePlayerEntity_3_);
        entityplayermp.dimension = p_recreatePlayerEntity_2_;
        entityplayermp.setEntityId(p_recreatePlayerEntity_1_.getEntityId());
        entityplayermp.setCommandStats(p_recreatePlayerEntity_1_);
        entityplayermp.setPrimaryHand(p_recreatePlayerEntity_1_.getPrimaryHand());
        for (String s : p_recreatePlayerEntity_1_.getTags()) {
            entityplayermp.addTag(s);
        }
        WorldServer worldserver = this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension);
        this.setPlayerGameTypeBasedOnOther(entityplayermp, p_recreatePlayerEntity_1_, worldserver);
        if (blockpos != null) {
            BlockPos blockpos1 = EntityPlayer.getBedSpawnLocation(this.mcServer.worldServerForDimension(p_recreatePlayerEntity_1_.dimension), blockpos, flag);
            if (blockpos1 != null) {
                entityplayermp.setLocationAndAngles((float)blockpos1.getX() + 0.5f, (float)blockpos1.getY() + 0.1f, (float)blockpos1.getZ() + 0.5f, 0.0f, 0.0f);
                entityplayermp.setSpawnPoint(blockpos, flag);
            } else {
                entityplayermp.connection.sendPacket(new SPacketChangeGameState(0, 0.0f));
            }
        }
        worldserver.getChunkProvider().provideChunk((int)entityplayermp.posX >> 4, (int)entityplayermp.posZ >> 4);
        while (!worldserver.getCollisionBoxes(entityplayermp, entityplayermp.getEntityBoundingBox()).isEmpty() && entityplayermp.posY < 256.0) {
            entityplayermp.setPosition(entityplayermp.posX, entityplayermp.posY + 1.0, entityplayermp.posZ);
        }
        entityplayermp.connection.sendPacket(new SPacketRespawn(entityplayermp.dimension, entityplayermp.world.getDifficulty(), entityplayermp.world.getWorldInfo().getTerrainType(), entityplayermp.interactionManager.getGameType()));
        BlockPos blockpos2 = worldserver.getSpawnPoint();
        entityplayermp.connection.setPlayerLocation(entityplayermp.posX, entityplayermp.posY, entityplayermp.posZ, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
        entityplayermp.connection.sendPacket(new SPacketSpawnPosition(blockpos2));
        entityplayermp.connection.sendPacket(new SPacketSetExperience(entityplayermp.experience, entityplayermp.experienceTotal, entityplayermp.experienceLevel));
        this.updateTimeAndWeatherForPlayer(entityplayermp, worldserver);
        this.updatePermissionLevel(entityplayermp);
        worldserver.getPlayerChunkMap().addPlayer(entityplayermp);
        worldserver.spawnEntity(entityplayermp);
        this.playerEntityList.add(entityplayermp);
        this.uuidToPlayerMap.put(entityplayermp.getUniqueID(), entityplayermp);
        entityplayermp.addSelfToInternalCraftingInventory();
        entityplayermp.setHealth(entityplayermp.getHealth());
        FMLCommonHandler.instance().firePlayerRespawnEvent(entityplayermp, p_recreatePlayerEntity_3_);
        return entityplayermp;
    }

    public void updatePermissionLevel(EntityPlayerMP p_updatePermissionLevel_1_) {
        GameProfile gameprofile = p_updatePermissionLevel_1_.getGameProfile();
        int i = this.canSendCommands(gameprofile) ? this.ops.getPermissionLevel(gameprofile) : 0;
        i = this.mcServer.isSinglePlayer() && this.mcServer.worlds[0].getWorldInfo().areCommandsAllowed() ? 4 : i;
        i = this.commandsAllowedForAll ? 4 : i;
        this.sendPlayerPermissionLevel(p_updatePermissionLevel_1_, i);
    }

    public void changePlayerDimension(EntityPlayerMP p_changePlayerDimension_1_, int p_changePlayerDimension_2_) {
        this.transferPlayerToDimension(p_changePlayerDimension_1_, p_changePlayerDimension_2_, this.mcServer.worldServerForDimension(p_changePlayerDimension_2_).getDefaultTeleporter());
    }

    public void transferPlayerToDimension(EntityPlayerMP p_transferPlayerToDimension_1_, int p_transferPlayerToDimension_2_, Teleporter p_transferPlayerToDimension_3_) {
        int i = p_transferPlayerToDimension_1_.dimension;
        WorldServer worldserver = this.mcServer.worldServerForDimension(p_transferPlayerToDimension_1_.dimension);
        p_transferPlayerToDimension_1_.dimension = p_transferPlayerToDimension_2_;
        WorldServer worldserver1 = this.mcServer.worldServerForDimension(p_transferPlayerToDimension_1_.dimension);
        p_transferPlayerToDimension_1_.connection.sendPacket(new SPacketRespawn(p_transferPlayerToDimension_1_.dimension, worldserver1.getDifficulty(), worldserver1.getWorldInfo().getTerrainType(), p_transferPlayerToDimension_1_.interactionManager.getGameType()));
        this.updatePermissionLevel(p_transferPlayerToDimension_1_);
        worldserver.removeEntityDangerously(p_transferPlayerToDimension_1_);
        p_transferPlayerToDimension_1_.isDead = false;
        this.transferEntityToWorld(p_transferPlayerToDimension_1_, i, worldserver, worldserver1, p_transferPlayerToDimension_3_);
        this.preparePlayer(p_transferPlayerToDimension_1_, worldserver);
        p_transferPlayerToDimension_1_.connection.setPlayerLocation(p_transferPlayerToDimension_1_.posX, p_transferPlayerToDimension_1_.posY, p_transferPlayerToDimension_1_.posZ, p_transferPlayerToDimension_1_.rotationYaw, p_transferPlayerToDimension_1_.rotationPitch);
        p_transferPlayerToDimension_1_.interactionManager.setWorld(worldserver1);
        p_transferPlayerToDimension_1_.connection.sendPacket(new SPacketPlayerAbilities(p_transferPlayerToDimension_1_.capabilities));
        this.updateTimeAndWeatherForPlayer(p_transferPlayerToDimension_1_, worldserver1);
        this.syncPlayerInventory(p_transferPlayerToDimension_1_);
        for (PotionEffect potioneffect : p_transferPlayerToDimension_1_.getActivePotionEffects()) {
            p_transferPlayerToDimension_1_.connection.sendPacket(new SPacketEntityEffect(p_transferPlayerToDimension_1_.getEntityId(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent(p_transferPlayerToDimension_1_, i, p_transferPlayerToDimension_2_);
    }

    public void transferEntityToWorld(Entity p_transferEntityToWorld_1_, int p_transferEntityToWorld_2_, WorldServer p_transferEntityToWorld_3_, WorldServer p_transferEntityToWorld_4_) {
        this.transferEntityToWorld(p_transferEntityToWorld_1_, p_transferEntityToWorld_2_, p_transferEntityToWorld_3_, p_transferEntityToWorld_4_, p_transferEntityToWorld_4_.getDefaultTeleporter());
    }

    public void transferEntityToWorld(Entity p_transferEntityToWorld_1_, int p_transferEntityToWorld_2_, WorldServer p_transferEntityToWorld_3_, WorldServer p_transferEntityToWorld_4_, Teleporter p_transferEntityToWorld_5_) {
        WorldProvider pOld = p_transferEntityToWorld_3_.provider;
        WorldProvider pNew = p_transferEntityToWorld_4_.provider;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = p_transferEntityToWorld_1_.posX * moveFactor;
        double d1 = p_transferEntityToWorld_1_.posZ * moveFactor;
        double d2 = 8.0;
        float f = p_transferEntityToWorld_1_.rotationYaw;
        p_transferEntityToWorld_3_.theProfiler.startSection("moving");
        if (p_transferEntityToWorld_1_.dimension == 1) {
            BlockPos blockpos = p_transferEntityToWorld_2_ == 1 ? p_transferEntityToWorld_4_.getSpawnPoint() : p_transferEntityToWorld_4_.getSpawnCoordinate();
            d0 = blockpos.getX();
            p_transferEntityToWorld_1_.posY = blockpos.getY();
            d1 = blockpos.getZ();
            p_transferEntityToWorld_1_.setLocationAndAngles(d0, p_transferEntityToWorld_1_.posY, d1, 90.0f, 0.0f);
            if (p_transferEntityToWorld_1_.isEntityAlive()) {
                p_transferEntityToWorld_3_.updateEntityWithOptionalForce(p_transferEntityToWorld_1_, false);
            }
        }
        p_transferEntityToWorld_3_.theProfiler.endSection();
        if (p_transferEntityToWorld_2_ != 1) {
            p_transferEntityToWorld_3_.theProfiler.startSection("placing");
            d0 = MathHelper.clamp((int)d0, -29999872, 29999872);
            d1 = MathHelper.clamp((int)d1, -29999872, 29999872);
            if (p_transferEntityToWorld_1_.isEntityAlive()) {
                p_transferEntityToWorld_1_.setLocationAndAngles(d0, p_transferEntityToWorld_1_.posY, d1, p_transferEntityToWorld_1_.rotationYaw, p_transferEntityToWorld_1_.rotationPitch);
                p_transferEntityToWorld_5_.placeInPortal(p_transferEntityToWorld_1_, f);
                p_transferEntityToWorld_4_.spawnEntity(p_transferEntityToWorld_1_);
                p_transferEntityToWorld_4_.updateEntityWithOptionalForce(p_transferEntityToWorld_1_, false);
            }
            p_transferEntityToWorld_3_.theProfiler.endSection();
        }
        p_transferEntityToWorld_1_.setWorld(p_transferEntityToWorld_4_);
    }

    public void onTick() {
        if (++this.playerPingIndex > 600) {
            this.sendPacketToAllPlayers(new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_LATENCY, this.playerEntityList));
            this.playerPingIndex = 0;
        }
    }

    public void sendPacketToAllPlayers(Packet<?> p_sendPacketToAllPlayers_1_) {
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            this.playerEntityList.get((int)i).connection.sendPacket(p_sendPacketToAllPlayers_1_);
        }
    }

    public void sendPacketToAllPlayersInDimension(Packet<?> p_sendPacketToAllPlayersInDimension_1_, int p_sendPacketToAllPlayersInDimension_2_) {
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            EntityPlayerMP entityplayermp = this.playerEntityList.get(i);
            if (entityplayermp.dimension != p_sendPacketToAllPlayersInDimension_2_) continue;
            entityplayermp.connection.sendPacket(p_sendPacketToAllPlayersInDimension_1_);
        }
    }

    public void sendMessageToAllTeamMembers(EntityPlayer p_sendMessageToAllTeamMembers_1_, ITextComponent p_sendMessageToAllTeamMembers_2_) {
        Team team = p_sendMessageToAllTeamMembers_1_.getTeam();
        if (team != null) {
            for (String s : team.getMembershipCollection()) {
                EntityPlayerMP entityplayermp = this.getPlayerByUsername(s);
                if (entityplayermp == null || entityplayermp == p_sendMessageToAllTeamMembers_1_) continue;
                entityplayermp.sendMessage(p_sendMessageToAllTeamMembers_2_);
            }
        }
    }

    public void sendMessageToTeamOrAllPlayers(EntityPlayer p_sendMessageToTeamOrAllPlayers_1_, ITextComponent p_sendMessageToTeamOrAllPlayers_2_) {
        Team team = p_sendMessageToTeamOrAllPlayers_1_.getTeam();
        if (team == null) {
            this.sendMessage(p_sendMessageToTeamOrAllPlayers_2_);
        } else {
            for (int i = 0; i < this.playerEntityList.size(); ++i) {
                EntityPlayerMP entityplayermp = this.playerEntityList.get(i);
                if (entityplayermp.getTeam() == team) continue;
                entityplayermp.sendMessage(p_sendMessageToTeamOrAllPlayers_2_);
            }
        }
    }

    public String getFormattedListOfPlayers(boolean p_getFormattedListOfPlayers_1_) {
        String s = "";
        ArrayList list = Lists.newArrayList(this.playerEntityList);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + ((EntityPlayerMP)list.get(i)).getName();
            if (!p_getFormattedListOfPlayers_1_) continue;
            s = s + " (" + ((EntityPlayerMP)list.get(i)).getCachedUniqueIdString() + ")";
        }
        return s;
    }

    public String[] getOnlinePlayerNames() {
        String[] astring = new String[this.playerEntityList.size()];
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            astring[i] = this.playerEntityList.get(i).getName();
        }
        return astring;
    }

    public GameProfile[] getOnlinePlayerProfiles() {
        GameProfile[] agameprofile = new GameProfile[this.playerEntityList.size()];
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            agameprofile[i] = this.playerEntityList.get(i).getGameProfile();
        }
        return agameprofile;
    }

    public UserListBans getBannedPlayers() {
        return this.bannedPlayers;
    }

    public UserListIPBans getBannedIPs() {
        return this.bannedIPs;
    }

    public void addOp(GameProfile p_addOp_1_) {
        int i = this.mcServer.getOpPermissionLevel();
        this.ops.addEntry(new UserListOpsEntry(p_addOp_1_, this.mcServer.getOpPermissionLevel(), this.ops.bypassesPlayerLimit(p_addOp_1_)));
        this.sendPlayerPermissionLevel(this.getPlayerByUUID(p_addOp_1_.getId()), i);
    }

    public void removeOp(GameProfile p_removeOp_1_) {
        this.ops.removeEntry(p_removeOp_1_);
        this.sendPlayerPermissionLevel(this.getPlayerByUUID(p_removeOp_1_.getId()), 0);
    }

    private void sendPlayerPermissionLevel(EntityPlayerMP p_sendPlayerPermissionLevel_1_, int p_sendPlayerPermissionLevel_2_) {
        if (p_sendPlayerPermissionLevel_1_ != null && p_sendPlayerPermissionLevel_1_.connection != null) {
            byte b0 = p_sendPlayerPermissionLevel_2_ <= 0 ? (byte)24 : (p_sendPlayerPermissionLevel_2_ >= 4 ? (byte)28 : (byte)((byte)(24 + p_sendPlayerPermissionLevel_2_)));
            p_sendPlayerPermissionLevel_1_.connection.sendPacket(new SPacketEntityStatus(p_sendPlayerPermissionLevel_1_, b0));
        }
    }

    public boolean canJoin(GameProfile p_canJoin_1_) {
        return !this.whiteListEnforced || this.ops.hasEntry(p_canJoin_1_) || this.whiteListedPlayers.hasEntry(p_canJoin_1_);
    }

    public boolean canSendCommands(GameProfile p_canSendCommands_1_) {
        return this.ops.hasEntry(p_canSendCommands_1_) || this.mcServer.isSinglePlayer() && this.mcServer.worlds[0].getWorldInfo().areCommandsAllowed() && this.mcServer.getServerOwner().equalsIgnoreCase(p_canSendCommands_1_.getName()) || this.commandsAllowedForAll;
    }

    @Nullable
    public EntityPlayerMP getPlayerByUsername(String p_getPlayerByUsername_1_) {
        for (EntityPlayerMP entityplayermp : this.playerEntityList) {
            if (!entityplayermp.getName().equalsIgnoreCase(p_getPlayerByUsername_1_)) continue;
            return entityplayermp;
        }
        return null;
    }

    public void sendToAllNearExcept(EntityPlayer p_sendToAllNearExcept_1_, double p_sendToAllNearExcept_2_, double p_sendToAllNearExcept_4_, double p_sendToAllNearExcept_6_, double p_sendToAllNearExcept_8_, int p_sendToAllNearExcept_10_, Packet<?> p_sendToAllNearExcept_11_) {
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            double d2;
            double d1;
            double d0;
            EntityPlayerMP entityplayermp = this.playerEntityList.get(i);
            if (entityplayermp == p_sendToAllNearExcept_1_ || entityplayermp.dimension != p_sendToAllNearExcept_10_ || !((d0 = p_sendToAllNearExcept_2_ - entityplayermp.posX) * d0 + (d1 = p_sendToAllNearExcept_4_ - entityplayermp.posY) * d1 + (d2 = p_sendToAllNearExcept_6_ - entityplayermp.posZ) * d2 < p_sendToAllNearExcept_8_ * p_sendToAllNearExcept_8_)) continue;
            entityplayermp.connection.sendPacket(p_sendToAllNearExcept_11_);
        }
    }

    public void saveAllPlayerData() {
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            this.writePlayerData(this.playerEntityList.get(i));
        }
    }

    public void addWhitelistedPlayer(GameProfile p_addWhitelistedPlayer_1_) {
        this.whiteListedPlayers.addEntry(new UserListWhitelistEntry(p_addWhitelistedPlayer_1_));
    }

    public void removePlayerFromWhitelist(GameProfile p_removePlayerFromWhitelist_1_) {
        this.whiteListedPlayers.removeEntry(p_removePlayerFromWhitelist_1_);
    }

    public UserListWhitelist getWhitelistedPlayers() {
        return this.whiteListedPlayers;
    }

    public String[] getWhitelistedPlayerNames() {
        return this.whiteListedPlayers.getKeys();
    }

    public UserListOps getOppedPlayers() {
        return this.ops;
    }

    public String[] getOppedPlayerNames() {
        return this.ops.getKeys();
    }

    public void reloadWhitelist() {
    }

    public void updateTimeAndWeatherForPlayer(EntityPlayerMP p_updateTimeAndWeatherForPlayer_1_, WorldServer p_updateTimeAndWeatherForPlayer_2_) {
        WorldBorder worldborder = this.mcServer.worlds[0].getWorldBorder();
        p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketWorldBorder(worldborder, SPacketWorldBorder.Action.INITIALIZE));
        p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketTimeUpdate(p_updateTimeAndWeatherForPlayer_2_.getTotalWorldTime(), p_updateTimeAndWeatherForPlayer_2_.getWorldTime(), p_updateTimeAndWeatherForPlayer_2_.getGameRules().getBoolean("doDaylightCycle")));
        BlockPos blockpos = p_updateTimeAndWeatherForPlayer_2_.getSpawnPoint();
        p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketSpawnPosition(blockpos));
        if (p_updateTimeAndWeatherForPlayer_2_.isRaining()) {
            p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketChangeGameState(1, 0.0f));
            p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketChangeGameState(7, p_updateTimeAndWeatherForPlayer_2_.getRainStrength(1.0f)));
            p_updateTimeAndWeatherForPlayer_1_.connection.sendPacket(new SPacketChangeGameState(8, p_updateTimeAndWeatherForPlayer_2_.getThunderStrength(1.0f)));
        }
    }

    public void syncPlayerInventory(EntityPlayerMP p_syncPlayerInventory_1_) {
        p_syncPlayerInventory_1_.sendContainerToPlayer(p_syncPlayerInventory_1_.inventoryContainer);
        p_syncPlayerInventory_1_.setPlayerHealthUpdated();
        p_syncPlayerInventory_1_.connection.sendPacket(new SPacketHeldItemChange(p_syncPlayerInventory_1_.inventory.currentItem));
    }

    public int getCurrentPlayerCount() {
        return this.playerEntityList.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String[] getAvailablePlayerDat() {
        return this.mcServer.worlds[0].getSaveHandler().getPlayerNBTManager().getAvailablePlayerDat();
    }

    public void setWhiteListEnabled(boolean p_setWhiteListEnabled_1_) {
        this.whiteListEnforced = p_setWhiteListEnabled_1_;
    }

    public List<EntityPlayerMP> getPlayersMatchingAddress(String p_getPlayersMatchingAddress_1_) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayerMP entityplayermp : this.playerEntityList) {
            if (!entityplayermp.getPlayerIP().equals(p_getPlayersMatchingAddress_1_)) continue;
            list.add(entityplayermp);
        }
        return list;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public MinecraftServer getServerInstance() {
        return this.mcServer;
    }

    public NBTTagCompound getHostPlayerData() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGameType(GameType p_setGameType_1_) {
        this.gameType = p_setGameType_1_;
    }

    private void setPlayerGameTypeBasedOnOther(EntityPlayerMP p_setPlayerGameTypeBasedOnOther_1_, EntityPlayerMP p_setPlayerGameTypeBasedOnOther_2_, World p_setPlayerGameTypeBasedOnOther_3_) {
        if (p_setPlayerGameTypeBasedOnOther_2_ != null) {
            p_setPlayerGameTypeBasedOnOther_1_.interactionManager.setGameType(p_setPlayerGameTypeBasedOnOther_2_.interactionManager.getGameType());
        } else if (this.gameType != null) {
            p_setPlayerGameTypeBasedOnOther_1_.interactionManager.setGameType(this.gameType);
        }
        p_setPlayerGameTypeBasedOnOther_1_.interactionManager.initializeGameType(p_setPlayerGameTypeBasedOnOther_3_.getWorldInfo().getGameType());
    }

    @SideOnly(value=Side.CLIENT)
    public void setCommandsAllowedForAll(boolean p_setCommandsAllowedForAll_1_) {
        this.commandsAllowedForAll = p_setCommandsAllowedForAll_1_;
    }

    public void removeAllPlayers() {
        for (int i = 0; i < this.playerEntityList.size(); ++i) {
            this.playerEntityList.get((int)i).connection.disconnect("Server closed");
        }
    }

    public void sendMessage(ITextComponent p_sendMessage_1_, boolean p_sendMessage_2_) {
        this.mcServer.sendMessage(p_sendMessage_1_);
        byte b0 = (byte)(p_sendMessage_2_ ? 1 : 0);
        this.sendPacketToAllPlayers(new SPacketChat(p_sendMessage_1_, b0));
    }

    public void sendMessage(ITextComponent p_sendMessage_1_) {
        this.sendMessage(p_sendMessage_1_, true);
    }

    public StatisticsManagerServer getPlayerStatsFile(EntityPlayer p_getPlayerStatsFile_1_) {
        StatisticsManagerServer statisticsmanagerserver;
        UUID uuid = p_getPlayerStatsFile_1_.getUniqueID();
        StatisticsManagerServer statisticsManagerServer = statisticsmanagerserver = uuid == null ? null : this.playerStatFiles.get(uuid);
        if (statisticsmanagerserver == null) {
            File file3;
            File file1 = new File(this.mcServer.worldServerForDimension(0).getSaveHandler().getWorldDirectory(), "stats");
            File file2 = new File(file1, uuid + ".json");
            if (!file2.exists() && (file3 = new File(file1, p_getPlayerStatsFile_1_.getName() + ".json")).exists() && file3.isFile()) {
                file3.renameTo(file2);
            }
            statisticsmanagerserver = new StatisticsManagerServer(this.mcServer, file2);
            statisticsmanagerserver.readStatFile();
            this.playerStatFiles.put(uuid, statisticsmanagerserver);
        }
        return statisticsmanagerserver;
    }

    public void setViewDistance(int p_setViewDistance_1_) {
        this.viewDistance = p_setViewDistance_1_;
        if (this.mcServer.worlds != null) {
            for (WorldServer worldserver : this.mcServer.worlds) {
                if (worldserver == null) continue;
                worldserver.getPlayerChunkMap().setPlayerViewRadius(p_setViewDistance_1_);
                worldserver.getEntityTracker().setViewDistance(p_setViewDistance_1_);
            }
        }
    }

    public List<EntityPlayerMP> getPlayers() {
        return this.playerEntityList;
    }

    public EntityPlayerMP getPlayerByUUID(UUID p_getPlayerByUUID_1_) {
        return this.uuidToPlayerMap.get(p_getPlayerByUUID_1_);
    }

    public boolean bypassesPlayerLimit(GameProfile p_bypassesPlayerLimit_1_) {
        return false;
    }

    @SideOnly(value=Side.SERVER)
    public boolean isWhiteListEnabled() {
        return this.whiteListEnforced;
    }
}

