/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.IOUtils;

public class PlayerProfileCache {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static boolean onlineMode;
    private final Map<String, ProfileEntry> usernameToProfileEntryMap = Maps.newHashMap();
    private final Map<UUID, ProfileEntry> uuidToProfileEntryMap = Maps.newHashMap();
    private final Deque<GameProfile> gameProfiles = Lists.newLinkedList();
    private final GameProfileRepository profileRepo;
    protected final Gson gson;
    private final File usercacheFile;
    private static final ParameterizedType TYPE;

    public PlayerProfileCache(GameProfileRepository p_i46836_1_, File p_i46836_2_) {
        this.profileRepo = p_i46836_1_;
        this.usercacheFile = p_i46836_2_;
        GsonBuilder lvt_3_1_ = new GsonBuilder();
        lvt_3_1_.registerTypeHierarchyAdapter(ProfileEntry.class, (Object)new Serializer());
        this.gson = lvt_3_1_.create();
        this.load();
    }

    private static GameProfile lookupProfile(GameProfileRepository p_lookupProfile_0_, String p_lookupProfile_1_) {
        final GameProfile[] lvt_2_1_ = new GameProfile[1];
        ProfileLookupCallback lvt_3_1_ = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                lvt_2_1_[0] = p_onProfileLookupSucceeded_1_;
            }

            public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                lvt_2_1_[0] = null;
            }
        };
        p_lookupProfile_0_.findProfilesByNames(new String[]{p_lookupProfile_1_}, Agent.MINECRAFT, lvt_3_1_);
        if (!PlayerProfileCache.isOnlineMode() && lvt_2_1_[0] == null) {
            UUID lvt_4_1_ = EntityPlayer.getUUID(new GameProfile(null, p_lookupProfile_1_));
            GameProfile lvt_5_1_ = new GameProfile(lvt_4_1_, p_lookupProfile_1_);
            lvt_3_1_.onProfileLookupSucceeded(lvt_5_1_);
        }
        return lvt_2_1_[0];
    }

    public static void setOnlineMode(boolean p_setOnlineMode_0_) {
        onlineMode = p_setOnlineMode_0_;
    }

    private static boolean isOnlineMode() {
        return onlineMode;
    }

    public void addEntry(GameProfile p_addEntry_1_) {
        this.addEntry(p_addEntry_1_, null);
    }

    private void addEntry(GameProfile p_addEntry_1_, Date p_addEntry_2_) {
        UUID lvt_3_1_ = p_addEntry_1_.getId();
        if (p_addEntry_2_ == null) {
            Calendar lvt_4_1_ = Calendar.getInstance();
            lvt_4_1_.setTime(new Date());
            lvt_4_1_.add(2, 1);
            p_addEntry_2_ = lvt_4_1_.getTime();
        }
        String lvt_4_2_ = p_addEntry_1_.getName().toLowerCase(Locale.ROOT);
        ProfileEntry lvt_5_1_ = new ProfileEntry(p_addEntry_1_, p_addEntry_2_);
        if (this.uuidToProfileEntryMap.containsKey(lvt_3_1_)) {
            ProfileEntry lvt_6_1_ = this.uuidToProfileEntryMap.get(lvt_3_1_);
            this.usernameToProfileEntryMap.remove(lvt_6_1_.getGameProfile().getName().toLowerCase(Locale.ROOT));
            this.gameProfiles.remove(p_addEntry_1_);
        }
        this.usernameToProfileEntryMap.put(p_addEntry_1_.getName().toLowerCase(Locale.ROOT), lvt_5_1_);
        this.uuidToProfileEntryMap.put(lvt_3_1_, lvt_5_1_);
        this.gameProfiles.addFirst(p_addEntry_1_);
        this.save();
    }

    @Nullable
    public GameProfile getGameProfileForUsername(String p_getGameProfileForUsername_1_) {
        String lvt_2_1_ = p_getGameProfileForUsername_1_.toLowerCase(Locale.ROOT);
        ProfileEntry lvt_3_1_ = this.usernameToProfileEntryMap.get(lvt_2_1_);
        if (lvt_3_1_ != null && new Date().getTime() >= lvt_3_1_.expirationDate.getTime()) {
            this.uuidToProfileEntryMap.remove(lvt_3_1_.getGameProfile().getId());
            this.usernameToProfileEntryMap.remove(lvt_3_1_.getGameProfile().getName().toLowerCase(Locale.ROOT));
            this.gameProfiles.remove(lvt_3_1_.getGameProfile());
            lvt_3_1_ = null;
        }
        if (lvt_3_1_ != null) {
            GameProfile lvt_4_1_ = lvt_3_1_.getGameProfile();
            this.gameProfiles.remove(lvt_4_1_);
            this.gameProfiles.addFirst(lvt_4_1_);
        } else {
            GameProfile lvt_4_2_ = PlayerProfileCache.lookupProfile(this.profileRepo, lvt_2_1_);
            if (lvt_4_2_ != null) {
                this.addEntry(lvt_4_2_);
                lvt_3_1_ = this.usernameToProfileEntryMap.get(lvt_2_1_);
            }
        }
        this.save();
        return lvt_3_1_ == null ? null : lvt_3_1_.getGameProfile();
    }

    public String[] getUsernames() {
        ArrayList lvt_1_1_ = Lists.newArrayList(this.usernameToProfileEntryMap.keySet());
        return lvt_1_1_.toArray(new String[lvt_1_1_.size()]);
    }

    @Nullable
    public GameProfile getProfileByUUID(UUID p_getProfileByUUID_1_) {
        ProfileEntry lvt_2_1_ = this.uuidToProfileEntryMap.get(p_getProfileByUUID_1_);
        return lvt_2_1_ == null ? null : lvt_2_1_.getGameProfile();
    }

    private ProfileEntry getByUUID(UUID p_getByUUID_1_) {
        ProfileEntry lvt_2_1_ = this.uuidToProfileEntryMap.get(p_getByUUID_1_);
        if (lvt_2_1_ != null) {
            GameProfile lvt_3_1_ = lvt_2_1_.getGameProfile();
            this.gameProfiles.remove(lvt_3_1_);
            this.gameProfiles.addFirst(lvt_3_1_);
        }
        return lvt_2_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        BufferedReader lvt_1_1_;
        block5: {
            lvt_1_1_ = null;
            try {
                lvt_1_1_ = Files.newReader((File)this.usercacheFile, (Charset)Charsets.UTF_8);
                List lvt_2_1_ = (List)this.gson.fromJson((Reader)lvt_1_1_, (Type)TYPE);
                this.usernameToProfileEntryMap.clear();
                this.uuidToProfileEntryMap.clear();
                this.gameProfiles.clear();
                if (lvt_2_1_ == null) break block5;
                for (ProfileEntry lvt_4_1_ : Lists.reverse((List)lvt_2_1_)) {
                    if (lvt_4_1_ == null) continue;
                    this.addEntry(lvt_4_1_.getGameProfile(), lvt_4_1_.getExpirationDate());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtils.closeQuietly(lvt_1_1_);
            }
            catch (JsonParseException jsonParseException) {
                IOUtils.closeQuietly(lvt_1_1_);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_1_1_);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)lvt_1_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        String lvt_1_1_ = this.gson.toJson(this.getEntriesWithLimit(1000));
        BufferedWriter lvt_2_1_ = null;
        try {
            lvt_2_1_ = Files.newWriter((File)this.usercacheFile, (Charset)Charsets.UTF_8);
            lvt_2_1_.write(lvt_1_1_);
        }
        catch (FileNotFoundException lvt_3_1_) {
            IOUtils.closeQuietly(lvt_2_1_);
            return;
        }
        catch (IOException lvt_3_2_) {
            IOUtils.closeQuietly(lvt_2_1_);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lvt_2_1_);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lvt_2_1_);
    }

    private List<ProfileEntry> getEntriesWithLimit(int p_getEntriesWithLimit_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        ArrayList lvt_3_1_ = Lists.newArrayList((Iterator)Iterators.limit(this.gameProfiles.iterator(), (int)p_getEntriesWithLimit_1_));
        for (GameProfile lvt_5_1_ : lvt_3_1_) {
            ProfileEntry lvt_6_1_ = this.getByUUID(lvt_5_1_.getId());
            if (lvt_6_1_ == null) continue;
            lvt_2_1_.add(lvt_6_1_);
        }
        return lvt_2_1_;
    }

    static {
        TYPE = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{ProfileEntry.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    class ProfileEntry {
        private final GameProfile gameProfile;
        private final Date expirationDate;

        private ProfileEntry(GameProfile p_i46333_2_, Date p_i46333_3_) {
            this.gameProfile = p_i46333_2_;
            this.expirationDate = p_i46333_3_;
        }

        public GameProfile getGameProfile() {
            return this.gameProfile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }
    }

    class Serializer
    implements JsonDeserializer<ProfileEntry>,
    JsonSerializer<ProfileEntry> {
        private Serializer() {
        }

        public JsonElement serialize(ProfileEntry p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject lvt_4_1_ = new JsonObject();
            lvt_4_1_.addProperty("name", p_serialize_1_.getGameProfile().getName());
            UUID lvt_5_1_ = p_serialize_1_.getGameProfile().getId();
            lvt_4_1_.addProperty("uuid", lvt_5_1_ == null ? "" : lvt_5_1_.toString());
            lvt_4_1_.addProperty("expiresOn", DATE_FORMAT.format(p_serialize_1_.getExpirationDate()));
            return lvt_4_1_;
        }

        /*
         * WARNING - void declaration
         */
        public ProfileEntry deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            if (p_deserialize_1_.isJsonObject()) {
                void lvt_11_3_;
                JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
                JsonElement lvt_5_1_ = lvt_4_1_.get("name");
                JsonElement lvt_6_1_ = lvt_4_1_.get("uuid");
                JsonElement lvt_7_1_ = lvt_4_1_.get("expiresOn");
                if (lvt_5_1_ == null || lvt_6_1_ == null) {
                    return null;
                }
                String lvt_8_1_ = lvt_6_1_.getAsString();
                String lvt_9_1_ = lvt_5_1_.getAsString();
                Date lvt_10_1_ = null;
                if (lvt_7_1_ != null) {
                    try {
                        lvt_10_1_ = DATE_FORMAT.parse(lvt_7_1_.getAsString());
                    }
                    catch (ParseException lvt_11_1_) {
                        lvt_10_1_ = null;
                    }
                }
                if (lvt_9_1_ == null || lvt_8_1_ == null) {
                    return null;
                }
                try {
                    UUID lvt_11_2_ = UUID.fromString(lvt_8_1_);
                }
                catch (Throwable lvt_12_1_) {
                    return null;
                }
                return new ProfileEntry(new GameProfile((UUID)lvt_11_3_, lvt_9_1_), lvt_10_1_);
            }
            return null;
        }

        public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return this.serialize((ProfileEntry)p_serialize_1_, p_serialize_2_, p_serialize_3_);
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

