/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntryBan;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.server.management.UserListWhitelistEntry;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreYggdrasilConverter {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File OLD_IPBAN_FILE = new File("banned-ips.txt");
    public static final File OLD_PLAYERBAN_FILE = new File("banned-players.txt");
    public static final File OLD_OPS_FILE = new File("ops.txt");
    public static final File OLD_WHITELIST_FILE = new File("white-list.txt");

    private static void lookupNames(MinecraftServer p_lookupNames_0_, Collection<String> p_lookupNames_1_, ProfileLookupCallback p_lookupNames_2_) {
        String[] lvt_3_1_ = (String[])Iterators.toArray((Iterator)Iterators.filter(p_lookupNames_1_.iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String p_apply_1_) {
                return !StringUtils.isNullOrEmpty(p_apply_1_);
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((String)p_apply_1_);
            }
        }), String.class);
        if (p_lookupNames_0_.isServerInOnlineMode()) {
            p_lookupNames_0_.getGameProfileRepository().findProfilesByNames(lvt_3_1_, Agent.MINECRAFT, p_lookupNames_2_);
        } else {
            for (String lvt_7_1_ : lvt_3_1_) {
                UUID lvt_8_1_ = EntityPlayer.getUUID(new GameProfile(null, lvt_7_1_));
                GameProfile lvt_9_1_ = new GameProfile(lvt_8_1_, lvt_7_1_);
                p_lookupNames_2_.onProfileLookupSucceeded(lvt_9_1_);
            }
        }
    }

    public static String convertMobOwnerIfNeeded(final MinecraftServer p_convertMobOwnerIfNeeded_0_, String p_convertMobOwnerIfNeeded_1_) {
        if (StringUtils.isNullOrEmpty(p_convertMobOwnerIfNeeded_1_) || p_convertMobOwnerIfNeeded_1_.length() > 16) {
            return p_convertMobOwnerIfNeeded_1_;
        }
        GameProfile lvt_2_1_ = p_convertMobOwnerIfNeeded_0_.getPlayerProfileCache().getGameProfileForUsername(p_convertMobOwnerIfNeeded_1_);
        if (lvt_2_1_ != null && lvt_2_1_.getId() != null) {
            return lvt_2_1_.getId().toString();
        }
        if (p_convertMobOwnerIfNeeded_0_.isSinglePlayer() || !p_convertMobOwnerIfNeeded_0_.isServerInOnlineMode()) {
            return EntityPlayer.getUUID(new GameProfile(null, p_convertMobOwnerIfNeeded_1_)).toString();
        }
        final ArrayList lvt_3_1_ = Lists.newArrayList();
        ProfileLookupCallback lvt_4_1_ = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                p_convertMobOwnerIfNeeded_0_.getPlayerProfileCache().addEntry(p_onProfileLookupSucceeded_1_);
                lvt_3_1_.add(p_onProfileLookupSucceeded_1_);
            }

            public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                LOGGER.warn("Could not lookup user whitelist entry for {}", new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_});
            }
        };
        PreYggdrasilConverter.lookupNames(p_convertMobOwnerIfNeeded_0_, Lists.newArrayList((Object[])new String[]{p_convertMobOwnerIfNeeded_1_}), lvt_4_1_);
        if (!lvt_3_1_.isEmpty() && ((GameProfile)lvt_3_1_.get(0)).getId() != null) {
            return ((GameProfile)lvt_3_1_.get(0)).getId().toString();
        }
        return "";
    }

    @SideOnly(value=Side.SERVER)
    static List<String> readFile(File p_readFile_0_, Map<String, String[]> p_readFile_1_) throws IOException {
        List lvt_2_1_ = Files.readLines((File)p_readFile_0_, (Charset)Charsets.UTF_8);
        for (String lvt_4_1_ : lvt_2_1_) {
            if ((lvt_4_1_ = lvt_4_1_.trim()).startsWith("#") || lvt_4_1_.length() < 1) continue;
            String[] lvt_5_1_ = lvt_4_1_.split("\\|");
            p_readFile_1_.put(lvt_5_1_[0].toLowerCase(Locale.ROOT), lvt_5_1_);
        }
        return lvt_2_1_;
    }

    @SideOnly(value=Side.SERVER)
    public static boolean convertUserBanlist(final MinecraftServer p_convertUserBanlist_0_) throws IOException {
        final UserListBans lvt_1_1_ = new UserListBans(PlayerList.FILE_PLAYERBANS);
        if (OLD_PLAYERBAN_FILE.exists() && OLD_PLAYERBAN_FILE.isFile()) {
            if (lvt_1_1_.getSaveFile().exists()) {
                try {
                    lvt_1_1_.readSavedFile();
                }
                catch (FileNotFoundException lvt_2_1_) {
                    LOGGER.warn("Could not load existing file {}", new Object[]{lvt_1_1_.getSaveFile().getName(), lvt_2_1_});
                }
            }
            try {
                final HashMap lvt_2_2_ = Maps.newHashMap();
                PreYggdrasilConverter.readFile(OLD_PLAYERBAN_FILE, lvt_2_2_);
                ProfileLookupCallback lvt_3_1_ = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_convertUserBanlist_0_.getPlayerProfileCache().addEntry(p_onProfileLookupSucceeded_1_);
                        String[] lvt_2_1_ = (String[])lvt_2_2_.get(p_onProfileLookupSucceeded_1_.getName().toLowerCase(Locale.ROOT));
                        if (lvt_2_1_ == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", new Object[]{p_onProfileLookupSucceeded_1_.getName()});
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date lvt_3_1_ = lvt_2_1_.length > 1 ? PreYggdrasilConverter.parseDate(lvt_2_1_[1], null) : null;
                        String lvt_4_1_ = lvt_2_1_.length > 2 ? lvt_2_1_[2] : null;
                        Date lvt_5_1_ = lvt_2_1_.length > 3 ? PreYggdrasilConverter.parseDate(lvt_2_1_[3], null) : null;
                        String lvt_6_1_ = lvt_2_1_.length > 4 ? lvt_2_1_[4] : null;
                        lvt_1_1_.addEntry(new UserListBansEntry(p_onProfileLookupSucceeded_1_, lvt_3_1_, lvt_4_1_, lvt_5_1_, lvt_6_1_));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_});
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.lookupNames(p_convertUserBanlist_0_, lvt_2_2_.keySet(), lvt_3_1_);
                lvt_1_1_.writeChanges();
                PreYggdrasilConverter.backupConverted(OLD_PLAYERBAN_FILE);
            }
            catch (IOException lvt_2_3_) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)lvt_2_3_);
                return false;
            }
            catch (ConversionError lvt_2_4_) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)lvt_2_4_);
                return false;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    public static boolean convertIpBanlist(MinecraftServer p_convertIpBanlist_0_) throws IOException {
        UserListIPBans lvt_1_1_ = new UserListIPBans(PlayerList.FILE_IPBANS);
        if (OLD_IPBAN_FILE.exists() && OLD_IPBAN_FILE.isFile()) {
            if (lvt_1_1_.getSaveFile().exists()) {
                try {
                    lvt_1_1_.readSavedFile();
                }
                catch (FileNotFoundException lvt_2_1_) {
                    LOGGER.warn("Could not load existing file {}", new Object[]{lvt_1_1_.getSaveFile().getName(), lvt_2_1_});
                }
            }
            try {
                HashMap lvt_2_2_ = Maps.newHashMap();
                PreYggdrasilConverter.readFile(OLD_IPBAN_FILE, lvt_2_2_);
                for (String lvt_4_1_ : lvt_2_2_.keySet()) {
                    String[] lvt_5_1_ = (String[])lvt_2_2_.get(lvt_4_1_);
                    Date lvt_6_1_ = lvt_5_1_.length > 1 ? PreYggdrasilConverter.parseDate(lvt_5_1_[1], null) : null;
                    String lvt_7_1_ = lvt_5_1_.length > 2 ? lvt_5_1_[2] : null;
                    Date lvt_8_1_ = lvt_5_1_.length > 3 ? PreYggdrasilConverter.parseDate(lvt_5_1_[3], null) : null;
                    String lvt_9_1_ = lvt_5_1_.length > 4 ? lvt_5_1_[4] : null;
                    lvt_1_1_.addEntry(new UserListIPBansEntry(lvt_4_1_, lvt_6_1_, lvt_7_1_, lvt_8_1_, lvt_9_1_));
                }
                lvt_1_1_.writeChanges();
                PreYggdrasilConverter.backupConverted(OLD_IPBAN_FILE);
            }
            catch (IOException lvt_2_3_) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)lvt_2_3_);
                return false;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    public static boolean convertOplist(final MinecraftServer p_convertOplist_0_) throws IOException {
        final UserListOps lvt_1_1_ = new UserListOps(PlayerList.FILE_OPS);
        if (OLD_OPS_FILE.exists() && OLD_OPS_FILE.isFile()) {
            if (lvt_1_1_.getSaveFile().exists()) {
                try {
                    lvt_1_1_.readSavedFile();
                }
                catch (FileNotFoundException lvt_2_1_) {
                    LOGGER.warn("Could not load existing file {}", new Object[]{lvt_1_1_.getSaveFile().getName(), lvt_2_1_});
                }
            }
            try {
                List lvt_2_2_ = Files.readLines((File)OLD_OPS_FILE, (Charset)Charsets.UTF_8);
                ProfileLookupCallback lvt_3_1_ = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_convertOplist_0_.getPlayerProfileCache().addEntry(p_onProfileLookupSucceeded_1_);
                        lvt_1_1_.addEntry(new UserListOpsEntry(p_onProfileLookupSucceeded_1_, p_convertOplist_0_.getOpPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        LOGGER.warn("Could not lookup oplist entry for {}", new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_});
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.lookupNames(p_convertOplist_0_, lvt_2_2_, lvt_3_1_);
                lvt_1_1_.writeChanges();
                PreYggdrasilConverter.backupConverted(OLD_OPS_FILE);
            }
            catch (IOException lvt_2_3_) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)lvt_2_3_);
                return false;
            }
            catch (ConversionError lvt_2_4_) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)lvt_2_4_);
                return false;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    public static boolean convertWhitelist(final MinecraftServer p_convertWhitelist_0_) throws IOException {
        final UserListWhitelist lvt_1_1_ = new UserListWhitelist(PlayerList.FILE_WHITELIST);
        if (OLD_WHITELIST_FILE.exists() && OLD_WHITELIST_FILE.isFile()) {
            if (lvt_1_1_.getSaveFile().exists()) {
                try {
                    lvt_1_1_.readSavedFile();
                }
                catch (FileNotFoundException lvt_2_1_) {
                    LOGGER.warn("Could not load existing file {}", new Object[]{lvt_1_1_.getSaveFile().getName(), lvt_2_1_});
                }
            }
            try {
                List lvt_2_2_ = Files.readLines((File)OLD_WHITELIST_FILE, (Charset)Charsets.UTF_8);
                ProfileLookupCallback lvt_3_1_ = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_convertWhitelist_0_.getPlayerProfileCache().addEntry(p_onProfileLookupSucceeded_1_);
                        lvt_1_1_.addEntry(new UserListWhitelistEntry(p_onProfileLookupSucceeded_1_));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_});
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.lookupNames(p_convertWhitelist_0_, lvt_2_2_, lvt_3_1_);
                lvt_1_1_.writeChanges();
                PreYggdrasilConverter.backupConverted(OLD_WHITELIST_FILE);
            }
            catch (IOException lvt_2_3_) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)lvt_2_3_);
                return false;
            }
            catch (ConversionError lvt_2_4_) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)lvt_2_4_);
                return false;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    public static boolean convertSaveFiles(final DedicatedServer p_convertSaveFiles_0_, PropertyManager p_convertSaveFiles_1_) {
        final File lvt_2_1_ = PreYggdrasilConverter.getPlayersDirectory(p_convertSaveFiles_1_);
        final File lvt_3_1_ = new File(lvt_2_1_.getParentFile(), "playerdata");
        final File lvt_4_1_ = new File(lvt_2_1_.getParentFile(), "unknownplayers");
        if (!lvt_2_1_.exists() || !lvt_2_1_.isDirectory()) {
            return true;
        }
        File[] lvt_5_1_ = lvt_2_1_.listFiles();
        ArrayList lvt_6_1_ = Lists.newArrayList();
        for (File lvt_10_1_ : lvt_5_1_) {
            String lvt_12_1_;
            String lvt_11_1_ = lvt_10_1_.getName();
            if (!lvt_11_1_.toLowerCase(Locale.ROOT).endsWith(".dat") || (lvt_12_1_ = lvt_11_1_.substring(0, lvt_11_1_.length() - ".dat".length())).isEmpty()) continue;
            lvt_6_1_.add(lvt_12_1_);
        }
        try {
            Object[] lvt_7_1_ = lvt_6_1_.toArray(new String[lvt_6_1_.size()]);
            ProfileLookupCallback lvt_8_1_ = new ProfileLookupCallback((String[])lvt_7_1_){
                final /* synthetic */ String[] field_152749_e;
                {
                    this.field_152749_e = p_i1212_5_;
                }

                public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                    p_convertSaveFiles_0_.getPlayerProfileCache().addEntry(p_onProfileLookupSucceeded_1_);
                    UUID lvt_2_1_2 = p_onProfileLookupSucceeded_1_.getId();
                    if (lvt_2_1_2 == null) {
                        throw new ConversionError("Missing UUID for user profile " + p_onProfileLookupSucceeded_1_.getName());
                    }
                    this.renamePlayerFile(lvt_3_1_, this.getFileNameForProfile(p_onProfileLookupSucceeded_1_), lvt_2_1_2.toString());
                }

                public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                    LOGGER.warn("Could not lookup user uuid for {}", new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_});
                    if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                        throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                    }
                    String lvt_3_1_2 = this.getFileNameForProfile(p_onProfileLookupFailed_1_);
                    this.renamePlayerFile(lvt_4_1_, lvt_3_1_2, lvt_3_1_2);
                }

                private void renamePlayerFile(File p_renamePlayerFile_1_, String p_renamePlayerFile_2_, String p_renamePlayerFile_3_) {
                    File lvt_4_1_2 = new File(lvt_2_1_, p_renamePlayerFile_2_ + ".dat");
                    File lvt_5_1_ = new File(p_renamePlayerFile_1_, p_renamePlayerFile_3_ + ".dat");
                    PreYggdrasilConverter.mkdir(p_renamePlayerFile_1_);
                    if (!lvt_4_1_2.renameTo(lvt_5_1_)) {
                        throw new ConversionError("Could not convert file for " + p_renamePlayerFile_2_);
                    }
                }

                private String getFileNameForProfile(GameProfile p_getFileNameForProfile_1_) {
                    String lvt_2_1_2 = null;
                    for (String lvt_6_1_ : this.field_152749_e) {
                        if (lvt_6_1_ == null || !lvt_6_1_.equalsIgnoreCase(p_getFileNameForProfile_1_.getName())) continue;
                        lvt_2_1_2 = lvt_6_1_;
                        break;
                    }
                    if (lvt_2_1_2 == null) {
                        throw new ConversionError("Could not find the filename for " + p_getFileNameForProfile_1_.getName() + " anymore");
                    }
                    return lvt_2_1_2;
                }
            };
            PreYggdrasilConverter.lookupNames(p_convertSaveFiles_0_, Lists.newArrayList((Object[])lvt_7_1_), lvt_8_1_);
        }
        catch (ConversionError lvt_7_2_) {
            LOGGER.error("Conversion failed, please try again later", (Throwable)lvt_7_2_);
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    private static void mkdir(File p_mkdir_0_) {
        if (p_mkdir_0_.exists()) {
            if (p_mkdir_0_.isDirectory()) {
                return;
            }
            throw new ConversionError("Can't create directory " + p_mkdir_0_.getName() + " in world save directory.");
        }
        if (!p_mkdir_0_.mkdirs()) {
            throw new ConversionError("Can't create directory " + p_mkdir_0_.getName() + " in world save directory.");
        }
    }

    @SideOnly(value=Side.SERVER)
    public static boolean tryConvert(PropertyManager p_tryConvert_0_) {
        boolean lvt_1_1_ = PreYggdrasilConverter.hasUnconvertableFiles(p_tryConvert_0_);
        lvt_1_1_ = lvt_1_1_ && PreYggdrasilConverter.hasUnconvertablePlayerFiles(p_tryConvert_0_);
        return lvt_1_1_;
    }

    @SideOnly(value=Side.SERVER)
    private static boolean hasUnconvertableFiles(PropertyManager p_hasUnconvertableFiles_0_) {
        boolean lvt_1_1_ = false;
        if (OLD_PLAYERBAN_FILE.exists() && OLD_PLAYERBAN_FILE.isFile()) {
            lvt_1_1_ = true;
        }
        boolean lvt_2_1_ = false;
        if (OLD_IPBAN_FILE.exists() && OLD_IPBAN_FILE.isFile()) {
            lvt_2_1_ = true;
        }
        boolean lvt_3_1_ = false;
        if (OLD_OPS_FILE.exists() && OLD_OPS_FILE.isFile()) {
            lvt_3_1_ = true;
        }
        boolean lvt_4_1_ = false;
        if (OLD_WHITELIST_FILE.exists() && OLD_WHITELIST_FILE.isFile()) {
            lvt_4_1_ = true;
        }
        if (lvt_1_1_ || lvt_2_1_ || lvt_3_1_ || lvt_4_1_) {
            LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
            LOGGER.warn("** please remove the following files and restart the server:");
            if (lvt_1_1_) {
                LOGGER.warn("* {}", new Object[]{OLD_PLAYERBAN_FILE.getName()});
            }
            if (lvt_2_1_) {
                LOGGER.warn("* {}", new Object[]{OLD_IPBAN_FILE.getName()});
            }
            if (lvt_3_1_) {
                LOGGER.warn("* {}", new Object[]{OLD_OPS_FILE.getName()});
            }
            if (lvt_4_1_) {
                LOGGER.warn("* {}", new Object[]{OLD_WHITELIST_FILE.getName()});
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    private static boolean hasUnconvertablePlayerFiles(PropertyManager p_hasUnconvertablePlayerFiles_0_) {
        File lvt_1_1_ = PreYggdrasilConverter.getPlayersDirectory(p_hasUnconvertablePlayerFiles_0_);
        if (lvt_1_1_.exists() && lvt_1_1_.isDirectory() && (lvt_1_1_.list().length > 0 || !lvt_1_1_.delete())) {
            LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", new Object[]{lvt_1_1_.getPath()});
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.SERVER)
    private static File getPlayersDirectory(PropertyManager p_getPlayersDirectory_0_) {
        String lvt_1_1_ = p_getPlayersDirectory_0_.getStringProperty("level-name", "world");
        File lvt_2_1_ = new File(lvt_1_1_);
        return new File(lvt_2_1_, "players");
    }

    @SideOnly(value=Side.SERVER)
    private static void backupConverted(File p_backupConverted_0_) {
        File lvt_1_1_ = new File(p_backupConverted_0_.getName() + ".converted");
        p_backupConverted_0_.renameTo(lvt_1_1_);
    }

    @SideOnly(value=Side.SERVER)
    private static Date parseDate(String p_parseDate_0_, Date p_parseDate_1_) {
        Date lvt_2_2_;
        try {
            Date lvt_2_1_ = UserListEntryBan.DATE_FORMAT.parse(p_parseDate_0_);
        }
        catch (ParseException lvt_3_1_) {
            lvt_2_2_ = p_parseDate_1_;
        }
        return lvt_2_2_;
    }

    @SideOnly(value=Side.SERVER)
    static class ConversionError
    extends RuntimeException {
        private ConversionError(String p_i1206_1_, Throwable p_i1206_2_) {
            super(p_i1206_1_, p_i1206_2_);
        }

        private ConversionError(String p_i1207_1_) {
            super(p_i1207_1_);
        }
    }
}

