/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.server.management.UserListEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserList<K, V extends UserListEntry<K>> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Gson gson;
    private final File saveFile;
    private final Map<String, V> values = Maps.newHashMap();
    private boolean lanServer = true;
    private static final ParameterizedType USER_LIST_ENTRY_TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{UserListEntry.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    public UserList(File p_i1144_1_) {
        this.saveFile = p_i1144_1_;
        GsonBuilder lvt_2_1_ = new GsonBuilder().setPrettyPrinting();
        lvt_2_1_.registerTypeHierarchyAdapter(UserListEntry.class, (Object)new Serializer());
        this.gson = lvt_2_1_.create();
    }

    public boolean isLanServer() {
        return this.lanServer;
    }

    public void setLanServer(boolean p_setLanServer_1_) {
        this.lanServer = p_setLanServer_1_;
    }

    public void addEntry(V p_addEntry_1_) {
        this.values.put(this.getObjectKey(((UserListEntry)p_addEntry_1_).getValue()), p_addEntry_1_);
        try {
            this.writeChanges();
        }
        catch (IOException lvt_2_1_) {
            LOGGER.warn("Could not save the list after adding a user.", (Throwable)lvt_2_1_);
        }
    }

    public V getEntry(K p_getEntry_1_) {
        this.removeExpired();
        return (V)((UserListEntry)this.values.get(this.getObjectKey(p_getEntry_1_)));
    }

    public void removeEntry(K p_removeEntry_1_) {
        this.values.remove(this.getObjectKey(p_removeEntry_1_));
        try {
            this.writeChanges();
        }
        catch (IOException lvt_2_1_) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)lvt_2_1_);
        }
    }

    @SideOnly(value=Side.SERVER)
    public File getSaveFile() {
        return this.saveFile;
    }

    public String[] getKeys() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    protected String getObjectKey(K p_getObjectKey_1_) {
        return p_getObjectKey_1_.toString();
    }

    protected boolean hasEntry(K p_hasEntry_1_) {
        return this.values.containsKey(this.getObjectKey(p_hasEntry_1_));
    }

    private void removeExpired() {
        ArrayList lvt_1_1_ = Lists.newArrayList();
        for (UserListEntry lvt_3_1_ : this.values.values()) {
            if (!lvt_3_1_.hasBanExpired()) continue;
            lvt_1_1_.add(lvt_3_1_.getValue());
        }
        for (Object lvt_3_2_ : lvt_1_1_) {
            this.values.remove(lvt_3_2_);
        }
    }

    protected UserListEntry<K> createEntry(JsonObject p_createEntry_1_) {
        return new UserListEntry<Object>(null, p_createEntry_1_);
    }

    protected Map<String, V> getValues() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChanges() throws IOException {
        Collection<V> lvt_1_1_ = this.values.values();
        String lvt_2_1_ = this.gson.toJson(lvt_1_1_);
        BufferedWriter lvt_3_1_ = null;
        try {
            lvt_3_1_ = Files.newWriter((File)this.saveFile, (Charset)Charsets.UTF_8);
            lvt_3_1_.write(lvt_2_1_);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lvt_3_1_);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lvt_3_1_);
    }

    @SideOnly(value=Side.SERVER)
    public boolean isEmpty() {
        return this.values.size() < 1;
    }

    @SideOnly(value=Side.SERVER)
    public void readSavedFile() throws IOException, FileNotFoundException {
        Collection lvt_1_1_ = null;
        BufferedReader lvt_2_1_ = null;
        try {
            lvt_2_1_ = Files.newReader((File)this.saveFile, (Charset)Charsets.UTF_8);
            lvt_1_1_ = (Collection)this.gson.fromJson((Reader)lvt_2_1_, (Type)USER_LIST_ENTRY_TYPE);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lvt_2_1_);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)lvt_2_1_);
        if (lvt_1_1_ != null) {
            this.values.clear();
            for (UserListEntry lvt_4_1_ : lvt_1_1_) {
                if (lvt_4_1_.getValue() == null) continue;
                this.values.put(this.getObjectKey(lvt_4_1_.getValue()), lvt_4_1_);
            }
        }
    }

    class Serializer
    implements JsonDeserializer<UserListEntry<K>>,
    JsonSerializer<UserListEntry<K>> {
        private Serializer() {
        }

        public JsonElement serialize(UserListEntry<K> p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject lvt_4_1_ = new JsonObject();
            p_serialize_1_.onSerialization(lvt_4_1_);
            return lvt_4_1_;
        }

        public UserListEntry<K> deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            if (p_deserialize_1_.isJsonObject()) {
                JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
                return UserList.this.createEntry(lvt_4_1_);
            }
            return null;
        }

        public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return this.serialize((UserListEntry)p_serialize_1_, p_serialize_2_, p_serialize_3_);
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

