/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.server.management.UserListEntry;

public abstract class UserListEntryBan<T>
extends UserListEntry<T> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    protected final Date banStartDate;
    protected final String bannedBy;
    protected final Date banEndDate;
    protected final String reason;

    public UserListEntryBan(T p_i46334_1_, Date p_i46334_2_, String p_i46334_3_, Date p_i46334_4_, String p_i46334_5_) {
        super(p_i46334_1_);
        this.banStartDate = p_i46334_2_ == null ? new Date() : p_i46334_2_;
        this.bannedBy = p_i46334_3_ == null ? "(Unknown)" : p_i46334_3_;
        this.banEndDate = p_i46334_4_;
        this.reason = p_i46334_5_ == null ? "Banned by an operator." : p_i46334_5_;
    }

    protected UserListEntryBan(T p_i1174_1_, JsonObject p_i1174_2_) {
        super(p_i1174_1_, p_i1174_2_);
        Object lvt_4_3_;
        Date lvt_3_2_;
        try {
            Date lvt_3_1_ = p_i1174_2_.has("created") ? DATE_FORMAT.parse(p_i1174_2_.get("created").getAsString()) : new Date();
        }
        catch (ParseException lvt_4_1_) {
            lvt_3_2_ = new Date();
        }
        this.banStartDate = lvt_3_2_;
        this.bannedBy = p_i1174_2_.has("source") ? p_i1174_2_.get("source").getAsString() : "(Unknown)";
        try {
            Date lvt_4_2_ = p_i1174_2_.has("expires") ? DATE_FORMAT.parse(p_i1174_2_.get("expires").getAsString()) : null;
        }
        catch (ParseException lvt_5_1_) {
            lvt_4_3_ = null;
        }
        this.banEndDate = lvt_4_3_;
        this.reason = p_i1174_2_.has("reason") ? p_i1174_2_.get("reason").getAsString() : "Banned by an operator.";
    }

    public Date getBanEndDate() {
        return this.banEndDate;
    }

    public String getBanReason() {
        return this.reason;
    }

    @Override
    boolean hasBanExpired() {
        if (this.banEndDate == null) {
            return false;
        }
        return this.banEndDate.before(new Date());
    }

    @Override
    protected void onSerialization(JsonObject p_onSerialization_1_) {
        p_onSerialization_1_.addProperty("created", DATE_FORMAT.format(this.banStartDate));
        p_onSerialization_1_.addProperty("source", this.bannedBy);
        p_onSerialization_1_.addProperty("expires", this.banEndDate == null ? "forever" : DATE_FORMAT.format(this.banEndDate));
        p_onSerialization_1_.addProperty("reason", this.reason);
    }
}

