/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.server.management.UserListEntry;

public class UserListOpsEntry
extends UserListEntry<GameProfile> {
    private final int permissionLevel;
    private final boolean bypassesPlayerLimit;

    public UserListOpsEntry(GameProfile p_i46492_1_, int p_i46492_2_, boolean p_i46492_3_) {
        super(p_i46492_1_);
        this.permissionLevel = p_i46492_2_;
        this.bypassesPlayerLimit = p_i46492_3_;
    }

    public UserListOpsEntry(JsonObject p_i1150_1_) {
        super(UserListOpsEntry.constructProfile(p_i1150_1_), p_i1150_1_);
        this.permissionLevel = p_i1150_1_.has("level") ? p_i1150_1_.get("level").getAsInt() : 0;
        this.bypassesPlayerLimit = p_i1150_1_.has("bypassesPlayerLimit") && p_i1150_1_.get("bypassesPlayerLimit").getAsBoolean();
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public boolean bypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    protected void onSerialization(JsonObject p_onSerialization_1_) {
        if (this.getValue() == null) {
            return;
        }
        p_onSerialization_1_.addProperty("uuid", ((GameProfile)this.getValue()).getId() == null ? "" : ((GameProfile)this.getValue()).getId().toString());
        p_onSerialization_1_.addProperty("name", ((GameProfile)this.getValue()).getName());
        super.onSerialization(p_onSerialization_1_);
        p_onSerialization_1_.addProperty("level", (Number)this.permissionLevel);
        p_onSerialization_1_.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
    }

    /*
     * WARNING - void declaration
     */
    private static GameProfile constructProfile(JsonObject p_constructProfile_0_) {
        void lvt_2_2_;
        if (!p_constructProfile_0_.has("uuid") || !p_constructProfile_0_.has("name")) {
            return null;
        }
        String lvt_1_1_ = p_constructProfile_0_.get("uuid").getAsString();
        try {
            UUID lvt_2_1_ = UUID.fromString(lvt_1_1_);
        }
        catch (Throwable lvt_3_1_) {
            return null;
        }
        return new GameProfile((UUID)lvt_2_2_, p_constructProfile_0_.get("name").getAsString());
    }
}

