/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.INetHandlerHandshakeServer;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.login.server.SPacketDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.NetHandlerLoginServer;
import net.minecraft.server.network.NetHandlerStatusServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NetHandlerHandshakeTCP
implements INetHandlerHandshakeServer {
    private final MinecraftServer server;
    private final NetworkManager networkManager;

    public NetHandlerHandshakeTCP(MinecraftServer p_i45295_1_, NetworkManager p_i45295_2_) {
        this.server = p_i45295_1_;
        this.networkManager = p_i45295_2_;
    }

    @Override
    public void processHandshake(C00Handshake p_processHandshake_1_) {
        if (!FMLCommonHandler.instance().handleServerHandshake(p_processHandshake_1_, this.networkManager)) {
            return;
        }
        switch (p_processHandshake_1_.getRequestedState()) {
            case LOGIN: {
                this.networkManager.setConnectionState(EnumConnectionState.LOGIN);
                if (p_processHandshake_1_.getProtocolVersion() > 316) {
                    TextComponentString textcomponentstring = new TextComponentString("Outdated server! I'm still on 1.11.2");
                    this.networkManager.sendPacket(new SPacketDisconnect(textcomponentstring));
                    this.networkManager.closeChannel(textcomponentstring);
                    break;
                }
                if (p_processHandshake_1_.getProtocolVersion() < 316) {
                    TextComponentString textcomponentstring1 = new TextComponentString("Outdated client! Please use 1.11.2");
                    this.networkManager.sendPacket(new SPacketDisconnect(textcomponentstring1));
                    this.networkManager.closeChannel(textcomponentstring1);
                    break;
                }
                this.networkManager.setNetHandler(new NetHandlerLoginServer(this.server, this.networkManager));
                break;
            }
            case STATUS: {
                this.networkManager.setConnectionState(EnumConnectionState.STATUS);
                this.networkManager.setNetHandler(new NetHandlerStatusServer(this.server, this.networkManager));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + (Object)((Object)p_processHandshake_1_.getRequestedState()));
            }
        }
    }

    @Override
    public void onDisconnect(ITextComponent p_onDisconnect_1_) {
    }
}

