/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.NetworkManager;
import net.minecraft.network.status.INetHandlerStatusServer;
import net.minecraft.network.status.client.CPacketPing;
import net.minecraft.network.status.client.CPacketServerQuery;
import net.minecraft.network.status.server.SPacketPong;
import net.minecraft.network.status.server.SPacketServerInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class NetHandlerStatusServer
implements INetHandlerStatusServer {
    private static final ITextComponent EXIT_MESSAGE = new TextComponentString("Status request has been handled.");
    private final MinecraftServer server;
    private final NetworkManager networkManager;
    private boolean handled;

    public NetHandlerStatusServer(MinecraftServer p_i45299_1_, NetworkManager p_i45299_2_) {
        this.server = p_i45299_1_;
        this.networkManager = p_i45299_2_;
    }

    @Override
    public void onDisconnect(ITextComponent p_onDisconnect_1_) {
    }

    @Override
    public void processServerQuery(CPacketServerQuery p_processServerQuery_1_) {
        if (this.handled) {
            this.networkManager.closeChannel(EXIT_MESSAGE);
            return;
        }
        this.handled = true;
        this.networkManager.sendPacket(new SPacketServerInfo(this.server.getServerStatusResponse()));
    }

    @Override
    public void processPing(CPacketPing p_processPing_1_) {
        this.networkManager.sendPacket(new SPacketPong(p_processPing_1_.getClientTime()));
        this.networkManager.closeChannel(EXIT_MESSAGE);
    }
}

