/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.IStatStringFormat;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Achievement
extends StatBase {
    public final int displayColumn;
    public final int displayRow;
    public final Achievement parentAchievement;
    private final String achievementDescription;
    @SideOnly(value=Side.CLIENT)
    private IStatStringFormat statStringFormatter;
    public final ItemStack theItemStack;
    private boolean isSpecial;

    public Achievement(String p_i46327_1_, String p_i46327_2_, int p_i46327_3_, int p_i46327_4_, Item p_i46327_5_, Achievement p_i46327_6_) {
        this(p_i46327_1_, p_i46327_2_, p_i46327_3_, p_i46327_4_, new ItemStack(p_i46327_5_), p_i46327_6_);
    }

    public Achievement(String p_i45301_1_, String p_i45301_2_, int p_i45301_3_, int p_i45301_4_, Block p_i45301_5_, Achievement p_i45301_6_) {
        this(p_i45301_1_, p_i45301_2_, p_i45301_3_, p_i45301_4_, new ItemStack(p_i45301_5_), p_i45301_6_);
    }

    public Achievement(String p_i45302_1_, String p_i45302_2_, int p_i45302_3_, int p_i45302_4_, ItemStack p_i45302_5_, Achievement p_i45302_6_) {
        super(p_i45302_1_, new TextComponentTranslation("achievement." + p_i45302_2_, new Object[0]));
        this.theItemStack = p_i45302_5_;
        this.achievementDescription = "achievement." + p_i45302_2_ + ".desc";
        this.displayColumn = p_i45302_3_;
        this.displayRow = p_i45302_4_;
        if (p_i45302_3_ < AchievementList.minDisplayColumn) {
            AchievementList.minDisplayColumn = p_i45302_3_;
        }
        if (p_i45302_4_ < AchievementList.minDisplayRow) {
            AchievementList.minDisplayRow = p_i45302_4_;
        }
        if (p_i45302_3_ > AchievementList.maxDisplayColumn) {
            AchievementList.maxDisplayColumn = p_i45302_3_;
        }
        if (p_i45302_4_ > AchievementList.maxDisplayRow) {
            AchievementList.maxDisplayRow = p_i45302_4_;
        }
        this.parentAchievement = p_i45302_6_;
    }

    @Override
    public Achievement initIndependentStat() {
        this.isIndependent = true;
        return this;
    }

    public Achievement setSpecial() {
        this.isSpecial = true;
        return this;
    }

    @Override
    public Achievement registerStat() {
        super.registerStat();
        AchievementList.ACHIEVEMENTS.add(this);
        return this;
    }

    @Override
    public boolean isAchievement() {
        return true;
    }

    @Override
    public ITextComponent getStatName() {
        ITextComponent lvt_1_1_ = super.getStatName();
        lvt_1_1_.getStyle().setColor(this.getSpecial() ? TextFormatting.DARK_PURPLE : TextFormatting.GREEN);
        return lvt_1_1_;
    }

    @Override
    public Achievement setSerializableClazz(Class<? extends IJsonSerializable> p_setSerializableClazz_1_) {
        return (Achievement)super.setSerializableClazz(p_setSerializableClazz_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (this.statStringFormatter != null) {
            return this.statStringFormatter.formatString(I18n.translateToLocal(this.achievementDescription));
        }
        return I18n.translateToLocal(this.achievementDescription);
    }

    @SideOnly(value=Side.CLIENT)
    public Achievement setStatStringFormatter(IStatStringFormat p_setStatStringFormatter_1_) {
        this.statStringFormatter = p_setStatStringFormatter_1_;
        return this;
    }

    public boolean getSpecial() {
        return this.isSpecial;
    }

    public /* synthetic */ StatBase setSerializableClazz(Class p_setSerializableClazz_1_) {
        return this.setSerializableClazz(p_setSerializableClazz_1_);
    }

    @Override
    public /* synthetic */ StatBase registerStat() {
        return this.registerStat();
    }

    @Override
    public /* synthetic */ StatBase initIndependentStat() {
        return this.initIndependentStat();
    }
}

