/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreCriteriaStat;
import net.minecraft.stats.IStatType;
import net.minecraft.stats.StatList;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatBase {
    public final String statId;
    private final ITextComponent statName;
    public boolean isIndependent;
    private final IStatType formatter;
    private final IScoreCriteria objectiveCriteria;
    private Class<? extends IJsonSerializable> serializableClazz;
    private static final NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
    public static IStatType simpleStatType = new IStatType(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(int p_format_1_) {
            return numberFormat.format(p_format_1_);
        }
    };
    private static final DecimalFormat decimalFormat = new DecimalFormat("########0.00");
    public static IStatType timeStatType = new IStatType(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(int p_format_1_) {
            double lvt_2_1_ = (double)p_format_1_ / 20.0;
            double lvt_4_1_ = lvt_2_1_ / 60.0;
            double lvt_6_1_ = lvt_4_1_ / 60.0;
            double lvt_8_1_ = lvt_6_1_ / 24.0;
            double lvt_10_1_ = lvt_8_1_ / 365.0;
            if (lvt_10_1_ > 0.5) {
                return decimalFormat.format(lvt_10_1_) + " y";
            }
            if (lvt_8_1_ > 0.5) {
                return decimalFormat.format(lvt_8_1_) + " d";
            }
            if (lvt_6_1_ > 0.5) {
                return decimalFormat.format(lvt_6_1_) + " h";
            }
            if (lvt_4_1_ > 0.5) {
                return decimalFormat.format(lvt_4_1_) + " m";
            }
            return lvt_2_1_ + " s";
        }
    };
    public static IStatType distanceStatType = new IStatType(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(int p_format_1_) {
            double lvt_2_1_ = (double)p_format_1_ / 100.0;
            double lvt_4_1_ = lvt_2_1_ / 1000.0;
            if (lvt_4_1_ > 0.5) {
                return decimalFormat.format(lvt_4_1_) + " km";
            }
            if (lvt_2_1_ > 0.5) {
                return decimalFormat.format(lvt_2_1_) + " m";
            }
            return p_format_1_ + " cm";
        }
    };
    public static IStatType divideByTen = new IStatType(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(int p_format_1_) {
            return decimalFormat.format((double)p_format_1_ * 0.1);
        }
    };

    public StatBase(String p_i45307_1_, ITextComponent p_i45307_2_, IStatType p_i45307_3_) {
        this.statId = p_i45307_1_;
        this.statName = p_i45307_2_;
        this.formatter = p_i45307_3_;
        this.objectiveCriteria = new ScoreCriteriaStat(this);
        IScoreCriteria.INSTANCES.put(this.objectiveCriteria.getName(), this.objectiveCriteria);
    }

    public StatBase(String p_i45308_1_, ITextComponent p_i45308_2_) {
        this(p_i45308_1_, p_i45308_2_, simpleStatType);
    }

    public StatBase initIndependentStat() {
        this.isIndependent = true;
        return this;
    }

    public StatBase registerStat() {
        if (StatList.ID_TO_STAT_MAP.containsKey(this.statId)) {
            throw new RuntimeException("Duplicate stat id: \"" + StatList.ID_TO_STAT_MAP.get((Object)this.statId).statName + "\" and \"" + this.statName + "\" at id " + this.statId);
        }
        StatList.ALL_STATS.add(this);
        StatList.ID_TO_STAT_MAP.put(this.statId, this);
        return this;
    }

    public boolean isAchievement() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String format(int p_format_1_) {
        return this.formatter.format(p_format_1_);
    }

    public ITextComponent getStatName() {
        ITextComponent lvt_1_1_ = this.statName.createCopy();
        lvt_1_1_.getStyle().setColor(TextFormatting.GRAY);
        lvt_1_1_.getStyle().setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ACHIEVEMENT, new TextComponentString(this.statId)));
        return lvt_1_1_;
    }

    public ITextComponent createChatComponent() {
        ITextComponent lvt_1_1_ = this.getStatName();
        ITextComponent lvt_2_1_ = new TextComponentString("[").appendSibling(lvt_1_1_).appendText("]");
        lvt_2_1_.setStyle(lvt_1_1_.getStyle());
        return lvt_2_1_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ == null || this.getClass() != p_equals_1_.getClass()) {
            return false;
        }
        StatBase lvt_2_1_ = (StatBase)p_equals_1_;
        return this.statId.equals(lvt_2_1_.statId);
    }

    public int hashCode() {
        return this.statId.hashCode();
    }

    public String toString() {
        return "Stat{id=" + this.statId + ", nameId=" + this.statName + ", awardLocallyOnly=" + this.isIndependent + ", formatter=" + this.formatter + ", objectiveCriteria=" + this.objectiveCriteria + '}';
    }

    public IScoreCriteria getCriteria() {
        return this.objectiveCriteria;
    }

    public Class<? extends IJsonSerializable> getSerializableClazz() {
        return this.serializableClazz;
    }

    public StatBase setSerializableClazz(Class<? extends IJsonSerializable> p_setSerializableClazz_1_) {
        this.serializableClazz = p_setSerializableClazz_1_;
        return this;
    }
}

