/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.TupleIntJsonSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatisticsManager {
    protected final Map<StatBase, TupleIntJsonSerializable> statsData = Maps.newConcurrentMap();

    public boolean hasAchievementUnlocked(Achievement p_hasAchievementUnlocked_1_) {
        return this.readStat(p_hasAchievementUnlocked_1_) > 0;
    }

    public boolean canUnlockAchievement(Achievement p_canUnlockAchievement_1_) {
        return p_canUnlockAchievement_1_.parentAchievement == null || this.hasAchievementUnlocked(p_canUnlockAchievement_1_.parentAchievement);
    }

    public void increaseStat(EntityPlayer p_increaseStat_1_, StatBase p_increaseStat_2_, int p_increaseStat_3_) {
        if (p_increaseStat_2_.isAchievement() && !this.canUnlockAchievement((Achievement)p_increaseStat_2_)) {
            return;
        }
        this.unlockAchievement(p_increaseStat_1_, p_increaseStat_2_, this.readStat(p_increaseStat_2_) + p_increaseStat_3_);
    }

    @SideOnly(value=Side.CLIENT)
    public int countRequirementsUntilAvailable(Achievement p_countRequirementsUntilAvailable_1_) {
        if (this.hasAchievementUnlocked(p_countRequirementsUntilAvailable_1_)) {
            return 0;
        }
        int lvt_2_1_ = 0;
        Achievement lvt_3_1_ = p_countRequirementsUntilAvailable_1_.parentAchievement;
        while (lvt_3_1_ != null && !this.hasAchievementUnlocked(lvt_3_1_)) {
            lvt_3_1_ = lvt_3_1_.parentAchievement;
            ++lvt_2_1_;
        }
        return lvt_2_1_;
    }

    public void unlockAchievement(EntityPlayer p_unlockAchievement_1_, StatBase p_unlockAchievement_2_, int p_unlockAchievement_3_) {
        TupleIntJsonSerializable lvt_4_1_ = this.statsData.get(p_unlockAchievement_2_);
        if (lvt_4_1_ == null) {
            lvt_4_1_ = new TupleIntJsonSerializable();
            this.statsData.put(p_unlockAchievement_2_, lvt_4_1_);
        }
        lvt_4_1_.setIntegerValue(p_unlockAchievement_3_);
    }

    public int readStat(StatBase p_readStat_1_) {
        TupleIntJsonSerializable lvt_2_1_ = this.statsData.get(p_readStat_1_);
        return lvt_2_1_ == null ? 0 : lvt_2_1_.getIntegerValue();
    }

    public <T extends IJsonSerializable> T getProgress(StatBase p_getProgress_1_) {
        TupleIntJsonSerializable lvt_2_1_ = this.statsData.get(p_getProgress_1_);
        if (lvt_2_1_ != null) {
            return lvt_2_1_.getJsonSerializableValue();
        }
        return null;
    }

    public <T extends IJsonSerializable> T setProgress(StatBase p_setProgress_1_, T p_setProgress_2_) {
        TupleIntJsonSerializable lvt_3_1_ = this.statsData.get(p_setProgress_1_);
        if (lvt_3_1_ == null) {
            lvt_3_1_ = new TupleIntJsonSerializable();
            this.statsData.put(p_setProgress_1_, lvt_3_1_);
        }
        lvt_3_1_.setJsonSerializableValue(p_setProgress_2_);
        return p_setProgress_2_;
    }
}

