/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketStatistics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.TupleIntJsonSerializable;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatisticsManagerServer
extends StatisticsManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinecraftServer mcServer;
    private final File statsFile;
    private final Set<StatBase> dirty = Sets.newHashSet();
    private int lastStatRequest = -300;
    private boolean hasUnsentAchievement;

    public StatisticsManagerServer(MinecraftServer p_i45306_1_, File p_i45306_2_) {
        this.mcServer = p_i45306_1_;
        this.statsFile = p_i45306_2_;
    }

    public void readStatFile() {
        if (this.statsFile.isFile()) {
            try {
                this.statsData.clear();
                this.statsData.putAll(this.parseJson(FileUtils.readFileToString((File)this.statsFile)));
            }
            catch (IOException lvt_1_1_) {
                LOGGER.error("Couldn't read statistics file {}", new Object[]{this.statsFile, lvt_1_1_});
            }
            catch (JsonParseException lvt_1_2_) {
                LOGGER.error("Couldn't parse statistics file {}", new Object[]{this.statsFile, lvt_1_2_});
            }
        }
    }

    public void saveStatFile() {
        try {
            FileUtils.writeStringToFile((File)this.statsFile, (String)StatisticsManagerServer.dumpJson(this.statsData));
        }
        catch (IOException lvt_1_1_) {
            LOGGER.error("Couldn't save stats", (Throwable)lvt_1_1_);
        }
    }

    @Override
    public void unlockAchievement(EntityPlayer p_unlockAchievement_1_, StatBase p_unlockAchievement_2_, int p_unlockAchievement_3_) {
        int lvt_4_1_ = p_unlockAchievement_2_.isAchievement() ? this.readStat(p_unlockAchievement_2_) : 0;
        super.unlockAchievement(p_unlockAchievement_1_, p_unlockAchievement_2_, p_unlockAchievement_3_);
        this.dirty.add(p_unlockAchievement_2_);
        if (p_unlockAchievement_2_.isAchievement() && lvt_4_1_ == 0 && p_unlockAchievement_3_ > 0) {
            this.hasUnsentAchievement = true;
            if (this.mcServer.isAnnouncingPlayerAchievements()) {
                this.mcServer.getPlayerList().sendMessage(new TextComponentTranslation("chat.type.achievement", p_unlockAchievement_1_.getDisplayName(), p_unlockAchievement_2_.createChatComponent()));
            }
        }
        if (p_unlockAchievement_2_.isAchievement() && lvt_4_1_ > 0 && p_unlockAchievement_3_ == 0) {
            this.hasUnsentAchievement = true;
            if (this.mcServer.isAnnouncingPlayerAchievements()) {
                this.mcServer.getPlayerList().sendMessage(new TextComponentTranslation("chat.type.achievement.taken", p_unlockAchievement_1_.getDisplayName(), p_unlockAchievement_2_.createChatComponent()));
            }
        }
    }

    public Set<StatBase> getDirty() {
        HashSet lvt_1_1_ = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        this.hasUnsentAchievement = false;
        return lvt_1_1_;
    }

    public Map<StatBase, TupleIntJsonSerializable> parseJson(String p_parseJson_1_) {
        JsonElement lvt_2_1_ = new JsonParser().parse(p_parseJson_1_);
        if (!lvt_2_1_.isJsonObject()) {
            return Maps.newHashMap();
        }
        JsonObject lvt_3_1_ = lvt_2_1_.getAsJsonObject();
        HashMap lvt_4_1_ = Maps.newHashMap();
        for (Map.Entry lvt_6_1_ : lvt_3_1_.entrySet()) {
            StatBase lvt_7_1_ = StatList.getOneShotStat((String)lvt_6_1_.getKey());
            if (lvt_7_1_ != null) {
                TupleIntJsonSerializable lvt_8_1_ = new TupleIntJsonSerializable();
                if (((JsonElement)lvt_6_1_.getValue()).isJsonPrimitive() && ((JsonElement)lvt_6_1_.getValue()).getAsJsonPrimitive().isNumber()) {
                    lvt_8_1_.setIntegerValue(((JsonElement)lvt_6_1_.getValue()).getAsInt());
                } else if (((JsonElement)lvt_6_1_.getValue()).isJsonObject()) {
                    JsonObject lvt_9_1_ = ((JsonElement)lvt_6_1_.getValue()).getAsJsonObject();
                    if (lvt_9_1_.has("value") && lvt_9_1_.get("value").isJsonPrimitive() && lvt_9_1_.get("value").getAsJsonPrimitive().isNumber()) {
                        lvt_8_1_.setIntegerValue(lvt_9_1_.getAsJsonPrimitive("value").getAsInt());
                    }
                    if (lvt_9_1_.has("progress") && lvt_7_1_.getSerializableClazz() != null) {
                        try {
                            Constructor<? extends IJsonSerializable> lvt_10_1_ = lvt_7_1_.getSerializableClazz().getConstructor(new Class[0]);
                            IJsonSerializable lvt_11_1_ = lvt_10_1_.newInstance(new Object[0]);
                            lvt_11_1_.fromJson(lvt_9_1_.get("progress"));
                            lvt_8_1_.setJsonSerializableValue(lvt_11_1_);
                        }
                        catch (Throwable lvt_10_2_) {
                            LOGGER.warn("Invalid statistic progress in {}", new Object[]{this.statsFile, lvt_10_2_});
                        }
                    }
                }
                lvt_4_1_.put(lvt_7_1_, lvt_8_1_);
                continue;
            }
            LOGGER.warn("Invalid statistic in {}: Don't know what {} is", new Object[]{this.statsFile, lvt_6_1_.getKey()});
        }
        return lvt_4_1_;
    }

    public static String dumpJson(Map<StatBase, TupleIntJsonSerializable> p_dumpJson_0_) {
        JsonObject lvt_1_1_ = new JsonObject();
        for (Map.Entry<StatBase, TupleIntJsonSerializable> lvt_3_1_ : p_dumpJson_0_.entrySet()) {
            if (lvt_3_1_.getValue().getJsonSerializableValue() != null) {
                JsonObject lvt_4_1_ = new JsonObject();
                lvt_4_1_.addProperty("value", (Number)lvt_3_1_.getValue().getIntegerValue());
                try {
                    lvt_4_1_.add("progress", lvt_3_1_.getValue().getJsonSerializableValue().getSerializableElement());
                }
                catch (Throwable lvt_5_1_) {
                    LOGGER.warn("Couldn't save statistic {}: error serializing progress", new Object[]{lvt_3_1_.getKey().getStatName(), lvt_5_1_});
                }
                lvt_1_1_.add(lvt_3_1_.getKey().statId, (JsonElement)lvt_4_1_);
                continue;
            }
            lvt_1_1_.addProperty(lvt_3_1_.getKey().statId, (Number)lvt_3_1_.getValue().getIntegerValue());
        }
        return lvt_1_1_.toString();
    }

    public void markAllDirty() {
        for (StatBase lvt_2_1_ : this.statsData.keySet()) {
            this.dirty.add(lvt_2_1_);
        }
    }

    public void sendStats(EntityPlayerMP p_sendStats_1_) {
        int lvt_2_1_ = this.mcServer.getTickCounter();
        HashMap lvt_3_1_ = Maps.newHashMap();
        if (this.hasUnsentAchievement || lvt_2_1_ - this.lastStatRequest > 300) {
            this.lastStatRequest = lvt_2_1_;
            for (StatBase lvt_5_1_ : this.getDirty()) {
                lvt_3_1_.put(lvt_5_1_, this.readStat(lvt_5_1_));
            }
        }
        p_sendStats_1_.connection.sendPacket(new SPacketStatistics(lvt_3_1_));
    }

    public void sendAchievements(EntityPlayerMP p_sendAchievements_1_) {
        HashMap lvt_2_1_ = Maps.newHashMap();
        for (Achievement lvt_4_1_ : AchievementList.ACHIEVEMENTS) {
            if (!this.hasAchievementUnlocked(lvt_4_1_)) continue;
            lvt_2_1_.put(lvt_4_1_, this.readStat(lvt_4_1_));
            this.dirty.remove(lvt_4_1_);
        }
        p_sendAchievements_1_.connection.sendPacket(new SPacketStatistics(lvt_2_1_));
    }

    public boolean hasUnsentAchievement() {
        return this.hasUnsentAchievement;
    }
}

