/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import io.netty.buffer.ByteBuf;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CommandBlockBaseLogic
implements ICommandSender {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private int successCount;
    private boolean trackOutput = true;
    private ITextComponent lastOutput;
    private String commandStored = "";
    private String customName = "@";
    private final CommandResultStats resultStats = new CommandResultStats();

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int p_setSuccessCount_1_) {
        this.successCount = p_setSuccessCount_1_;
    }

    public ITextComponent getLastOutput() {
        return this.lastOutput == null ? new TextComponentString("") : this.lastOutput;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        p_writeToNBT_1_.setString("Command", this.commandStored);
        p_writeToNBT_1_.setInteger("SuccessCount", this.successCount);
        p_writeToNBT_1_.setString("CustomName", this.customName);
        p_writeToNBT_1_.setBoolean("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            p_writeToNBT_1_.setString("LastOutput", ITextComponent.Serializer.componentToJson(this.lastOutput));
        }
        this.resultStats.writeStatsToNBT(p_writeToNBT_1_);
        return p_writeToNBT_1_;
    }

    public void readDataFromNBT(NBTTagCompound p_readDataFromNBT_1_) {
        this.commandStored = p_readDataFromNBT_1_.getString("Command");
        this.successCount = p_readDataFromNBT_1_.getInteger("SuccessCount");
        if (p_readDataFromNBT_1_.hasKey("CustomName", 8)) {
            this.customName = p_readDataFromNBT_1_.getString("CustomName");
        }
        if (p_readDataFromNBT_1_.hasKey("TrackOutput", 1)) {
            this.trackOutput = p_readDataFromNBT_1_.getBoolean("TrackOutput");
        }
        if (p_readDataFromNBT_1_.hasKey("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = ITextComponent.Serializer.jsonToComponent(p_readDataFromNBT_1_.getString("LastOutput"));
            }
            catch (Throwable lvt_2_1_) {
                this.lastOutput = new TextComponentString(lvt_2_1_.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        this.resultStats.readStatsFromNBT(p_readDataFromNBT_1_);
    }

    @Override
    public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
        return p_canUseCommand_1_ <= 2;
    }

    public void setCommand(String p_setCommand_1_) {
        this.commandStored = p_setCommand_1_;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.commandStored;
    }

    public void trigger(World p_trigger_1_) {
        if (p_trigger_1_.isRemote) {
            this.successCount = 0;
            return;
        }
        if ("Searge".equalsIgnoreCase(this.commandStored)) {
            this.lastOutput = new TextComponentString("#itzlipofutzli");
            this.successCount = 1;
            return;
        }
        MinecraftServer lvt_2_1_ = this.getServer();
        if (lvt_2_1_ != null && lvt_2_1_.isAnvilFileSet() && lvt_2_1_.isCommandBlockEnabled()) {
            ICommandManager lvt_3_1_ = lvt_2_1_.getCommandManager();
            try {
                this.lastOutput = null;
                this.successCount = lvt_3_1_.executeCommand(this, this.commandStored);
            }
            catch (Throwable lvt_4_1_) {
                CrashReport lvt_5_1_ = CrashReport.makeCrashReport(lvt_4_1_, "Executing command block");
                CrashReportCategory lvt_6_1_ = lvt_5_1_.makeCategory("Command to be executed");
                lvt_6_1_.setDetail("Command", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return CommandBlockBaseLogic.this.getCommand();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.call();
                    }
                });
                lvt_6_1_.setDetail("Name", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return CommandBlockBaseLogic.this.getName();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.call();
                    }
                });
                throw new ReportedException(lvt_5_1_);
            }
        } else {
            this.successCount = 0;
        }
    }

    @Override
    public String getName() {
        return this.customName;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public void setName(String p_setName_1_) {
        this.customName = p_setName_1_;
    }

    @Override
    public void sendMessage(ITextComponent p_sendMessage_1_) {
        if (this.trackOutput && this.getEntityWorld() != null && !this.getEntityWorld().isRemote) {
            this.lastOutput = new TextComponentString("[" + TIMESTAMP_FORMAT.format(new Date()) + "] ").appendSibling(p_sendMessage_1_);
            this.updateCommand();
        }
    }

    @Override
    public boolean sendCommandFeedback() {
        MinecraftServer lvt_1_1_ = this.getServer();
        return lvt_1_1_ == null || !lvt_1_1_.isAnvilFileSet() || lvt_1_1_.worlds[0].getGameRules().getBoolean("commandBlockOutput");
    }

    @Override
    public void setCommandStat(CommandResultStats.Type p_setCommandStat_1_, int p_setCommandStat_2_) {
        this.resultStats.setCommandStatForSender(this.getServer(), this, p_setCommandStat_1_, p_setCommandStat_2_);
    }

    public abstract void updateCommand();

    @SideOnly(value=Side.CLIENT)
    public abstract int getCommandBlockType();

    @SideOnly(value=Side.CLIENT)
    public abstract void fillInInfo(ByteBuf var1);

    public void setLastOutput(ITextComponent p_setLastOutput_1_) {
        this.lastOutput = p_setLastOutput_1_;
    }

    public void setTrackOutput(boolean p_setTrackOutput_1_) {
        this.trackOutput = p_setTrackOutput_1_;
    }

    public boolean shouldTrackOutput() {
        return this.trackOutput;
    }

    public boolean tryOpenEditCommandBlock(EntityPlayer p_tryOpenEditCommandBlock_1_) {
        if (!p_tryOpenEditCommandBlock_1_.canUseCommandBlock()) {
            return false;
        }
        if (p_tryOpenEditCommandBlock_1_.getEntityWorld().isRemote) {
            p_tryOpenEditCommandBlock_1_.displayGuiEditCommandCart(this);
        }
        return true;
    }

    public CommandResultStats getCommandResultStats() {
        return this.resultStats;
    }
}

