/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TileEntity
implements ICapabilitySerializable<NBTTagCompound> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> REGISTRY = GameData.getTileEntityRegistry();
    protected World world;
    protected BlockPos pos = BlockPos.ORIGIN;
    protected boolean tileEntityInvalid;
    private int blockMetadata = -1;
    protected Block blockType;
    private boolean isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    public static final AxisAlignedBB INFINITE_EXTENT_AABB = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private NBTTagCompound customTileData;
    private CapabilityDispatcher capabilities = ForgeEventFactory.gatherCapabilities(this);

    private static void register(String p_register_0_, Class<? extends TileEntity> p_register_1_) {
        REGISTRY.putObject(new ResourceLocation(p_register_0_), p_register_1_);
    }

    @Nullable
    public static ResourceLocation getKey(Class<? extends TileEntity> p_getKey_0_) {
        return REGISTRY.getNameForObject(p_getKey_0_);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        this.pos = new BlockPos(p_readFromNBT_1_.getInteger("x"), p_readFromNBT_1_.getInteger("y"), p_readFromNBT_1_.getInteger("z"));
        if (p_readFromNBT_1_.hasKey("ForgeData")) {
            this.customTileData = p_readFromNBT_1_.getCompoundTag("ForgeData");
        }
        if (this.capabilities != null && p_readFromNBT_1_.hasKey("ForgeCaps")) {
            this.capabilities.deserializeNBT(p_readFromNBT_1_.getCompoundTag("ForgeCaps"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        return this.writeInternal(p_writeToNBT_1_);
    }

    private NBTTagCompound writeInternal(NBTTagCompound p_writeInternal_1_) {
        ResourceLocation resourcelocation = REGISTRY.getNameForObject(this.getClass());
        if (resourcelocation == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        p_writeInternal_1_.setString("id", resourcelocation.toString());
        p_writeInternal_1_.setInteger("x", this.pos.getX());
        p_writeInternal_1_.setInteger("y", this.pos.getY());
        p_writeInternal_1_.setInteger("z", this.pos.getZ());
        if (this.customTileData != null) {
            p_writeInternal_1_.setTag("ForgeData", this.customTileData);
        }
        if (this.capabilities != null) {
            p_writeInternal_1_.setTag("ForgeCaps", this.capabilities.serializeNBT());
        }
        return p_writeInternal_1_;
    }

    @Nullable
    public static TileEntity create(World p_create_0_, NBTTagCompound p_create_1_) {
        TileEntity tileentity = null;
        String s = p_create_1_.getString("id");
        Class<? extends TileEntity> oclass = null;
        try {
            oclass = REGISTRY.getObject(new ResourceLocation(s));
            if (oclass != null) {
                tileentity = oclass.newInstance();
            }
        }
        catch (Throwable throwable1) {
            LOGGER.error("Failed to create block entity {}", new Object[]{s, throwable1});
            FMLLog.log(Level.ERROR, throwable1, "A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", s, oclass.getName());
        }
        if (tileentity != null) {
            try {
                tileentity.setWorldCreate(p_create_0_);
                tileentity.readFromNBT(p_create_1_);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to load data for block entity {}", new Object[]{s, throwable});
                FMLLog.log(Level.ERROR, throwable, "A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", s, oclass.getName());
                tileentity = null;
            }
        } else {
            LOGGER.warn("Skipping BlockEntity with id {}", new Object[]{s});
        }
        return tileentity;
    }

    protected void setWorldCreate(World p_setWorldCreate_1_) {
    }

    public int getBlockMetadata() {
        if (this.blockMetadata == -1) {
            IBlockState iblockstate = this.world.getBlockState(this.pos);
            this.blockMetadata = iblockstate.getBlock().getMetaFromState(iblockstate);
        }
        return this.blockMetadata;
    }

    public void markDirty() {
        if (this.world != null) {
            IBlockState iblockstate = this.world.getBlockState(this.pos);
            this.blockMetadata = iblockstate.getBlock().getMetaFromState(iblockstate);
            this.world.markChunkDirty(this.pos, this);
            if (this.getBlockType() != Blocks.AIR) {
                this.world.updateComparatorOutputLevel(this.pos, this.getBlockType());
            }
        }
    }

    public double getDistanceSq(double p_getDistanceSq_1_, double p_getDistanceSq_3_, double p_getDistanceSq_5_) {
        double d0 = (double)this.pos.getX() + 0.5 - p_getDistanceSq_1_;
        double d1 = (double)this.pos.getY() + 0.5 - p_getDistanceSq_3_;
        double d2 = (double)this.pos.getZ() + 0.5 - p_getDistanceSq_5_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 4096.0;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Block getBlockType() {
        if (this.blockType == null && this.world != null) {
            this.blockType = this.world.getBlockState(this.pos).getBlock();
        }
        return this.blockType;
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return null;
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeInternal(new NBTTagCompound());
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        return false;
    }

    public void updateContainingBlockInfo() {
        this.blockType = null;
        this.blockMetadata = -1;
    }

    public void addInfoToCrashReport(CrashReportCategory p_addInfoToCrashReport_1_) {
        p_addInfoToCrashReport_1_.setDetail("Name", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return REGISTRY.getNameForObject(TileEntity.this.getClass()) + " // " + TileEntity.this.getClass().getCanonicalName();
            }
        });
        if (this.world != null) {
            CrashReportCategory.addBlockInfo(p_addInfoToCrashReport_1_, this.pos, this.getBlockType(), this.getBlockMetadata());
            p_addInfoToCrashReport_1_.setDetail("Actual block type", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    int i = Block.getIdFromBlock(TileEntity.this.world.getBlockState(TileEntity.this.pos).getBlock());
                    try {
                        return String.format("ID #%d (%s // %s)", i, Block.getBlockById(i).getUnlocalizedName(), Block.getBlockById(i).getClass().getCanonicalName());
                    }
                    catch (Throwable var3) {
                        return "ID #" + i;
                    }
                }
            });
            p_addInfoToCrashReport_1_.setDetail("Actual block data value", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    IBlockState iblockstate = TileEntity.this.world.getBlockState(TileEntity.this.pos);
                    int i = iblockstate.getBlock().getMetaFromState(iblockstate);
                    if (i < 0) {
                        return "Unknown? (Got " + i + ")";
                    }
                    String s = String.format("%4s", Integer.toBinaryString(i)).replace(" ", "0");
                    return String.format("%1$d / 0x%1$X / 0b%2$s", i, s);
                }
            });
        }
    }

    public void setPos(BlockPos p_setPos_1_) {
        this.pos = p_setPos_1_.toImmutable();
    }

    public boolean onlyOpsCanSetNbt() {
        return false;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return null;
    }

    public void rotate(Rotation p_rotate_1_) {
    }

    public void mirror(Mirror p_mirror_1_) {
    }

    public void onDataPacket(NetworkManager p_onDataPacket_1_, SPacketUpdateTileEntity p_onDataPacket_2_) {
    }

    public void handleUpdateTag(NBTTagCompound p_handleUpdateTag_1_) {
        this.readFromNBT(p_handleUpdateTag_1_);
    }

    public void onChunkUnload() {
    }

    public boolean shouldRefresh(World p_shouldRefresh_1_, BlockPos p_shouldRefresh_2_, IBlockState p_shouldRefresh_3_, IBlockState p_shouldRefresh_4_) {
        return this.isVanilla ? p_shouldRefresh_3_.getBlock() != p_shouldRefresh_4_.getBlock() : p_shouldRefresh_3_ != p_shouldRefresh_4_;
    }

    public boolean shouldRenderInPass(int p_shouldRenderInPass_1_) {
        return p_shouldRenderInPass_1_ == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        Block type = this.getBlockType();
        BlockPos pos = this.getPos();
        if (type == Blocks.ENCHANTING_TABLE) {
            bb = new AxisAlignedBB(pos, pos.add(1, 1, 1));
        } else if (type == Blocks.CHEST || type == Blocks.TRAPPED_CHEST) {
            bb = new AxisAlignedBB(pos.add(-1, 0, -1), pos.add(2, 2, 2));
        } else if (type == Blocks.STRUCTURE_BLOCK) {
            bb = INFINITE_EXTENT_AABB;
        } else if (type != null && type != Blocks.BEACON) {
            AxisAlignedBB cbb = null;
            try {
                cbb = this.world.getBlockState(this.getPos()).getCollisionBoundingBox(this.world, pos).addCoord(pos.getX(), pos.getY(), pos.getZ());
            }
            catch (Exception e) {
                cbb = new AxisAlignedBB(this.getPos().add(-1, 0, -1), this.getPos().add(1, 1, 1));
            }
            if (cbb != null) {
                bb = cbb;
            }
        }
        return bb;
    }

    public boolean canRenderBreaking() {
        Block block = this.getBlockType();
        return block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
    }

    public NBTTagCompound getTileData() {
        if (this.customTileData == null) {
            this.customTileData = new NBTTagCompound();
        }
        return this.customTileData;
    }

    public boolean restrictNBTCopy() {
        return this instanceof TileEntityCommandBlock || this instanceof TileEntityMobSpawner || this instanceof TileEntitySign;
    }

    public void onLoad() {
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        return this.capabilities == null ? null : (T)this.capabilities.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public void deserializeNBT(NBTTagCompound p_deserializeNBT_1_) {
        this.readFromNBT(p_deserializeNBT_1_);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.writeToNBT(ret);
        return ret;
    }

    static {
        TileEntity.register("furnace", TileEntityFurnace.class);
        TileEntity.register("chest", TileEntityChest.class);
        TileEntity.register("ender_chest", TileEntityEnderChest.class);
        TileEntity.register("jukebox", BlockJukebox.TileEntityJukebox.class);
        TileEntity.register("dispenser", TileEntityDispenser.class);
        TileEntity.register("dropper", TileEntityDropper.class);
        TileEntity.register("sign", TileEntitySign.class);
        TileEntity.register("mob_spawner", TileEntityMobSpawner.class);
        TileEntity.register("noteblock", TileEntityNote.class);
        TileEntity.register("piston", TileEntityPiston.class);
        TileEntity.register("brewing_stand", TileEntityBrewingStand.class);
        TileEntity.register("enchanting_table", TileEntityEnchantmentTable.class);
        TileEntity.register("end_portal", TileEntityEndPortal.class);
        TileEntity.register("beacon", TileEntityBeacon.class);
        TileEntity.register("skull", TileEntitySkull.class);
        TileEntity.register("daylight_detector", TileEntityDaylightDetector.class);
        TileEntity.register("hopper", TileEntityHopper.class);
        TileEntity.register("comparator", TileEntityComparator.class);
        TileEntity.register("flower_pot", TileEntityFlowerPot.class);
        TileEntity.register("banner", TileEntityBanner.class);
        TileEntity.register("structure_block", TileEntityStructure.class);
        TileEntity.register("end_gateway", TileEntityEndGateway.class);
        TileEntity.register("command_block", TileEntityCommandBlock.class);
        TileEntity.register("shulker_box", TileEntityShulkerBox.class);
    }
}

