/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBanner
extends TileEntity
implements IWorldNameable {
    private String name;
    private EnumDyeColor baseColor = EnumDyeColor.BLACK;
    private NBTTagList patterns;
    private boolean patternDataSet;
    private List<BannerPattern> patternList;
    private List<EnumDyeColor> colorList;
    private String patternResourceLocation;

    public void setItemValues(ItemStack p_setItemValues_1_, boolean p_setItemValues_2_) {
        this.patterns = null;
        NBTTagCompound lvt_3_1_ = p_setItemValues_1_.getSubCompound("BlockEntityTag");
        if (lvt_3_1_ != null && lvt_3_1_.hasKey("Patterns", 9)) {
            this.patterns = lvt_3_1_.getTagList("Patterns", 10).copy();
        }
        this.baseColor = p_setItemValues_2_ ? TileEntityBanner.getColor(p_setItemValues_1_) : ItemBanner.getBaseColor(p_setItemValues_1_);
        this.patternList = null;
        this.colorList = null;
        this.patternResourceLocation = "";
        this.patternDataSet = true;
        this.name = p_setItemValues_1_.hasDisplayName() ? p_setItemValues_1_.getDisplayName() : null;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.name : "banner";
    }

    @Override
    public boolean hasCustomName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setInteger("Base", this.baseColor.getDyeDamage());
        if (this.patterns != null) {
            p_writeToNBT_1_.setTag("Patterns", this.patterns);
        }
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.name);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.name = p_readFromNBT_1_.getString("CustomName");
        }
        this.baseColor = EnumDyeColor.byDyeDamage(p_readFromNBT_1_.getInteger("Base"));
        this.patterns = p_readFromNBT_1_.getTagList("Patterns", 10);
        this.patternList = null;
        this.colorList = null;
        this.patternResourceLocation = null;
        this.patternDataSet = true;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 6, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public static int getPatterns(ItemStack p_getPatterns_0_) {
        NBTTagCompound lvt_1_1_ = p_getPatterns_0_.getSubCompound("BlockEntityTag");
        if (lvt_1_1_ != null && lvt_1_1_.hasKey("Patterns")) {
            return lvt_1_1_.getTagList("Patterns", 10).tagCount();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BannerPattern> getPatternList() {
        this.initializeBannerData();
        return this.patternList;
    }

    @SideOnly(value=Side.CLIENT)
    public List<EnumDyeColor> getColorList() {
        this.initializeBannerData();
        return this.colorList;
    }

    @SideOnly(value=Side.CLIENT)
    public String getPatternResourceLocation() {
        this.initializeBannerData();
        return this.patternResourceLocation;
    }

    @SideOnly(value=Side.CLIENT)
    private void initializeBannerData() {
        if (this.patternList != null && this.colorList != null && this.patternResourceLocation != null) {
            return;
        }
        if (!this.patternDataSet) {
            this.patternResourceLocation = "";
            return;
        }
        this.patternList = Lists.newArrayList();
        this.colorList = Lists.newArrayList();
        this.patternList.add(BannerPattern.BASE);
        this.colorList.add(this.baseColor);
        this.patternResourceLocation = "b" + this.baseColor.getDyeDamage();
        if (this.patterns != null) {
            for (int lvt_1_1_ = 0; lvt_1_1_ < this.patterns.tagCount(); ++lvt_1_1_) {
                NBTTagCompound lvt_2_1_ = this.patterns.getCompoundTagAt(lvt_1_1_);
                BannerPattern lvt_3_1_ = BannerPattern.byHash(lvt_2_1_.getString("Pattern"));
                if (lvt_3_1_ == null) continue;
                this.patternList.add(lvt_3_1_);
                int lvt_4_1_ = lvt_2_1_.getInteger("Color");
                this.colorList.add(EnumDyeColor.byDyeDamage(lvt_4_1_));
                this.patternResourceLocation = this.patternResourceLocation + lvt_3_1_.getHashname() + lvt_4_1_;
            }
        }
    }

    public static void removeBannerData(ItemStack p_removeBannerData_0_) {
        NBTTagCompound lvt_1_1_ = p_removeBannerData_0_.getSubCompound("BlockEntityTag");
        if (lvt_1_1_ == null || !lvt_1_1_.hasKey("Patterns", 9)) {
            return;
        }
        NBTTagList lvt_2_1_ = lvt_1_1_.getTagList("Patterns", 10);
        if (lvt_2_1_.hasNoTags()) {
            return;
        }
        lvt_2_1_.removeTag(lvt_2_1_.tagCount() - 1);
        if (lvt_2_1_.hasNoTags()) {
            p_removeBannerData_0_.getTagCompound().removeTag("BlockEntityTag");
            if (p_removeBannerData_0_.getTagCompound().hasNoTags()) {
                p_removeBannerData_0_.setTagCompound(null);
            }
        }
    }

    public ItemStack getItem() {
        ItemStack lvt_1_1_ = ItemBanner.makeBanner(this.baseColor, this.patterns);
        if (this.hasCustomName()) {
            lvt_1_1_.setStackDisplayName(this.getName());
        }
        return lvt_1_1_;
    }

    public static EnumDyeColor getColor(ItemStack p_getColor_0_) {
        NBTTagCompound lvt_1_1_ = p_getColor_0_.getSubCompound("BlockEntityTag");
        if (lvt_1_1_ != null && lvt_1_1_.hasKey("Base")) {
            return EnumDyeColor.byDyeDamage(lvt_1_1_.getInteger("Base"));
        }
        return EnumDyeColor.BLACK;
    }
}

