/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeacon
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    public static final Potion[][] EFFECTS_LIST = new Potion[][]{{MobEffects.SPEED, MobEffects.HASTE}, {MobEffects.RESISTANCE, MobEffects.JUMP_BOOST}, {MobEffects.STRENGTH}, {MobEffects.REGENERATION}};
    private static final Set<Potion> VALID_EFFECTS = Sets.newHashSet();
    private final List<BeamSegment> beamSegments = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;
    private boolean isComplete;
    private int levels = -1;
    @Nullable
    private Potion primaryEffect;
    @Nullable
    private Potion secondaryEffect;
    private ItemStack payment = ItemStack.EMPTY;
    private String customName;

    @Override
    public void update() {
        if (this.world.getTotalWorldTime() % 80L == 0L) {
            this.updateBeacon();
        }
    }

    public void updateBeacon() {
        if (this.world != null) {
            this.updateSegmentColors();
            this.addEffectsToPlayers();
        }
    }

    private void addEffectsToPlayers() {
        if (this.isComplete && this.levels > 0 && !this.world.isRemote && this.primaryEffect != null) {
            double d0 = this.levels * 10 + 10;
            int i = 0;
            if (this.levels >= 4 && this.primaryEffect == this.secondaryEffect) {
                i = 1;
            }
            int j = (9 + this.levels * 2) * 20;
            int k = this.pos.getX();
            int l = this.pos.getY();
            int i1 = this.pos.getZ();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(k, l, i1, k + 1, l + 1, i1 + 1).expandXyz(d0).addCoord(0.0, this.world.getHeight(), 0.0);
            List<EntityPlayer> list = this.world.getEntitiesWithinAABB(EntityPlayer.class, axisalignedbb);
            for (EntityPlayer entityplayer : list) {
                entityplayer.addPotionEffect(new PotionEffect(this.primaryEffect, j, i, true, true));
            }
            if (this.levels >= 4 && this.primaryEffect != this.secondaryEffect && this.secondaryEffect != null) {
                for (EntityPlayer entityplayer1 : list) {
                    entityplayer1.addPotionEffect(new PotionEffect(this.secondaryEffect, j, 0, true, true));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateSegmentColors() {
        i = this.levels;
        j = this.pos.getX();
        k = this.pos.getY();
        l = this.pos.getZ();
        this.levels = 0;
        this.beamSegments.clear();
        this.isComplete = true;
        tileentitybeacon$beamsegment = new BeamSegment(EntitySheep.getDyeRgb(EnumDyeColor.WHITE));
        this.beamSegments.add(tileentitybeacon$beamsegment);
        flag = true;
        blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (i1 = k + 1; i1 < 256; ++i1) {
            block15: {
                block14: {
                    iblockstate = this.world.getBlockState(blockpos$mutableblockpos.setPos(j, i1, l));
                    if (iblockstate.getBlock() != Blocks.STAINED_GLASS) break block14;
                    afloat = EntitySheep.getDyeRgb(iblockstate.getValue(BlockStainedGlass.COLOR));
                    break block15;
                }
                if (iblockstate.getBlock() == Blocks.STAINED_GLASS_PANE) ** GOTO lbl30
                if (iblockstate.getLightOpacity(this.world, blockpos$mutableblockpos) >= 15 && iblockstate.getBlock() != Blocks.BEDROCK) {
                    this.isComplete = false;
                    this.beamSegments.clear();
                    break;
                }
                customColor = iblockstate.getBlock().getBeaconColorMultiplier(iblockstate, this.world, blockpos$mutableblockpos, this.getPos());
                if (customColor != null) {
                    afloat = customColor;
                } else {
                    tileentitybeacon$beamsegment.incrementHeight();
                    continue;
lbl30:
                    // 1 sources

                    afloat = EntitySheep.getDyeRgb(iblockstate.getValue(BlockStainedGlassPane.COLOR));
                }
            }
            if (!flag) {
                afloat = new float[]{(tileentitybeacon$beamsegment.getColors()[0] + afloat[0]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[1] + afloat[1]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[2] + afloat[2]) / 2.0f};
            }
            if (Arrays.equals(afloat, tileentitybeacon$beamsegment.getColors())) {
                tileentitybeacon$beamsegment.incrementHeight();
            } else {
                tileentitybeacon$beamsegment = new BeamSegment(afloat);
                this.beamSegments.add(tileentitybeacon$beamsegment);
            }
            flag = false;
        }
        if (this.isComplete) {
            l1 = 1;
            while (l1 <= 4 && (i2 = k - l1) >= 0) {
                flag1 = true;
                block2: for (j1 = j - l1; j1 <= j + l1 && flag1; ++j1) {
                    for (k1 = l - l1; k1 <= l + l1; ++k1) {
                        block = this.world.getBlockState(new BlockPos(j1, i2, k1)).getBlock();
                        if (block.isBeaconBase(this.world, new BlockPos(j1, i2, k1), this.getPos())) continue;
                        flag1 = false;
                        continue block2;
                    }
                }
                if (!flag1) break;
                this.levels = l1++;
            }
            if (this.levels == 0) {
                this.isComplete = false;
            }
        }
        if (!this.world.isRemote && this.levels == 4 && i < this.levels) {
            for (EntityPlayer entityplayer : this.world.getEntitiesWithinAABB(EntityPlayer.class, new AxisAlignedBB(j, k, l, j, k - 4, l).expand(10.0, 5.0, 10.0))) {
                entityplayer.addStat(AchievementList.FULL_BEACON);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.beamSegments;
    }

    @SideOnly(value=Side.CLIENT)
    public float shouldBeamRender() {
        if (!this.isComplete) {
            return 0.0f;
        }
        int i = (int)(this.world.getTotalWorldTime() - this.beamRenderCounter);
        this.beamRenderCounter = this.world.getTotalWorldTime();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 3, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 65536.0;
    }

    @Nullable
    private static Potion isBeaconEffect(int p_isBeaconEffect_0_) {
        Potion potion = Potion.getPotionById(p_isBeaconEffect_0_);
        return VALID_EFFECTS.contains(potion) ? potion : null;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.primaryEffect = TileEntityBeacon.isBeaconEffect(p_readFromNBT_1_.getInteger("Primary"));
        this.secondaryEffect = TileEntityBeacon.isBeaconEffect(p_readFromNBT_1_.getInteger("Secondary"));
        this.levels = p_readFromNBT_1_.getInteger("Levels");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setInteger("Primary", Potion.getIdFromPotion(this.primaryEffect));
        p_writeToNBT_1_.setInteger("Secondary", Potion.getIdFromPotion(this.secondaryEffect));
        p_writeToNBT_1_.setInteger("Levels", this.levels);
        return p_writeToNBT_1_;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.payment.isEmpty();
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        return p_getStackInSlot_1_ == 0 ? this.payment : ItemStack.EMPTY;
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        if (p_decrStackSize_1_ == 0 && !this.payment.isEmpty()) {
            if (p_decrStackSize_2_ >= this.payment.getCount()) {
                ItemStack itemstack = this.payment;
                this.payment = ItemStack.EMPTY;
                return itemstack;
            }
            return this.payment.splitStack(p_decrStackSize_2_);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        if (p_removeStackFromSlot_1_ == 0) {
            ItemStack itemstack = this.payment;
            this.payment = ItemStack.EMPTY;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        if (p_setInventorySlotContents_1_ == 0) {
            this.payment = p_setInventorySlotContents_2_;
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.beacon";
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setName(String p_setName_1_) {
        this.customName = p_setName_1_;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.world.getTileEntity(this.pos) != this ? false : p_isUsableByPlayer_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return p_isItemValidForSlot_2_.getItem() != null && p_isItemValidForSlot_2_.getItem().isBeaconPayment(p_isItemValidForSlot_2_);
    }

    @Override
    public String getGuiID() {
        return "minecraft:beacon";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerBeacon(p_createContainer_1_, this);
    }

    @Override
    public int getField(int p_getField_1_) {
        switch (p_getField_1_) {
            case 0: {
                return this.levels;
            }
            case 1: {
                return Potion.getIdFromPotion(this.primaryEffect);
            }
            case 2: {
                return Potion.getIdFromPotion(this.secondaryEffect);
            }
        }
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
        switch (p_setField_1_) {
            case 0: {
                this.levels = p_setField_2_;
                break;
            }
            case 1: {
                this.primaryEffect = TileEntityBeacon.isBeaconEffect(p_setField_2_);
                break;
            }
            case 2: {
                this.secondaryEffect = TileEntityBeacon.isBeaconEffect(p_setField_2_);
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public void clear() {
        this.payment = ItemStack.EMPTY;
    }

    @Override
    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        if (p_receiveClientEvent_1_ == 1) {
            this.updateBeacon();
            return true;
        }
        return super.receiveClientEvent(p_receiveClientEvent_1_, p_receiveClientEvent_2_);
    }

    @Override
    public int[] getSlotsForFace(EnumFacing p_getSlotsForFace_1_) {
        return new int[0];
    }

    @Override
    public boolean canInsertItem(int p_canInsertItem_1_, ItemStack p_canInsertItem_2_, EnumFacing p_canInsertItem_3_) {
        return false;
    }

    @Override
    public boolean canExtractItem(int p_canExtractItem_1_, ItemStack p_canExtractItem_2_, EnumFacing p_canExtractItem_3_) {
        return false;
    }

    static {
        for (Potion[] apotion : EFFECTS_LIST) {
            Collections.addAll(VALID_EFFECTS, apotion);
        }
    }

    public static class BeamSegment {
        private final float[] colors;
        private int height;

        public BeamSegment(float[] p_i45669_1_) {
            this.colors = p_i45669_1_;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        public float[] getColors() {
            return this.colors;
        }

        @SideOnly(value=Side.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }
}

