/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Arrays;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityBrewingStand
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.withSize(5, ItemStack.EMPTY);
    private int brewTime;
    private boolean[] filledSlots;
    private Item ingredientID;
    private String customName;
    private int fuel;
    IItemHandler handlerInput = new SidedInvWrapper(this, EnumFacing.UP);
    IItemHandler handlerOutput = new SidedInvWrapper(this, EnumFacing.DOWN);
    IItemHandler handlerSides = new SidedInvWrapper(this, EnumFacing.NORTH);

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.brewing";
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setName(String p_setName_1_) {
        this.customName = p_setName_1_;
    }

    @Override
    public int getSizeInventory() {
        return this.brewingItemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update() {
        boolean[] aboolean;
        ItemStack itemstack = this.brewingItemStacks.get(4);
        if (this.fuel <= 0 && itemstack.getItem() == Items.BLAZE_POWDER) {
            this.fuel = 20;
            itemstack.shrink(1);
            this.markDirty();
        }
        boolean flag = this.canBrew();
        boolean flag1 = this.brewTime > 0;
        ItemStack itemstack1 = this.brewingItemStacks.get(3);
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                this.brewPotions();
                this.markDirty();
            } else if (!flag) {
                this.brewTime = 0;
                this.markDirty();
            } else if (this.ingredientID != itemstack1.getItem()) {
                this.brewTime = 0;
                this.markDirty();
            }
        } else if (flag && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.ingredientID = itemstack1.getItem();
            this.markDirty();
        }
        if (!this.world.isRemote && !Arrays.equals(aboolean = this.createFilledSlotsArray(), this.filledSlots)) {
            this.filledSlots = aboolean;
            IBlockState iblockstate = this.world.getBlockState(this.getPos());
            if (!(iblockstate.getBlock() instanceof BlockBrewingStand)) {
                return;
            }
            for (int i = 0; i < BlockBrewingStand.HAS_BOTTLE.length; ++i) {
                iblockstate = iblockstate.withProperty(BlockBrewingStand.HAS_BOTTLE[i], aboolean[i]);
            }
            this.world.setBlockState(this.pos, iblockstate, 2);
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.brewingItemStacks.get(i).isEmpty()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        return BrewingRecipeRegistry.canBrew(this.brewingItemStacks, this.brewingItemStacks.get(3), OUTPUT_SLOTS);
    }

    private void brewPotions() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.brewingItemStacks)) {
            return;
        }
        ItemStack itemstack = this.brewingItemStacks.get(3);
        BrewingRecipeRegistry.brewPotions(this.brewingItemStacks, this.brewingItemStacks.get(3), OUTPUT_SLOTS);
        itemstack.shrink(1);
        BlockPos blockpos = this.getPos();
        if (itemstack.getItem().hasContainerItem(itemstack)) {
            ItemStack itemstack1 = itemstack.getItem().getContainerItem(itemstack);
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else {
                InventoryHelper.spawnItemStack(this.world, blockpos.getX(), blockpos.getY(), blockpos.getZ(), itemstack1);
            }
        }
        this.brewingItemStacks.set(3, itemstack);
        this.world.playEvent(1035, blockpos, 0);
        ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
    }

    public static void registerFixesBrewingStand(DataFixer p_registerFixesBrewingStand_0_) {
        p_registerFixesBrewingStand_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists(TileEntityBrewingStand.class, "Items"));
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.brewingItemStacks = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        ItemStackHelper.loadAllItems(p_readFromNBT_1_, this.brewingItemStacks);
        this.brewTime = p_readFromNBT_1_.getShort("BrewTime");
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.customName = p_readFromNBT_1_.getString("CustomName");
        }
        this.fuel = p_readFromNBT_1_.getByte("Fuel");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setShort("BrewTime", (short)this.brewTime);
        ItemStackHelper.saveAllItems(p_writeToNBT_1_, this.brewingItemStacks);
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.customName);
        }
        p_writeToNBT_1_.setByte("Fuel", (byte)this.fuel);
        return p_writeToNBT_1_;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        return p_getStackInSlot_1_ >= 0 && p_getStackInSlot_1_ < this.brewingItemStacks.size() ? this.brewingItemStacks.get(p_getStackInSlot_1_) : ItemStack.EMPTY;
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        return ItemStackHelper.getAndSplit(this.brewingItemStacks, p_decrStackSize_1_, p_decrStackSize_2_);
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        return ItemStackHelper.getAndRemove(this.brewingItemStacks, p_removeStackFromSlot_1_);
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        if (p_setInventorySlotContents_1_ >= 0 && p_setInventorySlotContents_1_ < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.world.getTileEntity(this.pos) != this ? false : p_isUsableByPlayer_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        if (p_isItemValidForSlot_1_ == 3) {
            return BrewingRecipeRegistry.isValidIngredient(p_isItemValidForSlot_2_);
        }
        Item item = p_isItemValidForSlot_2_.getItem();
        return p_isItemValidForSlot_1_ == 4 ? item == Items.BLAZE_POWDER : BrewingRecipeRegistry.isValidInput(p_isItemValidForSlot_2_) && this.getStackInSlot(p_isItemValidForSlot_1_).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(EnumFacing p_getSlotsForFace_1_) {
        return p_getSlotsForFace_1_ == EnumFacing.UP ? SLOTS_FOR_UP : (p_getSlotsForFace_1_ == EnumFacing.DOWN ? SLOTS_FOR_DOWN : OUTPUT_SLOTS);
    }

    @Override
    public boolean canInsertItem(int p_canInsertItem_1_, ItemStack p_canInsertItem_2_, EnumFacing p_canInsertItem_3_) {
        return this.isItemValidForSlot(p_canInsertItem_1_, p_canInsertItem_2_);
    }

    @Override
    public boolean canExtractItem(int p_canExtractItem_1_, ItemStack p_canExtractItem_2_, EnumFacing p_canExtractItem_3_) {
        return p_canExtractItem_1_ == 3 ? p_canExtractItem_2_.getItem() == Items.GLASS_BOTTLE : true;
    }

    @Override
    public String getGuiID() {
        return "minecraft:brewing_stand";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerBrewingStand(p_createContainer_1_, this);
    }

    @Override
    public int getField(int p_getField_1_) {
        switch (p_getField_1_) {
            case 0: {
                return this.brewTime;
            }
            case 1: {
                return this.fuel;
            }
        }
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
        switch (p_setField_1_) {
            case 0: {
                this.brewTime = p_setField_2_;
                break;
            }
            case 1: {
                this.fuel = p_setField_2_;
            }
        }
    }

    @Override
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        if (p_getCapability_2_ != null && p_getCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (p_getCapability_2_ == EnumFacing.UP) {
                return (T)this.handlerInput;
            }
            if (p_getCapability_2_ == EnumFacing.DOWN) {
                return (T)this.handlerOutput;
            }
            return (T)this.handlerSides;
        }
        return super.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public void clear() {
        this.brewingItemStacks.clear();
    }
}

