/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCommandBlock
extends TileEntity {
    private boolean powered;
    private boolean auto;
    private boolean conditionMet;
    private boolean sendToClient;
    private final CommandBlockBaseLogic commandBlockLogic = new CommandBlockBaseLogic(){

        @Override
        public BlockPos getPosition() {
            return TileEntityCommandBlock.this.pos;
        }

        @Override
        public Vec3d getPositionVector() {
            return new Vec3d((double)TileEntityCommandBlock.this.pos.getX() + 0.5, (double)TileEntityCommandBlock.this.pos.getY() + 0.5, (double)TileEntityCommandBlock.this.pos.getZ() + 0.5);
        }

        @Override
        public World getEntityWorld() {
            return TileEntityCommandBlock.this.getWorld();
        }

        @Override
        public void setCommand(String p_setCommand_1_) {
            super.setCommand(p_setCommand_1_);
            TileEntityCommandBlock.this.markDirty();
        }

        @Override
        public void updateCommand() {
            IBlockState lvt_1_1_ = TileEntityCommandBlock.this.world.getBlockState(TileEntityCommandBlock.this.pos);
            TileEntityCommandBlock.this.getWorld().notifyBlockUpdate(TileEntityCommandBlock.this.pos, lvt_1_1_, lvt_1_1_, 3);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getCommandBlockType() {
            return 0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void fillInInfo(ByteBuf p_fillInInfo_1_) {
            p_fillInInfo_1_.writeInt(TileEntityCommandBlock.this.pos.getX());
            p_fillInInfo_1_.writeInt(TileEntityCommandBlock.this.pos.getY());
            p_fillInInfo_1_.writeInt(TileEntityCommandBlock.this.pos.getZ());
        }

        @Override
        public Entity getCommandSenderEntity() {
            return null;
        }

        @Override
        public MinecraftServer getServer() {
            return TileEntityCommandBlock.this.world.getMinecraftServer();
        }
    };

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        this.commandBlockLogic.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setBoolean("powered", this.isPowered());
        p_writeToNBT_1_.setBoolean("conditionMet", this.isConditionMet());
        p_writeToNBT_1_.setBoolean("auto", this.isAuto());
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.commandBlockLogic.readDataFromNBT(p_readFromNBT_1_);
        this.setPowered(p_readFromNBT_1_.getBoolean("powered"));
        this.setConditionMet(p_readFromNBT_1_.getBoolean("conditionMet"));
        this.setAuto(p_readFromNBT_1_.getBoolean("auto"));
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        if (this.isSendToClient()) {
            this.setSendToClient(false);
            NBTTagCompound lvt_1_1_ = this.writeToNBT(new NBTTagCompound());
            return new SPacketUpdateTileEntity(this.pos, 2, lvt_1_1_);
        }
        return null;
    }

    @Override
    public boolean onlyOpsCanSetNbt() {
        return true;
    }

    public CommandBlockBaseLogic getCommandBlockLogic() {
        return this.commandBlockLogic;
    }

    public CommandResultStats getCommandResultStats() {
        return this.commandBlockLogic.getCommandResultStats();
    }

    public void setPowered(boolean p_setPowered_1_) {
        this.powered = p_setPowered_1_;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean p_setAuto_1_) {
        Block lvt_3_1_;
        boolean lvt_2_1_ = this.auto;
        this.auto = p_setAuto_1_;
        if (!lvt_2_1_ && p_setAuto_1_ && !this.powered && this.world != null && this.getMode() != Mode.SEQUENCE && (lvt_3_1_ = this.getBlockType()) instanceof BlockCommandBlock) {
            BlockPos lvt_4_1_ = this.getPos();
            BlockCommandBlock lvt_5_1_ = (BlockCommandBlock)lvt_3_1_;
            this.conditionMet = !this.isConditional() || lvt_5_1_.isNextToSuccessfulCommandBlock(this.world, lvt_4_1_, this.world.getBlockState(lvt_4_1_));
            this.world.scheduleUpdate(lvt_4_1_, lvt_3_1_, lvt_3_1_.tickRate(this.world));
            if (this.conditionMet) {
                lvt_5_1_.propagateUpdate(this.world, lvt_4_1_);
            }
        }
    }

    public boolean isConditionMet() {
        return this.conditionMet;
    }

    public void setConditionMet(boolean p_setConditionMet_1_) {
        this.conditionMet = p_setConditionMet_1_;
    }

    public boolean isSendToClient() {
        return this.sendToClient;
    }

    public void setSendToClient(boolean p_setSendToClient_1_) {
        this.sendToClient = p_setSendToClient_1_;
    }

    public Mode getMode() {
        Block lvt_1_1_ = this.getBlockType();
        if (lvt_1_1_ == Blocks.COMMAND_BLOCK) {
            return Mode.REDSTONE;
        }
        if (lvt_1_1_ == Blocks.REPEATING_COMMAND_BLOCK) {
            return Mode.AUTO;
        }
        if (lvt_1_1_ == Blocks.CHAIN_COMMAND_BLOCK) {
            return Mode.SEQUENCE;
        }
        return Mode.REDSTONE;
    }

    public boolean isConditional() {
        IBlockState lvt_1_1_ = this.world.getBlockState(this.getPos());
        if (lvt_1_1_.getBlock() instanceof BlockCommandBlock) {
            return lvt_1_1_.getValue(BlockCommandBlock.CONDITIONAL);
        }
        return false;
    }

    @Override
    public void validate() {
        this.blockType = null;
        super.validate();
    }

    public static enum Mode {
        SEQUENCE,
        AUTO,
        REDSTONE;

    }
}

