/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;

public class TileEntityDispenser
extends TileEntityLockableLoot {
    private static final Random RNG = new Random();
    private NonNullList<ItemStack> stacks = NonNullList.withSize(9, ItemStack.EMPTY);

    @Override
    public int getSizeInventory() {
        return 9;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack lvt_2_1_ : this.stacks) {
            if (lvt_2_1_.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getDispenseSlot() {
        this.fillWithLoot(null);
        int lvt_1_1_ = -1;
        int lvt_2_1_ = 1;
        for (int lvt_3_1_ = 0; lvt_3_1_ < this.stacks.size(); ++lvt_3_1_) {
            if (this.stacks.get(lvt_3_1_).isEmpty() || RNG.nextInt(lvt_2_1_++) != 0) continue;
            lvt_1_1_ = lvt_3_1_;
        }
        return lvt_1_1_;
    }

    public int addItemStack(ItemStack p_addItemStack_1_) {
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.stacks.size(); ++lvt_2_1_) {
            if (!this.stacks.get(lvt_2_1_).isEmpty()) continue;
            this.setInventorySlotContents(lvt_2_1_, p_addItemStack_1_);
            return lvt_2_1_;
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.dispenser";
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists(TileEntityDispenser.class, "Items"));
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.stacks = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        if (!this.checkLootAndRead(p_readFromNBT_1_)) {
            ItemStackHelper.loadAllItems(p_readFromNBT_1_, this.stacks);
        }
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.customName = p_readFromNBT_1_.getString("CustomName");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        if (!this.checkLootAndWrite(p_writeToNBT_1_)) {
            ItemStackHelper.saveAllItems(p_writeToNBT_1_, this.stacks);
        }
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.customName);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public String getGuiID() {
        return "minecraft:dispenser";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        this.fillWithLoot(p_createContainer_2_);
        return new ContainerDispenser(p_createContainer_1_, this);
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }
}

