/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;

public class TileEntityEnchantmentTable
extends TileEntity
implements ITickable,
IInteractionObject {
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation;
    public float bookRotationPrev;
    public float tRot;
    private static final Random rand = new Random();
    private String customName;

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.customName);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.customName = p_readFromNBT_1_.getString("CustomName");
        }
    }

    @Override
    public void update() {
        float lvt_2_2_;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        EntityPlayer lvt_1_1_ = this.world.getClosestPlayer((double)((float)this.pos.getX() + 0.5f), (double)((float)this.pos.getY() + 0.5f), (double)((float)this.pos.getZ() + 0.5f), 3.0, false);
        if (lvt_1_1_ != null) {
            double lvt_2_1_ = lvt_1_1_.posX - (double)((float)this.pos.getX() + 0.5f);
            double lvt_4_1_ = lvt_1_1_.posZ - (double)((float)this.pos.getZ() + 0.5f);
            this.tRot = (float)MathHelper.atan2(lvt_4_1_, lvt_2_1_);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float lvt_6_1_ = this.flipT;
                do {
                    this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
                } while (lvt_6_1_ == this.flipT);
            }
        } else {
            this.tRot += 0.02f;
            this.bookSpread -= 0.1f;
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (lvt_2_2_ = this.tRot - this.bookRotation; lvt_2_2_ >= (float)Math.PI; lvt_2_2_ -= (float)Math.PI * 2) {
        }
        while (lvt_2_2_ < (float)(-Math.PI)) {
            lvt_2_2_ += (float)Math.PI * 2;
        }
        this.bookRotation += lvt_2_2_ * 0.4f;
        this.bookSpread = MathHelper.clamp(this.bookSpread, 0.0f, 1.0f);
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float lvt_3_1_ = (this.flipT - this.pageFlip) * 0.4f;
        float lvt_4_2_ = 0.2f;
        lvt_3_1_ = MathHelper.clamp(lvt_3_1_, -0.2f, 0.2f);
        this.flipA += (lvt_3_1_ - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.enchant";
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String p_setCustomName_1_) {
        this.customName = p_setCustomName_1_;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerEnchantment(p_createContainer_1_, this.world, this.pos);
    }

    @Override
    public String getGuiID() {
        return "minecraft:enchanting_table";
    }
}

