/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenEndGateway;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileEntityEndGateway
extends TileEntityEndPortal
implements ITickable {
    private static final Logger LOG = LogManager.getLogger();
    private long age;
    private int teleportCooldown;
    private BlockPos exitPortal;
    private boolean exactTeleport;

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setLong("Age", this.age);
        if (this.exitPortal != null) {
            p_writeToNBT_1_.setTag("ExitPortal", NBTUtil.createPosTag(this.exitPortal));
        }
        if (this.exactTeleport) {
            p_writeToNBT_1_.setBoolean("ExactTeleport", this.exactTeleport);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.age = p_readFromNBT_1_.getLong("Age");
        if (p_readFromNBT_1_.hasKey("ExitPortal", 10)) {
            this.exitPortal = NBTUtil.getPosFromTag(p_readFromNBT_1_.getCompoundTag("ExitPortal"));
        }
        this.exactTeleport = p_readFromNBT_1_.getBoolean("ExactTeleport");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 65536.0;
    }

    @Override
    public void update() {
        boolean lvt_1_1_ = this.isSpawning();
        boolean lvt_2_1_ = this.isCoolingDown();
        ++this.age;
        if (lvt_2_1_) {
            --this.teleportCooldown;
        } else if (!this.world.isRemote) {
            List<Entity> lvt_3_1_ = this.world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB(this.getPos()));
            if (!lvt_3_1_.isEmpty()) {
                this.teleportEntity(lvt_3_1_.get(0));
            }
            if (this.age % 2400L == 0L) {
                this.triggerCooldown();
            }
        }
        if (lvt_1_1_ != this.isSpawning() || lvt_2_1_ != this.isCoolingDown()) {
            this.markDirty();
        }
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSpawnPercent(float p_getSpawnPercent_1_) {
        return MathHelper.clamp(((float)this.age + p_getSpawnPercent_1_) / 200.0f, 0.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCooldownPercent(float p_getCooldownPercent_1_) {
        return 1.0f - MathHelper.clamp(((float)this.teleportCooldown - p_getCooldownPercent_1_) / 40.0f, 0.0f, 1.0f);
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 8, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void triggerCooldown() {
        if (!this.world.isRemote) {
            this.teleportCooldown = 40;
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 1, 0);
            this.markDirty();
        }
    }

    @Override
    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        if (p_receiveClientEvent_1_ == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.receiveClientEvent(p_receiveClientEvent_1_, p_receiveClientEvent_2_);
    }

    public void teleportEntity(Entity p_teleportEntity_1_) {
        if (this.world.isRemote || this.isCoolingDown()) {
            return;
        }
        this.teleportCooldown = 100;
        if (this.exitPortal == null && this.world.provider instanceof WorldProviderEnd) {
            this.findExitPortal();
        }
        if (this.exitPortal != null) {
            BlockPos lvt_2_1_ = this.exactTeleport ? this.exitPortal : this.findExitPosition();
            p_teleportEntity_1_.setPositionAndUpdate((double)lvt_2_1_.getX() + 0.5, (double)lvt_2_1_.getY() + 0.5, (double)lvt_2_1_.getZ() + 0.5);
        }
        this.triggerCooldown();
    }

    private BlockPos findExitPosition() {
        BlockPos lvt_1_1_ = TileEntityEndGateway.findHighestBlock(this.world, this.exitPortal, 5, false);
        LOG.debug("Best exit position for portal at {} is {}", new Object[]{this.exitPortal, lvt_1_1_});
        return lvt_1_1_.up();
    }

    private void findExitPortal() {
        Vec3d lvt_1_1_ = new Vec3d(this.getPos().getX(), 0.0, this.getPos().getZ()).normalize();
        Vec3d lvt_2_1_ = lvt_1_1_.scale(1024.0);
        int lvt_3_1_ = 16;
        while (TileEntityEndGateway.getChunk(this.world, lvt_2_1_).getTopFilledSegment() > 0 && lvt_3_1_-- > 0) {
            LOG.debug("Skipping backwards past nonempty chunk at {}", new Object[]{lvt_2_1_});
            lvt_2_1_ = lvt_2_1_.add(lvt_1_1_.scale(-16.0));
        }
        lvt_3_1_ = 16;
        while (TileEntityEndGateway.getChunk(this.world, lvt_2_1_).getTopFilledSegment() == 0 && lvt_3_1_-- > 0) {
            LOG.debug("Skipping forward past empty chunk at {}", new Object[]{lvt_2_1_});
            lvt_2_1_ = lvt_2_1_.add(lvt_1_1_.scale(16.0));
        }
        LOG.debug("Found chunk at {}", new Object[]{lvt_2_1_});
        Chunk lvt_4_1_ = TileEntityEndGateway.getChunk(this.world, lvt_2_1_);
        this.exitPortal = TileEntityEndGateway.findSpawnpointInChunk(lvt_4_1_);
        if (this.exitPortal == null) {
            this.exitPortal = new BlockPos(lvt_2_1_.xCoord + 0.5, 75.0, lvt_2_1_.zCoord + 0.5);
            LOG.debug("Failed to find suitable block, settling on {}", new Object[]{this.exitPortal});
            new WorldGenEndIsland().generate(this.world, new Random(this.exitPortal.toLong()), this.exitPortal);
        } else {
            LOG.debug("Found block at {}", new Object[]{this.exitPortal});
        }
        this.exitPortal = TileEntityEndGateway.findHighestBlock(this.world, this.exitPortal, 16, true);
        LOG.debug("Creating portal at {}", new Object[]{this.exitPortal});
        this.exitPortal = this.exitPortal.up(10);
        this.createExitPortal(this.exitPortal);
        this.markDirty();
    }

    private static BlockPos findHighestBlock(World p_findHighestBlock_0_, BlockPos p_findHighestBlock_1_, int p_findHighestBlock_2_, boolean p_findHighestBlock_3_) {
        Vec3i lvt_4_1_ = null;
        for (int lvt_5_1_ = -p_findHighestBlock_2_; lvt_5_1_ <= p_findHighestBlock_2_; ++lvt_5_1_) {
            block1: for (int lvt_6_1_ = -p_findHighestBlock_2_; lvt_6_1_ <= p_findHighestBlock_2_; ++lvt_6_1_) {
                if (lvt_5_1_ == 0 && lvt_6_1_ == 0 && !p_findHighestBlock_3_) continue;
                for (int lvt_7_1_ = 255; lvt_7_1_ > (lvt_4_1_ == null ? 0 : lvt_4_1_.getY()); --lvt_7_1_) {
                    BlockPos lvt_8_1_ = new BlockPos(p_findHighestBlock_1_.getX() + lvt_5_1_, lvt_7_1_, p_findHighestBlock_1_.getZ() + lvt_6_1_);
                    IBlockState lvt_9_1_ = p_findHighestBlock_0_.getBlockState(lvt_8_1_);
                    if (!lvt_9_1_.isBlockNormalCube() || !p_findHighestBlock_3_ && lvt_9_1_.getBlock() == Blocks.BEDROCK) continue;
                    lvt_4_1_ = lvt_8_1_;
                    continue block1;
                }
            }
        }
        return lvt_4_1_ == null ? p_findHighestBlock_1_ : lvt_4_1_;
    }

    private static Chunk getChunk(World p_getChunk_0_, Vec3d p_getChunk_1_) {
        return p_getChunk_0_.getChunkFromChunkCoords(MathHelper.floor(p_getChunk_1_.xCoord / 16.0), MathHelper.floor(p_getChunk_1_.zCoord / 16.0));
    }

    @Nullable
    private static BlockPos findSpawnpointInChunk(Chunk p_findSpawnpointInChunk_0_) {
        BlockPos lvt_1_1_ = new BlockPos(p_findSpawnpointInChunk_0_.xPosition * 16, 30, p_findSpawnpointInChunk_0_.zPosition * 16);
        int lvt_2_1_ = p_findSpawnpointInChunk_0_.getTopFilledSegment() + 16 - 1;
        BlockPos lvt_3_1_ = new BlockPos(p_findSpawnpointInChunk_0_.xPosition * 16 + 16 - 1, lvt_2_1_, p_findSpawnpointInChunk_0_.zPosition * 16 + 16 - 1);
        BlockPos lvt_4_1_ = null;
        double lvt_5_1_ = 0.0;
        for (BlockPos lvt_8_1_ : BlockPos.getAllInBox(lvt_1_1_, lvt_3_1_)) {
            IBlockState lvt_9_1_ = p_findSpawnpointInChunk_0_.getBlockState(lvt_8_1_);
            if (lvt_9_1_.getBlock() != Blocks.END_STONE || p_findSpawnpointInChunk_0_.getBlockState(lvt_8_1_.up(1)).isBlockNormalCube() || p_findSpawnpointInChunk_0_.getBlockState(lvt_8_1_.up(2)).isBlockNormalCube()) continue;
            double lvt_10_1_ = lvt_8_1_.distanceSqToCenter(0.0, 0.0, 0.0);
            if (lvt_4_1_ != null && !(lvt_10_1_ < lvt_5_1_)) continue;
            lvt_4_1_ = lvt_8_1_;
            lvt_5_1_ = lvt_10_1_;
        }
        return lvt_4_1_;
    }

    private void createExitPortal(BlockPos p_createExitPortal_1_) {
        new WorldGenEndGateway().generate(this.world, new Random(), p_createExitPortal_1_);
        TileEntity lvt_2_1_ = this.world.getTileEntity(p_createExitPortal_1_);
        if (lvt_2_1_ instanceof TileEntityEndGateway) {
            TileEntityEndGateway lvt_3_1_ = (TileEntityEndGateway)lvt_2_1_;
            lvt_3_1_.exitPortal = new BlockPos(this.getPos());
            lvt_3_1_.markDirty();
        } else {
            LOG.warn("Couldn't save exit portal at {}", new Object[]{p_createExitPortal_1_});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderFace(EnumFacing p_shouldRenderFace_1_) {
        return this.getBlockType().getDefaultState().shouldSideBeRendered(this.world, this.getPos(), p_shouldRenderFace_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public int getParticleAmount() {
        int lvt_1_1_ = 0;
        for (EnumFacing lvt_5_1_ : EnumFacing.values()) {
            lvt_1_1_ += this.shouldRenderFace(lvt_5_1_) ? 1 : 0;
        }
        return lvt_1_1_;
    }

    public void setExactPosition(BlockPos p_setExactPosition_1_) {
        this.exactTeleport = true;
        this.exitPortal = p_setExactPosition_1_;
    }
}

