/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityEnderChest
extends TileEntity
implements ITickable {
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;

    @Override
    public void update() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.world.addBlockEvent(this.pos, Blocks.ENDER_CHEST, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        int lvt_1_1_ = this.pos.getX();
        int lvt_2_1_ = this.pos.getY();
        int lvt_3_1_ = this.pos.getZ();
        float lvt_4_1_ = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double lvt_5_1_ = (double)lvt_1_1_ + 0.5;
            double lvt_7_1_ = (double)lvt_3_1_ + 0.5;
            this.world.playSound(null, lvt_5_1_, (double)lvt_2_1_ + 0.5, lvt_7_1_, SoundEvents.BLOCK_ENDERCHEST_OPEN, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float lvt_5_2_ = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float lvt_6_1_ = 0.5f;
            if (this.lidAngle < 0.5f && lvt_5_2_ >= 0.5f) {
                double lvt_7_2_ = (double)lvt_1_1_ + 0.5;
                double lvt_9_1_ = (double)lvt_3_1_ + 0.5;
                this.world.playSound(null, lvt_7_2_, (double)lvt_2_1_ + 0.5, lvt_9_1_, SoundEvents.BLOCK_ENDERCHEST_CLOSE, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        if (p_receiveClientEvent_1_ == 1) {
            this.numPlayersUsing = p_receiveClientEvent_2_;
            return true;
        }
        return super.receiveClientEvent(p_receiveClientEvent_1_, p_receiveClientEvent_2_);
    }

    @Override
    public void invalidate() {
        this.updateContainingBlockInfo();
        super.invalidate();
    }

    public void openChest() {
        ++this.numPlayersUsing;
        this.world.addBlockEvent(this.pos, Blocks.ENDER_CHEST, 1, this.numPlayersUsing);
    }

    public void closeChest() {
        --this.numPlayersUsing;
        this.world.addBlockEvent(this.pos, Blocks.ENDER_CHEST, 1, this.numPlayersUsing);
    }

    public boolean canBeUsed(EntityPlayer p_canBeUsed_1_) {
        if (this.world.getTileEntity(this.pos) != this) {
            return false;
        }
        return !(p_canBeUsed_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > 64.0);
    }
}

