/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityFurnace
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.withSize(3, ItemStack.EMPTY);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    IItemHandler handlerTop = new SidedInvWrapper(this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper(this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper(this, EnumFacing.WEST);

    @Override
    public int getSizeInventory() {
        return this.furnaceItemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        return this.furnaceItemStacks.get(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        return ItemStackHelper.getAndSplit(this.furnaceItemStacks, p_decrStackSize_1_, p_decrStackSize_2_);
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        return ItemStackHelper.getAndRemove(this.furnaceItemStacks, p_removeStackFromSlot_1_);
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        ItemStack itemstack = this.furnaceItemStacks.get(p_setInventorySlotContents_1_);
        boolean flag = !p_setInventorySlotContents_2_.isEmpty() && p_setInventorySlotContents_2_.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual(p_setInventorySlotContents_2_, itemstack);
        this.furnaceItemStacks.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
        if (p_setInventorySlotContents_1_ == 0 && !flag) {
            this.totalCookTime = this.getCookTime(p_setInventorySlotContents_2_);
            this.cookTime = 0;
            this.markDirty();
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.furnaceCustomName : "container.furnace";
    }

    @Override
    public boolean hasCustomName() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_setCustomInventoryName_1_) {
        this.furnaceCustomName = p_setCustomInventoryName_1_;
    }

    public static void registerFixesFurnace(DataFixer p_registerFixesFurnace_0_) {
        p_registerFixesFurnace_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists(TileEntityFurnace.class, "Items"));
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.furnaceItemStacks = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        ItemStackHelper.loadAllItems(p_readFromNBT_1_, this.furnaceItemStacks);
        this.furnaceBurnTime = p_readFromNBT_1_.getInteger("BurnTime");
        this.cookTime = p_readFromNBT_1_.getInteger("CookTime");
        this.totalCookTime = p_readFromNBT_1_.getInteger("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.getItemBurnTime(this.furnaceItemStacks.get(1));
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.furnaceCustomName = p_readFromNBT_1_.getString("CustomName");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setInteger("BurnTime", (short)this.furnaceBurnTime);
        p_writeToNBT_1_.setInteger("CookTime", (short)this.cookTime);
        p_writeToNBT_1_.setInteger("CookTimeTotal", (short)this.totalCookTime);
        ItemStackHelper.saveAllItems(p_writeToNBT_1_, this.furnaceItemStacks);
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.furnaceCustomName);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory p_isBurning_0_) {
        return p_isBurning_0_.getField(0) > 0;
    }

    @Override
    public void update() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.world.isRemote) {
            ItemStack itemstack = this.furnaceItemStacks.get(1);
            if (this.isBurning() || !itemstack.isEmpty() && !this.furnaceItemStacks.get(0).isEmpty()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.getItemBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.isEmpty()) {
                            Item item = itemstack.getItem();
                            itemstack.shrink(1);
                            if (itemstack.isEmpty()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime(this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.clamp(this.cookTime - 2, 0, this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockFurnace.setState(this.isBurning(), this.world, this.pos);
            }
        }
        if (flag1) {
            this.markDirty();
        }
    }

    public int getCookTime(ItemStack p_getCookTime_1_) {
        return 200;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks.get(0).isEmpty()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.furnaceItemStacks.get(0));
        if (itemstack.isEmpty()) {
            return false;
        }
        ItemStack itemstack1 = this.furnaceItemStacks.get(2);
        if (itemstack1.isEmpty()) {
            return true;
        }
        if (!itemstack1.isItemEqual(itemstack)) {
            return false;
        }
        int result = itemstack1.getCount() + itemstack.getCount();
        return result <= this.getInventoryStackLimit() && result <= itemstack1.getMaxStackSize();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.instance().getSmeltingResult(itemstack);
            ItemStack itemstack2 = this.furnaceItemStacks.get(2);
            if (itemstack2.isEmpty()) {
                this.furnaceItemStacks.set(2, itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (itemstack.getItem() == Item.getItemFromBlock(Blocks.SPONGE) && itemstack.getMetadata() == 1 && !this.furnaceItemStacks.get(1).isEmpty() && this.furnaceItemStacks.get(1).getItem() == Items.BUCKET) {
                this.furnaceItemStacks.set(1, new ItemStack(Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
        }
    }

    public static int getItemBurnTime(ItemStack p_getItemBurnTime_0_) {
        if (p_getItemBurnTime_0_.isEmpty()) {
            return 0;
        }
        Item item = p_getItemBurnTime_0_.getItem();
        if (item instanceof ItemBlock && Block.getBlockFromItem(item) != Blocks.AIR) {
            Block block = Block.getBlockFromItem(item);
            if (block == Blocks.WOODEN_SLAB) {
                return 150;
            }
            if (block.getDefaultState().getMaterial() == Material.WOOD) {
                return 300;
            }
            if (block == Blocks.COAL_BLOCK) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).getToolMaterialName())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).getToolMaterialName())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).getMaterialName())) {
            return 200;
        }
        if (item == Items.STICK) {
            return 100;
        }
        if (item == Items.COAL) {
            return 1600;
        }
        if (item == Items.LAVA_BUCKET) {
            return 20000;
        }
        if (item == Item.getItemFromBlock(Blocks.SAPLING)) {
            return 100;
        }
        if (item == Items.BLAZE_ROD) {
            return 2400;
        }
        return GameRegistry.getFuelValue(p_getItemBurnTime_0_);
    }

    public static boolean isItemFuel(ItemStack p_isItemFuel_0_) {
        return TileEntityFurnace.getItemBurnTime(p_isItemFuel_0_) > 0;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.world.getTileEntity(this.pos) != this ? false : p_isUsableByPlayer_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        if (p_isItemValidForSlot_1_ == 2) {
            return false;
        }
        if (p_isItemValidForSlot_1_ != 1) {
            return true;
        }
        ItemStack itemstack = this.furnaceItemStacks.get(1);
        return TileEntityFurnace.isItemFuel(p_isItemValidForSlot_2_) || SlotFurnaceFuel.isBucket(p_isItemValidForSlot_2_) && itemstack.getItem() != Items.BUCKET;
    }

    @Override
    public int[] getSlotsForFace(EnumFacing p_getSlotsForFace_1_) {
        return p_getSlotsForFace_1_ == EnumFacing.DOWN ? SLOTS_BOTTOM : (p_getSlotsForFace_1_ == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    @Override
    public boolean canInsertItem(int p_canInsertItem_1_, ItemStack p_canInsertItem_2_, EnumFacing p_canInsertItem_3_) {
        return this.isItemValidForSlot(p_canInsertItem_1_, p_canInsertItem_2_);
    }

    @Override
    public boolean canExtractItem(int p_canExtractItem_1_, ItemStack p_canExtractItem_2_, EnumFacing p_canExtractItem_3_) {
        Item item;
        return p_canExtractItem_3_ != EnumFacing.DOWN || p_canExtractItem_1_ != 1 || (item = p_canExtractItem_2_.getItem()) == Items.WATER_BUCKET || item == Items.BUCKET;
    }

    @Override
    public String getGuiID() {
        return "minecraft:furnace";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerFurnace(p_createContainer_1_, this);
    }

    @Override
    public int getField(int p_getField_1_) {
        switch (p_getField_1_) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
        switch (p_setField_1_) {
            case 0: {
                this.furnaceBurnTime = p_setField_2_;
                break;
            }
            case 1: {
                this.currentItemBurnTime = p_setField_2_;
                break;
            }
            case 2: {
                this.cookTime = p_setField_2_;
                break;
            }
            case 3: {
                this.totalCookTime = p_setField_2_;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 4;
    }

    @Override
    public void clear() {
        this.furnaceItemStacks.clear();
    }

    @Override
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        if (p_getCapability_2_ != null && p_getCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (p_getCapability_2_ == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (p_getCapability_2_ == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return super.getCapability(p_getCapability_1_, p_getCapability_2_);
    }
}

