/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaHopperItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class TileEntityHopper
extends TileEntityLockableLoot
implements IHopper,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.withSize(5, ItemStack.EMPTY);
    private int transferCooldown = -1;
    private long tickedGameTime;

    public static void registerFixesHopper(DataFixer p_registerFixesHopper_0_) {
        p_registerFixesHopper_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists(TileEntityHopper.class, "Items"));
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.inventory = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        if (!this.checkLootAndRead(p_readFromNBT_1_)) {
            ItemStackHelper.loadAllItems(p_readFromNBT_1_, this.inventory);
        }
        if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
            this.customName = p_readFromNBT_1_.getString("CustomName");
        }
        this.transferCooldown = p_readFromNBT_1_.getInteger("TransferCooldown");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        if (!this.checkLootAndWrite(p_writeToNBT_1_)) {
            ItemStackHelper.saveAllItems(p_writeToNBT_1_, this.inventory);
        }
        p_writeToNBT_1_.setInteger("TransferCooldown", this.transferCooldown);
        if (this.hasCustomName()) {
            p_writeToNBT_1_.setString("CustomName", this.customName);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public int getSizeInventory() {
        return this.inventory.size();
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        this.fillWithLoot(null);
        ItemStack itemstack = ItemStackHelper.getAndSplit(this.getItems(), p_decrStackSize_1_, p_decrStackSize_2_);
        return itemstack;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.fillWithLoot(null);
        this.getItems().set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.hopper";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void update() {
        if (this.world != null && !this.world.isRemote) {
            --this.transferCooldown;
            this.tickedGameTime = this.world.getTotalWorldTime();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    private boolean updateHopper() {
        if (this.world != null && !this.world.isRemote) {
            if (!this.isOnTransferCooldown() && BlockHopper.isEnabled(this.getBlockMetadata())) {
                boolean flag = false;
                if (!this.isInventoryEmpty()) {
                    flag = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    boolean bl = flag = TileEntityHopper.captureDroppedItems(this) || flag;
                }
                if (flag) {
                    this.setTransferCooldown(8);
                    this.markDirty();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        if (VanillaInventoryCodeHooks.insertHook(this)) {
            return true;
        }
        IInventory iinventory = this.getInventoryForHopperTransfer();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = BlockHopper.getFacing(this.getBlockMetadata()).getOpposite();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i).isEmpty()) continue;
            ItemStack itemstack = this.getStackInSlot(i).copy();
            ItemStack itemstack1 = TileEntityHopper.putStackInInventoryAllSlots(this, iinventory, this.decrStackSize(i, 1), enumfacing);
            if (itemstack1.isEmpty()) {
                iinventory.markDirty();
                return true;
            }
            this.setInventorySlotContents(i, itemstack);
        }
        return false;
    }

    private boolean isInventoryFull(IInventory p_isInventoryFull_1_, EnumFacing p_isInventoryFull_2_) {
        if (p_isInventoryFull_1_ instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)p_isInventoryFull_1_;
            for (int k : aint = isidedinventory.getSlotsForFace(p_isInventoryFull_2_)) {
                ItemStack itemstack1 = isidedinventory.getStackInSlot(k);
                if (!itemstack1.isEmpty() && itemstack1.getCount() == itemstack1.getMaxStackSize()) continue;
                return false;
            }
        } else {
            int i = p_isInventoryFull_1_.getSizeInventory();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = p_isInventoryFull_1_.getStackInSlot(j);
                if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory p_isInventoryEmpty_0_, EnumFacing p_isInventoryEmpty_1_) {
        if (p_isInventoryEmpty_0_ instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)p_isInventoryEmpty_0_;
            for (int i : aint = isidedinventory.getSlotsForFace(p_isInventoryEmpty_1_)) {
                if (isidedinventory.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
        } else {
            int j = p_isInventoryEmpty_0_.getSizeInventory();
            for (int k = 0; k < j; ++k) {
                if (p_isInventoryEmpty_0_.getStackInSlot(k).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean captureDroppedItems(IHopper p_captureDroppedItems_0_) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook(p_captureDroppedItems_0_);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = TileEntityHopper.getHopperInventory(p_captureDroppedItems_0_);
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileEntityHopper.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.getSlotsForFace(enumfacing)) {
                    if (!TileEntityHopper.pullItemFromSlot(p_captureDroppedItems_0_, iinventory, i, enumfacing)) continue;
                    return true;
                }
            } else {
                int j = iinventory.getSizeInventory();
                for (int k = 0; k < j; ++k) {
                    if (!TileEntityHopper.pullItemFromSlot(p_captureDroppedItems_0_, iinventory, k, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityHopper.getCaptureItems(p_captureDroppedItems_0_.getWorld(), p_captureDroppedItems_0_.getXPos(), p_captureDroppedItems_0_.getYPos(), p_captureDroppedItems_0_.getZPos())) {
                if (!TileEntityHopper.putDropInInventoryAllSlots(null, p_captureDroppedItems_0_, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper p_pullItemFromSlot_0_, IInventory p_pullItemFromSlot_1_, int p_pullItemFromSlot_2_, EnumFacing p_pullItemFromSlot_3_) {
        ItemStack itemstack = p_pullItemFromSlot_1_.getStackInSlot(p_pullItemFromSlot_2_);
        if (!itemstack.isEmpty() && TileEntityHopper.canExtractItemFromSlot(p_pullItemFromSlot_1_, itemstack, p_pullItemFromSlot_2_, p_pullItemFromSlot_3_)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = TileEntityHopper.putStackInInventoryAllSlots(p_pullItemFromSlot_1_, p_pullItemFromSlot_0_, p_pullItemFromSlot_1_.decrStackSize(p_pullItemFromSlot_2_, 1), null);
            if (itemstack2.isEmpty()) {
                p_pullItemFromSlot_1_.markDirty();
                return true;
            }
            p_pullItemFromSlot_1_.setInventorySlotContents(p_pullItemFromSlot_2_, itemstack1);
        }
        return false;
    }

    public static boolean putDropInInventoryAllSlots(IInventory p_putDropInInventoryAllSlots_0_, IInventory p_putDropInInventoryAllSlots_1_, EntityItem p_putDropInInventoryAllSlots_2_) {
        boolean flag = false;
        if (p_putDropInInventoryAllSlots_2_ == null) {
            return false;
        }
        ItemStack itemstack = p_putDropInInventoryAllSlots_2_.getEntityItem().copy();
        ItemStack itemstack1 = TileEntityHopper.putStackInInventoryAllSlots(p_putDropInInventoryAllSlots_0_, p_putDropInInventoryAllSlots_1_, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            p_putDropInInventoryAllSlots_2_.setDead();
        } else {
            p_putDropInInventoryAllSlots_2_.setEntityItemStack(itemstack1);
        }
        return flag;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new VanillaHopperItemHandler(this);
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory p_putStackInInventoryAllSlots_0_, IInventory p_putStackInInventoryAllSlots_1_, ItemStack p_putStackInInventoryAllSlots_2_, EnumFacing p_putStackInInventoryAllSlots_3_) {
        if (p_putStackInInventoryAllSlots_1_ instanceof ISidedInventory && p_putStackInInventoryAllSlots_3_ != null) {
            ISidedInventory isidedinventory = (ISidedInventory)p_putStackInInventoryAllSlots_1_;
            int[] aint = isidedinventory.getSlotsForFace(p_putStackInInventoryAllSlots_3_);
            for (int k = 0; k < aint.length && !p_putStackInInventoryAllSlots_2_.isEmpty(); ++k) {
                p_putStackInInventoryAllSlots_2_ = TileEntityHopper.insertStack(p_putStackInInventoryAllSlots_0_, p_putStackInInventoryAllSlots_1_, p_putStackInInventoryAllSlots_2_, aint[k], p_putStackInInventoryAllSlots_3_);
            }
        } else {
            int i = p_putStackInInventoryAllSlots_1_.getSizeInventory();
            for (int j = 0; j < i && !p_putStackInInventoryAllSlots_2_.isEmpty(); ++j) {
                p_putStackInInventoryAllSlots_2_ = TileEntityHopper.insertStack(p_putStackInInventoryAllSlots_0_, p_putStackInInventoryAllSlots_1_, p_putStackInInventoryAllSlots_2_, j, p_putStackInInventoryAllSlots_3_);
            }
        }
        return p_putStackInInventoryAllSlots_2_;
    }

    private static boolean canInsertItemInSlot(IInventory p_canInsertItemInSlot_0_, ItemStack p_canInsertItemInSlot_1_, int p_canInsertItemInSlot_2_, EnumFacing p_canInsertItemInSlot_3_) {
        return !p_canInsertItemInSlot_0_.isItemValidForSlot(p_canInsertItemInSlot_2_, p_canInsertItemInSlot_1_) ? false : !(p_canInsertItemInSlot_0_ instanceof ISidedInventory) || ((ISidedInventory)p_canInsertItemInSlot_0_).canInsertItem(p_canInsertItemInSlot_2_, p_canInsertItemInSlot_1_, p_canInsertItemInSlot_3_);
    }

    private static boolean canExtractItemFromSlot(IInventory p_canExtractItemFromSlot_0_, ItemStack p_canExtractItemFromSlot_1_, int p_canExtractItemFromSlot_2_, EnumFacing p_canExtractItemFromSlot_3_) {
        return !(p_canExtractItemFromSlot_0_ instanceof ISidedInventory) || ((ISidedInventory)p_canExtractItemFromSlot_0_).canExtractItem(p_canExtractItemFromSlot_2_, p_canExtractItemFromSlot_1_, p_canExtractItemFromSlot_3_);
    }

    private static ItemStack insertStack(IInventory p_insertStack_0_, IInventory p_insertStack_1_, ItemStack p_insertStack_2_, int p_insertStack_3_, EnumFacing p_insertStack_4_) {
        ItemStack itemstack = p_insertStack_1_.getStackInSlot(p_insertStack_3_);
        if (TileEntityHopper.canInsertItemInSlot(p_insertStack_1_, p_insertStack_2_, p_insertStack_3_, p_insertStack_4_)) {
            boolean flag = false;
            boolean flag1 = p_insertStack_1_.isEmpty();
            if (itemstack.isEmpty()) {
                p_insertStack_1_.setInventorySlotContents(p_insertStack_3_, p_insertStack_2_);
                p_insertStack_2_ = ItemStack.EMPTY;
                flag = true;
            } else if (TileEntityHopper.canCombine(itemstack, p_insertStack_2_)) {
                int i = p_insertStack_2_.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(p_insertStack_2_.getCount(), i);
                p_insertStack_2_.shrink(j);
                itemstack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper1;
                if (flag1 && p_insertStack_1_ instanceof TileEntityHopper && !(tileentityhopper1 = (TileEntityHopper)p_insertStack_1_).mayTransfer()) {
                    int k = 0;
                    if (p_insertStack_0_ != null && p_insertStack_0_ instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper = (TileEntityHopper)p_insertStack_0_;
                        if (tileentityhopper1.tickedGameTime >= tileentityhopper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentityhopper1.setTransferCooldown(8 - k);
                }
                p_insertStack_1_.markDirty();
            }
        }
        return p_insertStack_2_;
    }

    private IInventory getInventoryForHopperTransfer() {
        EnumFacing enumfacing = BlockHopper.getFacing(this.getBlockMetadata());
        return TileEntityHopper.getInventoryAtPosition(this.getWorld(), this.getXPos() + (double)enumfacing.getFrontOffsetX(), this.getYPos() + (double)enumfacing.getFrontOffsetY(), this.getZPos() + (double)enumfacing.getFrontOffsetZ());
    }

    public static IInventory getHopperInventory(IHopper p_getHopperInventory_0_) {
        return TileEntityHopper.getInventoryAtPosition(p_getHopperInventory_0_.getWorld(), p_getHopperInventory_0_.getXPos(), p_getHopperInventory_0_.getYPos() + 1.0, p_getHopperInventory_0_.getZPos());
    }

    public static List<EntityItem> getCaptureItems(World p_getCaptureItems_0_, double p_getCaptureItems_1_, double p_getCaptureItems_3_, double p_getCaptureItems_5_) {
        return p_getCaptureItems_0_.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(p_getCaptureItems_1_ - 0.5, p_getCaptureItems_3_, p_getCaptureItems_5_ - 0.5, p_getCaptureItems_1_ + 0.5, p_getCaptureItems_3_ + 1.5, p_getCaptureItems_5_ + 0.5), EntitySelectors.IS_ALIVE);
    }

    public static IInventory getInventoryAtPosition(World p_getInventoryAtPosition_0_, double p_getInventoryAtPosition_1_, double p_getInventoryAtPosition_3_, double p_getInventoryAtPosition_5_) {
        List<Entity> list;
        TileEntity tileentity;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.floor(p_getInventoryAtPosition_1_);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(p_getInventoryAtPosition_3_), k = MathHelper.floor(p_getInventoryAtPosition_5_));
        IBlockState state = p_getInventoryAtPosition_0_.getBlockState(blockpos);
        Block block = state.getBlock();
        if (block.hasTileEntity(state) && (tileentity = p_getInventoryAtPosition_0_.getTileEntity(blockpos)) instanceof IInventory && (iinventory = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).getContainer(p_getInventoryAtPosition_0_, blockpos, true);
        }
        if (iinventory == null && !(list = p_getInventoryAtPosition_0_.getEntitiesInAABBexcluding(null, new AxisAlignedBB(p_getInventoryAtPosition_1_ - 0.5, p_getInventoryAtPosition_3_ - 0.5, p_getInventoryAtPosition_5_ - 0.5, p_getInventoryAtPosition_1_ + 0.5, p_getInventoryAtPosition_3_ + 0.5, p_getInventoryAtPosition_5_ + 0.5), EntitySelectors.HAS_INVENTORY)).isEmpty()) {
            iinventory = (IInventory)((Object)list.get(p_getInventoryAtPosition_0_.rand.nextInt(list.size())));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack p_canCombine_0_, ItemStack p_canCombine_1_) {
        return p_canCombine_0_.getItem() != p_canCombine_1_.getItem() ? false : (p_canCombine_0_.getMetadata() != p_canCombine_1_.getMetadata() ? false : (p_canCombine_0_.getCount() > p_canCombine_0_.getMaxStackSize() ? false : ItemStack.areItemStackTagsEqual(p_canCombine_0_, p_canCombine_1_)));
    }

    @Override
    public double getXPos() {
        return (double)this.pos.getX() + 0.5;
    }

    @Override
    public double getYPos() {
        return (double)this.pos.getY() + 0.5;
    }

    @Override
    public double getZPos() {
        return (double)this.pos.getZ() + 0.5;
    }

    public void setTransferCooldown(int p_setTransferCooldown_1_) {
        this.transferCooldown = p_setTransferCooldown_1_;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    @Override
    public String getGuiID() {
        return "minecraft:hopper";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        this.fillWithLoot(p_createContainer_2_);
        return new ContainerHopper(p_createContainer_1_, this, p_createContainer_2_);
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

