/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public abstract class TileEntityLockableLoot
extends TileEntityLockable
implements ILootContainer {
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    protected String customName;

    protected boolean checkLootAndRead(NBTTagCompound p_checkLootAndRead_1_) {
        if (p_checkLootAndRead_1_.hasKey("LootTable", 8)) {
            this.lootTable = new ResourceLocation(p_checkLootAndRead_1_.getString("LootTable"));
            this.lootTableSeed = p_checkLootAndRead_1_.getLong("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound p_checkLootAndWrite_1_) {
        if (this.lootTable != null) {
            p_checkLootAndWrite_1_.setString("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                p_checkLootAndWrite_1_.setLong("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    public void fillWithLoot(EntityPlayer p_fillWithLoot_1_) {
        if (this.lootTable != null) {
            Random lvt_3_2_;
            LootTable lvt_2_1_ = this.world.getLootTableManager().getLootTableFromLocation(this.lootTable);
            this.lootTable = null;
            if (this.lootTableSeed == 0L) {
                Random lvt_3_1_ = new Random();
            } else {
                lvt_3_2_ = new Random(this.lootTableSeed);
            }
            LootContext.Builder lvt_4_1_ = new LootContext.Builder((WorldServer)this.world);
            if (p_fillWithLoot_1_ != null) {
                lvt_4_1_.withLuck(p_fillWithLoot_1_.getLuck());
            }
            lvt_2_1_.fillInventory(this, lvt_3_2_, lvt_4_1_.build());
        }
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation p_setLootTable_1_, long p_setLootTable_2_) {
        this.lootTable = p_setLootTable_1_;
        this.lootTableSeed = p_setLootTable_2_;
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String p_setCustomName_1_) {
        this.customName = p_setCustomName_1_;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        this.fillWithLoot(null);
        return this.getItems().get(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        this.fillWithLoot(null);
        ItemStack lvt_3_1_ = ItemStackHelper.getAndSplit(this.getItems(), p_decrStackSize_1_, p_decrStackSize_2_);
        if (!lvt_3_1_.isEmpty()) {
            this.markDirty();
        }
        return lvt_3_1_;
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        this.fillWithLoot(null);
        return ItemStackHelper.getAndRemove(this.getItems(), p_removeStackFromSlot_1_);
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.fillWithLoot(null);
        this.getItems().set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
        this.markDirty();
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        if (this.world.getTileEntity(this.pos) != this) {
            return false;
        }
        return !(p_isUsableByPlayer_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > 64.0);
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.fillWithLoot(null);
        this.getItems().clear();
    }

    protected abstract NonNullList<ItemStack> getItems();
}

