/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityMobSpawner
extends TileEntity
implements ITickable {
    private final MobSpawnerBaseLogic spawnerLogic = new MobSpawnerBaseLogic(){

        @Override
        public void broadcastEvent(int p_broadcastEvent_1_) {
            TileEntityMobSpawner.this.world.addBlockEvent(TileEntityMobSpawner.this.pos, Blocks.MOB_SPAWNER, p_broadcastEvent_1_, 0);
        }

        @Override
        public World getSpawnerWorld() {
            return TileEntityMobSpawner.this.world;
        }

        @Override
        public BlockPos getSpawnerPosition() {
            return TileEntityMobSpawner.this.pos;
        }

        @Override
        public void setNextSpawnData(WeightedSpawnerEntity p_setNextSpawnData_1_) {
            super.setNextSpawnData(p_setNextSpawnData_1_);
            if (this.getSpawnerWorld() != null) {
                IBlockState lvt_2_1_ = this.getSpawnerWorld().getBlockState(this.getSpawnerPosition());
                this.getSpawnerWorld().notifyBlockUpdate(TileEntityMobSpawner.this.pos, lvt_2_1_, lvt_2_1_, 4);
            }
        }
    };

    public static void registerFixesMobSpawner(DataFixer p_registerFixesMobSpawner_0_) {
        p_registerFixesMobSpawner_0_.registerWalker(FixTypes.BLOCK_ENTITY, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (TileEntity.getKey(TileEntityMobSpawner.class).equals(new ResourceLocation(p_process_2_.getString("id")))) {
                    if (p_process_2_.hasKey("SpawnPotentials", 9)) {
                        NBTTagList lvt_4_1_ = p_process_2_.getTagList("SpawnPotentials", 10);
                        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.tagCount(); ++lvt_5_1_) {
                            NBTTagCompound lvt_6_1_ = lvt_4_1_.getCompoundTagAt(lvt_5_1_);
                            lvt_6_1_.setTag("Entity", p_process_1_.process(FixTypes.ENTITY, lvt_6_1_.getCompoundTag("Entity"), p_process_3_));
                        }
                    }
                    p_process_2_.setTag("SpawnData", p_process_1_.process(FixTypes.ENTITY, p_process_2_.getCompoundTag("SpawnData"), p_process_3_));
                }
                return p_process_2_;
            }
        });
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.spawnerLogic.readFromNBT(p_readFromNBT_1_);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        this.spawnerLogic.writeToNBT(p_writeToNBT_1_);
        return p_writeToNBT_1_;
    }

    @Override
    public void update() {
        this.spawnerLogic.updateSpawner();
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 1, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        NBTTagCompound lvt_1_1_ = this.writeToNBT(new NBTTagCompound());
        lvt_1_1_.removeTag("SpawnPotentials");
        return lvt_1_1_;
    }

    @Override
    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        if (this.spawnerLogic.setDelayToMin(p_receiveClientEvent_1_)) {
            return true;
        }
        return super.receiveClientEvent(p_receiveClientEvent_1_, p_receiveClientEvent_2_);
    }

    @Override
    public boolean onlyOpsCanSetNbt() {
        return true;
    }

    public MobSpawnerBaseLogic getSpawnerBaseLogic() {
        return this.spawnerLogic;
    }
}

