/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityNote
extends TileEntity {
    public byte note;
    public boolean previousRedstoneState;

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setByte("note", this.note);
        p_writeToNBT_1_.setBoolean("powered", this.previousRedstoneState);
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.note = p_readFromNBT_1_.getByte("note");
        this.note = (byte)MathHelper.clamp(this.note, 0, 24);
        this.previousRedstoneState = p_readFromNBT_1_.getBoolean("powered");
    }

    public void changePitch() {
        byte old = this.note;
        this.note = (byte)((this.note + 1) % 25);
        if (!ForgeHooks.onNoteChange(this, old)) {
            return;
        }
        this.markDirty();
    }

    public void triggerNote(World p_triggerNote_1_, BlockPos p_triggerNote_2_) {
        if (p_triggerNote_1_.getBlockState(p_triggerNote_2_.up()).getMaterial() == Material.AIR) {
            Material material = p_triggerNote_1_.getBlockState(p_triggerNote_2_.down()).getMaterial();
            int i = 0;
            if (material == Material.ROCK) {
                i = 1;
            }
            if (material == Material.SAND) {
                i = 2;
            }
            if (material == Material.GLASS) {
                i = 3;
            }
            if (material == Material.WOOD) {
                i = 4;
            }
            p_triggerNote_1_.addBlockEvent(p_triggerNote_2_, Blocks.NOTEBLOCK, i, this.note);
        }
    }
}

