/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPiston
extends TileEntity
implements ITickable {
    private IBlockState pistonState;
    private EnumFacing pistonFacing;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    private static final ThreadLocal<EnumFacing> MOVING_ENTITY = new ThreadLocal<EnumFacing>(){

        @Override
        protected EnumFacing initialValue() {
            return null;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private float progress;
    private float lastProgress;

    public TileEntityPiston() {
    }

    public TileEntityPiston(IBlockState p_i45665_1_, EnumFacing p_i45665_2_, boolean p_i45665_3_, boolean p_i45665_4_) {
        this.pistonState = p_i45665_1_;
        this.pistonFacing = p_i45665_2_;
        this.extending = p_i45665_3_;
        this.shouldHeadBeRendered = p_i45665_4_;
    }

    public IBlockState getPistonState() {
        return this.pistonState;
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Override
    public int getBlockMetadata() {
        return 0;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public EnumFacing getFacing() {
        return this.pistonFacing;
    }

    public boolean shouldPistonHeadBeRendered() {
        return this.shouldHeadBeRendered;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgress(float p_getProgress_1_) {
        if (p_getProgress_1_ > 1.0f) {
            p_getProgress_1_ = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * p_getProgress_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetX(float p_getOffsetX_1_) {
        return (float)this.pistonFacing.getFrontOffsetX() * this.getExtendedProgress(this.getProgress(p_getOffsetX_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetY(float p_getOffsetY_1_) {
        return (float)this.pistonFacing.getFrontOffsetY() * this.getExtendedProgress(this.getProgress(p_getOffsetY_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetZ(float p_getOffsetZ_1_) {
        return (float)this.pistonFacing.getFrontOffsetZ() * this.getExtendedProgress(this.getProgress(p_getOffsetZ_1_));
    }

    private float getExtendedProgress(float p_getExtendedProgress_1_) {
        return this.extending ? p_getExtendedProgress_1_ - 1.0f : 1.0f - p_getExtendedProgress_1_;
    }

    public AxisAlignedBB getAABB(IBlockAccess p_getAABB_1_, BlockPos p_getAABB_2_) {
        return this.getAABB(p_getAABB_1_, p_getAABB_2_, this.progress).union(this.getAABB(p_getAABB_1_, p_getAABB_2_, this.lastProgress));
    }

    public AxisAlignedBB getAABB(IBlockAccess p_getAABB_1_, BlockPos p_getAABB_2_, float p_getAABB_3_) {
        p_getAABB_3_ = this.getExtendedProgress(p_getAABB_3_);
        IBlockState lvt_4_1_ = this.getCollisionRelatedBlockState();
        return lvt_4_1_.getBoundingBox(p_getAABB_1_, p_getAABB_2_).offset(p_getAABB_3_ * (float)this.pistonFacing.getFrontOffsetX(), p_getAABB_3_ * (float)this.pistonFacing.getFrontOffsetY(), p_getAABB_3_ * (float)this.pistonFacing.getFrontOffsetZ());
    }

    private IBlockState getCollisionRelatedBlockState() {
        if (!this.isExtending() && this.shouldPistonHeadBeRendered()) {
            return Blocks.PISTON_HEAD.getDefaultState().withProperty(BlockPistonExtension.TYPE, this.pistonState.getBlock() == Blocks.STICKY_PISTON ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT).withProperty(BlockPistonExtension.FACING, this.pistonState.getValue(BlockPistonBase.FACING));
        }
        return this.pistonState;
    }

    private void moveCollidedEntities(float p_moveCollidedEntities_1_) {
        EnumFacing lvt_2_1_ = this.extending ? this.pistonFacing : this.pistonFacing.getOpposite();
        double lvt_3_1_ = p_moveCollidedEntities_1_ - this.progress;
        ArrayList lvt_5_1_ = Lists.newArrayList();
        this.getCollisionRelatedBlockState().addCollisionBoxToList(this.world, BlockPos.ORIGIN, new AxisAlignedBB(BlockPos.ORIGIN), lvt_5_1_, null, true);
        if (lvt_5_1_.isEmpty()) {
            return;
        }
        AxisAlignedBB lvt_6_1_ = this.moveByPositionAndProgress(this.func_191515_a(lvt_5_1_));
        List<Entity> lvt_7_1_ = this.world.getEntitiesWithinAABBExcludingEntity(null, this.getMovementArea(lvt_6_1_, lvt_2_1_, lvt_3_1_).union(lvt_6_1_));
        if (lvt_7_1_.isEmpty()) {
            return;
        }
        boolean lvt_8_1_ = this.pistonState.getBlock() == Blocks.SLIME_BLOCK;
        for (int lvt_9_1_ = 0; lvt_9_1_ < lvt_7_1_.size(); ++lvt_9_1_) {
            AxisAlignedBB lvt_15_1_;
            AxisAlignedBB lvt_14_1_;
            Entity lvt_10_1_ = lvt_7_1_.get(lvt_9_1_);
            if (lvt_10_1_.getPushReaction() == EnumPushReaction.IGNORE) continue;
            if (lvt_8_1_) {
                switch (lvt_2_1_.getAxis()) {
                    case X: {
                        lvt_10_1_.motionX = lvt_2_1_.getFrontOffsetX();
                        break;
                    }
                    case Y: {
                        lvt_10_1_.motionY = lvt_2_1_.getFrontOffsetY();
                        break;
                    }
                    case Z: {
                        lvt_10_1_.motionZ = lvt_2_1_.getFrontOffsetZ();
                    }
                }
            }
            double lvt_11_1_ = 0.0;
            for (int lvt_13_1_ = 0; !(lvt_13_1_ >= lvt_5_1_.size() || (lvt_14_1_ = this.getMovementArea(this.moveByPositionAndProgress((AxisAlignedBB)lvt_5_1_.get(lvt_13_1_)), lvt_2_1_, lvt_3_1_)).intersectsWith(lvt_15_1_ = lvt_10_1_.getEntityBoundingBox()) && (lvt_11_1_ = Math.max(lvt_11_1_, this.getMovement(lvt_14_1_, lvt_2_1_, lvt_15_1_))) >= lvt_3_1_); ++lvt_13_1_) {
            }
            if (lvt_11_1_ <= 0.0) continue;
            lvt_11_1_ = Math.min(lvt_11_1_, lvt_3_1_) + 0.01;
            MOVING_ENTITY.set(lvt_2_1_);
            lvt_10_1_.move(MoverType.PISTON, lvt_11_1_ * (double)lvt_2_1_.getFrontOffsetX(), lvt_11_1_ * (double)lvt_2_1_.getFrontOffsetY(), lvt_11_1_ * (double)lvt_2_1_.getFrontOffsetZ());
            MOVING_ENTITY.set(null);
            if (this.extending || !this.shouldHeadBeRendered) continue;
            this.fixEntityWithinPistonBase(lvt_10_1_, lvt_2_1_, lvt_3_1_);
        }
    }

    private AxisAlignedBB func_191515_a(List<AxisAlignedBB> p_191515_1_) {
        double lvt_2_1_ = 0.0;
        double lvt_4_1_ = 0.0;
        double lvt_6_1_ = 0.0;
        double lvt_8_1_ = 1.0;
        double lvt_10_1_ = 1.0;
        double lvt_12_1_ = 1.0;
        for (AxisAlignedBB lvt_15_1_ : p_191515_1_) {
            lvt_2_1_ = Math.min(lvt_15_1_.minX, lvt_2_1_);
            lvt_4_1_ = Math.min(lvt_15_1_.minY, lvt_4_1_);
            lvt_6_1_ = Math.min(lvt_15_1_.minZ, lvt_6_1_);
            lvt_8_1_ = Math.max(lvt_15_1_.maxX, lvt_8_1_);
            lvt_10_1_ = Math.max(lvt_15_1_.maxY, lvt_10_1_);
            lvt_12_1_ = Math.max(lvt_15_1_.maxZ, lvt_12_1_);
        }
        return new AxisAlignedBB(lvt_2_1_, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_);
    }

    private double getMovement(AxisAlignedBB p_getMovement_1_, EnumFacing p_getMovement_2_, AxisAlignedBB p_getMovement_3_) {
        switch (p_getMovement_2_.getAxis()) {
            case X: {
                return TileEntityPiston.getDeltaX(p_getMovement_1_, p_getMovement_2_, p_getMovement_3_);
            }
            default: {
                return TileEntityPiston.getDeltaY(p_getMovement_1_, p_getMovement_2_, p_getMovement_3_);
            }
            case Z: 
        }
        return TileEntityPiston.getDeltaZ(p_getMovement_1_, p_getMovement_2_, p_getMovement_3_);
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB p_moveByPositionAndProgress_1_) {
        double lvt_2_1_ = this.getExtendedProgress(this.progress);
        return p_moveByPositionAndProgress_1_.offset((double)this.pos.getX() + lvt_2_1_ * (double)this.pistonFacing.getFrontOffsetX(), (double)this.pos.getY() + lvt_2_1_ * (double)this.pistonFacing.getFrontOffsetY(), (double)this.pos.getZ() + lvt_2_1_ * (double)this.pistonFacing.getFrontOffsetZ());
    }

    private AxisAlignedBB getMovementArea(AxisAlignedBB p_getMovementArea_1_, EnumFacing p_getMovementArea_2_, double p_getMovementArea_3_) {
        double lvt_5_1_ = p_getMovementArea_3_ * (double)p_getMovementArea_2_.getAxisDirection().getOffset();
        double lvt_7_1_ = Math.min(lvt_5_1_, 0.0);
        double lvt_9_1_ = Math.max(lvt_5_1_, 0.0);
        switch (p_getMovementArea_2_) {
            case WEST: {
                return new AxisAlignedBB(p_getMovementArea_1_.minX + lvt_7_1_, p_getMovementArea_1_.minY, p_getMovementArea_1_.minZ, p_getMovementArea_1_.minX + lvt_9_1_, p_getMovementArea_1_.maxY, p_getMovementArea_1_.maxZ);
            }
            case EAST: {
                return new AxisAlignedBB(p_getMovementArea_1_.maxX + lvt_7_1_, p_getMovementArea_1_.minY, p_getMovementArea_1_.minZ, p_getMovementArea_1_.maxX + lvt_9_1_, p_getMovementArea_1_.maxY, p_getMovementArea_1_.maxZ);
            }
            case DOWN: {
                return new AxisAlignedBB(p_getMovementArea_1_.minX, p_getMovementArea_1_.minY + lvt_7_1_, p_getMovementArea_1_.minZ, p_getMovementArea_1_.maxX, p_getMovementArea_1_.minY + lvt_9_1_, p_getMovementArea_1_.maxZ);
            }
            default: {
                return new AxisAlignedBB(p_getMovementArea_1_.minX, p_getMovementArea_1_.maxY + lvt_7_1_, p_getMovementArea_1_.minZ, p_getMovementArea_1_.maxX, p_getMovementArea_1_.maxY + lvt_9_1_, p_getMovementArea_1_.maxZ);
            }
            case NORTH: {
                return new AxisAlignedBB(p_getMovementArea_1_.minX, p_getMovementArea_1_.minY, p_getMovementArea_1_.minZ + lvt_7_1_, p_getMovementArea_1_.maxX, p_getMovementArea_1_.maxY, p_getMovementArea_1_.minZ + lvt_9_1_);
            }
            case SOUTH: 
        }
        return new AxisAlignedBB(p_getMovementArea_1_.minX, p_getMovementArea_1_.minY, p_getMovementArea_1_.maxZ + lvt_7_1_, p_getMovementArea_1_.maxX, p_getMovementArea_1_.maxY, p_getMovementArea_1_.maxZ + lvt_9_1_);
    }

    private void fixEntityWithinPistonBase(Entity p_fixEntityWithinPistonBase_1_, EnumFacing p_fixEntityWithinPistonBase_2_, double p_fixEntityWithinPistonBase_3_) {
        double lvt_10_1_;
        EnumFacing lvt_7_1_;
        double lvt_8_1_;
        AxisAlignedBB lvt_6_1_;
        AxisAlignedBB lvt_5_1_ = p_fixEntityWithinPistonBase_1_.getEntityBoundingBox();
        if (lvt_5_1_.intersectsWith(lvt_6_1_ = Block.FULL_BLOCK_AABB.offset(this.pos)) && Math.abs((lvt_8_1_ = this.getMovement(lvt_6_1_, lvt_7_1_ = p_fixEntityWithinPistonBase_2_.getOpposite(), lvt_5_1_) + 0.01) - (lvt_10_1_ = this.getMovement(lvt_6_1_, lvt_7_1_, lvt_5_1_.intersect(lvt_6_1_)) + 0.01)) < 0.01) {
            lvt_8_1_ = Math.min(lvt_8_1_, p_fixEntityWithinPistonBase_3_) + 0.01;
            MOVING_ENTITY.set(p_fixEntityWithinPistonBase_2_);
            p_fixEntityWithinPistonBase_1_.move(MoverType.PISTON, lvt_8_1_ * (double)lvt_7_1_.getFrontOffsetX(), lvt_8_1_ * (double)lvt_7_1_.getFrontOffsetY(), lvt_8_1_ * (double)lvt_7_1_.getFrontOffsetZ());
            MOVING_ENTITY.set(null);
        }
    }

    private static double getDeltaX(AxisAlignedBB p_getDeltaX_0_, EnumFacing p_getDeltaX_1_, AxisAlignedBB p_getDeltaX_2_) {
        if (p_getDeltaX_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE) {
            return p_getDeltaX_0_.maxX - p_getDeltaX_2_.minX;
        }
        return p_getDeltaX_2_.maxX - p_getDeltaX_0_.minX;
    }

    private static double getDeltaY(AxisAlignedBB p_getDeltaY_0_, EnumFacing p_getDeltaY_1_, AxisAlignedBB p_getDeltaY_2_) {
        if (p_getDeltaY_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE) {
            return p_getDeltaY_0_.maxY - p_getDeltaY_2_.minY;
        }
        return p_getDeltaY_2_.maxY - p_getDeltaY_0_.minY;
    }

    private static double getDeltaZ(AxisAlignedBB p_getDeltaZ_0_, EnumFacing p_getDeltaZ_1_, AxisAlignedBB p_getDeltaZ_2_) {
        if (p_getDeltaZ_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE) {
            return p_getDeltaZ_0_.maxZ - p_getDeltaZ_2_.minZ;
        }
        return p_getDeltaZ_2_.maxZ - p_getDeltaZ_0_.minZ;
    }

    public void clearPistonTileEntity() {
        if (this.lastProgress < 1.0f && this.world != null) {
            this.lastProgress = this.progress = 1.0f;
            this.world.removeTileEntity(this.pos);
            this.invalidate();
            if (this.world.getBlockState(this.pos).getBlock() == Blocks.PISTON_EXTENSION) {
                this.world.setBlockState(this.pos, this.pistonState, 3);
                this.world.neighborChanged(this.pos, this.pistonState.getBlock(), this.pos);
            }
        }
    }

    @Override
    public void update() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.world.removeTileEntity(this.pos);
            this.invalidate();
            if (this.world.getBlockState(this.pos).getBlock() == Blocks.PISTON_EXTENSION) {
                this.world.setBlockState(this.pos, this.pistonState, 3);
                this.world.neighborChanged(this.pos, this.pistonState.getBlock(), this.pos);
            }
            return;
        }
        float lvt_1_1_ = this.progress + 0.5f;
        this.moveCollidedEntities(lvt_1_1_);
        this.progress = lvt_1_1_;
        if (this.progress >= 1.0f) {
            this.progress = 1.0f;
        }
    }

    public static void registerFixesPiston(DataFixer p_registerFixesPiston_0_) {
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.pistonState = Block.getBlockById(p_readFromNBT_1_.getInteger("blockId")).getStateFromMeta(p_readFromNBT_1_.getInteger("blockData"));
        this.pistonFacing = EnumFacing.getFront(p_readFromNBT_1_.getInteger("facing"));
        this.lastProgress = this.progress = p_readFromNBT_1_.getFloat("progress");
        this.extending = p_readFromNBT_1_.getBoolean("extending");
        this.shouldHeadBeRendered = p_readFromNBT_1_.getBoolean("source");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setInteger("blockId", Block.getIdFromBlock(this.pistonState.getBlock()));
        p_writeToNBT_1_.setInteger("blockData", this.pistonState.getBlock().getMetaFromState(this.pistonState));
        p_writeToNBT_1_.setInteger("facing", this.pistonFacing.getIndex());
        p_writeToNBT_1_.setFloat("progress", this.lastProgress);
        p_writeToNBT_1_.setBoolean("extending", this.extending);
        p_writeToNBT_1_.setBoolean("source", this.shouldHeadBeRendered);
        return p_writeToNBT_1_;
    }

    public void addCollissionAABBs(World p_addCollissionAABBs_1_, BlockPos p_addCollissionAABBs_2_, AxisAlignedBB p_addCollissionAABBs_3_, List<AxisAlignedBB> p_addCollissionAABBs_4_, Entity p_addCollissionAABBs_5_) {
        IBlockState lvt_8_2_;
        if (!this.extending && this.shouldHeadBeRendered) {
            this.pistonState.withProperty(BlockPistonBase.EXTENDED, true).addCollisionBoxToList(p_addCollissionAABBs_1_, p_addCollissionAABBs_2_, p_addCollissionAABBs_3_, p_addCollissionAABBs_4_, p_addCollissionAABBs_5_, false);
        }
        EnumFacing lvt_6_1_ = MOVING_ENTITY.get();
        if ((double)this.progress < 1.0 && lvt_6_1_ == (this.extending ? this.pistonFacing : this.pistonFacing.getOpposite())) {
            return;
        }
        int lvt_7_1_ = p_addCollissionAABBs_4_.size();
        if (this.shouldPistonHeadBeRendered()) {
            IBlockState lvt_8_1_ = Blocks.PISTON_HEAD.getDefaultState().withProperty(BlockPistonExtension.FACING, this.pistonFacing).withProperty(BlockPistonExtension.SHORT, this.extending != 1.0f - this.progress < 0.25f);
        } else {
            lvt_8_2_ = this.pistonState;
        }
        float lvt_9_1_ = this.getExtendedProgress(this.progress);
        double lvt_10_1_ = (float)this.pistonFacing.getFrontOffsetX() * lvt_9_1_;
        double lvt_12_1_ = (float)this.pistonFacing.getFrontOffsetY() * lvt_9_1_;
        double lvt_14_1_ = (float)this.pistonFacing.getFrontOffsetZ() * lvt_9_1_;
        lvt_8_2_.addCollisionBoxToList(p_addCollissionAABBs_1_, p_addCollissionAABBs_2_, p_addCollissionAABBs_3_.offset(-lvt_10_1_, -lvt_12_1_, -lvt_14_1_), p_addCollissionAABBs_4_, p_addCollissionAABBs_5_, true);
        for (int lvt_16_1_ = lvt_7_1_; lvt_16_1_ < p_addCollissionAABBs_4_.size(); ++lvt_16_1_) {
            p_addCollissionAABBs_4_.set(lvt_16_1_, p_addCollissionAABBs_4_.get(lvt_16_1_).offset(lvt_10_1_, lvt_12_1_, lvt_14_1_));
        }
    }
}

