/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityShulkerBox
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS = new int[27];
    private NonNullList<ItemStack> items = NonNullList.withSize(27, ItemStack.EMPTY);
    private boolean hasBeenCleared;
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    private EnumDyeColor color;
    private boolean destroyedByCreativePlayer;

    public TileEntityShulkerBox() {
        this(null);
    }

    public TileEntityShulkerBox(EnumDyeColor p_i47242_1_) {
        this.color = p_i47242_1_;
    }

    @Override
    public void update() {
        this.updateAnimation();
        if (this.animationStatus == AnimationStatus.OPENING || this.animationStatus == AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = AnimationStatus.OPENED;
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_) {
        return this.getBoundingBox(p_getBoundingBox_1_.getValue(BlockShulkerBox.FACING));
    }

    public AxisAlignedBB getBoundingBox(EnumFacing p_getBoundingBox_1_) {
        return Block.FULL_BLOCK_AABB.addCoord(0.5f * this.getProgress(1.0f) * (float)p_getBoundingBox_1_.getFrontOffsetX(), 0.5f * this.getProgress(1.0f) * (float)p_getBoundingBox_1_.getFrontOffsetY(), 0.5f * this.getProgress(1.0f) * (float)p_getBoundingBox_1_.getFrontOffsetZ());
    }

    private AxisAlignedBB getTopBoundingBox(EnumFacing p_getTopBoundingBox_1_) {
        EnumFacing lvt_2_1_ = p_getTopBoundingBox_1_.getOpposite();
        return this.getBoundingBox(p_getTopBoundingBox_1_).contract(lvt_2_1_.getFrontOffsetX(), lvt_2_1_.getFrontOffsetY(), lvt_2_1_.getFrontOffsetZ());
    }

    private void moveCollidedEntities() {
        IBlockState lvt_1_1_ = this.world.getBlockState(this.getPos());
        if (!(lvt_1_1_.getBlock() instanceof BlockShulkerBox)) {
            return;
        }
        EnumFacing lvt_2_1_ = lvt_1_1_.getValue(BlockShulkerBox.FACING);
        AxisAlignedBB lvt_3_1_ = this.getTopBoundingBox(lvt_2_1_).offset(this.pos);
        List<Entity> lvt_4_1_ = this.world.getEntitiesWithinAABBExcludingEntity(null, lvt_3_1_);
        if (lvt_4_1_.isEmpty()) {
            return;
        }
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.size(); ++lvt_5_1_) {
            Entity lvt_6_1_ = lvt_4_1_.get(lvt_5_1_);
            if (lvt_6_1_.getPushReaction() == EnumPushReaction.IGNORE) continue;
            double lvt_7_1_ = 0.0;
            double lvt_9_1_ = 0.0;
            double lvt_11_1_ = 0.0;
            AxisAlignedBB lvt_13_1_ = lvt_6_1_.getEntityBoundingBox();
            switch (lvt_2_1_.getAxis()) {
                case X: {
                    lvt_7_1_ = lvt_2_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE ? lvt_3_1_.maxX - lvt_13_1_.minX : lvt_13_1_.maxX - lvt_3_1_.minX;
                    lvt_7_1_ += 0.01;
                    break;
                }
                case Y: {
                    lvt_9_1_ = lvt_2_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE ? lvt_3_1_.maxY - lvt_13_1_.minY : lvt_13_1_.maxY - lvt_3_1_.minY;
                    lvt_9_1_ += 0.01;
                    break;
                }
                case Z: {
                    lvt_11_1_ = lvt_2_1_.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE ? lvt_3_1_.maxZ - lvt_13_1_.minZ : lvt_13_1_.maxZ - lvt_3_1_.minZ;
                    lvt_11_1_ += 0.01;
                }
            }
            lvt_6_1_.move(MoverType.SHULKER_BOX, lvt_7_1_ * (double)lvt_2_1_.getFrontOffsetX(), lvt_9_1_ * (double)lvt_2_1_.getFrontOffsetY(), lvt_11_1_ * (double)lvt_2_1_.getFrontOffsetZ());
        }
    }

    @Override
    public int getSizeInventory() {
        return this.items.size();
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean receiveClientEvent(int p_receiveClientEvent_1_, int p_receiveClientEvent_2_) {
        if (p_receiveClientEvent_1_ == 1) {
            this.openCount = p_receiveClientEvent_2_;
            if (p_receiveClientEvent_2_ == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
            }
            if (p_receiveClientEvent_2_ == 1) {
                this.animationStatus = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.receiveClientEvent(p_receiveClientEvent_1_, p_receiveClientEvent_2_);
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
        if (!p_openInventory_1_.isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.world.addBlockEvent(this.pos, this.getBlockType(), 1, this.openCount);
            if (this.openCount == 1) {
                this.world.playSound(null, this.pos, SoundEvents.BLOCK_SHULKER_BOX_OPEN, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
        if (!p_closeInventory_1_.isSpectator()) {
            --this.openCount;
            this.world.addBlockEvent(this.pos, this.getBlockType(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.world.playSound(null, this.pos, SoundEvents.BLOCK_SHULKER_BOX_CLOSE, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerShulkerBox(p_createContainer_1_, this, p_createContainer_2_);
    }

    @Override
    public String getGuiID() {
        return "minecraft:shulker_box";
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.shulkerBox";
    }

    public static void registerFixesShulkerBox(DataFixer p_registerFixesShulkerBox_0_) {
        p_registerFixesShulkerBox_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists(TileEntityShulkerBox.class, "Items"));
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.loadFromNbt(p_readFromNBT_1_);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        return this.saveToNbt(p_writeToNBT_1_);
    }

    public void loadFromNbt(NBTTagCompound p_loadFromNbt_1_) {
        this.items = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        if (!this.checkLootAndRead(p_loadFromNbt_1_) && p_loadFromNbt_1_.hasKey("Items", 9)) {
            ItemStackHelper.loadAllItems(p_loadFromNbt_1_, this.items);
        }
        if (p_loadFromNbt_1_.hasKey("CustomName", 8)) {
            this.customName = p_loadFromNbt_1_.getString("CustomName");
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound p_saveToNbt_1_) {
        if (!this.checkLootAndWrite(p_saveToNbt_1_)) {
            ItemStackHelper.saveAllItems(p_saveToNbt_1_, this.items, false);
        }
        if (this.hasCustomName()) {
            p_saveToNbt_1_.setString("CustomName", this.customName);
        }
        if (!p_saveToNbt_1_.hasKey("Lock") && this.isLocked()) {
            this.getLockCode().toNBT(p_saveToNbt_1_);
        }
        return p_saveToNbt_1_;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack lvt_2_1_ : this.items) {
            if (lvt_2_1_.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] getSlotsForFace(EnumFacing p_getSlotsForFace_1_) {
        return SLOTS;
    }

    @Override
    public boolean canInsertItem(int p_canInsertItem_1_, ItemStack p_canInsertItem_2_, EnumFacing p_canInsertItem_3_) {
        return !(Block.getBlockFromItem(p_canInsertItem_2_.getItem()) instanceof BlockShulkerBox);
    }

    @Override
    public boolean canExtractItem(int p_canExtractItem_1_, ItemStack p_canExtractItem_2_, EnumFacing p_canExtractItem_3_) {
        return true;
    }

    @Override
    public void clear() {
        this.hasBeenCleared = true;
        super.clear();
    }

    public boolean isCleared() {
        return this.hasBeenCleared;
    }

    public float getProgress(float p_getProgress_1_) {
        return this.progressOld + (this.progress - this.progressOld) * p_getProgress_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        if (this.color == null) {
            this.color = BlockShulkerBox.getColorFromBlock(this.getBlockType());
        }
        return this.color;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 10, this.getUpdateTag());
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void setDestroyedByCreativePlayer(boolean p_setDestroyedByCreativePlayer_1_) {
        this.destroyedByCreativePlayer = p_setDestroyedByCreativePlayer_1_;
    }

    public boolean shouldDrop() {
        return !this.isDestroyedByCreativePlayer() || !this.isEmpty() || this.hasCustomName() || this.lootTable != null;
    }

    static {
        for (int lvt_0_1_ = 0; lvt_0_1_ < SLOTS.length; ++lvt_0_1_) {
            TileEntityShulkerBox.SLOTS[lvt_0_1_] = lvt_0_1_;
        }
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

