/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSkull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySkull
extends TileEntity
implements ITickable {
    private int skullType;
    private int skullRotation;
    private GameProfile playerProfile;
    private int dragonAnimatedTicks;
    private boolean dragonAnimated;
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;

    public static void setProfileCache(PlayerProfileCache p_setProfileCache_0_) {
        profileCache = p_setProfileCache_0_;
    }

    public static void setSessionService(MinecraftSessionService p_setSessionService_0_) {
        sessionService = p_setSessionService_0_;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setByte("SkullType", (byte)(this.skullType & 0xFF));
        p_writeToNBT_1_.setByte("Rot", (byte)(this.skullRotation & 0xFF));
        if (this.playerProfile != null) {
            NBTTagCompound lvt_2_1_ = new NBTTagCompound();
            NBTUtil.writeGameProfile(lvt_2_1_, this.playerProfile);
            p_writeToNBT_1_.setTag("Owner", lvt_2_1_);
        }
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.skullType = p_readFromNBT_1_.getByte("SkullType");
        this.skullRotation = p_readFromNBT_1_.getByte("Rot");
        if (this.skullType == 3) {
            String lvt_2_1_;
            if (p_readFromNBT_1_.hasKey("Owner", 10)) {
                this.playerProfile = NBTUtil.readGameProfileFromNBT(p_readFromNBT_1_.getCompoundTag("Owner"));
            } else if (p_readFromNBT_1_.hasKey("ExtraType", 8) && !StringUtils.isNullOrEmpty(lvt_2_1_ = p_readFromNBT_1_.getString("ExtraType"))) {
                this.playerProfile = new GameProfile(null, lvt_2_1_);
                this.updatePlayerProfile();
            }
        }
    }

    @Override
    public void update() {
        if (this.skullType == 5) {
            if (this.world.isBlockPowered(this.pos)) {
                this.dragonAnimated = true;
                ++this.dragonAnimatedTicks;
            } else {
                this.dragonAnimated = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress(float p_getAnimationProgress_1_) {
        if (this.dragonAnimated) {
            return (float)this.dragonAnimatedTicks + p_getAnimationProgress_1_;
        }
        return this.dragonAnimatedTicks;
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 4, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void setType(int p_setType_1_) {
        this.skullType = p_setType_1_;
        this.playerProfile = null;
    }

    public void setPlayerProfile(GameProfile p_setPlayerProfile_1_) {
        this.skullType = 3;
        this.playerProfile = p_setPlayerProfile_1_;
        this.updatePlayerProfile();
    }

    private void updatePlayerProfile() {
        this.playerProfile = TileEntitySkull.updateGameprofile(this.playerProfile);
        this.markDirty();
    }

    public static GameProfile updateGameprofile(GameProfile p_updateGameprofile_0_) {
        if (p_updateGameprofile_0_ == null || StringUtils.isNullOrEmpty(p_updateGameprofile_0_.getName())) {
            return p_updateGameprofile_0_;
        }
        if (p_updateGameprofile_0_.isComplete() && p_updateGameprofile_0_.getProperties().containsKey((Object)"textures")) {
            return p_updateGameprofile_0_;
        }
        if (profileCache == null || sessionService == null) {
            return p_updateGameprofile_0_;
        }
        GameProfile lvt_1_1_ = profileCache.getGameProfileForUsername(p_updateGameprofile_0_.getName());
        if (lvt_1_1_ == null) {
            return p_updateGameprofile_0_;
        }
        Property lvt_2_1_ = (Property)Iterables.getFirst((Iterable)lvt_1_1_.getProperties().get((Object)"textures"), null);
        if (lvt_2_1_ == null) {
            lvt_1_1_ = sessionService.fillProfileProperties(lvt_1_1_, true);
        }
        return lvt_1_1_;
    }

    public int getSkullType() {
        return this.skullType;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSkullRotation() {
        return this.skullRotation;
    }

    public void setSkullRotation(int p_setSkullRotation_1_) {
        this.skullRotation = p_setSkullRotation_1_;
    }

    @Override
    public void mirror(Mirror p_mirror_1_) {
        if (this.world != null && this.world.getBlockState(this.getPos()).getValue(BlockSkull.FACING) == EnumFacing.UP) {
            this.skullRotation = p_mirror_1_.mirrorRotation(this.skullRotation, 16);
        }
    }

    @Override
    public void rotate(Rotation p_rotate_1_) {
        if (this.world != null && this.world.getBlockState(this.getPos()).getValue(BlockSkull.FACING) == EnumFacing.UP) {
            this.skullRotation = p_rotate_1_.rotate(this.skullRotation, 16);
        }
    }
}

