/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityStructure
extends TileEntity {
    private String name = "";
    private String author = "";
    private String metadata = "";
    private BlockPos position = new BlockPos(0, 1, 0);
    private BlockPos size = BlockPos.ORIGIN;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private Mode mode = Mode.DATA;
    private boolean ignoreEntities = true;
    private boolean powered;
    private boolean showAir;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed;

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        super.writeToNBT(p_writeToNBT_1_);
        p_writeToNBT_1_.setString("name", this.name);
        p_writeToNBT_1_.setString("author", this.author);
        p_writeToNBT_1_.setString("metadata", this.metadata);
        p_writeToNBT_1_.setInteger("posX", this.position.getX());
        p_writeToNBT_1_.setInteger("posY", this.position.getY());
        p_writeToNBT_1_.setInteger("posZ", this.position.getZ());
        p_writeToNBT_1_.setInteger("sizeX", this.size.getX());
        p_writeToNBT_1_.setInteger("sizeY", this.size.getY());
        p_writeToNBT_1_.setInteger("sizeZ", this.size.getZ());
        p_writeToNBT_1_.setString("rotation", this.rotation.toString());
        p_writeToNBT_1_.setString("mirror", this.mirror.toString());
        p_writeToNBT_1_.setString("mode", this.mode.toString());
        p_writeToNBT_1_.setBoolean("ignoreEntities", this.ignoreEntities);
        p_writeToNBT_1_.setBoolean("powered", this.powered);
        p_writeToNBT_1_.setBoolean("showair", this.showAir);
        p_writeToNBT_1_.setBoolean("showboundingbox", this.showBoundingBox);
        p_writeToNBT_1_.setFloat("integrity", this.integrity);
        p_writeToNBT_1_.setLong("seed", this.seed);
        return p_writeToNBT_1_;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        super.readFromNBT(p_readFromNBT_1_);
        this.setName(p_readFromNBT_1_.getString("name"));
        this.author = p_readFromNBT_1_.getString("author");
        this.metadata = p_readFromNBT_1_.getString("metadata");
        int lvt_2_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("posX"), -32, 32);
        int lvt_3_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("posY"), -32, 32);
        int lvt_4_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("posZ"), -32, 32);
        this.position = new BlockPos(lvt_2_1_, lvt_3_1_, lvt_4_1_);
        int lvt_5_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("sizeX"), 0, 32);
        int lvt_6_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("sizeY"), 0, 32);
        int lvt_7_1_ = MathHelper.clamp(p_readFromNBT_1_.getInteger("sizeZ"), 0, 32);
        this.size = new BlockPos(lvt_5_1_, lvt_6_1_, lvt_7_1_);
        try {
            this.rotation = Rotation.valueOf(p_readFromNBT_1_.getString("rotation"));
        }
        catch (IllegalArgumentException lvt_8_1_) {
            this.rotation = Rotation.NONE;
        }
        try {
            this.mirror = Mirror.valueOf(p_readFromNBT_1_.getString("mirror"));
        }
        catch (IllegalArgumentException lvt_8_2_) {
            this.mirror = Mirror.NONE;
        }
        try {
            this.mode = Mode.valueOf(p_readFromNBT_1_.getString("mode"));
        }
        catch (IllegalArgumentException lvt_8_3_) {
            this.mode = Mode.DATA;
        }
        this.ignoreEntities = p_readFromNBT_1_.getBoolean("ignoreEntities");
        this.powered = p_readFromNBT_1_.getBoolean("powered");
        this.showAir = p_readFromNBT_1_.getBoolean("showair");
        this.showBoundingBox = p_readFromNBT_1_.getBoolean("showboundingbox");
        this.integrity = p_readFromNBT_1_.hasKey("integrity") ? p_readFromNBT_1_.getFloat("integrity") : 1.0f;
        this.seed = p_readFromNBT_1_.getLong("seed");
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.world == null) {
            return;
        }
        BlockPos lvt_1_1_ = this.getPos();
        IBlockState lvt_2_1_ = this.world.getBlockState(lvt_1_1_);
        if (lvt_2_1_.getBlock() == Blocks.STRUCTURE_BLOCK) {
            this.world.setBlockState(lvt_1_1_, lvt_2_1_.withProperty(BlockStructure.MODE, this.mode), 2);
        }
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, 7, this.getUpdateTag());
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public boolean usedBy(EntityPlayer p_usedBy_1_) {
        if (!p_usedBy_1_.canUseCommandBlock()) {
            return false;
        }
        if (p_usedBy_1_.getEntityWorld().isRemote) {
            p_usedBy_1_.openEditStructure(this);
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String p_setName_1_) {
        String lvt_2_1_ = p_setName_1_;
        for (char lvt_6_1_ : ChatAllowedCharacters.ILLEGAL_STRUCTURE_CHARACTERS) {
            lvt_2_1_ = lvt_2_1_.replace(lvt_6_1_, '_');
        }
        this.name = lvt_2_1_;
    }

    public void createdBy(EntityLivingBase p_createdBy_1_) {
        if (!StringUtils.isNullOrEmpty(p_createdBy_1_.getName())) {
            this.author = p_createdBy_1_.getName();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos p_setPosition_1_) {
        this.position = p_setPosition_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getStructureSize() {
        return this.size;
    }

    public void setSize(BlockPos p_setSize_1_) {
        this.size = p_setSize_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror p_setMirror_1_) {
        this.mirror = p_setMirror_1_;
    }

    public void setRotation(Rotation p_setRotation_1_) {
        this.rotation = p_setRotation_1_;
    }

    public void setMetadata(String p_setMetadata_1_) {
        this.metadata = p_setMetadata_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public Rotation getRotation() {
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public String getMetadata() {
        return this.metadata;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode p_setMode_1_) {
        this.mode = p_setMode_1_;
        IBlockState lvt_2_1_ = this.world.getBlockState(this.getPos());
        if (lvt_2_1_.getBlock() == Blocks.STRUCTURE_BLOCK) {
            this.world.setBlockState(this.getPos(), lvt_2_1_.withProperty(BlockStructure.MODE, p_setMode_1_), 2);
        }
    }

    public void setIgnoresEntities(boolean p_setIgnoresEntities_1_) {
        this.ignoreEntities = p_setIgnoresEntities_1_;
    }

    public void setIntegrity(float p_setIntegrity_1_) {
        this.integrity = p_setIntegrity_1_;
    }

    public void setSeed(long p_setSeed_1_) {
        this.seed = p_setSeed_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void nextMode() {
        switch (this.getMode()) {
            case SAVE: {
                this.setMode(Mode.LOAD);
                break;
            }
            case LOAD: {
                this.setMode(Mode.CORNER);
                break;
            }
            case CORNER: {
                this.setMode(Mode.DATA);
                break;
            }
            case DATA: {
                this.setMode(Mode.SAVE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean ignoresEntities() {
        return this.ignoreEntities;
    }

    @SideOnly(value=Side.CLIENT)
    public float getIntegrity() {
        return this.integrity;
    }

    @SideOnly(value=Side.CLIENT)
    public long getSeed() {
        return this.seed;
    }

    public boolean detectSize() {
        BlockPos lvt_4_1_;
        if (this.mode != Mode.SAVE) {
            return false;
        }
        BlockPos lvt_1_1_ = this.getPos();
        int lvt_2_1_ = 80;
        BlockPos lvt_3_1_ = new BlockPos(lvt_1_1_.getX() - 80, 0, lvt_1_1_.getZ() - 80);
        List<TileEntityStructure> lvt_5_1_ = this.getNearbyCornerBlocks(lvt_3_1_, lvt_4_1_ = new BlockPos(lvt_1_1_.getX() + 80, 255, lvt_1_1_.getZ() + 80));
        List<TileEntityStructure> lvt_6_1_ = this.filterRelatedCornerBlocks(lvt_5_1_);
        if (lvt_6_1_.size() < 1) {
            return false;
        }
        StructureBoundingBox lvt_7_1_ = this.calculateEnclosingBoundingBox(lvt_1_1_, lvt_6_1_);
        if (lvt_7_1_.maxX - lvt_7_1_.minX > 1 && lvt_7_1_.maxY - lvt_7_1_.minY > 1 && lvt_7_1_.maxZ - lvt_7_1_.minZ > 1) {
            this.position = new BlockPos(lvt_7_1_.minX - lvt_1_1_.getX() + 1, lvt_7_1_.minY - lvt_1_1_.getY() + 1, lvt_7_1_.minZ - lvt_1_1_.getZ() + 1);
            this.size = new BlockPos(lvt_7_1_.maxX - lvt_7_1_.minX - 1, lvt_7_1_.maxY - lvt_7_1_.minY - 1, lvt_7_1_.maxZ - lvt_7_1_.minZ - 1);
            this.markDirty();
            IBlockState lvt_8_1_ = this.world.getBlockState(lvt_1_1_);
            this.world.notifyBlockUpdate(lvt_1_1_, lvt_8_1_, lvt_8_1_, 3);
            return true;
        }
        return false;
    }

    private List<TileEntityStructure> filterRelatedCornerBlocks(List<TileEntityStructure> p_filterRelatedCornerBlocks_1_) {
        Iterable lvt_2_1_ = Iterables.filter(p_filterRelatedCornerBlocks_1_, (Predicate)new Predicate<TileEntityStructure>(){

            public boolean apply(TileEntityStructure p_apply_1_) {
                return p_apply_1_.mode == Mode.CORNER && TileEntityStructure.this.name.equals(p_apply_1_.name);
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((TileEntityStructure)p_apply_1_);
            }
        });
        return Lists.newArrayList((Iterable)lvt_2_1_);
    }

    private List<TileEntityStructure> getNearbyCornerBlocks(BlockPos p_getNearbyCornerBlocks_1_, BlockPos p_getNearbyCornerBlocks_2_) {
        ArrayList lvt_3_1_ = Lists.newArrayList();
        for (BlockPos.MutableBlockPos lvt_5_1_ : BlockPos.getAllInBoxMutable(p_getNearbyCornerBlocks_1_, p_getNearbyCornerBlocks_2_)) {
            TileEntity lvt_7_1_;
            IBlockState lvt_6_1_ = this.world.getBlockState(lvt_5_1_);
            if (lvt_6_1_.getBlock() != Blocks.STRUCTURE_BLOCK || (lvt_7_1_ = this.world.getTileEntity(lvt_5_1_)) == null || !(lvt_7_1_ instanceof TileEntityStructure)) continue;
            lvt_3_1_.add((TileEntityStructure)lvt_7_1_);
        }
        return lvt_3_1_;
    }

    private StructureBoundingBox calculateEnclosingBoundingBox(BlockPos p_calculateEnclosingBoundingBox_1_, List<TileEntityStructure> p_calculateEnclosingBoundingBox_2_) {
        StructureBoundingBox lvt_3_2_;
        if (p_calculateEnclosingBoundingBox_2_.size() > 1) {
            BlockPos lvt_4_1_ = p_calculateEnclosingBoundingBox_2_.get(0).getPos();
            StructureBoundingBox lvt_3_1_ = new StructureBoundingBox(lvt_4_1_, lvt_4_1_);
        } else {
            lvt_3_2_ = new StructureBoundingBox(p_calculateEnclosingBoundingBox_1_, p_calculateEnclosingBoundingBox_1_);
        }
        for (TileEntityStructure lvt_5_1_ : p_calculateEnclosingBoundingBox_2_) {
            BlockPos lvt_6_1_ = lvt_5_1_.getPos();
            if (lvt_6_1_.getX() < lvt_3_2_.minX) {
                lvt_3_2_.minX = lvt_6_1_.getX();
            } else if (lvt_6_1_.getX() > lvt_3_2_.maxX) {
                lvt_3_2_.maxX = lvt_6_1_.getX();
            }
            if (lvt_6_1_.getY() < lvt_3_2_.minY) {
                lvt_3_2_.minY = lvt_6_1_.getY();
            } else if (lvt_6_1_.getY() > lvt_3_2_.maxY) {
                lvt_3_2_.maxY = lvt_6_1_.getY();
            }
            if (lvt_6_1_.getZ() < lvt_3_2_.minZ) {
                lvt_3_2_.minZ = lvt_6_1_.getZ();
                continue;
            }
            if (lvt_6_1_.getZ() <= lvt_3_2_.maxZ) continue;
            lvt_3_2_.maxZ = lvt_6_1_.getZ();
        }
        return lvt_3_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public void writeCoordinates(ByteBuf p_writeCoordinates_1_) {
        p_writeCoordinates_1_.writeInt(this.pos.getX());
        p_writeCoordinates_1_.writeInt(this.pos.getY());
        p_writeCoordinates_1_.writeInt(this.pos.getZ());
    }

    public boolean save() {
        return this.save(true);
    }

    public boolean save(boolean p_save_1_) {
        if (this.mode != Mode.SAVE || this.world.isRemote || StringUtils.isNullOrEmpty(this.name)) {
            return false;
        }
        BlockPos lvt_2_1_ = this.getPos().add(this.position);
        WorldServer lvt_3_1_ = (WorldServer)this.world;
        MinecraftServer lvt_4_1_ = this.world.getMinecraftServer();
        TemplateManager lvt_5_1_ = lvt_3_1_.getStructureTemplateManager();
        Template lvt_6_1_ = lvt_5_1_.getTemplate(lvt_4_1_, new ResourceLocation(this.name));
        lvt_6_1_.takeBlocksFromWorld(this.world, lvt_2_1_, this.size, !this.ignoreEntities, Blocks.STRUCTURE_VOID);
        lvt_6_1_.setAuthor(this.author);
        return !p_save_1_ || lvt_5_1_.writeTemplate(lvt_4_1_, new ResourceLocation(this.name));
    }

    public boolean load() {
        return this.load(true);
    }

    public boolean load(boolean p_load_1_) {
        BlockPos lvt_8_1_;
        boolean lvt_9_1_;
        if (this.mode != Mode.LOAD || this.world.isRemote || StringUtils.isNullOrEmpty(this.name)) {
            return false;
        }
        BlockPos lvt_2_1_ = this.getPos();
        BlockPos lvt_3_1_ = lvt_2_1_.add(this.position);
        WorldServer lvt_4_1_ = (WorldServer)this.world;
        MinecraftServer lvt_5_1_ = this.world.getMinecraftServer();
        TemplateManager lvt_6_1_ = lvt_4_1_.getStructureTemplateManager();
        Template lvt_7_1_ = lvt_6_1_.get(lvt_5_1_, new ResourceLocation(this.name));
        if (lvt_7_1_ == null) {
            return false;
        }
        if (!StringUtils.isNullOrEmpty(lvt_7_1_.getAuthor())) {
            this.author = lvt_7_1_.getAuthor();
        }
        if (!(lvt_9_1_ = this.size.equals(lvt_8_1_ = lvt_7_1_.getSize()))) {
            this.size = lvt_8_1_;
            this.markDirty();
            IBlockState lvt_10_1_ = this.world.getBlockState(lvt_2_1_);
            this.world.notifyBlockUpdate(lvt_2_1_, lvt_10_1_, lvt_10_1_, 3);
        }
        if (!p_load_1_ || lvt_9_1_) {
            PlacementSettings lvt_10_2_ = new PlacementSettings().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities).setChunk(null).setReplacedBlock(null).setIgnoreStructureBlock(false);
            if (this.integrity < 1.0f) {
                lvt_10_2_.setIntegrity(MathHelper.clamp(this.integrity, 0.0f, 1.0f)).setSeed(this.seed);
            }
            lvt_7_1_.addBlocksToWorldChunk(this.world, lvt_3_1_, lvt_10_2_);
            return true;
        }
        return false;
    }

    public void unloadStructure() {
        WorldServer lvt_1_1_ = (WorldServer)this.world;
        TemplateManager lvt_2_1_ = lvt_1_1_.getStructureTemplateManager();
        lvt_2_1_.remove(new ResourceLocation(this.name));
    }

    public boolean isStructureLoadable() {
        if (this.mode != Mode.LOAD || this.world.isRemote) {
            return false;
        }
        WorldServer lvt_1_1_ = (WorldServer)this.world;
        MinecraftServer lvt_2_1_ = this.world.getMinecraftServer();
        TemplateManager lvt_3_1_ = lvt_1_1_.getStructureTemplateManager();
        return lvt_3_1_.get(lvt_2_1_, new ResourceLocation(this.name)) != null;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean p_setPowered_1_) {
        this.powered = p_setPowered_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showsAir() {
        return this.showAir;
    }

    public void setShowAir(boolean p_setShowAir_1_) {
        this.showAir = p_setShowAir_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showsBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean p_setShowBoundingBox_1_) {
        this.showBoundingBox = p_setShowBoundingBox_1_;
    }

    @Override
    @Nullable
    public ITextComponent getDisplayName() {
        return new TextComponentTranslation("structure_block.hover." + this.mode.modeName, this.mode == Mode.DATA ? this.metadata : this.name);
    }

    public static enum Mode implements IStringSerializable
    {
        SAVE("save", 0),
        LOAD("load", 1),
        CORNER("corner", 2),
        DATA("data", 3);

        private static final Mode[] MODES;
        private final String modeName;
        private final int modeId;

        private Mode(String p_i47027_3_, int p_i47027_4_) {
            this.modeName = p_i47027_3_;
            this.modeId = p_i47027_4_;
        }

        @Override
        public String getName() {
            return this.modeName;
        }

        public int getModeId() {
            return this.modeId;
        }

        public static Mode getById(int p_getById_0_) {
            if (p_getById_0_ < 0 || p_getById_0_ >= MODES.length) {
                return MODES[0];
            }
            return MODES[p_getById_0_];
        }

        static {
            MODES = new Mode[Mode.values().length];
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            for (int i = 0; i < n; ++i) {
                Mode lvt_3_1_;
                Mode.MODES[lvt_3_1_.getModeId()] = lvt_3_1_ = modeArray[i];
            }
        }
    }
}

