/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInheritanceMultiMap<T>
extends AbstractSet<T> {
    private static final Set<Class<?>> ALL_KNOWN = Sets.newHashSet();
    private final Map<Class<?>, List<T>> map = Maps.newHashMap();
    private final Set<Class<?>> knownKeys = Sets.newIdentityHashSet();
    private final Class<T> baseClass;
    private final List<T> values = Lists.newArrayList();

    public ClassInheritanceMultiMap(Class<T> p_i45909_1_) {
        this.baseClass = p_i45909_1_;
        this.knownKeys.add(p_i45909_1_);
        this.map.put(p_i45909_1_, this.values);
        for (Class<?> lvt_3_1_ : ALL_KNOWN) {
            this.createLookup(lvt_3_1_);
        }
    }

    protected void createLookup(Class<?> p_createLookup_1_) {
        ALL_KNOWN.add(p_createLookup_1_);
        for (T lvt_3_1_ : this.values) {
            if (!p_createLookup_1_.isAssignableFrom(lvt_3_1_.getClass())) continue;
            this.addForClass(lvt_3_1_, p_createLookup_1_);
        }
        this.knownKeys.add(p_createLookup_1_);
    }

    protected Class<?> initializeClassLookup(Class<?> p_initializeClassLookup_1_) {
        if (this.baseClass.isAssignableFrom(p_initializeClassLookup_1_)) {
            if (!this.knownKeys.contains(p_initializeClassLookup_1_)) {
                this.createLookup(p_initializeClassLookup_1_);
            }
            return p_initializeClassLookup_1_;
        }
        throw new IllegalArgumentException("Don't know how to search for " + p_initializeClassLookup_1_);
    }

    @Override
    public boolean add(T p_add_1_) {
        for (Class<?> lvt_3_1_ : this.knownKeys) {
            if (!lvt_3_1_.isAssignableFrom(p_add_1_.getClass())) continue;
            this.addForClass(p_add_1_, lvt_3_1_);
        }
        return true;
    }

    private void addForClass(T p_addForClass_1_, Class<?> p_addForClass_2_) {
        List<T> lvt_3_1_ = this.map.get(p_addForClass_2_);
        if (lvt_3_1_ == null) {
            this.map.put(p_addForClass_2_, Lists.newArrayList((Object[])new Object[]{p_addForClass_1_}));
        } else {
            lvt_3_1_.add(p_addForClass_1_);
        }
    }

    @Override
    public boolean remove(Object p_remove_1_) {
        Object lvt_2_1_ = p_remove_1_;
        boolean lvt_3_1_ = false;
        for (Class<?> lvt_5_1_ : this.knownKeys) {
            List<T> lvt_6_1_;
            if (!lvt_5_1_.isAssignableFrom(lvt_2_1_.getClass()) || (lvt_6_1_ = this.map.get(lvt_5_1_)) == null || !lvt_6_1_.remove(lvt_2_1_)) continue;
            lvt_3_1_ = true;
        }
        return lvt_3_1_;
    }

    @Override
    public boolean contains(Object p_contains_1_) {
        return Iterators.contains(this.getByClass(p_contains_1_.getClass()).iterator(), (Object)p_contains_1_);
    }

    public <S> Iterable<S> getByClass(final Class<S> p_getByClass_1_) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                List lvt_1_1_ = (List)ClassInheritanceMultiMap.this.map.get(ClassInheritanceMultiMap.this.initializeClassLookup(p_getByClass_1_));
                if (lvt_1_1_ == null) {
                    return Iterators.emptyIterator();
                }
                Iterator lvt_2_1_ = lvt_1_1_.iterator();
                return Iterators.filter(lvt_2_1_, (Class)p_getByClass_1_);
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        if (this.values.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return Iterators.unmodifiableIterator(this.values.iterator());
    }

    @Override
    public int size() {
        return this.values.size();
    }
}

