/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CombatTracker {
    private final List<CombatEntry> combatEntries = Lists.newArrayList();
    private final EntityLivingBase fighter;
    private int lastDamageTime;
    private int combatStartTime;
    private int combatEndTime;
    private boolean inCombat;
    private boolean takingDamage;
    private String fallSuffix;

    public CombatTracker(EntityLivingBase p_i1565_1_) {
        this.fighter = p_i1565_1_;
    }

    public void calculateFallSuffix() {
        this.resetFallSuffix();
        if (this.fighter.isOnLadder()) {
            Block lvt_1_1_ = this.fighter.world.getBlockState(new BlockPos(this.fighter.posX, this.fighter.getEntityBoundingBox().minY, this.fighter.posZ)).getBlock();
            if (lvt_1_1_ == Blocks.LADDER) {
                this.fallSuffix = "ladder";
            } else if (lvt_1_1_ == Blocks.VINE) {
                this.fallSuffix = "vines";
            }
        } else if (this.fighter.isInWater()) {
            this.fallSuffix = "water";
        }
    }

    public void trackDamage(DamageSource p_trackDamage_1_, float p_trackDamage_2_, float p_trackDamage_3_) {
        this.reset();
        this.calculateFallSuffix();
        CombatEntry lvt_4_1_ = new CombatEntry(p_trackDamage_1_, this.fighter.ticksExisted, p_trackDamage_2_, p_trackDamage_3_, this.fallSuffix, this.fighter.fallDistance);
        this.combatEntries.add(lvt_4_1_);
        this.lastDamageTime = this.fighter.ticksExisted;
        this.takingDamage = true;
        if (lvt_4_1_.isLivingDamageSrc() && !this.inCombat && this.fighter.isEntityAlive()) {
            this.inCombat = true;
            this.combatEndTime = this.combatStartTime = this.fighter.ticksExisted;
            this.fighter.sendEnterCombat();
        }
    }

    public ITextComponent getDeathMessage() {
        ITextComponent lvt_3_7_;
        if (this.combatEntries.isEmpty()) {
            return new TextComponentTranslation("death.attack.generic", this.fighter.getDisplayName());
        }
        CombatEntry lvt_1_1_ = this.getBestCombatEntry();
        CombatEntry lvt_2_1_ = this.combatEntries.get(this.combatEntries.size() - 1);
        ITextComponent lvt_4_1_ = lvt_2_1_.getDamageSrcDisplayName();
        Entity lvt_5_1_ = lvt_2_1_.getDamageSrc().getEntity();
        if (lvt_1_1_ != null && lvt_2_1_.getDamageSrc() == DamageSource.FALL) {
            ITextComponent lvt_6_1_ = lvt_1_1_.getDamageSrcDisplayName();
            if (lvt_1_1_.getDamageSrc() == DamageSource.FALL || lvt_1_1_.getDamageSrc() == DamageSource.OUT_OF_WORLD) {
                TextComponentTranslation lvt_3_1_ = new TextComponentTranslation("death.fell.accident." + this.getFallSuffix(lvt_1_1_), this.fighter.getDisplayName());
            } else if (!(lvt_6_1_ == null || lvt_4_1_ != null && lvt_6_1_.equals(lvt_4_1_))) {
                ItemStack lvt_8_1_;
                Entity lvt_7_1_ = lvt_1_1_.getDamageSrc().getEntity();
                ItemStack itemStack = lvt_8_1_ = lvt_7_1_ instanceof EntityLivingBase ? ((EntityLivingBase)lvt_7_1_).getHeldItemMainhand() : ItemStack.EMPTY;
                if (!lvt_8_1_.isEmpty() && lvt_8_1_.hasDisplayName()) {
                    TextComponentTranslation lvt_3_2_ = new TextComponentTranslation("death.fell.assist.item", this.fighter.getDisplayName(), lvt_6_1_, lvt_8_1_.getTextComponent());
                } else {
                    TextComponentTranslation lvt_3_3_ = new TextComponentTranslation("death.fell.assist", this.fighter.getDisplayName(), lvt_6_1_);
                }
            } else if (lvt_4_1_ != null) {
                ItemStack lvt_7_2_;
                ItemStack itemStack = lvt_7_2_ = lvt_5_1_ instanceof EntityLivingBase ? ((EntityLivingBase)lvt_5_1_).getHeldItemMainhand() : ItemStack.EMPTY;
                if (!lvt_7_2_.isEmpty() && lvt_7_2_.hasDisplayName()) {
                    TextComponentTranslation lvt_3_4_ = new TextComponentTranslation("death.fell.finish.item", this.fighter.getDisplayName(), lvt_4_1_, lvt_7_2_.getTextComponent());
                } else {
                    TextComponentTranslation lvt_3_5_ = new TextComponentTranslation("death.fell.finish", this.fighter.getDisplayName(), lvt_4_1_);
                }
            } else {
                TextComponentTranslation lvt_3_6_ = new TextComponentTranslation("death.fell.killer", this.fighter.getDisplayName());
            }
        } else {
            lvt_3_7_ = lvt_2_1_.getDamageSrc().getDeathMessage(this.fighter);
        }
        return lvt_3_7_;
    }

    @Nullable
    public EntityLivingBase getBestAttacker() {
        EntityLivingBase lvt_1_1_ = null;
        EntityPlayer lvt_2_1_ = null;
        float lvt_3_1_ = 0.0f;
        float lvt_4_1_ = 0.0f;
        for (CombatEntry lvt_6_1_ : this.combatEntries) {
            if (lvt_6_1_.getDamageSrc().getEntity() instanceof EntityPlayer && (lvt_2_1_ == null || lvt_6_1_.getDamage() > lvt_4_1_)) {
                lvt_4_1_ = lvt_6_1_.getDamage();
                lvt_2_1_ = (EntityPlayer)lvt_6_1_.getDamageSrc().getEntity();
            }
            if (!(lvt_6_1_.getDamageSrc().getEntity() instanceof EntityLivingBase) || lvt_1_1_ != null && !(lvt_6_1_.getDamage() > lvt_3_1_)) continue;
            lvt_3_1_ = lvt_6_1_.getDamage();
            lvt_1_1_ = (EntityLivingBase)lvt_6_1_.getDamageSrc().getEntity();
        }
        if (lvt_2_1_ != null && lvt_4_1_ >= lvt_3_1_ / 3.0f) {
            return lvt_2_1_;
        }
        return lvt_1_1_;
    }

    @Nullable
    private CombatEntry getBestCombatEntry() {
        CombatEntry lvt_1_1_ = null;
        CombatEntry lvt_2_1_ = null;
        float lvt_3_1_ = 0.0f;
        float lvt_4_1_ = 0.0f;
        for (int lvt_5_1_ = 0; lvt_5_1_ < this.combatEntries.size(); ++lvt_5_1_) {
            CombatEntry lvt_7_1_;
            CombatEntry lvt_6_1_ = this.combatEntries.get(lvt_5_1_);
            CombatEntry combatEntry = lvt_7_1_ = lvt_5_1_ > 0 ? this.combatEntries.get(lvt_5_1_ - 1) : null;
            if ((lvt_6_1_.getDamageSrc() == DamageSource.FALL || lvt_6_1_.getDamageSrc() == DamageSource.OUT_OF_WORLD) && lvt_6_1_.getDamageAmount() > 0.0f && (lvt_1_1_ == null || lvt_6_1_.getDamageAmount() > lvt_4_1_)) {
                lvt_1_1_ = lvt_5_1_ > 0 ? lvt_7_1_ : lvt_6_1_;
                lvt_4_1_ = lvt_6_1_.getDamageAmount();
            }
            if (lvt_6_1_.getFallSuffix() == null || lvt_2_1_ != null && !(lvt_6_1_.getDamage() > lvt_3_1_)) continue;
            lvt_2_1_ = lvt_6_1_;
            lvt_3_1_ = lvt_6_1_.getDamage();
        }
        if (lvt_4_1_ > 5.0f && lvt_1_1_ != null) {
            return lvt_1_1_;
        }
        if (lvt_3_1_ > 5.0f && lvt_2_1_ != null) {
            return lvt_2_1_;
        }
        return null;
    }

    private String getFallSuffix(CombatEntry p_getFallSuffix_1_) {
        return p_getFallSuffix_1_.getFallSuffix() == null ? "generic" : p_getFallSuffix_1_.getFallSuffix();
    }

    public int getCombatDuration() {
        if (this.inCombat) {
            return this.fighter.ticksExisted - this.combatStartTime;
        }
        return this.combatEndTime - this.combatStartTime;
    }

    private void resetFallSuffix() {
        this.fallSuffix = null;
    }

    public void reset() {
        int lvt_1_1_;
        int n = lvt_1_1_ = this.inCombat ? 300 : 100;
        if (this.takingDamage && (!this.fighter.isEntityAlive() || this.fighter.ticksExisted - this.lastDamageTime > lvt_1_1_)) {
            boolean lvt_2_1_ = this.inCombat;
            this.takingDamage = false;
            this.inCombat = false;
            this.combatEndTime = this.fighter.ticksExisted;
            if (lvt_2_1_) {
                this.fighter.sendEndCombat();
            }
            this.combatEntries.clear();
        }
    }

    public EntityLivingBase getFighter() {
        return this.fighter;
    }
}

