/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CooldownTracker {
    private final Map<Item, Cooldown> cooldowns = Maps.newHashMap();
    private int ticks;

    public boolean hasCooldown(Item p_hasCooldown_1_) {
        return this.getCooldown(p_hasCooldown_1_, 0.0f) > 0.0f;
    }

    public float getCooldown(Item p_getCooldown_1_, float p_getCooldown_2_) {
        Cooldown lvt_3_1_ = this.cooldowns.get(p_getCooldown_1_);
        if (lvt_3_1_ != null) {
            float lvt_4_1_ = lvt_3_1_.expireTicks - lvt_3_1_.createTicks;
            float lvt_5_1_ = (float)lvt_3_1_.expireTicks - ((float)this.ticks + p_getCooldown_2_);
            return MathHelper.clamp(lvt_5_1_ / lvt_4_1_, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.ticks;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<Item, Cooldown>> lvt_1_1_ = this.cooldowns.entrySet().iterator();
            while (lvt_1_1_.hasNext()) {
                Map.Entry<Item, Cooldown> lvt_2_1_ = lvt_1_1_.next();
                if (lvt_2_1_.getValue().expireTicks > this.ticks) continue;
                lvt_1_1_.remove();
                this.notifyOnRemove(lvt_2_1_.getKey());
            }
        }
    }

    public void setCooldown(Item p_setCooldown_1_, int p_setCooldown_2_) {
        this.cooldowns.put(p_setCooldown_1_, new Cooldown(this.ticks, this.ticks + p_setCooldown_2_));
        this.notifyOnSet(p_setCooldown_1_, p_setCooldown_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public void removeCooldown(Item p_removeCooldown_1_) {
        this.cooldowns.remove(p_removeCooldown_1_);
        this.notifyOnRemove(p_removeCooldown_1_);
    }

    protected void notifyOnSet(Item p_notifyOnSet_1_, int p_notifyOnSet_2_) {
    }

    protected void notifyOnRemove(Item p_notifyOnRemove_1_) {
    }

    class Cooldown {
        final int createTicks;
        final int expireTicks;

        private Cooldown(int p_i47037_2_, int p_i47037_3_) {
            this.createTicks = p_i47037_2_;
            this.expireTicks = p_i47037_3_;
        }
    }
}

