/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptManager {
    private static final Logger LOGGER = LogManager.getLogger();

    @SideOnly(value=Side.CLIENT)
    public static SecretKey createNewSharedKey() {
        try {
            KeyGenerator lvt_0_1_ = KeyGenerator.getInstance("AES");
            lvt_0_1_.init(128);
            return lvt_0_1_.generateKey();
        }
        catch (NoSuchAlgorithmException lvt_0_2_) {
            throw new Error(lvt_0_2_);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator lvt_0_1_ = KeyPairGenerator.getInstance("RSA");
            lvt_0_1_.initialize(1024);
            return lvt_0_1_.generateKeyPair();
        }
        catch (NoSuchAlgorithmException lvt_0_2_) {
            lvt_0_2_.printStackTrace();
            LOGGER.error("Key pair generation failed!");
            return null;
        }
    }

    public static byte[] getServerIdHash(String p_getServerIdHash_0_, PublicKey p_getServerIdHash_1_, SecretKey p_getServerIdHash_2_) {
        try {
            return CryptManager.digestOperation("SHA-1", p_getServerIdHash_0_.getBytes("ISO_8859_1"), p_getServerIdHash_2_.getEncoded(), p_getServerIdHash_1_.getEncoded());
        }
        catch (UnsupportedEncodingException lvt_3_1_) {
            lvt_3_1_.printStackTrace();
            return null;
        }
    }

    private static byte[] digestOperation(String p_digestOperation_0_, byte[] ... p_digestOperation_1_) {
        try {
            MessageDigest lvt_2_1_ = MessageDigest.getInstance(p_digestOperation_0_);
            for (byte[] lvt_6_1_ : p_digestOperation_1_) {
                lvt_2_1_.update(lvt_6_1_);
            }
            return lvt_2_1_.digest();
        }
        catch (NoSuchAlgorithmException lvt_2_2_) {
            lvt_2_2_.printStackTrace();
            return null;
        }
    }

    public static PublicKey decodePublicKey(byte[] p_decodePublicKey_0_) {
        try {
            X509EncodedKeySpec lvt_1_1_ = new X509EncodedKeySpec(p_decodePublicKey_0_);
            KeyFactory lvt_2_1_ = KeyFactory.getInstance("RSA");
            return lvt_2_1_.generatePublic(lvt_1_1_);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        LOGGER.error("Public key reconstitute failed!");
        return null;
    }

    public static SecretKey decryptSharedKey(PrivateKey p_decryptSharedKey_0_, byte[] p_decryptSharedKey_1_) {
        return new SecretKeySpec(CryptManager.decryptData(p_decryptSharedKey_0_, p_decryptSharedKey_1_), "AES");
    }

    @SideOnly(value=Side.CLIENT)
    public static byte[] encryptData(Key p_encryptData_0_, byte[] p_encryptData_1_) {
        return CryptManager.cipherOperation(1, p_encryptData_0_, p_encryptData_1_);
    }

    public static byte[] decryptData(Key p_decryptData_0_, byte[] p_decryptData_1_) {
        return CryptManager.cipherOperation(2, p_decryptData_0_, p_decryptData_1_);
    }

    private static byte[] cipherOperation(int p_cipherOperation_0_, Key p_cipherOperation_1_, byte[] p_cipherOperation_2_) {
        try {
            return CryptManager.createTheCipherInstance(p_cipherOperation_0_, p_cipherOperation_1_.getAlgorithm(), p_cipherOperation_1_).doFinal(p_cipherOperation_2_);
        }
        catch (IllegalBlockSizeException lvt_3_1_) {
            lvt_3_1_.printStackTrace();
        }
        catch (BadPaddingException lvt_3_2_) {
            lvt_3_2_.printStackTrace();
        }
        LOGGER.error("Cipher data failed!");
        return null;
    }

    private static Cipher createTheCipherInstance(int p_createTheCipherInstance_0_, String p_createTheCipherInstance_1_, Key p_createTheCipherInstance_2_) {
        try {
            Cipher lvt_3_1_ = Cipher.getInstance(p_createTheCipherInstance_1_);
            lvt_3_1_.init(p_createTheCipherInstance_0_, p_createTheCipherInstance_2_);
            return lvt_3_1_;
        }
        catch (InvalidKeyException lvt_3_2_) {
            lvt_3_2_.printStackTrace();
        }
        catch (NoSuchAlgorithmException lvt_3_3_) {
            lvt_3_3_.printStackTrace();
        }
        catch (NoSuchPaddingException lvt_3_4_) {
            lvt_3_4_.printStackTrace();
        }
        LOGGER.error("Cipher creation failed!");
        return null;
    }

    public static Cipher createNetCipherInstance(int p_createNetCipherInstance_0_, Key p_createNetCipherInstance_1_) {
        try {
            Cipher lvt_2_1_ = Cipher.getInstance("AES/CFB8/NoPadding");
            lvt_2_1_.init(p_createNetCipherInstance_0_, p_createNetCipherInstance_1_, new IvParameterSpec(p_createNetCipherInstance_1_.getEncoded()));
            return lvt_2_1_;
        }
        catch (GeneralSecurityException lvt_2_2_) {
            throw new RuntimeException(lvt_2_2_);
        }
    }
}

