/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;

public class DamageSource {
    public static final DamageSource IN_FIRE = new DamageSource("inFire").setFireDamage();
    public static final DamageSource LIGHTNING_BOLT = new DamageSource("lightningBolt");
    public static final DamageSource ON_FIRE = new DamageSource("onFire").setDamageBypassesArmor().setFireDamage();
    public static final DamageSource LAVA = new DamageSource("lava").setFireDamage();
    public static final DamageSource HOT_FLOOR = new DamageSource("hotFloor").setFireDamage();
    public static final DamageSource IN_WALL = new DamageSource("inWall").setDamageBypassesArmor();
    public static final DamageSource CRAMMING = new DamageSource("cramming").setDamageBypassesArmor();
    public static final DamageSource DROWN = new DamageSource("drown").setDamageBypassesArmor();
    public static final DamageSource STARVE = new DamageSource("starve").setDamageBypassesArmor().setDamageIsAbsolute();
    public static final DamageSource CACTUS = new DamageSource("cactus");
    public static final DamageSource FALL = new DamageSource("fall").setDamageBypassesArmor();
    public static final DamageSource FLY_INTO_WALL = new DamageSource("flyIntoWall").setDamageBypassesArmor();
    public static final DamageSource OUT_OF_WORLD = new DamageSource("outOfWorld").setDamageBypassesArmor().setDamageAllowedInCreativeMode();
    public static final DamageSource GENERIC = new DamageSource("generic").setDamageBypassesArmor();
    public static final DamageSource MAGIC = new DamageSource("magic").setDamageBypassesArmor().setMagicDamage();
    public static final DamageSource WITHER = new DamageSource("wither").setDamageBypassesArmor();
    public static final DamageSource ANVIL = new DamageSource("anvil");
    public static final DamageSource FALLING_BLOCK = new DamageSource("fallingBlock");
    public static final DamageSource DRAGON_BREATH = new DamageSource("dragonBreath").setDamageBypassesArmor();
    public static final DamageSource field_191552_t = new DamageSource("fireworks").setExplosion();
    private boolean isUnblockable;
    private boolean isDamageAllowedInCreativeMode;
    private boolean damageIsAbsolute;
    private float hungerDamage = 0.1f;
    private boolean fireDamage;
    private boolean projectile;
    private boolean difficultyScaled;
    private boolean magicDamage;
    private boolean explosion;
    public String damageType;

    public static DamageSource causeMobDamage(EntityLivingBase p_causeMobDamage_0_) {
        return new EntityDamageSource("mob", p_causeMobDamage_0_);
    }

    public static DamageSource causeIndirectDamage(Entity p_causeIndirectDamage_0_, EntityLivingBase p_causeIndirectDamage_1_) {
        return new EntityDamageSourceIndirect("mob", p_causeIndirectDamage_0_, p_causeIndirectDamage_1_);
    }

    public static DamageSource causePlayerDamage(EntityPlayer p_causePlayerDamage_0_) {
        return new EntityDamageSource("player", p_causePlayerDamage_0_);
    }

    public static DamageSource causeArrowDamage(EntityArrow p_causeArrowDamage_0_, Entity p_causeArrowDamage_1_) {
        return new EntityDamageSourceIndirect("arrow", p_causeArrowDamage_0_, p_causeArrowDamage_1_).setProjectile();
    }

    public static DamageSource causeFireballDamage(EntityFireball p_causeFireballDamage_0_, Entity p_causeFireballDamage_1_) {
        if (p_causeFireballDamage_1_ == null) {
            return new EntityDamageSourceIndirect("onFire", p_causeFireballDamage_0_, p_causeFireballDamage_0_).setFireDamage().setProjectile();
        }
        return new EntityDamageSourceIndirect("fireball", p_causeFireballDamage_0_, p_causeFireballDamage_1_).setFireDamage().setProjectile();
    }

    public static DamageSource causeThrownDamage(Entity p_causeThrownDamage_0_, Entity p_causeThrownDamage_1_) {
        return new EntityDamageSourceIndirect("thrown", p_causeThrownDamage_0_, p_causeThrownDamage_1_).setProjectile();
    }

    public static DamageSource causeIndirectMagicDamage(Entity p_causeIndirectMagicDamage_0_, Entity p_causeIndirectMagicDamage_1_) {
        return new EntityDamageSourceIndirect("indirectMagic", p_causeIndirectMagicDamage_0_, p_causeIndirectMagicDamage_1_).setDamageBypassesArmor().setMagicDamage();
    }

    public static DamageSource causeThornsDamage(Entity p_causeThornsDamage_0_) {
        return new EntityDamageSource("thorns", p_causeThornsDamage_0_).setIsThornsDamage().setMagicDamage();
    }

    public static DamageSource causeExplosionDamage(Explosion p_causeExplosionDamage_0_) {
        if (p_causeExplosionDamage_0_ != null && p_causeExplosionDamage_0_.getExplosivePlacedBy() != null) {
            return new EntityDamageSource("explosion.player", p_causeExplosionDamage_0_.getExplosivePlacedBy()).setDifficultyScaled().setExplosion();
        }
        return new DamageSource("explosion").setDifficultyScaled().setExplosion();
    }

    public static DamageSource causeExplosionDamage(EntityLivingBase p_causeExplosionDamage_0_) {
        if (p_causeExplosionDamage_0_ != null) {
            return new EntityDamageSource("explosion.player", p_causeExplosionDamage_0_).setDifficultyScaled().setExplosion();
        }
        return new DamageSource("explosion").setDifficultyScaled().setExplosion();
    }

    public boolean isProjectile() {
        return this.projectile;
    }

    public DamageSource setProjectile() {
        this.projectile = true;
        return this;
    }

    public boolean isExplosion() {
        return this.explosion;
    }

    public DamageSource setExplosion() {
        this.explosion = true;
        return this;
    }

    public boolean isUnblockable() {
        return this.isUnblockable;
    }

    public float getHungerDamage() {
        return this.hungerDamage;
    }

    public boolean canHarmInCreative() {
        return this.isDamageAllowedInCreativeMode;
    }

    public boolean isDamageAbsolute() {
        return this.damageIsAbsolute;
    }

    public DamageSource(String p_i1566_1_) {
        this.damageType = p_i1566_1_;
    }

    @Nullable
    public Entity getSourceOfDamage() {
        return this.getEntity();
    }

    @Nullable
    public Entity getEntity() {
        return null;
    }

    public DamageSource setDamageBypassesArmor() {
        this.isUnblockable = true;
        this.hungerDamage = 0.0f;
        return this;
    }

    public DamageSource setDamageAllowedInCreativeMode() {
        this.isDamageAllowedInCreativeMode = true;
        return this;
    }

    public DamageSource setDamageIsAbsolute() {
        this.damageIsAbsolute = true;
        this.hungerDamage = 0.0f;
        return this;
    }

    public DamageSource setFireDamage() {
        this.fireDamage = true;
        return this;
    }

    public ITextComponent getDeathMessage(EntityLivingBase p_getDeathMessage_1_) {
        EntityLivingBase lvt_2_1_ = p_getDeathMessage_1_.getAttackingEntity();
        String lvt_3_1_ = "death.attack." + this.damageType;
        String lvt_4_1_ = lvt_3_1_ + ".player";
        if (lvt_2_1_ != null && I18n.canTranslate(lvt_4_1_)) {
            return new TextComponentTranslation(lvt_4_1_, p_getDeathMessage_1_.getDisplayName(), lvt_2_1_.getDisplayName());
        }
        return new TextComponentTranslation(lvt_3_1_, p_getDeathMessage_1_.getDisplayName());
    }

    public boolean isFireDamage() {
        return this.fireDamage;
    }

    public String getDamageType() {
        return this.damageType;
    }

    public DamageSource setDifficultyScaled() {
        this.difficultyScaled = true;
        return this;
    }

    public boolean isDifficultyScaled() {
        return this.difficultyScaled;
    }

    public boolean isMagicDamage() {
        return this.magicDamage;
    }

    public DamageSource setMagicDamage() {
        this.magicDamage = true;
        return this;
    }

    public boolean isCreativePlayer() {
        Entity lvt_1_1_ = this.getEntity();
        return lvt_1_1_ instanceof EntityPlayer && ((EntityPlayer)lvt_1_1_).capabilities.isCreativeMode;
    }

    @Nullable
    public Vec3d getDamageLocation() {
        return null;
    }
}

